/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.internal.osgi;

import com.ibm.ws.logging.RoutedMessage;
import com.ibm.ws.logging.WsTraceHandler;
import com.ibm.ws.logging.WsTraceRouter;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class WsTraceRouterImpl
implements WsTraceRouter {
    private final ConcurrentMap<String, WsTraceHandler> wsTraceHandlerServices = new ConcurrentHashMap<String, WsTraceHandler>();
    private Queue<RoutedMessage> earlierTraces;
    private static final ReentrantReadWriteLock RERWLOCK = new ReentrantReadWriteLock(true);

    protected WsTraceRouterImpl() {
    }

    public void setEarlierTraces(Queue<RoutedMessage> earlierTraces) {
        RERWLOCK.writeLock().lock();
        try {
            this.earlierTraces = earlierTraces;
        }
        finally {
            RERWLOCK.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWsTraceHandler(String id, WsTraceHandler ref) {
        if (id != null && ref != null) {
            RERWLOCK.writeLock().lock();
            try {
                this.wsTraceHandlerServices.put(id, ref);
                if (this.earlierTraces == null) {
                    return;
                }
                for (RoutedMessage earlierTrace : this.earlierTraces.toArray(new RoutedMessage[this.earlierTraces.size()])) {
                    if (earlierTrace == null) continue;
                    this.routeTo(earlierTrace, id);
                }
            }
            finally {
                RERWLOCK.writeLock().unlock();
            }
        }
    }

    public void unsetWsTraceHandler(String id, WsTraceHandler ref) {
        if (id != null) {
            if (ref == null) {
                this.wsTraceHandlerServices.remove(id);
            } else {
                this.wsTraceHandlerServices.remove(id, ref);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean route(RoutedMessage routedTrace) {
        boolean logNormally = true;
        RERWLOCK.readLock().lock();
        try {
            if (this.earlierTraces != null) {
                this.earlierTraces.add(routedTrace);
            }
            Set<String> routeAllMsgsToTheseLogHandlers = this.wsTraceHandlerServices.keySet();
            logNormally = this.routeToAll(routedTrace, routeAllMsgsToTheseLogHandlers);
        }
        finally {
            RERWLOCK.readLock().unlock();
        }
        return logNormally;
    }

    protected boolean routeToAll(RoutedMessage routedTrace, Set<String> logHandlerIds) {
        for (String logHandlerId : logHandlerIds) {
            this.routeTo(routedTrace, logHandlerId);
        }
        return true;
    }

    protected void routeTo(RoutedMessage routedTrace, String logHandlerId) {
        WsTraceHandler wsTraceHandler = (WsTraceHandler)this.wsTraceHandlerServices.get(logHandlerId);
        if (wsTraceHandler != null) {
            wsTraceHandler.publish(routedTrace);
        }
    }
}

