/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.logging.hpel.reader.filters;

import com.ibm.websphere.logging.hpel.reader.LogQueryBean;
import com.ibm.websphere.logging.hpel.reader.LogRecordFilter;
import com.ibm.websphere.logging.hpel.reader.RepositoryLogRecord;
import com.ibm.websphere.logging.hpel.reader.filters.LevelFilter;
import java.util.regex.Pattern;

public class MultipleCriteriaFilter
implements LogRecordFilter {
    private boolean checkDate = false;
    private LevelFilter levelFilter = null;
    private Pattern[] includeLoggers;
    private Pattern[] excludeLoggers;
    private final int[] threadIDs;
    private Pattern[] messageContent;
    private Pattern[] excludeMessages;
    private long endDate;
    private long startDate;

    public MultipleCriteriaFilter(LogQueryBean logQueryBean) {
        if (logQueryBean.getMinTime() != null || logQueryBean.getMaxTime() != null) {
            this.checkDate = true;
            this.startDate = logQueryBean.getMinTime() != null ? logQueryBean.getMinTime().getTime() : 0L;
            long l = this.endDate = logQueryBean.getMaxTime() != null ? logQueryBean.getMaxTime().getTime() : Long.MAX_VALUE;
        }
        if (logQueryBean.getMinLevel() != null || logQueryBean.getMaxLevel() != null) {
            this.levelFilter = new LevelFilter(logQueryBean.getMinLevel(), logQueryBean.getMaxLevel());
        }
        if (logQueryBean.getMessageContent() != null) {
            this.messageContent = this.compile(logQueryBean.getMessageContent());
        }
        if (logQueryBean.getExcludeMessages() != null) {
            this.excludeMessages = this.compile(logQueryBean.getExcludeMessages());
        }
        if (logQueryBean.getIncludeLoggers() != null) {
            this.includeLoggers = this.compile(logQueryBean.getIncludeLoggers());
        }
        if (logQueryBean.getExcludeLoggers() != null) {
            this.excludeLoggers = this.compile(logQueryBean.getExcludeLoggers());
        }
        this.threadIDs = logQueryBean.getThreadIDs();
    }

    private Pattern[] compile(String[] patterns) {
        Pattern[] result = null;
        if (patterns != null) {
            result = new Pattern[patterns.length];
            for (int i = 0; i < patterns.length; ++i) {
                result[i] = LogQueryBean.compile(patterns[i]);
            }
        }
        return result;
    }

    @Override
    public boolean accept(RepositoryLogRecord record) {
        int n;
        int n2;
        Pattern[] patternArray;
        String message;
        if (this.checkDate && (record.getMillis() > this.endDate || this.startDate > record.getMillis())) {
            return false;
        }
        if (this.levelFilter != null && !this.levelFilter.accept(record)) {
            return false;
        }
        String string = message = record.getFormattedMessage() != null ? record.getFormattedMessage() : record.getRawMessage();
        if (this.messageContent != null) {
            boolean match = false;
            patternArray = this.messageContent;
            n2 = patternArray.length;
            for (n = 0; n < n2; ++n) {
                Pattern pattern = patternArray[n];
                if (!pattern.matcher(message).find()) continue;
                match = true;
                break;
            }
            if (!match) {
                return false;
            }
        }
        if (this.excludeMessages != null) {
            boolean matchExcMessage = false;
            patternArray = this.excludeMessages;
            n2 = patternArray.length;
            for (n = 0; n < n2; ++n) {
                Pattern excMessage = patternArray[n];
                if (!excMessage.matcher(message).find()) continue;
                matchExcMessage = true;
                break;
            }
            if (matchExcMessage) {
                return false;
            }
        }
        String loggerName = record.getLoggerName();
        if (this.includeLoggers != null) {
            boolean matchIncLogger = false;
            Pattern[] patternArray2 = this.includeLoggers;
            n = patternArray2.length;
            for (int excMessage = 0; excMessage < n; ++excMessage) {
                Pattern incLogger = patternArray2[excMessage];
                if (loggerName == null || !incLogger.matcher(loggerName).find()) continue;
                matchIncLogger = true;
                break;
            }
            if (!matchIncLogger) {
                return false;
            }
        }
        if (this.excludeLoggers != null) {
            Pattern[] patternArray3 = this.excludeLoggers;
            int n3 = patternArray3.length;
            for (n = 0; n < n3; ++n) {
                Pattern excLogger = patternArray3[n];
                if (loggerName == null || !excLogger.matcher(loggerName).find()) continue;
                return false;
            }
        }
        if (this.threadIDs != null) {
            for (int hexThread : this.threadIDs) {
                if (hexThread != record.getThreadID()) continue;
                return true;
            }
            return false;
        }
        return true;
    }
}

