/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.internal.adaptor;

import com.ibm.ws.install.InstallConstants;
import com.ibm.ws.install.InstallException;
import com.ibm.ws.install.internal.InstallUtils;
import com.ibm.ws.install.internal.Product;
import com.ibm.ws.install.internal.adaptor.ArchiveAdaptor;
import com.ibm.ws.install.internal.asset.ServerPackageAsset;
import com.ibm.ws.kernel.boot.cmdline.Utils;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;

public class ServicePackageAdaptor
extends ArchiveAdaptor {
    private static final String WLP_USR = "wlp/usr";

    public static void install(Product product, ServerPackageAsset serverPackageAsset, List<File> filesInstalled, InstallConstants.ExistsAction existsAction) throws IOException, InstallException {
        File userDir = Utils.getUserDir();
        Enumeration<? extends ZipEntry> entries = serverPackageAsset.getPackageEntries();
        while (entries.hasMoreElements()) {
            ZipEntry ze = entries.nextElement();
            String zeName = ze.getName().toLowerCase();
            if (!zeName.startsWith(WLP_USR) || ze.isDirectory() || zeName.endsWith(".slock")) continue;
            String entryName = ze.getName().substring(WLP_USR.length());
            File f = new File(userDir, entryName);
            try {
                ServicePackageAdaptor.write(false, filesInstalled, f, serverPackageAsset.getInputStream(ze), InstallConstants.ExistsAction.ignore, null);
            }
            catch (IOException e) {
                InstallUtils.delete(filesInstalled);
                throw e;
            }
            catch (InstallException e) {
                InstallUtils.delete(filesInstalled);
                throw e;
            }
        }
    }
}

