/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.launch.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.kernel.launch.internal.TraceClassFileTransformer;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.jar.JarFile;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class TraceInstrumentation
implements InvocationHandler {
    static final TraceComponent tc = Tr.register(TraceInstrumentation.class, (String)"instrumentation");
    private final Instrumentation instrumentation;
    private final Map<ClassFileTransformer, TraceClassFileTransformer> traceTransformers;
    static final long serialVersionUID = 1803109116911016438L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    public TraceInstrumentation(Instrumentation instrumentation) {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object[])new Object[]{instrumentation});
        }
        this.traceTransformers = Collections.synchronizedMap(new IdentityHashMap());
        this.instrumentation = instrumentation;
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    @Override
    @Trivial
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if ("addTransformer".equals(method.getName())) {
            this.addTransformer((ClassFileTransformer)args[0], args.length > 1 ? (Boolean)args[1] : false);
            return null;
        }
        if ("removeTransformer".equals(method.getName())) {
            return this.removeTransformer((ClassFileTransformer)args[0]);
        }
        if ("appendToBootstrapClassLoaderSearch".equals(method.getName())) {
            this.appendToBootstrapClassLoaderSearch((JarFile)args[0]);
            return null;
        }
        if ("appendToSystemClassLoaderSearch".equals(method.getName())) {
            this.appendToSystemClassLoaderSearch((JarFile)args[0]);
            return null;
        }
        if ("setNativeMethodPrefix".equals(method.getName())) {
            this.setNativeMethodPrefix((ClassFileTransformer)args[0], (String)args[1]);
            return null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)method.getName(), (Object[])args);
        }
        Object retValue = method.invoke((Object)this.instrumentation, args);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            if (Void.TYPE == method.getReturnType()) {
                Tr.exit((TraceComponent)tc, (String)method.getName());
            } else {
                Tr.exit((TraceComponent)tc, (String)method.getName(), (Object)retValue);
            }
        }
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    private void addTransformer(ClassFileTransformer transformer, boolean canRetransform) {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"addTransformer", (Object[])new Object[]{transformer, canRetransform});
        }
        if (transformer == null) {
            throw new NullPointerException();
        }
        TraceClassFileTransformer traceTransformer = new TraceClassFileTransformer(transformer);
        try {
            this.instrumentation.addTransformer(traceTransformer, canRetransform);
        }
        finally {
            this.traceTransformers.put(transformer, traceTransformer);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"addTransformer");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    private boolean removeTransformer(ClassFileTransformer transformer) {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"removeTransformer", (Object[])new Object[]{transformer});
        }
        if (transformer == null) {
            throw new NullPointerException();
        }
        TraceClassFileTransformer traceTransformer = this.traceTransformers.remove(transformer);
        boolean bl = traceTransformer != null && this.instrumentation.removeTransformer(traceTransformer);
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            bl = bl;
            Tr.exit((Object)this, (TraceComponent)tc, (String)"removeTransformer", (Object)bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    private static String jarFileToString(JarFile jarfile) {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"jarFileToString", (Object[])new Object[]{jarfile});
        }
        String string = jarfile == null ? null : jarfile.toString() + '[' + jarfile.getName() + ']';
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            string = string;
            Tr.exit((TraceComponent)tc, (String)"jarFileToString", (Object)string);
        }
        return string;
    }

    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    private void appendToBootstrapClassLoaderSearch(JarFile jarFile) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"appendToBootstrapClassLoaderSearch", (Object[])new Object[]{TraceInstrumentation.jarFileToString(jarFile)});
        }
        this.instrumentation.appendToBootstrapClassLoaderSearch(jarFile);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"appendToBootstrapClassLoaderSearch");
        }
    }

    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    private void appendToSystemClassLoaderSearch(JarFile jarFile) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"appendToSystemClassLoaderSearch", (Object[])new Object[]{TraceInstrumentation.jarFileToString(jarFile)});
        }
        this.instrumentation.appendToSystemClassLoaderSearch(jarFile);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"appendToSystemClassLoaderSearch");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    private void setNativeMethodPrefix(ClassFileTransformer transformer, String prefix) {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"setNativeMethodPrefix", (Object[])new Object[]{transformer, prefix});
        }
        if (transformer == null) {
            throw new NullPointerException();
        }
        ClassFileTransformer traceTransformer = this.traceTransformers.get(transformer);
        if (traceTransformer == null) {
            throw new IllegalArgumentException();
        }
        this.instrumentation.setNativeMethodPrefix(traceTransformer, prefix);
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"setNativeMethodPrefix");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        TraceClassFileTransformer.initialize();
    }
}

