/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.internal.osgi;

import com.ibm.websphere.ras.TrConfigurator;
import com.ibm.ws.logging.WsTraceHandler;
import com.ibm.ws.logging.WsTraceRouter;
import com.ibm.ws.logging.internal.osgi.WsTraceRouterImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class TraceRouterConfigurator {
    private BundleContext bundleContext = null;
    private WsTraceRouterImpl traceRouter = null;
    private final ServiceListener wsTraceHandlerListener = new ServiceListener(){

        public void serviceChanged(ServiceEvent event) {
            switch (event.getType()) {
                case 1: {
                    TraceRouterConfigurator.this.setWsTraceHandler((ServiceReference<WsTraceHandler>)event.getServiceReference());
                    break;
                }
                case 4: {
                    TraceRouterConfigurator.this.unsetWsTraceHandler((ServiceReference<WsTraceHandler>)event.getServiceReference());
                    break;
                }
            }
        }
    };

    public TraceRouterConfigurator(BundleContext context) {
        this.bundleContext = context;
        try {
            this.bundleContext.addServiceListener(this.wsTraceHandlerListener, "(objectClass=com.ibm.ws.logging.WsTraceHandler)");
            this.processInitialTraceHandlerServices();
        }
        catch (InvalidSyntaxException ise) {
            throw new RuntimeException(ise);
        }
    }

    protected void setWsTraceHandler(ServiceReference<WsTraceHandler> ref) {
        this.getTraceRouter().setWsTraceHandler((String)ref.getProperty("id"), (WsTraceHandler)this.bundleContext.getService(ref));
    }

    protected void unsetWsTraceHandler(ServiceReference<WsTraceHandler> ref) {
        this.getTraceRouter().unsetWsTraceHandler((String)ref.getProperty("id"), (WsTraceHandler)this.bundleContext.getService(ref));
    }

    protected void processInitialTraceHandlerServices() throws InvalidSyntaxException {
        ServiceReference[] servRefs = this.bundleContext.getServiceReferences(WsTraceHandler.class.getName(), null);
        if (servRefs != null) {
            for (ServiceReference servRef : servRefs) {
                this.setWsTraceHandler((ServiceReference<WsTraceHandler>)servRef);
            }
        }
    }

    protected WsTraceRouterImpl getTraceRouter() {
        if (this.traceRouter == null) {
            this.traceRouter = WsTraceRouterSingleton.singleton;
            TrConfigurator.setTraceRouter((WsTraceRouter)this.traceRouter);
        }
        return this.traceRouter;
    }

    public void stop() {
        if (this.traceRouter != null) {
            TrConfigurator.unsetTraceRouter((WsTraceRouter)this.traceRouter);
        }
    }

    private static class WsTraceRouterSingleton {
        public static final WsTraceRouterImpl singleton = new WsTraceRouterImpl();

        private WsTraceRouterSingleton() {
        }
    }
}

