/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.featureUtility.cli;

import com.ibm.ws.install.featureUtility.cli.FeatureAction;
import com.ibm.ws.kernel.boot.ReturnCode;
import com.ibm.ws.kernel.boot.cmdline.ActionHandler;
import com.ibm.ws.kernel.boot.cmdline.Arguments;
import com.ibm.ws.kernel.boot.cmdline.ExitCode;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class FeatureHelpAction
implements ActionHandler {
    private static final String COMMAND = "featureUtility";
    private static final String NL = System.getProperty("line.separator");
    public static final ResourceBundle featureUtilityToolOptions = ResourceBundle.getBundle("com.ibm.ws.install.featureUtility.internal.resources.FeatureUtilityToolOptions");

    public String getScriptUsage() {
        StringBuffer scriptUsage = new StringBuffer(NL);
        scriptUsage.append(FeatureHelpAction.getHelpPart("usage", COMMAND));
        scriptUsage.append(" {");
        FeatureAction[] tasks = FeatureAction.values();
        for (int i = 0; i < tasks.length; ++i) {
            FeatureAction task = tasks[i];
            scriptUsage.append(task.toString());
            if (i == tasks.length - 1) continue;
            scriptUsage.append("|");
        }
        scriptUsage.append("} [");
        scriptUsage.append(FeatureHelpAction.getHelpPart("global.options.lower", new Object[0]));
        scriptUsage.append("]");
        scriptUsage.append(NL);
        return scriptUsage.toString();
    }

    private String getDescription(FeatureAction action) {
        return FeatureHelpAction.getHelpPart((Object)((Object)action) + ".desc", new Object[0]);
    }

    public StringBuilder getVerboseHelp() {
        StringBuilder verboseHelp = new StringBuilder(this.getScriptUsage());
        verboseHelp.append(NL);
        verboseHelp.append(FeatureHelpAction.getHelpPart("global.actions", new Object[0]));
        verboseHelp.append(NL);
        for (FeatureAction action : FeatureAction.values()) {
            verboseHelp.append(NL);
            verboseHelp.append("    ");
            verboseHelp.append(action.toString());
            if (!action.getAbbreviation().isEmpty()) {
                verboseHelp.append(", ").append(action.getAbbreviation());
            }
            verboseHelp.append(NL);
            verboseHelp.append(this.getDescription(action));
            verboseHelp.append(NL);
        }
        verboseHelp.append(NL);
        verboseHelp.append(FeatureHelpAction.getHelpPart("global.options", new Object[0]));
        verboseHelp.append(NL);
        verboseHelp.append(FeatureHelpAction.getHelpPart("global.options.statement", new Object[0]));
        verboseHelp.append(NL);
        verboseHelp.append(NL);
        return verboseHelp;
    }

    public String getTaskUsage(FeatureAction task) {
        StringBuilder taskUsage = new StringBuilder(NL);
        taskUsage.append(FeatureHelpAction.getHelpPart("global.usage", new Object[0]));
        taskUsage.append(NL);
        taskUsage.append('\t');
        taskUsage.append(COMMAND);
        taskUsage.append(' ');
        taskUsage.append((Object)task);
        if (task.showOptions()) {
            taskUsage.append(" [");
            taskUsage.append(FeatureHelpAction.getHelpPart("global.options.lower", new Object[0]));
            taskUsage.append("]");
        }
        List<String> options = task.getCommandOptions();
        for (String option : options) {
            if (option.charAt(0) == '-') continue;
            taskUsage.append(' ');
            taskUsage.append(option);
        }
        taskUsage.append(NL);
        if (!task.getAbbreviation().isEmpty()) {
            taskUsage.append('\t');
            taskUsage.append(COMMAND);
            taskUsage.append(' ');
            taskUsage.append(task.getAbbreviation());
            if (task.showOptions()) {
                taskUsage.append(" [");
                taskUsage.append(FeatureHelpAction.getHelpPart("global.options.lower", new Object[0]));
                taskUsage.append("]");
            }
            for (String option : options) {
                if (option.charAt(0) == '-') continue;
                taskUsage.append(' ');
                taskUsage.append(option);
            }
            taskUsage.append(NL);
        }
        taskUsage.append(NL);
        taskUsage.append(FeatureHelpAction.getHelpPart("global.description", new Object[0]));
        taskUsage.append(NL);
        taskUsage.append(this.getDescription(task));
        taskUsage.append(NL);
        if (options.size() > 0) {
            taskUsage.append(NL);
            taskUsage.append(FeatureHelpAction.getHelpPart("global.options", new Object[0]));
            for (String option : task.getCommandOptions()) {
                String optionKey;
                taskUsage.append(NL);
                try {
                    optionKey = FeatureHelpAction.getHelpPart((Object)((Object)task) + ".option-key." + option, new Object[0]);
                }
                catch (MissingResourceException e) {
                    optionKey = "    " + option;
                }
                taskUsage.append(optionKey);
                taskUsage.append(NL);
                taskUsage.append(FeatureHelpAction.getHelpPart((Object)((Object)task) + ".option-desc." + option, new Object[0]));
                taskUsage.append(NL);
            }
        }
        taskUsage.append(NL);
        return taskUsage.toString();
    }

    public static String getHelpPart(String key, Object ... args) {
        String option = featureUtilityToolOptions.getString(key);
        return args.length == 0 ? option : MessageFormat.format(option, args);
    }

    public ExitCode handleTask(PrintStream stdout, PrintStream stderr, Arguments args) {
        ReturnCode retCode = ReturnCode.OK;
        String actionName = args.getAction();
        if (actionName == null) {
            stdout.println(this.getScriptUsage());
        } else if (args.getPositionalArguments().isEmpty()) {
            stdout.println(this.getVerboseHelp());
        } else {
            try {
                FeatureAction task = FeatureAction.getEnum((String)args.getPositionalArguments().get(0));
                stdout.println(this.getTaskUsage(task));
            }
            catch (IllegalArgumentException e) {
                stderr.println();
                stderr.println(FeatureHelpAction.getHelpPart("task.unknown", args.getPositionalArguments().get(0)));
                stdout.println(this.getScriptUsage());
                retCode = ReturnCode.BAD_ARGUMENT;
            }
        }
        return retCode;
    }
}

