/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras.hpel;

import com.ibm.ejs.ras.hpel.HpelHelper;
import com.ibm.ejs.ras.hpel.NullOutputStream;
import com.ibm.ws.logging.hpel.handlers.LogRecordHandler;
import com.ibm.ws.logging.hpel.handlers.LogRecordTextHandler;
import com.ibm.ws.logging.hpel.handlers.LogRepositoryConfiguration;
import java.io.PrintStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class HpelSystemStream
extends PrintStream {
    private static final String TEXTLOGGER_HANDLER_NAME = LogRecordTextHandler.class.getName();
    private static final String BINLOGGER_HANDLER_NAME = LogRecordHandler.class.getName();
    private static final LogRepositoryConfiguration logRepositoryConfiguration = LogRepositoryConfiguration.getLogRepositoryConfiguration();
    private static final String svTrue = "true";
    private static final String svFalse = "false";
    private static final String svLineSeparator = HpelHelper.getSystemProperty("line.separator");
    private static final byte[] svLineSeparatorBytes = svLineSeparator.getBytes();
    private static final char[] svLineSeparatorChars = svLineSeparator.toCharArray();
    private boolean ivSuppress;
    private StringBuilder buffer = new StringBuilder();
    private int ivCacheSize = 0;
    private static final int svMaxCacheSize = 8192;
    private Logger logger;
    private static LogRecordHandler binaryHandler;
    private static LogRecordTextHandler textHandler;

    HpelSystemStream(String loggerName) {
        super(new NullOutputStream());
        this.logger = Logger.getLogger(loggerName);
    }

    public synchronized void dispatchEvent(LogRecord event) {
        if (binaryHandler == null || textHandler == null && logRepositoryConfiguration.isTextEnabled() || textHandler != null && !logRepositoryConfiguration.isTextEnabled()) {
            HpelSystemStream.determineHandlers();
        }
        if (binaryHandler == null) {
            return;
        }
        binaryHandler.publish(event);
        if (textHandler != null) {
            textHandler.publish(event);
        }
    }

    public static synchronized void reset() {
        binaryHandler = null;
        textHandler = null;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    @Override
    public boolean checkError() {
        return false;
    }

    @Override
    public void write(int b) {
        if (this.ivSuppress) {
            return;
        }
        byte[] data = new byte[]{(byte)b};
        LogRecord se = this.cacheTraceData(data);
        if (se != null) {
            this.dispatchEvent(se);
        }
    }

    @Override
    public void write(byte[] buffer, int offset, int len) {
        if (this.ivSuppress) {
            return;
        }
        if (len == 0) {
            return;
        }
        if (buffer == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || len < 0) {
            throw new IndexOutOfBoundsException();
        }
        int size = buffer.length;
        if (offset > size || len > size || offset + len > size) {
            throw new IndexOutOfBoundsException();
        }
        if (offset + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        byte[] data = new byte[len];
        System.arraycopy(buffer, offset, data, 0, len);
        LogRecord se = this.cacheTraceData(data);
        if (se != null) {
            this.dispatchEvent(se);
        }
    }

    private static boolean endsWithLineSeparator(String s) {
        if (s == null) {
            return false;
        }
        return s.endsWith(svLineSeparator);
    }

    private static boolean endsWithLineSeparator(byte[] b) {
        if (b == null) {
            return false;
        }
        if (b.length < svLineSeparatorBytes.length) {
            return false;
        }
        for (int i = 1; i <= svLineSeparatorBytes.length; ++i) {
            if (b[b.length - i] == svLineSeparatorBytes[svLineSeparatorBytes.length - i]) continue;
            return false;
        }
        return true;
    }

    private static boolean endsWithLineSeparator(char[] c) {
        if (c == null) {
            return false;
        }
        if (c.length < svLineSeparatorChars.length) {
            return false;
        }
        for (int i = 1; i <= svLineSeparatorBytes.length; ++i) {
            if (c[c.length - i] == svLineSeparatorBytes[svLineSeparatorBytes.length - i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public void print(boolean x) {
        if (this.ivSuppress) {
            return;
        }
        if (!x) {
            this.doPrint(svFalse);
        } else {
            this.doPrint(svTrue);
        }
    }

    @Override
    public void print(char x) {
        if (this.ivSuppress) {
            return;
        }
        String writeData = String.valueOf(x);
        this.doPrint(writeData);
    }

    @Override
    public void print(int x) {
        if (this.ivSuppress) {
            return;
        }
        String writeData = String.valueOf(x);
        this.doPrint(writeData);
    }

    @Override
    public void print(long x) {
        if (this.ivSuppress) {
            return;
        }
        String writeData = String.valueOf(x);
        this.doPrint(writeData);
    }

    @Override
    public void print(float x) {
        if (this.ivSuppress) {
            return;
        }
        String writeData = String.valueOf(x);
        this.doPrint(writeData);
    }

    @Override
    public void print(double x) {
        if (this.ivSuppress) {
            return;
        }
        String writeData = String.valueOf(x);
        this.doPrint(writeData);
    }

    @Override
    public void print(char[] x) {
        if (this.ivSuppress) {
            return;
        }
        LogRecord se = this.cacheTraceData(x);
        if (se != null) {
            this.dispatchEvent(se);
        }
    }

    @Override
    public void print(String x) {
        if (this.ivSuppress) {
            return;
        }
        this.doPrint(x);
    }

    @Override
    public void print(Object obj) {
        if (this.ivSuppress) {
            return;
        }
        String writeData = String.valueOf(obj);
        this.doPrint(writeData);
    }

    @Override
    public void println() {
        if (this.ivSuppress) {
            return;
        }
        String writeData = null;
        LogRecord sse = null;
        sse = this.getTraceData(writeData);
        this.dispatchEvent(sse);
    }

    @Override
    public void println(boolean x) {
        if (this.ivSuppress) {
            return;
        }
        if (x) {
            this.doPrintLine(svTrue);
        } else {
            this.doPrintLine(svFalse);
        }
    }

    @Override
    public void println(char x) {
        if (this.ivSuppress) {
            return;
        }
        String writeData = String.valueOf(x);
        this.doPrintLine(writeData);
    }

    @Override
    public void println(int x) {
        if (this.ivSuppress) {
            return;
        }
        String writeData = String.valueOf(x);
        this.doPrintLine(writeData);
    }

    @Override
    public void println(long x) {
        if (this.ivSuppress) {
            return;
        }
        String writeData = String.valueOf(x);
        this.doPrintLine(writeData);
    }

    @Override
    public void println(float x) {
        if (this.ivSuppress) {
            return;
        }
        String writeData = String.valueOf(x);
        this.doPrintLine(writeData);
    }

    @Override
    public void println(double x) {
        if (this.ivSuppress) {
            return;
        }
        String writeData = String.valueOf(x);
        this.doPrintLine(writeData);
    }

    @Override
    public void println(char[] x) {
        if (this.ivSuppress) {
            return;
        }
        LogRecord sse = null;
        sse = this.getTraceData(x);
        this.dispatchEvent(sse);
    }

    @Override
    public void println(String x) {
        if (this.ivSuppress) {
            return;
        }
        this.doPrintLine(x);
    }

    @Override
    public void println(Object x) {
        if (this.ivSuppress) {
            return;
        }
        String writeData = null;
        writeData = x instanceof Throwable ? HpelHelper.throwableToString((Throwable)x) : String.valueOf(x);
        this.doPrintLine(writeData);
    }

    private final void doPrint(String data) {
        LogRecord se = this.cacheTraceData(data);
        if (se != null) {
            this.dispatchEvent(se);
        }
    }

    private final void doPrintLine(String data) {
        LogRecord sse = this.getTraceData(data);
        this.dispatchEvent(sse);
    }

    private synchronized LogRecord cacheTraceData(String data) {
        int size;
        int n = size = data == null ? 8 : data.length() * 2;
        if (this.ivCacheSize + size > 8192) {
            return this.getTraceData(data);
        }
        if (HpelSystemStream.endsWithLineSeparator(data)) {
            return this.getTraceData(data);
        }
        this.buffer.append(data);
        this.ivCacheSize += size;
        return null;
    }

    private synchronized LogRecord cacheTraceData(byte[] data) {
        int size;
        int n = size = data == null ? 0 : data.length;
        if (this.ivCacheSize + size > 8192) {
            return this.getTraceData(data);
        }
        if (HpelSystemStream.endsWithLineSeparator(data)) {
            return this.getTraceData(data);
        }
        this.buffer.append(data);
        this.ivCacheSize += size;
        return null;
    }

    private synchronized LogRecord cacheTraceData(char[] data) {
        int size;
        int n = size = data == null ? 0 : data.length;
        if (this.ivCacheSize + size > 8192) {
            return this.getTraceData(data);
        }
        if (HpelSystemStream.endsWithLineSeparator(data)) {
            return this.getTraceData(data);
        }
        this.buffer.append(data);
        this.ivCacheSize += size;
        return null;
    }

    private synchronized LogRecord getTraceData(String data) {
        this.buffer.append(data);
        LogRecord se = new LogRecord(Level.parse("625"), this.buffer.toString());
        se.setSourceClassName("");
        se.setSourceMethodName("");
        se.setLoggerName(this.logger.getName());
        this.buffer = new StringBuilder();
        this.ivCacheSize = 0;
        return se;
    }

    private synchronized LogRecord getTraceData(byte[] data) {
        this.buffer.append(new String(data));
        LogRecord se = new LogRecord(Level.parse("625"), this.buffer.toString());
        se.setLoggerName(this.logger.getName());
        this.buffer = new StringBuilder();
        this.ivCacheSize = 0;
        return se;
    }

    private synchronized LogRecord getTraceData(char[] data) {
        this.buffer.append(data);
        LogRecord se = new LogRecord(Level.parse("625"), this.buffer.toString());
        se.setLoggerName(this.logger.getName());
        this.buffer = new StringBuilder();
        this.ivCacheSize = 0;
        return se;
    }

    public static void redirectStreams() {
        try {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    HpelSystemStream newErr = new HpelSystemStream("SystemErr");
                    System.setErr(newErr);
                    HpelSystemStream newOut = new HpelSystemStream("SystemOut");
                    System.setOut(newOut);
                    return null;
                }
            });
        }
        catch (Throwable t) {
            throw new RuntimeException("Unable to replace System streams", t);
        }
        HpelSystemStream.reset();
    }

    private static void determineHandlers() {
        Handler[] handlers;
        if (textHandler != null && !logRepositoryConfiguration.isTextEnabled()) {
            textHandler = null;
        }
        if (binaryHandler != null && !logRepositoryConfiguration.isTextEnabled()) {
            return;
        }
        for (Handler handler : handlers = Logger.getLogger("").getHandlers()) {
            String name = handler.getClass().getName();
            if (BINLOGGER_HANDLER_NAME.equals(name)) {
                binaryHandler = (LogRecordHandler)handler;
                continue;
            }
            if (!TEXTLOGGER_HANDLER_NAME.equals(name)) continue;
            textHandler = (LogRecordTextHandler)handler;
        }
    }
}

