/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.repository.resolver;

import com.ibm.ws.kernel.feature.provisioning.FeatureResource;
import com.ibm.ws.kernel.feature.provisioning.ProvisioningFeatureDefinition;
import com.ibm.ws.kernel.feature.provisioning.SubsystemContentType;
import com.ibm.ws.repository.resolver.Walker;
import com.ibm.ws.repository.resolver.internal.kernel.CapabilityMatching;
import com.ibm.ws.repository.resolver.internal.kernel.KernelResolverRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class FeatureTreeWalker {
    private Consumer<? super ProvisioningFeatureDefinition> forEach;
    private BiConsumer<? super ProvisioningFeatureDefinition, ? super FeatureResource> onMissingDependency;
    private boolean useAutofeatureProvisionAsDependency = true;
    private final Supplier<Collection<? extends ProvisioningFeatureDefinition>> allFeaturesSupplier;
    private final Function<String, ProvisioningFeatureDefinition> getFeatureByNameFunction;
    private HashSet<ProvisioningFeatureDefinition> seenFeatures;
    private DependencyConsumer forEachLink;

    public static FeatureTreeWalker walkOver(KernelResolverRepository repositry) {
        return new FeatureTreeWalker(repositry::getAllFeatures, repositry::getFeature);
    }

    public static FeatureTreeWalker walkOver(Map<String, ProvisioningFeatureDefinition> resolvedFeatureMap) {
        return new FeatureTreeWalker(resolvedFeatureMap::values, resolvedFeatureMap::get);
    }

    private FeatureTreeWalker(Supplier<Collection<? extends ProvisioningFeatureDefinition>> allFeaturesSupplier, Function<String, ProvisioningFeatureDefinition> getFeatureByNameFunction) {
        this.allFeaturesSupplier = allFeaturesSupplier;
        this.getFeatureByNameFunction = getFeatureByNameFunction;
    }

    public void walkBreadthFirst(Collection<ProvisioningFeatureDefinition> roots) {
        Walker.walkCollectionBreadthFirst(roots, this::visitFeature, this::getChildren);
    }

    public void walkBreadthFirst(ProvisioningFeatureDefinition root) {
        Walker.walkBreadthFirst(root, this::visitFeature, this::getChildren);
    }

    public void walkDepthFirst(ProvisioningFeatureDefinition root) {
        Walker.walkDepthFirst(root, this::visitFeature, this::getChildren);
    }

    public FeatureTreeWalker forEach(Consumer<? super ProvisioningFeatureDefinition> forEach) {
        this.forEach = forEach;
        return this;
    }

    public FeatureTreeWalker forEachLink(DependencyConsumer forEachLink) {
        this.forEachLink = forEachLink;
        return this;
    }

    public FeatureTreeWalker onMissingDependency(BiConsumer<? super ProvisioningFeatureDefinition, ? super FeatureResource> onMissingDependency) {
        this.onMissingDependency = onMissingDependency;
        return this;
    }

    public FeatureTreeWalker useAutofeatureProvisionAsDependency(boolean useAutofeatureProvisionAsDependency) {
        this.useAutofeatureProvisionAsDependency = useAutofeatureProvisionAsDependency;
        return this;
    }

    public FeatureTreeWalker walkEachFeatureOnlyOnce() {
        this.seenFeatures = new HashSet();
        return this;
    }

    private List<ProvisioningFeatureDefinition> getChildren(ProvisioningFeatureDefinition feature) {
        ArrayList<ProvisioningFeatureDefinition> result = new ArrayList<ProvisioningFeatureDefinition>();
        for (FeatureResource dependency : feature.getConstituents(SubsystemContentType.FEATURE_TYPE)) {
            List<ProvisioningFeatureDefinition> children = this.findDependencies(dependency);
            if (children.isEmpty()) {
                this.processMissingDependency(feature, dependency);
            }
            result.addAll(children);
        }
        if (this.useAutofeatureProvisionAsDependency) {
            result.addAll(CapabilityMatching.findFeaturesSatisfyingCapability(feature, this.allFeaturesSupplier.get()));
        }
        return result;
    }

    private List<ProvisioningFeatureDefinition> findDependencies(FeatureResource featureResource) {
        ArrayList<ProvisioningFeatureDefinition> result = new ArrayList<ProvisioningFeatureDefinition>();
        ProvisioningFeatureDefinition feature = this.getFeatureByNameFunction.apply(featureResource.getSymbolicName());
        if (feature != null) {
            result.add(feature);
        }
        String baseName = this.getFeatureBaseName(featureResource.getSymbolicName());
        List tolerates = featureResource.getTolerates();
        if (tolerates != null) {
            for (String toleratedVersion : tolerates) {
                String featureName = baseName + toleratedVersion;
                feature = this.getFeatureByNameFunction.apply(featureName);
                if (feature == null) continue;
                result.add(feature);
            }
        }
        return result;
    }

    private void processMissingDependency(ProvisioningFeatureDefinition feature, FeatureResource dependency) {
        if (this.onMissingDependency != null) {
            this.onMissingDependency.accept((ProvisioningFeatureDefinition)feature, (FeatureResource)dependency);
        }
    }

    private Walker.WalkDecision visitFeature(ProvisioningFeatureDefinition parent, ProvisioningFeatureDefinition feature) {
        if (this.forEachLink != null) {
            this.forEachLink.accept(parent, feature);
        }
        if (this.seenFeatures != null) {
            if (this.seenFeatures.contains(feature)) {
                return Walker.WalkDecision.IGNORE_CHILDREN;
            }
            this.seenFeatures.add(feature);
        }
        if (this.forEach != null) {
            this.forEach.accept((ProvisioningFeatureDefinition)feature);
        }
        return Walker.WalkDecision.WALK_CHILDREN;
    }

    private String getFeatureBaseName(String nameAndVersion) {
        int dashPosition = nameAndVersion.lastIndexOf(45);
        if (dashPosition != -1) {
            return nameAndVersion.substring(0, dashPosition + 1);
        }
        return nameAndVersion;
    }

    @FunctionalInterface
    public static interface DependencyConsumer {
        public void accept(ProvisioningFeatureDefinition var1, ProvisioningFeatureDefinition var2);
    }
}

