/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.faulttolerance.impl.policy;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.microprofile.faulttolerance.spi.RetryPolicy;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.eclipse.microprofile.faulttolerance.Retry;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class RetryPolicyImpl
implements RetryPolicy {
    private static final TraceComponent tc = Tr.register(RetryPolicyImpl.class, (String)"FAULTTOLERANCE", (String)"com.ibm.ws.microprofile.faulttolerance.resources.FaultTolerance");
    private int maxRetries;
    private Duration delay;
    private Duration maxDuration;
    private Duration jitter;
    private Class<? extends Throwable>[] retryOn;
    private Class<? extends Throwable>[] abortOn;
    static final long serialVersionUID = 856322626658761595L;

    /*
     * WARNING - void declaration
     */
    public RetryPolicyImpl() {
        try {
            this.maxRetries = (Integer)Retry.class.getMethod("maxRetries", new Class[0]).getDefaultValue();
            long longDelay = (Long)Retry.class.getMethod("delay", new Class[0]).getDefaultValue();
            ChronoUnit delayUnit = (ChronoUnit)Retry.class.getMethod("delayUnit", new Class[0]).getDefaultValue();
            this.delay = Duration.of(longDelay, delayUnit);
            long longMaxDuration = (Long)Retry.class.getMethod("maxDuration", new Class[0]).getDefaultValue();
            ChronoUnit durationUnit = (ChronoUnit)Retry.class.getMethod("durationUnit", new Class[0]).getDefaultValue();
            this.maxDuration = Duration.of(longMaxDuration, durationUnit);
            long longJitter = (Long)Retry.class.getMethod("jitter", new Class[0]).getDefaultValue();
            ChronoUnit jitterUnit = (ChronoUnit)Retry.class.getMethod("jitterDelayUnit", new Class[0]).getDefaultValue();
            this.jitter = Duration.of(longJitter, jitterUnit);
            this.retryOn = (Class[])Retry.class.getMethod("retryOn", new Class[0]).getDefaultValue();
            this.abortOn = (Class[])Retry.class.getMethod("abortOn", new Class[0]).getDefaultValue();
        }
        catch (NoSuchMethodException | SecurityException longDelay) {
            void e;
            FFDCFilter.processException((Throwable)longDelay, (String)"com.ibm.ws.microprofile.faulttolerance.impl.policy.RetryPolicyImpl", (String)"60", (Object)this, (Object[])new Object[0]);
            throw new FaultToleranceException(Tr.formatMessage((TraceComponent)tc, (String)"internal.error.CWMFT4998E", (Object[])new Object[]{e}), (Throwable)e);
        }
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public Duration getDelay() {
        return this.delay;
    }

    public void setDelay(Duration delay) {
        this.delay = delay;
    }

    public Duration getMaxDuration() {
        return this.maxDuration;
    }

    public void setMaxDuration(Duration maxDuration) {
        this.maxDuration = maxDuration;
    }

    public Duration getJitter() {
        return this.jitter;
    }

    public void setJitter(Duration jitter) {
        this.jitter = jitter;
    }

    public Class<? extends Throwable>[] getRetryOn() {
        return this.retryOn;
    }

    public void setRetryOn(Class<? extends Throwable> ... retryOn) {
        this.retryOn = retryOn;
    }

    public Class<? extends Throwable>[] getAbortOn() {
        return this.abortOn;
    }

    public void setAbortOn(Class<? extends Throwable> ... abortOn) {
        this.abortOn = abortOn;
    }
}

