/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.openapi20.validation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.openapi20.utils.Constants;
import io.openliberty.microprofile.openapi20.utils.OpenAPIModelWalker;
import io.openliberty.microprofile.openapi20.validation.OASValidationResult;
import io.openliberty.microprofile.openapi20.validation.ReferenceValidator;
import io.openliberty.microprofile.openapi20.validation.ValidationHelper;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.microprofile.openapi.models.security.OAuthFlow;
import org.eclipse.microprofile.openapi.models.security.OAuthFlows;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ValidatorUtils {
    private static final TraceComponent tc = Tr.register(ValidatorUtils.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.validation.ValidationMessages");
    static final long serialVersionUID = 2206839596250074618L;

    public static <T> Optional<OASValidationResult.ValidationEvent> validateRequiredField(T value, OpenAPIModelWalker.Context context, String fieldName) {
        boolean isValid = true;
        if (value == null) {
            isValid = false;
        } else {
            if (value instanceof String && StringUtils.isBlank((CharSequence)((String)value))) {
                isValid = false;
            }
            if (value instanceof Map && ((Map)value).isEmpty()) {
                isValid = false;
            }
        }
        if (!isValid) {
            String location = context.getLocation();
            String message = Tr.formatMessage((TraceComponent)tc, (String)"requiredFieldMissing", (Object[])new Object[]{fieldName});
            OASValidationResult.ValidationEvent event = new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, location, message);
            return Optional.of(event);
        }
        return Optional.empty();
    }

    @FFDCIgnore(value={MalformedURLException.class})
    public static boolean isValidURL(String urlStr) {
        try {
            URL url = new URL(urlStr);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    @FFDCIgnore(value={URISyntaxException.class})
    public static boolean isValidURI(String uriStr) {
        try {
            URI uri = new URI(uriStr);
            return true;
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    public static boolean flowsIsSet(OAuthFlows flows) {
        if (flows != null) {
            OAuthFlow implicit = flows.getImplicit();
            OAuthFlow authCode = flows.getAuthorizationCode();
            OAuthFlow clientCred = flows.getClientCredentials();
            OAuthFlow password = flows.getPassword();
            if (implicit != null && (StringUtils.isNotBlank((CharSequence)implicit.getAuthorizationUrl()) || StringUtils.isNotBlank((CharSequence)implicit.getRefreshUrl()) || StringUtils.isNotBlank((CharSequence)implicit.getTokenUrl()) || implicit.getScopes() != null || implicit.getExtensions() != null)) {
                return true;
            }
            if (authCode != null && (StringUtils.isNotBlank((CharSequence)authCode.getTokenUrl()) || StringUtils.isNotBlank((CharSequence)authCode.getAuthorizationUrl()) || StringUtils.isNotBlank((CharSequence)authCode.getRefreshUrl()) || authCode.getScopes() != null || authCode.getExtensions() != null)) {
                return true;
            }
            if (clientCred != null && (StringUtils.isNotBlank((CharSequence)clientCred.getTokenUrl()) || StringUtils.isNotBlank((CharSequence)clientCred.getRefreshUrl()) || StringUtils.isNotBlank((CharSequence)clientCred.getAuthorizationUrl()) || clientCred.getScopes() != null || clientCred.getExtensions() != null)) {
                return true;
            }
            if (password != null && (StringUtils.isNotBlank((CharSequence)password.getTokenUrl()) || StringUtils.isNotBlank((CharSequence)password.getRefreshUrl()) || StringUtils.isNotBlank((CharSequence)password.getAuthorizationUrl()) || password.getScopes() != null || password.getExtensions() != null)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isValidEmailAddress(String email) {
        return Constants.REGEX_EMAIL_PATTERN.matcher(email).matches();
    }

    public static void referenceValidatorHelper(String reference, Object t, ValidationHelper helper, OpenAPIModelWalker.Context context, String key) {
        ReferenceValidator referenceValidator = ReferenceValidator.getInstance();
        Object component = referenceValidator.validate(helper, context, key, reference);
        if (!t.getClass().isInstance(component)) {
            String message = Tr.formatMessage((TraceComponent)tc, (String)"referenceToObjectInvalid", (Object[])new Object[]{reference});
            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
        }
    }

    public static String formatMessage(String messageId, String ... strings) {
        return Tr.formatMessage((TraceComponent)tc, (String)messageId, (Object[])strings);
    }
}

