/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.event.internal;

import com.ibm.websphere.event.Event;
import com.ibm.websphere.event.EventHandle;
import com.ibm.websphere.event.EventLocal;
import com.ibm.websphere.event.ReservedKey;
import com.ibm.websphere.event.Topic;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.event.internal.EventLocalMap;
import com.ibm.ws.event.internal.MapDictionary;
import com.ibm.ws.event.internal.TopicData;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import org.osgi.framework.Filter;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class EventImpl
implements Event,
EventHandle {
    private final Topic topic;
    private MapDictionary<String, Object> properties = new MapDictionary();
    private TopicData topicData;
    private Future<?>[] futures;
    private EventImpl parent = null;
    private EventLocalMap<EventLocal<?>, Object> locals = null;
    private EventLocalMap<EventLocal<?>, Object> inheritableLocals = null;
    private volatile Set<String> eventLocalNames = null;
    static final long serialVersionUID = 281760639123616779L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addEventLocalName(String name) {
        Set<String> localNames = this.eventLocalNames;
        if (localNames == null) {
            EventImpl eventImpl = this;
            synchronized (eventImpl) {
                localNames = this.eventLocalNames;
                if (localNames == null) {
                    localNames = this.eventLocalNames = Collections.synchronizedSet(new HashSet());
                }
            }
        }
        return localNames.add(name);
    }

    public void removeEventLocalName(String name) {
        if (this.eventLocalNames != null) {
            this.eventLocalNames.remove(name);
        }
    }

    protected EventImpl(Topic value) {
        this.topic = value;
    }

    void setTopicData(TopicData value) {
        this.topicData = value;
    }

    TopicData getTopicData() {
        return this.topicData;
    }

    @Override
    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    @Override
    public Object getProperty(ReservedKey key) {
        return this.properties.get(key.getName());
    }

    @Override
    public <T> T getProperty(String name, Class<T> type) {
        return (T)this.getProperty(name);
    }

    @Override
    public <T> T getProperty(ReservedKey key, Class<T> type) {
        return (T)this.getProperty(key);
    }

    @Override
    public List<String> getPropertyNames() {
        int size = this.properties.size();
        if (0 == size) {
            return Collections.emptyList();
        }
        ArrayList<String> names = new ArrayList<String>(size);
        names.addAll(this.properties.keySet());
        return names;
    }

    void setReadOnly(boolean readOnly) {
        this.properties.setReadOnly(readOnly);
    }

    @Override
    public void setProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    @Override
    public void setProperty(ReservedKey key, Object value) {
        this.properties.put(key.getName(), value);
    }

    public void setProperties(Map<String, ? extends Object> newProps) {
        this.properties.putAll(newProps);
    }

    final Topic getTopicObject() {
        return this.topic;
    }

    @Override
    @Trivial
    public String getTopic() {
        return this.getTopicObject().getName();
    }

    public final MapDictionary<String, Object> getProperties() {
        if (this.properties.isReadyOnly()) {
            return this.properties;
        }
        return new MapDictionary<String, Object>(this.properties);
    }

    @Override
    public boolean matches(Filter filter) {
        return filter.match((Dictionary)((Object)this.getProperties()));
    }

    public String toString() {
        return "[" + this.getTopic() + "]";
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.futures == null) {
            return false;
        }
        for (Future<?> future : this.futures) {
            if (future.cancel(mayInterruptIfRunning)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isCancelled() {
        if (this.futures == null) {
            return false;
        }
        for (Future<?> future : this.futures) {
            if (future.isCancelled()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isDone() {
        if (this.futures == null) {
            return true;
        }
        for (Future<?> future : this.futures) {
            if (future.isDone()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void waitForCompletion() {
        if (this.futures == null) {
            return;
        }
        for (Future<?> future : this.futures) {
            try {
                future.wait();
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.event.internal.EventImpl", (String)"275", (Object)this, (Object[])new Object[0]);
            }
        }
    }

    public Future<?>[] getFutures() {
        return this.futures;
    }

    public void setFutures(Future<?>[] futures) {
        this.futures = futures;
    }

    public void setParent(EventImpl event) {
        this.parent = event;
    }

    private <T> EventLocalMap<EventLocal<?>, Object> getMap(EventLocal<T> key) {
        if (key.isInheritable()) {
            EventLocalMap<EventLocal<?>, Object> map;
            if (null == this.inheritableLocals && null != this.parent && null != (map = this.parent.getMap(key))) {
                this.inheritableLocals = new EventLocalMap(map);
            }
            return this.inheritableLocals;
        }
        return this.locals;
    }

    public <T> T get(EventLocal<T> key) {
        EventLocalMap<EventLocal<?>, Object> map = this.getMap(key);
        if (null == map) {
            return key.initialValue();
        }
        return (T)map.get(key);
    }

    public <T> void set(EventLocal<T> key, Object value) {
        EventLocalMap<EventLocal<Object>, Object> map = this.getMap(key);
        if (null == map) {
            map = new EventLocalMap();
            if (key.isInheritable()) {
                this.inheritableLocals = map;
            } else {
                this.locals = map;
            }
        }
        map.put(key, value);
    }

    public <T> T remove(EventLocal<T> key) {
        EventLocalMap<EventLocal<?>, Object> map = this.getMap(key);
        if (null != map) {
            return (T)map.remove(key);
        }
        return null;
    }

    public <T> T getContextData(String name) {
        Object rc = null;
        if (null != this.inheritableLocals) {
            rc = this.inheritableLocals.get((EventLocal<?>)((Object)name));
        }
        if (null == rc && null != this.locals) {
            rc = this.locals.get((EventLocal<?>)((Object)name));
        }
        return (T)rc;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.event.internal.EventImpl", EventImpl.class, (String)"EventEngine", null);
    }
}

