/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.logging.source;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.http.channel.internal.values.AccessLogCurrentTime;
import com.ibm.ws.http.channel.internal.values.AccessLogElapsedTime;
import com.ibm.ws.http.channel.internal.values.AccessLogFirstLine;
import com.ibm.ws.http.channel.internal.values.AccessLogRemoteIP;
import com.ibm.ws.http.channel.internal.values.AccessLogRemoteUser;
import com.ibm.ws.http.channel.internal.values.AccessLogRequestCookie;
import com.ibm.ws.http.channel.internal.values.AccessLogRequestHeaderValue;
import com.ibm.ws.http.channel.internal.values.AccessLogResponseHeaderValue;
import com.ibm.ws.http.channel.internal.values.AccessLogResponseSize;
import com.ibm.ws.http.channel.internal.values.AccessLogStartTime;
import com.ibm.ws.http.logging.internal.AccessLogRecordDataExt;
import com.ibm.ws.http.logging.internal.AccessLogger;
import com.ibm.ws.http.logging.source.AccessLogDataFieldSetter;
import com.ibm.ws.logging.collector.BurstDateFormat;
import com.ibm.ws.logging.collector.CollectorJsonHelpers;
import com.ibm.ws.logging.data.AccessLogConfig;
import com.ibm.ws.logging.data.AccessLogData;
import com.ibm.ws.logging.data.AccessLogDataFormatter;
import com.ibm.ws.logging.data.JsonFieldAdder;
import com.ibm.ws.logging.data.KeyValuePair;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.collector.manager.BufferManager;
import com.ibm.wsspi.collector.manager.Source;
import com.ibm.wsspi.http.HttpCookie;
import com.ibm.wsspi.http.logging.AccessLogForwarder;
import com.ibm.wsspi.http.logging.AccessLogRecordData;
import com.ibm.wsspi.http.logging.LogForwarderManager;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class AccessLogSource
implements Source {
    private static final TraceComponent tc = Tr.register(AccessLogSource.class, (String)"logging", (String)"com.ibm.ws.logging.internal.resources.LoggingMessages");
    private final String sourceName = "com.ibm.ws.http.logging.source.accesslog";
    private final String location = "memory";
    private static String USER_AGENT_HEADER = "user-agent";
    public static final int MAX_USER_AGENT_LENGTH = 2048;
    Map<Configuration, SetterFormatter> setterFormatterMap = new ConcurrentHashMap<Configuration, SetterFormatter>();
    public static String jsonAccessLogFieldsConfig = "";
    public static String jsonAccessLogFieldsLogstashConfig = "";
    public Map<String, Object> configuration;
    private static boolean isFirstWarning = true;
    private BufferManager bufferMgr = null;
    private AccessLogHandler accessLogHandler;
    static final long serialVersionUID = 2017508783479283480L;

    protected synchronized void activate(Map<String, Object> configuration) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Activating " + this), (Object[])new Object[0]);
        }
    }

    protected void deactivate(int reason) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)(" Deactivating " + this), (Object[])new Object[]{" reason = " + reason});
        }
    }

    public String getSourceName() {
        return "com.ibm.ws.http.logging.source.accesslog";
    }

    public String getLocation() {
        return "memory";
    }

    public void setBufferManager(BufferManager bufferMgr) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Setting buffer manager " + this), (Object[])new Object[0]);
        }
        this.bufferMgr = bufferMgr;
        this.startSource();
    }

    public void unsetBufferManager(BufferManager bufferMgr) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Un-setting buffer manager " + this), (Object[])new Object[0]);
        }
        this.stopSource();
        this.bufferMgr = null;
    }

    private void startSource() {
        this.accessLogHandler = new AccessLogHandler();
        LogForwarderManager.registerAccessLogForwarder(this.accessLogHandler);
    }

    private void stopSource() {
        LogForwarderManager.deregisterAccessLogForwarder(this.accessLogHandler);
        this.accessLogHandler = null;
    }

    private static void addDefaultFields(Map<String, HashSet<Object>> map) {
        String[] defaultFields;
        for (String s : defaultFields = new String[]{"%h", "%H", "%A", "%B", "%m", "%p", "%q", "%{R}W", "%s", "%U"}) {
            map.put(s, null);
        }
        HashSet<String> data = new HashSet<String>();
        data.add(USER_AGENT_HEADER);
        map.put("%i", data);
    }

    private static void initializeFieldMap(Map<String, HashSet<Object>> map, AccessLogger.FormatSegment[] parsedFormat) {
        AccessLogSource.initializeFieldMap(map, parsedFormat, jsonAccessLogFieldsConfig);
        AccessLogSource.initializeFieldMap(map, parsedFormat, jsonAccessLogFieldsLogstashConfig);
    }

    private static void initializeFieldMap(Map<String, HashSet<Object>> map, AccessLogger.FormatSegment[] parsedFormat, String format) {
        boolean nullHeaderValue = false;
        StringBuilder sb = new StringBuilder();
        if (format.equals("default")) {
            AccessLogSource.addDefaultFields(map);
        }
        if (format.equals("logFormat")) {
            for (AccessLogger.FormatSegment s : parsedFormat) {
                if (s.log == null) continue;
                if (s.data != null) {
                    HashSet<Object> data = new HashSet();
                    if (map.containsKey(s.log.getName())) {
                        data = map.get(s.log.getName());
                    }
                    if (s.log.getName().equals("%i") || s.log.getName().equals("%o")) {
                        data.add(((String)s.data).toLowerCase());
                    } else {
                        data.add(s.data);
                    }
                    map.put(s.log.getName(), data);
                    continue;
                }
                if (s.log.getName().equals("%i") || s.log.getName().equals("%o")) {
                    nullHeaderValue = true;
                    if (sb.length() == 0) {
                        sb.append(s.log.getName());
                        continue;
                    }
                    sb.append(", ").append(s.log.getName());
                    continue;
                }
                map.put(s.log.getName(), null);
            }
        }
        if (isFirstWarning && nullHeaderValue) {
            Tr.warning((TraceComponent)tc, (String)"JSON_ACCESS_LOG_NO_HEADER_NAME_SPECIFIED", (Object[])new Object[]{sb.toString()});
            isFirstWarning = false;
        }
    }

    private static ArrayList<AccessLogDataFieldSetter> populateSetters(Map<String, HashSet<Object>> fields) {
        ArrayList<AccessLogDataFieldSetter> fieldSetters = new ArrayList<AccessLogDataFieldSetter>();
        Iterator<String> iterator = fields.keySet().iterator();
        block44: while (iterator.hasNext()) {
            String f;
            switch (f = iterator.next()) {
                case "%h": {
                    fieldSetters.add((ald, alrd) -> ald.setRemoteHost(alrd.getRemoteAddress()));
                    break;
                }
                case "%H": {
                    fieldSetters.add((ald, alrd) -> ald.setRequestProtocol(alrd.getVersion()));
                    break;
                }
                case "%A": {
                    fieldSetters.add((ald, alrd) -> ald.setRequestHost(alrd.getLocalIP()));
                    break;
                }
                case "%B": {
                    fieldSetters.add((ald, alrd) -> ald.setBytesReceived(alrd.getBytesWritten()));
                    break;
                }
                case "%m": {
                    fieldSetters.add((ald, alrd) -> ald.setRequestMethod(alrd.getRequest().getMethod()));
                    break;
                }
                case "%p": {
                    fieldSetters.add((ald, alrd) -> ald.setRequestPort(alrd.getLocalPort()));
                    break;
                }
                case "%q": {
                    fieldSetters.add((ald, alrd) -> ald.setQueryString(alrd.getRequest().getQueryString()));
                    break;
                }
                case "%{R}W": {
                    fieldSetters.add((ald, alrd) -> ald.setElapsedTime(alrd.getElapsedTime()));
                    break;
                }
                case "%s": {
                    fieldSetters.add((ald, alrd) -> ald.setResponseCode(alrd.getResponse().getStatusCodeAsInt()));
                    break;
                }
                case "%U": {
                    fieldSetters.add((ald, alrd) -> ald.setUriPath(alrd.getRequest().getRequestURI()));
                    break;
                }
                case "%a": {
                    fieldSetters.add((ald, alrd) -> ald.setRemoteIP(AccessLogRemoteIP.getRemoteIP(alrd.getResponse(), alrd.getRequest(), null)));
                    break;
                }
                case "%b": {
                    fieldSetters.add((ald, alrd) -> ald.setBytesSent(AccessLogResponseSize.getResponseSize(alrd.getResponse(), alrd.getRequest(), null)));
                    break;
                }
                case "%C": {
                    if (fields.get("%C") == null) {
                        fieldSetters.add((ald, alrd) -> AccessLogRequestCookie.getAllCookies(alrd.getResponse(), alrd.getRequest(), null).forEach(c -> ald.setCookies(c.getName(), c.getValue())));
                        break;
                    }
                    for (Object data : fields.get("%C")) {
                        fieldSetters.add((ald, alrd) -> {
                            HttpCookie c = AccessLogRequestCookie.getCookie(alrd.getResponse(), alrd.getRequest(), data);
                            if (c != null) {
                                ald.setCookies(c.getName(), c.getValue());
                            }
                        });
                    }
                    continue block44;
                }
                case "%D": {
                    fieldSetters.add((ald, alrd) -> ald.setRequestElapsedTime(AccessLogElapsedTime.getElapsedTimeForJSON(alrd.getResponse(), alrd.getRequest(), null)));
                    break;
                }
                case "%i": {
                    for (Object data : fields.get("%i")) {
                        if (((String)data).equalsIgnoreCase(USER_AGENT_HEADER)) {
                            fieldSetters.add((ald, alrd) -> ald.setUserAgent(alrd.getRequest().getHeader(USER_AGENT_HEADER).asString()));
                            continue;
                        }
                        if (data == null) continue;
                        fieldSetters.add((ald, alrd) -> ald.setRequestHeader((String)data, AccessLogRequestHeaderValue.getHeaderValue(alrd.getResponse(), alrd.getRequest(), data)));
                    }
                    continue block44;
                }
                case "%o": {
                    for (Object data : fields.get("%o")) {
                        if (data == null) continue;
                        fieldSetters.add((ald, alrd) -> ald.setResponseHeader((String)data, AccessLogResponseHeaderValue.getHeaderValue(alrd.getResponse(), alrd.getRequest(), data)));
                    }
                    continue block44;
                }
                case "%r": {
                    fieldSetters.add((ald, alrd) -> ald.setRequestFirstLine(AccessLogFirstLine.getFirstLineAsString(alrd.getResponse(), alrd.getRequest(), null)));
                    break;
                }
                case "%t": {
                    fieldSetters.add((ald, alrd) -> ald.setRequestStartTime(AccessLogStartTime.getStartTimeAsLongForJSON(alrd.getResponse(), alrd.getRequest(), null)));
                    break;
                }
                case "%{t}W": {
                    fieldSetters.add((ald, alrd) -> ald.setAccessLogDatetime(AccessLogCurrentTime.getAccessLogCurrentTimeAsLong(alrd.getResponse(), alrd.getRequest(), null)));
                    break;
                }
                case "%u": {
                    fieldSetters.add((ald, alrd) -> ald.setRemoteUser(AccessLogRemoteUser.getRemoteUser(alrd.getResponse(), alrd.getRequest(), null)));
                }
            }
        }
        return fieldSetters;
    }

    private static AccessLogDataFormatter populateCustomFormatters(Map<String, HashSet<Object>> fields, int format) {
        AccessLogDataFormatter.AccessLogDataFormatterBuilder builder = new AccessLogDataFormatter.AccessLogDataFormatterBuilder();
        Iterator<String> iterator = fields.keySet().iterator();
        while (iterator.hasNext()) {
            String s;
            switch (s = iterator.next()) {
                case "%h": {
                    builder.add(AccessLogSource.addRemoteHostField(format));
                    break;
                }
                case "%H": {
                    builder.add(AccessLogSource.addRequestProtocolField(format));
                    break;
                }
                case "%A": {
                    builder.add(AccessLogSource.addRequestHostField(format));
                    break;
                }
                case "%B": {
                    builder.add(AccessLogSource.addBytesReceivedField(format));
                    break;
                }
                case "%m": {
                    builder.add(AccessLogSource.addRequestMethodField(format));
                    break;
                }
                case "%p": {
                    builder.add(AccessLogSource.addRequestPortField(format));
                    break;
                }
                case "%q": {
                    builder.add(AccessLogSource.addQueryStringField(format));
                    break;
                }
                case "%{R}W": {
                    builder.add(AccessLogSource.addElapsedTimeField(format));
                    break;
                }
                case "%s": {
                    builder.add(AccessLogSource.addResponseCodeField(format));
                    break;
                }
                case "%U": {
                    builder.add(AccessLogSource.addUriPathField(format));
                    break;
                }
                case "%a": {
                    builder.add(AccessLogSource.addRemoteIPField(format));
                    break;
                }
                case "%b": {
                    builder.add(AccessLogSource.addBytesSentField(format));
                    break;
                }
                case "%C": {
                    builder.add(AccessLogSource.addCookiesField(format));
                    break;
                }
                case "%D": {
                    builder.add(AccessLogSource.addRequestElapsedTimeField(format));
                    break;
                }
                case "%i": {
                    if (fields.get("%i") == null) break;
                    if (fields.get("%i").contains(USER_AGENT_HEADER)) {
                        builder.add(AccessLogSource.addUserAgentField(format));
                        if (fields.get("%i").size() == 1) break;
                    }
                    builder.add(AccessLogSource.addRequestHeaderField(format));
                    break;
                }
                case "%o": {
                    builder.add(AccessLogSource.addResponseHeaderField(format));
                    break;
                }
                case "%r": {
                    builder.add(AccessLogSource.addRequestFirstLineField(format));
                    break;
                }
                case "%t": {
                    builder.add(AccessLogSource.addRequestStartTimeField(format));
                    break;
                }
                case "%{t}W": {
                    builder.add(AccessLogSource.addAccessLogDatetimeField(format));
                    break;
                }
                case "%u": {
                    builder.add(AccessLogSource.addRemoteUserField(format));
                }
            }
        }
        builder.add(AccessLogSource.addDatetimeField(format)).add(AccessLogSource.addSequenceField(format));
        return builder.build();
    }

    private static AccessLogDataFormatter populateDefaultFormatters(int format) {
        AccessLogDataFormatter.AccessLogDataFormatterBuilder builder = new AccessLogDataFormatter.AccessLogDataFormatterBuilder();
        builder.add(AccessLogSource.addRemoteHostField(format)).add(AccessLogSource.addRequestProtocolField(format)).add(AccessLogSource.addRequestHostField(format)).add(AccessLogSource.addBytesReceivedField(format)).add(AccessLogSource.addRequestMethodField(format)).add(AccessLogSource.addRequestPortField(format)).add(AccessLogSource.addQueryStringField(format)).add(AccessLogSource.addElapsedTimeField(format)).add(AccessLogSource.addResponseCodeField(format)).add(AccessLogSource.addUriPathField(format)).add(AccessLogSource.addUserAgentField(format)).add(AccessLogSource.addDatetimeField(format)).add(AccessLogSource.addSequenceField(format));
        return builder.build();
    }

    private static SetterFormatter createSetterFormatter(Configuration config, AccessLogger.FormatSegment[] parsedFormat, AtomicLong seq) {
        SetterFormatter newSF = new SetterFormatter(config);
        ArrayList<Object> fieldSetters = new ArrayList();
        AccessLogDataFormatter[] formatters = new AccessLogDataFormatter[]{null, null, null, null};
        HashMap<String, HashSet<Object>> fieldsToAdd = new HashMap<String, HashSet<Object>>();
        HashMap<String, HashSet<Object>> fieldsToAddJson = new HashMap<String, HashSet<Object>>();
        HashMap<String, HashSet<Object>> fieldsToAddLogstash = new HashMap<String, HashSet<Object>>();
        AccessLogSource.initializeFieldMap(fieldsToAdd, parsedFormat);
        AccessLogSource.initializeFieldMap(fieldsToAddJson, parsedFormat, jsonAccessLogFieldsConfig);
        AccessLogSource.initializeFieldMap(fieldsToAddLogstash, parsedFormat, jsonAccessLogFieldsLogstashConfig);
        fieldSetters = AccessLogSource.populateSetters(fieldsToAdd);
        fieldSetters.add((ald, alrd) -> ald.setSequence(alrd.getStartTime() + "_" + String.format("%013X", seq.incrementAndGet())));
        fieldSetters.add((ald, alrd) -> ald.setDatetime(alrd.getTimestamp()));
        if (jsonAccessLogFieldsConfig.equals("default")) {
            formatters[0] = AccessLogSource.populateDefaultFormatters(0);
        } else if (jsonAccessLogFieldsConfig.equals("logFormat")) {
            formatters[1] = AccessLogSource.populateCustomFormatters(fieldsToAddJson, 0);
        }
        if (jsonAccessLogFieldsLogstashConfig.equals("default")) {
            formatters[2] = AccessLogSource.populateDefaultFormatters(1);
        } else if (jsonAccessLogFieldsLogstashConfig.equals("logFormat")) {
            formatters[3] = AccessLogSource.populateCustomFormatters(fieldsToAddLogstash, 1);
        }
        newSF.setSettersAndFormatters(fieldSetters, formatters);
        return newSF;
    }

    private static JsonFieldAdder addRemoteHostField(int format) {
        return (jsonBuilder, ald) -> jsonBuilder.addField(AccessLogData.getRemoteHostKey((int)format), ald.getRemoteHost(), false, true);
    }

    private static JsonFieldAdder addRequestProtocolField(int format) {
        return (jsonBuilder, ald) -> jsonBuilder.addField(AccessLogData.getRequestProtocolKey((int)format), ald.getRequestProtocol(), false, true);
    }

    private static JsonFieldAdder addRequestHostField(int format) {
        return (jsonBuilder, ald) -> jsonBuilder.addField(AccessLogData.getRequestHostKey((int)format), ald.getRequestHost(), false, true);
    }

    private static JsonFieldAdder addBytesReceivedField(int format) {
        return (jsonBuilder, ald) -> jsonBuilder.addField(AccessLogData.getBytesReceivedKey((int)format), ald.getBytesReceived(), false);
    }

    private static JsonFieldAdder addRequestMethodField(int format) {
        return (jsonBuilder, ald) -> jsonBuilder.addField(AccessLogData.getRequestMethodKey((int)format), ald.getRequestMethod(), false, true);
    }

    private static JsonFieldAdder addRequestPortField(int format) {
        return (jsonBuilder, ald) -> jsonBuilder.addField(AccessLogData.getRequestPortKey((int)format), ald.getRequestPort(), false, true);
    }

    private static JsonFieldAdder addQueryStringField(int format) {
        return (jsonBuilder, ald) -> {
            String jsonQueryString = ald.getQueryString();
            if (jsonQueryString != null) {
                try {
                    jsonQueryString = URLDecoder.decode(jsonQueryString, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            return jsonBuilder.addField(AccessLogData.getQueryStringKey((int)format), jsonQueryString, false, true);
        };
    }

    private static JsonFieldAdder addElapsedTimeField(int format) {
        return (jsonBuilder, ald) -> jsonBuilder.addField(AccessLogData.getElapsedTimeKey((int)format), ald.getElapsedTime(), false);
    }

    private static JsonFieldAdder addResponseCodeField(int format) {
        return (jsonBuilder, ald) -> jsonBuilder.addField(AccessLogData.getResponseCodeKey((int)format), ald.getResponseCode(), false);
    }

    private static JsonFieldAdder addUriPathField(int format) {
        return (jsonBuilder, ald) -> jsonBuilder.addField(AccessLogData.getUriPathKey((int)format), ald.getUriPath(), false, true);
    }

    private static JsonFieldAdder addRemoteIPField(int format) {
        return (jsonBuilder, ald) -> jsonBuilder.addField(AccessLogData.getRemoteIPKey((int)format), ald.getRemoteIP(), false, true);
    }

    private static JsonFieldAdder addBytesSentField(int format) {
        return (jsonBuilder, ald) -> jsonBuilder.addField(AccessLogData.getBytesSentKey((int)format), ald.getBytesSent(), false);
    }

    private static JsonFieldAdder addCookiesField(int format) {
        return (jsonBuilder, ald) -> {
            if (ald.getCookies() != null) {
                ald.getCookies().getList().forEach(c -> jsonBuilder.addField(AccessLogData.getCookieKey((int)format, (KeyValuePair)c), c.getStringValue(), true, true));
            }
            return jsonBuilder;
        };
    }

    private static JsonFieldAdder addRequestElapsedTimeField(int format) {
        return (jsonBuilder, ald) -> jsonBuilder.addField(AccessLogData.getRequestElapsedTimeKey((int)format), ald.getRequestElapsedTime(), false);
    }

    private static JsonFieldAdder addUserAgentField(int format) {
        return (jsonBuilder, ald) -> {
            String userAgent = ald.getUserAgent();
            if (userAgent != null && userAgent.length() > 2048) {
                userAgent = userAgent.substring(0, 2048);
            }
            return jsonBuilder.addField(AccessLogData.getUserAgentKey((int)format), userAgent, true, true);
        };
    }

    private static JsonFieldAdder addRequestHeaderField(int format) {
        return (jsonBuilder, ald) -> {
            if (ald.getRequestHeaders() != null) {
                ald.getRequestHeaders().getList().forEach(h -> jsonBuilder.addField(AccessLogData.getRequestHeaderKey((int)format, (KeyValuePair)h), h.getStringValue(), false, true));
            }
            return jsonBuilder;
        };
    }

    private static JsonFieldAdder addResponseHeaderField(int format) {
        return (jsonBuilder, ald) -> {
            if (ald.getResponseHeaders() != null) {
                ald.getResponseHeaders().getList().forEach(h -> jsonBuilder.addField(AccessLogData.getResponseHeaderKey((int)format, (KeyValuePair)h), h.getStringValue(), true, true));
            }
            return jsonBuilder;
        };
    }

    private static JsonFieldAdder addRequestFirstLineField(int format) {
        return (jsonBuilder, ald) -> jsonBuilder.addField(AccessLogData.getRequestFirstLineKey((int)format), ald.getRequestFirstLine(), false, true);
    }

    private static JsonFieldAdder addRequestStartTimeField(int format) {
        return (jsonBuilder, ald) -> {
            String startTime = ((BurstDateFormat)CollectorJsonHelpers.dateFormatTL.get()).format(ald.getRequestStartTime());
            return jsonBuilder.addField(AccessLogData.getRequestStartTimeKey((int)format), startTime, false, true);
        };
    }

    private static JsonFieldAdder addAccessLogDatetimeField(int format) {
        return (jsonBuilder, ald) -> {
            String accessLogDatetime = ((BurstDateFormat)CollectorJsonHelpers.dateFormatTL.get()).format(ald.getAccessLogDatetime());
            return jsonBuilder.addField(AccessLogData.getAccessLogDatetimeKey((int)format), accessLogDatetime, false, true);
        };
    }

    private static JsonFieldAdder addRemoteUserField(int format) {
        return (jsonBuilder, ald) -> {
            if (ald.getRemoteUser() != null && !ald.getRemoteUser().isEmpty()) {
                return jsonBuilder.addField(AccessLogData.getRemoteUserKey((int)format), ald.getRemoteUser(), false, true);
            }
            return jsonBuilder;
        };
    }

    private static JsonFieldAdder addSequenceField(int format) {
        return (jsonBuilder, ald) -> jsonBuilder.addField(AccessLogData.getSequenceKey((int)format), ald.getSequence(), false, true);
    }

    private static JsonFieldAdder addDatetimeField(int format) {
        return (jsonBuilder, ald) -> {
            String datetime = ((BurstDateFormat)CollectorJsonHelpers.dateFormatTL.get()).format(ald.getDatetime());
            return jsonBuilder.addField(AccessLogData.getDatetimeKey((int)format), datetime, false, true);
        };
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class AccessLogHandler
    implements AccessLogForwarder {
        private final AtomicLong seq = new AtomicLong();
        static final long serialVersionUID = 6715811758680259629L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private AccessLogHandler() {
        }

        @Override
        public void process(AccessLogRecordData recordData) {
            String formatString = ((AccessLogRecordDataExt)recordData).getFormatString();
            AccessLogger.FormatSegment[] parsedFormat = ((AccessLogRecordDataExt)recordData).getParsedFormat();
            jsonAccessLogFieldsConfig = AccessLogConfig.jsonAccessLogFieldsConfig;
            jsonAccessLogFieldsLogstashConfig = AccessLogConfig.jsonAccessLogFieldsLogstashConfig;
            Configuration config = new Configuration(formatString, jsonAccessLogFieldsConfig, jsonAccessLogFieldsLogstashConfig);
            SetterFormatter currentSF = AccessLogSource.this.setterFormatterMap.get(config);
            if (currentSF == null) {
                isFirstWarning = true;
                currentSF = AccessLogSource.createSetterFormatter(config, parsedFormat, this.seq);
                AccessLogSource.this.setterFormatterMap.put(config, currentSF);
            }
            AccessLogData accessLogData = new AccessLogData();
            for (AccessLogDataFieldSetter s : currentSF.getSetters()) {
                s.add(accessLogData, recordData);
            }
            accessLogData.addFormatters(currentSF.getFormatters());
            accessLogData.setSourceName("com.ibm.ws.http.logging.source.accesslog");
            AccessLogSource.this.bufferMgr.add((Object)accessLogData);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Added a event to buffer " + accessLogData), (Object[])new Object[0]);
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.http.logging.source.AccessLogSource$AccessLogHandler", AccessLogHandler.class, null, null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class SetterFormatter {
        Configuration config;
        AccessLogDataFormatter[] formatters = new AccessLogDataFormatter[]{null, null, null, null};
        List<AccessLogDataFieldSetter> setters;
        static final long serialVersionUID = 7494218955089466868L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private SetterFormatter(Configuration config) {
            this.config = config;
        }

        void setSettersAndFormatters(List<AccessLogDataFieldSetter> setters, AccessLogDataFormatter[] formatters) {
            this.setters = setters;
            this.formatters = formatters;
        }

        List<AccessLogDataFieldSetter> getSetters() {
            return this.setters;
        }

        AccessLogDataFormatter[] getFormatters() {
            return this.formatters;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.http.logging.source.AccessLogSource$SetterFormatter", SetterFormatter.class, null, null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class Configuration {
        String logFormat;
        String loggingConfig;
        String logstashConfig;
        static final long serialVersionUID = 5956015041749109816L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private Configuration(String logFormat, String loggingConfig, String logstashConfig) {
            this.logFormat = logFormat;
            this.loggingConfig = loggingConfig;
            this.logstashConfig = logstashConfig;
        }

        String getLogFormat() {
            return this.logFormat;
        }

        String getLoggingConfig() {
            return this.loggingConfig;
        }

        String getLogstashConfig() {
            return this.logstashConfig;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getEnclosingInstance().hashCode();
            result = 31 * result + (this.logFormat == null ? 0 : this.logFormat.hashCode());
            result = 31 * result + (this.loggingConfig == null ? 0 : this.loggingConfig.hashCode());
            result = 31 * result + (this.logstashConfig == null ? 0 : this.logstashConfig.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Configuration other = (Configuration)obj;
            if (!this.getEnclosingInstance().equals(other.getEnclosingInstance())) {
                return false;
            }
            return other.getLogFormat().equals(this.logFormat) && other.getLoggingConfig().equals(this.loggingConfig) && other.getLogstashConfig().equals(this.logstashConfig);
        }

        private AccessLogSource getEnclosingInstance() {
            return AccessLogSource.this;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.http.logging.source.AccessLogSource$Configuration", Configuration.class, null, null);
        }
    }
}

