/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.AbstractLocationConfigSourceLoader;
import io.smallrye.config.EnvConfigSource;
import io.smallrye.config.common.utils.ConfigSourceUtil;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;

public class DotEnvConfigSourceProvider
extends AbstractLocationConfigSourceLoader
implements ConfigSourceProvider {
    private final String location;

    public DotEnvConfigSourceProvider() {
        this(".env");
    }

    public DotEnvConfigSourceProvider(String location) {
        this.location = location;
    }

    @Override
    protected String[] getFileExtensions() {
        return new String[]{""};
    }

    @Override
    protected ConfigSource loadConfigSource(URL url) throws IOException {
        return this.loadConfigSource(url, 295);
    }

    @Override
    protected ConfigSource loadConfigSource(final URL url, int ordinal) throws IOException {
        return new EnvConfigSource(ConfigSourceUtil.urlToMap(url), ordinal){

            @Override
            public String getName() {
                return super.getName() + "[source=" + url + "]";
            }
        };
    }

    public List<ConfigSource> getConfigSources(ClassLoader forClassLoader) {
        return this.loadConfigSources(this.location, forClassLoader);
    }

    public static List<ConfigSource> dotEnvSources(ClassLoader classLoader) {
        return new DotEnvConfigSourceProvider().getConfigSources(classLoader);
    }

    public static List<ConfigSource> dotEnvSources(String location, ClassLoader classLoader) {
        return new DotEnvConfigSourceProvider(location).getConfigSources(classLoader);
    }
}

