/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.io.async;

import com.ibm.io.async.AbstractAsyncChannel;
import com.ibm.io.async.AbstractAsyncFuture;
import com.ibm.io.async.ICompletionListener;
import com.ibm.io.async.TimerWorkItem;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import java.io.IOException;

abstract class AsyncChannelFuture
extends AbstractAsyncFuture {
    private static final TraceComponent tc = Tr.register(AsyncChannelFuture.class, (String)"TCPChannel", (String)"com.ibm.ws.tcpchannel.internal.resources.TCPChannelMessages");
    protected TimerWorkItem timeoutTracker = null;

    protected AsyncChannelFuture(AbstractAsyncChannel channel) {
        super(channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCompletionListener(ICompletionListener listener, Object state) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("addCompletionListener, listener " + listener), (Object[])new Object[0]);
        }
        boolean alreadyComplete = true;
        if (!this.fullyCompleted) {
            Object object = this.completedSemaphore;
            synchronized (object) {
                if (!this.completed) {
                    alreadyComplete = false;
                    this.firstListener = listener;
                    this.firstListenerState = state;
                }
            }
        }
        if (alreadyComplete) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"request already complete - notifying listener", (Object[])new Object[0]);
            }
            this.invokeCallback(listener, this, state);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("addCompletionListener, listener " + listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel(Exception reason) {
        if (this.channel == null) {
            return;
        }
        Object object = this.completedSemaphore;
        synchronized (object) {
            if (!this.completed) {
                try {
                    this.channel.cancel(this, reason);
                }
                catch (Exception exception) {}
            } else {
                if (this.channel.readFuture != null) {
                    this.channel.readFuture.setCancelInProgress(0);
                }
                if (this.channel.writeFuture != null) {
                    this.channel.writeFuture.setCancelInProgress(0);
                }
            }
        }
    }

    @Override
    protected void fireCompletionActions() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"fireCompletionActions", (Object[])new Object[0]);
        }
        if (this.firstListener != null) {
            ICompletionListener listenerToInvoke = this.firstListener;
            this.firstListener = null;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("invoking callback for channel id: " + this.channel.channelIdentifier), (Object[])new Object[0]);
            }
            this.invokeCallback(listenerToInvoke, this, this.firstListenerState);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("no listener found for event, future: " + this), (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"fireCompletionActions");
        }
    }

    protected void throwException() throws InterruptedException, IOException {
        if (this.exception instanceof IOException) {
            throw (IOException)this.exception;
        }
        if (this.exception instanceof InterruptedException) {
            throw (InterruptedException)this.exception;
        }
        if (this.exception instanceof RuntimeException) {
            throw (RuntimeException)this.exception;
        }
        throw new RuntimeException(this.exception);
    }

    @Override
    public void setTimeoutWorkItem(TimerWorkItem twi) {
        this.timeoutTracker = twi;
    }

    @Override
    public TimerWorkItem getTimeoutWorkItem() {
        return this.timeoutTracker;
    }
}

