/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.session.http;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.session.utils.LoggingUtil;
import com.ibm.wsspi.session.IProtocolAdapter;
import com.ibm.wsspi.session.ISession;
import com.ibm.wsspi.session.ISessionStateObserver;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;

public class HttpSessionAttributeObserver
implements ISessionStateObserver {
    private static boolean _loggedVersion = false;
    protected ArrayList _sessionAttributeListeners;
    protected IProtocolAdapter _adapter = null;
    private static final String methodClassName = "HttpSessionAttributeObserver";

    public HttpSessionAttributeObserver(ArrayList listeners, IProtocolAdapter adapter) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE) && !_loggedVersion) {
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "", "CMVC Version 1.8 5/30/08 16:34:55");
            _loggedVersion = true;
        }
        this._sessionAttributeListeners = listeners;
        this._adapter = adapter;
    }

    @Override
    public void sessionAttributeSet(ISession session, Object name, Object oldValue, Object newValue) {
        this.sessionAttributeSet(session, name, oldValue, false, newValue, false);
    }

    @Override
    public void sessionAttributeRemoved(ISession session, Object name, Object value) {
        this.sessionAttributeRemoved(session, name, value, false);
    }

    @Override
    public void sessionAttributeSet(ISession session, Object name, Object oldValue, Boolean oldIsListener, Object newValue, Boolean newIsListener) {
        HttpSession httpsession = (HttpSession)this._adapter.adapt(session);
        HttpSessionBindingEvent addEvent = null;
        HttpSessionBindingEvent replaceEvent = null;
        if (oldValue != null && oldIsListener.booleanValue()) {
            replaceEvent = new HttpSessionBindingEvent(httpsession, (String)name, oldValue);
            ((HttpSessionBindingListener)oldValue).valueUnbound(replaceEvent);
        }
        if (newValue != null && newIsListener.booleanValue()) {
            addEvent = new HttpSessionBindingEvent(httpsession, (String)name, newValue);
            ((HttpSessionBindingListener)newValue).valueBound(addEvent);
        }
        HttpSessionAttributeListener listener = null;
        for (int i = 0; i < this._sessionAttributeListeners.size(); ++i) {
            listener = (HttpSessionAttributeListener)this._sessionAttributeListeners.get(i);
            if (oldValue != null) {
                if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                    LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "sessionAttrSet", "Calling attributeReplace on listener:" + listener);
                }
                if (replaceEvent == null) {
                    replaceEvent = new HttpSessionBindingEvent(httpsession, (String)name, oldValue);
                }
                listener.attributeReplaced(replaceEvent);
                continue;
            }
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "sessionAttrSet", "Calling attributeCreated on listener:" + listener);
            }
            if (addEvent == null) {
                addEvent = new HttpSessionBindingEvent(httpsession, (String)name, newValue);
            }
            listener.attributeAdded(addEvent);
        }
    }

    @Override
    public void sessionAttributeRemoved(ISession session, Object name, Object value, Boolean oldIsBindingListener) {
        HttpSessionAttributeListener listener = null;
        HttpSessionBindingEvent event = null;
        HttpSession httpsession = (HttpSession)this._adapter.adapt(session);
        event = new HttpSessionBindingEvent(httpsession, (String)name, value);
        if (value != null && oldIsBindingListener.booleanValue()) {
            ((HttpSessionBindingListener)value).valueUnbound(event);
        }
        for (int i = 0; i < this._sessionAttributeListeners.size(); ++i) {
            listener = (HttpSessionAttributeListener)this._sessionAttributeListeners.get(i);
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "sessionAttributeRemoved", "SessionManager calling attributeRemoved on listener:" + listener);
            }
            listener.attributeRemoved(event);
        }
    }

    @Override
    public void sessionAttributeAccessed(ISession session, Object key, Object value) {
    }

    @Override
    public void sessionUserNameSet(ISession session, String oldUserName, String newUserName) {
    }

    @Override
    public void sessionLastAccessTimeSet(ISession session, long old, long newaccess) {
    }

    @Override
    public void sessionMaxInactiveTimeSet(ISession session, int old, int newval) {
    }

    @Override
    public void sessionExpiryTimeSet(ISession session, long old, long newone) {
    }

    @Override
    public String getId() {
        return methodClassName;
    }
}

