/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.jcache.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.productinfo.ProductInfo;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.jcache.CacheManagerService;
import io.openliberty.jcache.internal.CachingProviderService;
import io.openliberty.jcache.utils.CacheConfigUtil;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ScheduledExecutorService;
import javax.cache.CacheManager;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(immediate=true, configurationPolicy=ConfigurationPolicy.REQUIRE, configurationPid={"io.openliberty.jcache.cachemanager"}, property={"service.vendor=IBM"})
public class CacheManagerServiceImpl
implements CacheManagerService {
    private static final TraceComponent tc = Tr.register(CacheManagerServiceImpl.class, (String)"jcache", (String)"io.openliberty.jcache.internal.resources.JCacheMessages");
    private static final String KEY_URI = "uri";
    private static final String KEY_ID = "id";
    private static final String BASE_PREFIX = "properties";
    private static final int BASE_PREFIX_LENGTH = "properties".length();
    private static final int TOTAL_PREFIX_LENGTH = BASE_PREFIX_LENGTH + 3;
    private Properties properties = null;
    private URI configuredUri = null;
    private CacheManager cacheManager = null;
    private CachingProviderService cachingProviderService = null;
    private ScheduledExecutorService scheduledExecutorService = null;
    private Object syncObject = new Object();
    private String id = null;
    private CacheConfigUtil cacheConfigUtil = null;
    private static boolean issuedBetaMessage = false;
    static final long serialVersionUID = 6457572258387145753L;

    /*
     * WARNING - void declaration
     */
    @Activate
    public void activate(Map<String, Object> config) {
        this.betaFenceCheck();
        this.id = (String)config.get(KEY_ID);
        String uriValue = (String)config.get(KEY_URI);
        if (uriValue != null) {
            try {
                this.configuredUri = new URI(uriValue);
            }
            catch (URISyntaxException uRISyntaxException) {
                void e;
                FFDCFilter.processException((Throwable)uRISyntaxException, (String)"io.openliberty.jcache.internal.CacheManagerServiceImpl", (String)"89", (Object)this, (Object[])new Object[]{config});
                throw new IllegalArgumentException(Tr.formatMessage((TraceComponent)tc, (String)"CWLJC0007_URI_INVALID_SYNTAX", (Object[])new Object[]{e}), (Throwable)e);
            }
        } else {
            this.configuredUri = null;
        }
        this.properties = new Properties();
        for (Map.Entry<String, Object> entry : config.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (key.length() <= TOTAL_PREFIX_LENGTH || key.charAt(BASE_PREFIX_LENGTH) != '.' || !key.startsWith(BASE_PREFIX) || (key = key.substring(TOTAL_PREFIX_LENGTH)).equals("config.referenceType")) continue;
            this.properties.setProperty(key, (String)value);
        }
        this.scheduledExecutorService.execute(new Runnable(){
            static final long serialVersionUID = 7243767318192130234L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public void run() {
                CacheManagerServiceImpl.this.getCacheManager();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"io.openliberty.jcache.internal.CacheManagerServiceImpl$1", 1.class, (String)"jcache", (String)"io.openliberty.jcache.internal.resources.JCacheMessages");
            }
        });
    }

    @Deactivate
    public void deactivate() {
        if (this.cacheManager != null) {
            this.cacheManager.close();
        }
        this.cacheManager = null;
    }

    private void betaFenceCheck() throws UnsupportedOperationException {
        if (!ProductInfo.getBetaEdition()) {
            throw new UnsupportedOperationException("The cachingProvider feature is beta and is not available.");
        }
        if (!issuedBetaMessage) {
            Tr.info((TraceComponent)tc, (String)("BETA: A beta method has been invoked for the class " + this.getClass().getName() + " for the first time."), (Object[])new Object[0]);
            issuedBetaMessage = !issuedBetaMessage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public CacheManager getCacheManager() {
        if (this.cacheManager == null) {
            Object object = this.syncObject;
            synchronized (object) {
                if (this.cacheManager == null) {
                    try {
                        this.cacheConfigUtil = new CacheConfigUtil();
                        URI uri = this.cacheConfigUtil.preConfigureCacheManager(this.configuredUri, this.cachingProviderService.getCachingProvider(), this.properties);
                        long loadTimeMs = System.currentTimeMillis();
                        this.cacheManager = this.cachingProviderService.getCachingProvider().getCacheManager(uri, null, this.properties);
                        loadTimeMs = System.currentTimeMillis() - loadTimeMs;
                        if (TraceComponent.isAnyTracingEnabled() && tc.isInfoEnabled()) {
                            Tr.info((TraceComponent)tc, (String)"CWLJC0005_MANAGER_LOADED", (Object[])new Object[]{this.id, loadTimeMs});
                        }
                    }
                    catch (NullPointerException uri) {
                        void e;
                        FFDCFilter.processException((Throwable)uri, (String)"io.openliberty.jcache.internal.CacheManagerServiceImpl", (String)"208", (Object)this, (Object[])new Object[0]);
                        throw new IllegalArgumentException(Tr.formatMessage((TraceComponent)tc, (String)"CWLJC0007_URI_INVALID_SYNTAX", (Object[])new Object[]{e}), (Throwable)e);
                    }
                    catch (IOException e) {
                        FFDCFilter.processException((Throwable)e, (String)"io.openliberty.jcache.internal.CacheManagerServiceImpl", (String)"213", (Object)this, (Object[])new Object[0]);
                        throw new IllegalArgumentException(Tr.formatMessage((TraceComponent)tc, (String)"CWLJC0010_MANAGER_CONFIG_ERR", (Object[])new Object[]{e}), e);
                    }
                }
            }
        }
        return this.cacheManager;
    }

    @Override
    public CachingProviderService getCachingProviderService() {
        return this.cachingProviderService;
    }

    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    public void setCachingProviderService(CachingProviderService service) {
        this.cachingProviderService = service;
    }

    public void unsetCachingProviderService(CachingProviderService service) {
        this.cachingProviderService = null;
    }

    @Reference(name="scheduledExecutorService", service=ScheduledExecutorService.class, target="(deferrable=false)")
    public void setScheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        this.scheduledExecutorService = scheduledExecutorService;
    }

    public void unsetScheduledExecutorService(ServiceReference<ScheduledExecutorService> scheduledExecutorService) {
        this.scheduledExecutorService = null;
    }

    public String toString() {
        return super.toString() + "{id=" + this.id + ", configuredUri=" + this.configuredUri + ", cacheManager=" + this.cacheManager + "}";
    }
}

