/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.mp.jwt.impl.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.jwt.Claims;
import com.ibm.websphere.security.jwt.JwtToken;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.jwk.utils.JsonUtils;
import java.util.ArrayList;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import org.jose4j.json.JsonUtil;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.lang.JoseException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ClaimsUtils {
    public static final TraceComponent tc = Tr.register(ClaimsUtils.class, (String)"MPJWT", (String)"com.ibm.ws.security.mp.jwt.resources.MicroProfileJwtMessages");
    private static final JsonBuilderFactory builderFactory = Json.createBuilderFactory(null);
    static final long serialVersionUID = -7672569722419802758L;

    @ManualTrace
    public static JwtClaims getJwtClaims(JwtToken jwtToken) {
        String methodName = "getJwtClaims";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{jwtToken});
        }
        Claims claims = jwtToken.getClaims();
        JwtClaims jwtclaims = ClaimsUtils.createJwtClaims((Map<String, Object>)claims, jwtToken.compact());
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)jwtclaims);
        }
        return jwtclaims;
    }

    @ManualTrace
    public static JwtClaims getJwtClaims(String jwt) throws JoseException {
        JwtClaims jwtclaims;
        String payload;
        String methodName = "getJwtClaims";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{jwt});
        }
        if ((payload = ClaimsUtils.getJwtPayload(jwt)) != null) {
            Map payloadClaims = JsonUtil.parseJson((String)payload);
            jwtclaims = ClaimsUtils.createJwtClaims(payloadClaims, jwt);
        } else {
            jwtclaims = new JwtClaims();
        }
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)jwtclaims);
        }
        return jwtclaims;
    }

    @ManualTrace
    static String getJwtPayload(String jwt) {
        String[] parts;
        String methodName = "getJwtPayload";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{jwt});
        }
        String payload = null;
        if (jwt != null && (parts = JsonUtils.splitTokenString((String)jwt)).length > 0) {
            payload = JsonUtils.fromBase64ToJsonString((String)parts[1]);
        }
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, payload);
        }
        return payload;
    }

    @ManualTrace
    static JwtClaims createJwtClaims(Map<String, Object> claimsMap, String jwt) {
        String methodName = "getClaimsFromJwtPayload";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{jwt});
        }
        JwtClaims jwtclaims = new JwtClaims();
        for (Map.Entry<String, Object> entry : claimsMap.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Key : " + key + ", Value: " + value), (Object[])new Object[0]);
            }
            if (key == null || value == null) continue;
            jwtclaims.setClaim(key, value);
        }
        jwtclaims.setStringClaim(org.eclipse.microprofile.jwt.Claims.raw_token.name(), jwt);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Key : raw_token, Value: raw_token", (Object[])new Object[0]);
        }
        ClaimsUtils.convertJoseTypes(jwtclaims);
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)jwtclaims);
        }
        return jwtclaims;
    }

    private static void convertJoseTypes(JwtClaims claimsSet) {
        if (claimsSet.hasClaim("address")) {
            ClaimsUtils.replaceMapWithJsonObject("address", claimsSet);
        }
        if (claimsSet.hasClaim("jwk")) {
            ClaimsUtils.replaceMapWithJsonObject("jwk", claimsSet);
        }
        if (claimsSet.hasClaim("sub_jwk")) {
            ClaimsUtils.replaceMapWithJsonObject("sub_jwk", claimsSet);
        }
        if (claimsSet.hasClaim("aud")) {
            ClaimsUtils.convertToList("aud", claimsSet);
        }
        if (claimsSet.hasClaim("groups")) {
            ClaimsUtils.convertToList("groups", claimsSet);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void replaceMapWithJsonObject(String claimName, JwtClaims claimsSet) {
        block3: {
            try {
                Map map = (Map)claimsSet.getClaimValue(claimName, Map.class);
                JsonObjectBuilder builder = builderFactory.createObjectBuilder();
                for (Map.Entry entry : map.entrySet()) {
                    builder.add((String)entry.getKey(), entry.getValue().toString());
                }
                JsonObject jsonObject = builder.build();
                claimsSet.setClaim(claimName, (Object)jsonObject);
            }
            catch (MalformedClaimException map) {
                void e;
                FFDCFilter.processException((Throwable)map, (String)"com.ibm.ws.security.mp.jwt.impl.utils.ClaimsUtils", (String)"169", null, (Object[])new Object[]{claimName, claimsSet});
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)("The value for the claim [" + claimName + "] could not be convered to a Map: " + e.getLocalizedMessage()), (Object[])new Object[0]);
            }
        }
    }

    @FFDCIgnore(value={MalformedClaimException.class})
    private static void convertToList(String claimName, JwtClaims claimsSet) {
        block5: {
            ArrayList<String> list = null;
            try {
                list = claimsSet.getStringListClaimValue(claimName);
            }
            catch (MalformedClaimException e) {
                try {
                    String value = claimsSet.getStringClaimValue(claimName);
                    if (value != null) {
                        list = new ArrayList<String>();
                        list.add(value);
                        claimsSet.setClaim(claimName, list);
                    }
                }
                catch (MalformedClaimException e1) {
                    if (!tc.isDebugEnabled()) break block5;
                    Tr.debug((TraceComponent)tc, (String)("The value for the claim [" + claimName + "] could not be convered to a string list: " + e1.getLocalizedMessage()), (Object[])new Object[0]);
                }
            }
        }
    }
}

