/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.authentication.internal.cache;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCSelfIntrospectable;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.cache.CacheEvictionListener;
import com.ibm.ws.security.authentication.cache.CacheObject;
import com.ibm.ws.security.authentication.internal.cache.AuthCache;
import java.util.ArrayList;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class InMemoryAuthCache
implements AuthCache,
FFDCSelfIntrospectable {
    private static final TraceComponent tc = Tr.register(InMemoryAuthCache.class, (String)"Authentication");
    private ConcurrentHashMap<Object, Object> primaryTable;
    private ConcurrentHashMap<Object, Object> secondaryTable;
    private ConcurrentHashMap<Object, Object> tertiaryTable;
    private int minSize = 0;
    private int entryLimit = 500;
    private final Set<CacheEvictionListener> cacheEvictionListenerSet;
    private Timer timer;
    static final long serialVersionUID = -1549523945033025976L;

    public InMemoryAuthCache(int initialSize, int entryLimit, long timeoutInMilliSeconds) {
        this(initialSize, entryLimit, timeoutInMilliSeconds, null);
    }

    public InMemoryAuthCache(int initialSize, int entryLimit, long timeoutInMilliSeconds, Set<CacheEvictionListener> callbackSet) {
        this.primaryTable = new ConcurrentHashMap(initialSize);
        this.secondaryTable = new ConcurrentHashMap(initialSize);
        this.tertiaryTable = new ConcurrentHashMap(initialSize);
        this.minSize = initialSize;
        this.entryLimit = entryLimit;
        this.cacheEvictionListenerSet = callbackSet;
        if (timeoutInMilliSeconds > 0L) {
            this.scheduleEvictionTask(timeoutInMilliSeconds);
        }
    }

    private void scheduleEvictionTask(long timeoutInMilliSeconds) {
        long period;
        EvictionTask evictionTask = new EvictionTask();
        this.timer = new Timer(true);
        long delay = period = timeoutInMilliSeconds / 2L;
        this.timer.schedule((TimerTask)evictionTask, delay, period);
    }

    @Override
    public synchronized void remove(Object key) {
        Object victim = null;
        if (!this.cacheEvictionListenerSet.isEmpty()) {
            victim = this.get(key);
        }
        this.primaryTable.remove(key);
        this.secondaryTable.remove(key);
        this.tertiaryTable.remove(key);
        if (victim != null) {
            ArrayList<Object> evictedValues = new ArrayList<Object>();
            evictedValues.add(victim);
            for (CacheEvictionListener evictionCallback : this.cacheEvictionListenerSet) {
                evictionCallback.evicted(evictedValues);
            }
        }
    }

    @Override
    public synchronized Object get(Object key) {
        Entry prevEntry;
        ConcurrentHashMap<Object, Object> tableRef = this.primaryTable;
        Entry curEntry = (Entry)this.primaryTable.get(key);
        if (curEntry == null) {
            tableRef = this.secondaryTable;
            curEntry = (Entry)this.secondaryTable.get(key);
            if (curEntry == null) {
                tableRef = this.tertiaryTable;
                curEntry = (Entry)this.tertiaryTable.get(key);
            }
            if (curEntry == null) {
                tableRef = null;
            }
        }
        if (tableRef != null && tableRef != this.primaryTable) {
            this.primaryTable.put(key, curEntry);
            tableRef.remove(key);
        }
        if (tableRef == null && (curEntry = (Entry)this.primaryTable.get(key)) == null && (prevEntry = (Entry)this.primaryTable.putIfAbsent(key, curEntry = new Entry())) != null) {
            curEntry = prevEntry;
        }
        return curEntry.value;
    }

    @Override
    public synchronized void insert(Object key, CacheObject value) {
        while (this.isEvictionRequired() && this.entryLimit > 0 && this.entryLimit < Integer.MAX_VALUE) {
            this.evictStaleEntries();
        }
        Entry curEntry = new Entry(value);
        Entry oldEntry = (Entry)this.primaryTable.put(key, curEntry);
        if (oldEntry != null && oldEntry.value != null) {
            ArrayList<Object> evictedValues = new ArrayList<Object>();
            evictedValues.add(oldEntry.value);
            for (CacheEvictionListener evictionCallback : this.cacheEvictionListenerSet) {
                evictionCallback.evicted(evictedValues);
            }
        }
    }

    protected boolean isEvictionRequired() {
        int size;
        boolean evictionRequired = false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            size = this.primaryTable.size() + this.secondaryTable.size() + this.tertiaryTable.size();
            Tr.debug((TraceComponent)tc, (String)("The current cache size is " + size + "( " + this.primaryTable.size() + ", " + this.secondaryTable.size() + ", " + this.tertiaryTable.size() + ")"), (Object[])new Object[0]);
        }
        if (this.entryLimit != 0 && this.entryLimit != Integer.MAX_VALUE && (size = this.primaryTable.size() + this.secondaryTable.size() + this.tertiaryTable.size()) > this.entryLimit) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("The cache size is " + size + "( " + this.primaryTable.size() + ", " + this.secondaryTable.size() + ", " + this.tertiaryTable.size() + ") which is greater than the cache limit of " + this.entryLimit + "."), (Object[])new Object[0]);
            }
            evictionRequired = true;
        }
        return evictionRequired;
    }

    protected synchronized void evictStaleEntries() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            int size = this.primaryTable.size() + this.secondaryTable.size() + this.tertiaryTable.size();
            Tr.debug((TraceComponent)tc, (String)("The current cache size is " + size + "( " + this.primaryTable.size() + ", " + this.secondaryTable.size() + ", " + this.tertiaryTable.size() + ")"), (Object[])new Object[0]);
        }
        ConcurrentHashMap<Object, Object> victims = this.tertiaryTable;
        this.tertiaryTable = this.secondaryTable;
        this.secondaryTable = this.primaryTable;
        this.primaryTable = new ConcurrentHashMap(this.minSize > this.secondaryTable.size() ? this.minSize : this.secondaryTable.size());
        if (!victims.isEmpty()) {
            ArrayList<Object> evictedValues = new ArrayList<Object>();
            for (Entry entry : victims.values()) {
                if (entry.value == null) continue;
                evictedValues.add(entry.value);
            }
            for (CacheEvictionListener evictionCallback : this.cacheEvictionListenerSet) {
                evictionCallback.evicted(evictedValues);
            }
        }
    }

    @Override
    public synchronized void clearAllEntries() {
        this.tertiaryTable.putAll(this.primaryTable);
        this.tertiaryTable.putAll(this.secondaryTable);
        this.primaryTable.clear();
        this.secondaryTable.clear();
        this.evictStaleEntries();
    }

    int getEntryLimit() {
        return this.entryLimit;
    }

    @Override
    public void stopEvictionTask() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    public String[] introspectSelf() {
        return new String[]{"primaryTable.size() = " + this.primaryTable.size(), "secondaryTable.size() = " + this.secondaryTable.size(), "tertiaryTable.size() = " + this.tertiaryTable.size(), "minSize = " + this.minSize, "entryLimit = " + this.entryLimit, "cacheEvictionListenerSet = " + this.cacheEvictionListenerSet, "timer = " + this.timer};
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class EvictionTask
    extends TimerTask {
        static final long serialVersionUID = 179458103429609752L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private EvictionTask() {
        }

        @Override
        public void run() {
            InMemoryAuthCache.this.evictStaleEntries();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.authentication.internal.cache.InMemoryAuthCache$EvictionTask", EvictionTask.class, (String)"Authentication", (String)"com.ibm.ws.security.authentication.internal.resources.AuthenticationMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class Entry {
        public Object value;
        static final long serialVersionUID = -1119139445341983697L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public Entry() {
        }

        public Entry(Object value) {
            this.value = value;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.authentication.internal.cache.InMemoryAuthCache$Entry", Entry.class, (String)"Authentication", (String)"com.ibm.ws.security.authentication.internal.resources.AuthenticationMessages");
        }
    }
}

