/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.authentication.internal.cache;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.cache.CacheObject;
import com.ibm.ws.security.authentication.internal.cache.AuthCache;
import com.ibm.ws.security.authentication.internal.cache.AuthCacheServiceImpl;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import io.openliberty.jcache.CacheService;
import io.openliberty.jcache.DeserializationException;
import io.openliberty.jcache.SerializationException;
import java.util.HashSet;
import java.util.Set;
import javax.cache.Cache;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JCacheAuthCache
implements AuthCache {
    private static final TraceComponent tc = Tr.register(JCacheAuthCache.class, (String)"Authentication", (String)"com.ibm.ws.security.authentication.internal.resources.AuthenticationMessages");
    private CacheService cacheService = null;
    private AuthCache inMemoryCache = null;
    private static final Set<String> NOT_SERIALIZABLE_CREDS = new HashSet<String>();
    static final long serialVersionUID = -554074465734768964L;

    public JCacheAuthCache(CacheService cacheService, AuthCache inMemoryCache) {
        this.cacheService = cacheService;
        this.inMemoryCache = inMemoryCache;
    }

    @Override
    public void clearAllEntries() {
        this.inMemoryCache.clearAllEntries();
        if (!FrameworkState.isStopping() && AuthCacheServiceImpl.isServerStarted()) {
            Cache<Object, Object> jCache = this.getJCache();
            if (jCache != null) {
                jCache.removeAll();
            }
            Tr.info((TraceComponent)tc, (String)"JCACHE_AUTH_CACHE_CLEARED_ALL_ENTRIES", (Object[])new Object[]{this.cacheService.getCache().getName()});
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object get(Object key) {
        Object value = null;
        Cache<Object, Object> jCache = this.getJCache();
        if (jCache != null) {
            try {
                value = jCache.get(key);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    if (value == null) {
                        Tr.debug((TraceComponent)tc, (String)("JCache MISS for key " + key), (Object[])new Object[0]);
                    } else {
                        Tr.debug((TraceComponent)tc, (String)("JCache HIT for key " + key), (Object[])new Object[0]);
                    }
                }
            }
            catch (DeserializationException deserializationException) {
                void e;
                FFDCFilter.processException((Throwable)deserializationException, (String)"com.ibm.ws.security.authentication.internal.cache.JCacheAuthCache", (String)"112", (Object)this, (Object[])new Object[]{key});
                Tr.error((TraceComponent)tc, (String)e.getMessage(), (Object[])new Object[0]);
            }
        }
        if (value == null) {
            value = this.inMemoryCache.get(key);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                if (value == null) {
                    Tr.debug((TraceComponent)tc, (String)("In-memory cache MISS for key " + key), (Object[])new Object[0]);
                } else {
                    Tr.debug((TraceComponent)tc, (String)("In-memory cache HIT for key " + key), (Object[])new Object[0]);
                }
            }
        }
        return value;
    }

    @Override
    @FFDCIgnore(value={SerializationException.class})
    public void insert(Object key, CacheObject value) {
        boolean forceInMemory = false;
        for (Object cred : value.getSubject().getPrivateCredentials()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Checking private credential: " + cred.getClass()), (Object[])new Object[0]);
            }
            if (!NOT_SERIALIZABLE_CREDS.contains(cred.getClass().getName())) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Private credential: " + cred.getClass() + " will be stored to the in-memory cache."), (Object[])new Object[0]);
            }
            forceInMemory = true;
            break;
        }
        if (!forceInMemory) {
            try {
                Cache<Object, Object> jCache = this.getJCache();
                if (jCache != null) {
                    jCache.put(key, (Object)value);
                }
            }
            catch (SerializationException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Failed to insert value for key " + key + " into JCache due to SerializationException. Inserting into in-memory cache instead."), (Object[])new Object[]{e});
                }
                this.inMemoryCache.insert(key, value);
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Refused to insert value for key " + key + " into JCache due to known limitation. Inserting into in-memory cache instead."), (Object[])new Object[0]);
            }
            this.inMemoryCache.insert(key, value);
        }
    }

    @Override
    public void remove(Object key) {
        this.inMemoryCache.remove(key);
        Cache<Object, Object> jCache = this.getJCache();
        if (jCache != null) {
            jCache.remove(key);
        }
    }

    private Cache<Object, Object> getJCache() {
        Cache jCache = null;
        if (this.cacheService != null) {
            jCache = this.cacheService.getCache();
        }
        return jCache;
    }

    @Override
    @Trivial
    public void stopEvictionTask() {
        if (this.inMemoryCache != null) {
            this.inMemoryCache.stopEvictionTask();
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        NOT_SERIALIZABLE_CREDS.add("sun.security.jgss.GSSCredentialImpl");
        NOT_SERIALIZABLE_CREDS.add("com.ibm.security.jgss.GSSCredentialImpl");
        NOT_SERIALIZABLE_CREDS.add("com.sun.security.jgss.ExtendedGSSCredentialImpl");
        NOT_SERIALIZABLE_CREDS.add("com.ibm.ws.security.jwt.internal.JwtTokenConsumerImpl");
        NOT_SERIALIZABLE_CREDS.add("com.ibm.ws.security.openidconnect.client.jose4j.OidcTokenImpl");
    }
}

