/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.core;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.auth.WSSubject;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.Subject;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class SecurityContext {
    private static final TraceComponent tc = Tr.register(SecurityContext.class, null, null);
    public static final String REALM_SEPARATOR = "/";
    static final long serialVersionUID = -7309513695592511084L;

    /*
     * WARNING - void declaration
     */
    public static String getName() {
        String secname;
        block3: {
            secname = null;
            WSCredential credential = SecurityContext.getCallerWSCredential();
            try {
                String realmSecname;
                if (credential != null && !credential.isUnauthenticated() && (realmSecname = credential.getRealmSecurityName()) != null && !realmSecname.isEmpty()) {
                    secname = realmSecname.substring(realmSecname.lastIndexOf(REALM_SEPARATOR) + 1);
                }
            }
            catch (Exception realmSecname) {
                void e;
                FFDCFilter.processException((Throwable)realmSecname, (String)"com.ibm.ws.security.core.SecurityContext", (String)"55", null, (Object[])new Object[0]);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)("Internal error: " + e), (Object[])new Object[0]);
            }
        }
        return secname;
    }

    /*
     * WARNING - void declaration
     */
    public static String getUser() {
        String accessid;
        block3: {
            accessid = null;
            WSCredential credential = SecurityContext.getCallerWSCredential();
            try {
                if (credential != null && !credential.isUnauthenticated()) {
                    accessid = credential.getAccessId();
                }
            }
            catch (Exception exception) {
                void e;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityContext", (String)"74", null, (Object[])new Object[0]);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)("Internal error: " + e), (Object[])new Object[0]);
            }
        }
        return accessid;
    }

    /*
     * WARNING - void declaration
     */
    private static WSCredential getCallerWSCredential() {
        WSCredential wsCredential;
        block3: {
            wsCredential = null;
            try {
                Set<WSCredential> wsCredentials;
                Iterator<WSCredential> wsCredentialsIterator;
                Subject subject = WSSubject.getCallerSubject();
                if (subject != null && (wsCredentialsIterator = (wsCredentials = subject.getPublicCredentials(WSCredential.class)).iterator()).hasNext()) {
                    wsCredential = wsCredentialsIterator.next();
                }
            }
            catch (WSSecurityException subject) {
                void e;
                FFDCFilter.processException((Throwable)subject, (String)"com.ibm.ws.security.core.SecurityContext", (String)"92", null, (Object[])new Object[0]);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)("Internal error: " + e), (Object[])new Object[0]);
            }
        }
        return wsCredential;
    }
}

