/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.util;

import com.ibm.ws.webcontainer.util.ClauseTable;
import com.ibm.ws.webcontainer.util.URIMatcher;
import java.util.ArrayList;
import java.util.List;

public class ClauseNode {
    int hashCode = -1;
    volatile Object target = null;
    volatile Object starTarget = null;
    ClauseTable children;
    int length = -1;
    int depth = -1;
    protected static final String starString = "*";
    String cl;

    public ClauseNode(ClauseNode parent, String clause, Object target) {
        this.hashCode = URIMatcher.computeHash(clause) & Integer.MAX_VALUE;
        this.target = target;
        this.length = clause.length();
        this.cl = clause;
        this.children = new ClauseTable();
        this.depth = parent == null ? 0 : parent.depth + this.length + 1;
    }

    public ClauseNode add(ClauseNode node) throws Exception {
        ClauseNode n = null;
        n = this.children.get(node.getClause());
        if (n != null) {
            if (node.getTarget() != null) {
                if (n.getTarget() != null) {
                    throw new Exception("Mapping clash for " + node.getTarget() + ": Target " + n.getTarget() + " already exists at node " + this.cl);
                }
                n.setTarget(node.getTarget());
            }
            return n;
        }
        this.children.add(node.getClause(), node);
        return this.children.get(node.getClause());
    }

    public void setTarget(Object target) {
        this.target = target;
    }

    public Object getTarget() {
        return this.target;
    }

    public void setStarTarget(Object target) {
        this.starTarget = target;
    }

    public Object getStarTarget() {
        return this.starTarget;
    }

    public ClauseNode traverse(String clause) {
        return this.children.get(clause);
    }

    public Object getTarget(String clause) {
        if (this.cl.equals(clause)) {
            return this.target;
        }
        return null;
    }

    public String getClause() {
        return this.cl;
    }

    public List<Object> targets() {
        ArrayList<Object> targets = new ArrayList<Object>();
        ArrayList<ClauseNode> l = this.children.getList();
        for (ClauseNode node : l) {
            if (node == null) continue;
            targets.addAll(node.targets());
        }
        if (this.target != null) {
            targets.add(this.target);
        }
        if (this.starTarget != null) {
            targets.add(this.starTarget);
        }
        return targets;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean remove(String mapping) {
        if (mapping == null) {
            if (this.starTarget == null) {
                this.target = null;
            }
        } else {
            String childName;
            int index = mapping.indexOf(47, 1);
            String remainder = null;
            if (index == -1) {
                childName = mapping.substring(1);
            } else {
                childName = mapping.substring(1, index);
                remainder = mapping.substring(index);
            }
            if (childName.equals(starString)) {
                if (this.starTarget != null) {
                    this.target = null;
                    this.starTarget = null;
                }
            } else {
                boolean delete;
                ClauseNode node = this.traverse(childName);
                if (node != null && (delete = node.remove(remainder))) {
                    this.children.remove(node.getClause());
                }
            }
        }
        return this.children.size() == 0 && this.target == null && this.starTarget == null;
    }

    public Object replace(String uri, Object newTarget) throws Exception {
        if (uri == null) {
            if (this.starTarget == null) {
                if (this.target == null) {
                    throw new Exception("No target to replace at given node");
                }
                Object oldTarget = this.target;
                this.target = newTarget;
                return oldTarget;
            }
        } else {
            String childName;
            int index = uri.indexOf(47, 1);
            String remainder = null;
            if (index == -1) {
                childName = uri.substring(1);
            } else {
                childName = uri.substring(1, index);
                remainder = uri.substring(index);
            }
            if (childName.equals(starString)) {
                if (this.starTarget == null) {
                    throw new Exception("No target to replace at given node");
                }
                Object oldTarget = this.target;
                this.target = newTarget;
                this.starTarget = newTarget;
                return oldTarget;
            }
            ClauseNode node = this.traverse(childName);
            if (node != null) {
                return node.replace(remainder, newTarget);
            }
            throw new Exception("No exact matching path found to replace");
        }
        return null;
    }

    public int getDepth() {
        return this.depth;
    }

    public String toString() {
        return "CL:" + this.cl + "T:" + this.target;
    }
}

