/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.bus.osgi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import java.util.ArrayList;
import java.util.List;
import org.apache.cxf.bus.extension.Extension;
import org.apache.cxf.bus.extension.ExtensionRegistry;
import org.apache.cxf.bus.osgi.CXFExtensionBundleListener;
import org.apache.cxf.bus.osgi.ManagedWorkQueueList;
import org.apache.cxf.bus.osgi.OSGIBusListener;
import org.apache.cxf.common.util.CollectionUtils;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.util.tracker.ServiceTracker;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class CXFActivator
implements BundleActivator {
    private List<Extension> extensions;
    private ManagedWorkQueueList workQueues;
    private ServiceTracker<ConfigurationAdmin, ConfigurationAdmin> configAdminTracker;
    private CXFExtensionBundleListener cxfBundleListener;
    private ServiceRegistration<ManagedServiceFactory> workQueueServiceRegistration;
    static final long serialVersionUID = -4274477865515306174L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public void start(BundleContext context) throws Exception {
        this.workQueues = new ManagedWorkQueueList();
        this.cxfBundleListener = new CXFExtensionBundleListener(context.getBundle().getBundleId());
        context.addBundleListener((BundleListener)this.cxfBundleListener);
        this.cxfBundleListener.registerExistingBundles(context);
        this.configAdminTracker = new ServiceTracker(context, ConfigurationAdmin.class, null);
        this.configAdminTracker.open();
        this.workQueues.setConfigAdminTracker(this.configAdminTracker);
        this.workQueueServiceRegistration = this.registerManagedServiceFactory(context, ManagedServiceFactory.class, this.workQueues, "org.apache.cxf.workqueues");
        this.extensions = new ArrayList<Extension>();
        this.extensions.add(this.createOsgiBusListenerExtension(context));
        this.extensions.add(CXFActivator.createManagedWorkQueueListExtension(this.workQueues));
        ExtensionRegistry.addExtensions(this.extensions);
    }

    private <T> ServiceRegistration<T> registerManagedServiceFactory(BundleContext context, Class<T> serviceClass, T service, String servicePid) {
        return context.registerService(serviceClass, service, CollectionUtils.singletonDictionary("service.pid", servicePid));
    }

    private Extension createOsgiBusListenerExtension(BundleContext context) {
        Extension busListener = new Extension(OSGIBusListener.class);
        busListener.setArgs(new Object[]{context});
        return busListener;
    }

    private static Extension createManagedWorkQueueListExtension(final ManagedWorkQueueList workQueues) {
        return new Extension(ManagedWorkQueueList.class){
            static final long serialVersionUID = 7438834964764256808L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Object getLoadedObject() {
                return workQueues;
            }

            @Override
            public Extension cloneNoObject() {
                return this;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"org.apache.cxf.bus.osgi.CXFActivator$1", 1.class, null, null);
            }
        };
    }

    public void stop(BundleContext context) throws Exception {
        context.removeBundleListener((BundleListener)this.cxfBundleListener);
        this.cxfBundleListener.shutdown();
        this.workQueues.shutDown();
        this.workQueueServiceRegistration.unregister();
        this.configAdminTracker.close();
        ExtensionRegistry.removeExtensions(this.extensions);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.apache.cxf.bus.osgi.CXFActivator", CXFActivator.class, null, null);
    }
}

