/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cdi.internal.config;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.cdi.internal.config.CDIConfiguration;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public abstract class AggregatedConfiguration
implements CDIConfiguration {
    private static final TraceComponent tc = Tr.register(AggregatedConfiguration.class, (String)"JCDI", (String)"com.ibm.ws.cdi.internal.resources.CDI");
    public static final String ENABLE_IMPLICIT_BEAN_ARCHIVES = "enableImplicitBeanArchives";
    public static final String EMPTY_BEANS_XML_EXPLICIT_BEAN_ARCHIVE = "emptyBeansXMLExplicitBeanArchive";
    private static final Boolean ENABLE_IMPLICIT_BEAN_ARCHIVES_DEFAULT = Boolean.TRUE;
    private static final Boolean EMPTY_BEANS_XML_EXPLICIT_BEAN_ARCHIVE_DEFAULT = Boolean.FALSE;
    private Boolean cdi12EnableImplicitBeanArchives = null;
    private Boolean cdiEnableImplicitBeanArchives = null;
    private Boolean cdiEmptyBeansXMLExplicitBeanArchive = null;
    private boolean enableImplicitBeanArchives = ENABLE_IMPLICIT_BEAN_ARCHIVES_DEFAULT;
    private boolean emptyBeansXMLExplicitBeanArchive = EMPTY_BEANS_XML_EXPLICIT_BEAN_ARCHIVE_DEFAULT;
    static final long serialVersionUID = -521204149003456552L;

    public void setCdi12Config(Boolean enableImplicitBeanArchives) {
        this.cdi12EnableImplicitBeanArchives = enableImplicitBeanArchives;
        this.updateAggregateConfig();
    }

    public void setCdiConfig(Boolean enableImplicitBeanArchives, Boolean emptyBeansXMLExplicitBeanArchive) {
        this.cdiEnableImplicitBeanArchives = enableImplicitBeanArchives;
        this.cdiEmptyBeansXMLExplicitBeanArchive = emptyBeansXMLExplicitBeanArchive;
        this.updateAggregateConfig();
    }

    private void updateAggregateConfig() {
        if (this.cdiEnableImplicitBeanArchives != null) {
            this.enableImplicitBeanArchives = this.cdiEnableImplicitBeanArchives;
            if (this.cdi12EnableImplicitBeanArchives != null && this.cdiEnableImplicitBeanArchives != this.cdi12EnableImplicitBeanArchives && tc.isWarningEnabled()) {
                Tr.warning((TraceComponent)tc, (String)"enableImplicitBeanArchives.conflict.CWOWB1017W", (Object[])new Object[0]);
            }
        } else {
            this.enableImplicitBeanArchives = this.cdi12EnableImplicitBeanArchives != null ? this.cdi12EnableImplicitBeanArchives.booleanValue() : ENABLE_IMPLICIT_BEAN_ARCHIVES_DEFAULT.booleanValue();
        }
        if (tc.isWarningEnabled() && !this.enableImplicitBeanArchives) {
            Tr.warning((TraceComponent)tc, (String)"implicit.bean.scanning.disabled.CWOWB1009W", (Object[])new Object[0]);
        }
        this.emptyBeansXMLExplicitBeanArchive = this.cdiEmptyBeansXMLExplicitBeanArchive != null ? this.cdiEmptyBeansXMLExplicitBeanArchive.booleanValue() : EMPTY_BEANS_XML_EXPLICIT_BEAN_ARCHIVE_DEFAULT.booleanValue();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Aggregated Config: enableImplicitBeanArchives: " + this.enableImplicitBeanArchives + " " + EMPTY_BEANS_XML_EXPLICIT_BEAN_ARCHIVE + ": " + this.emptyBeansXMLExplicitBeanArchive), (Object[])new Object[0]);
        }
    }

    @Override
    public boolean isImplicitBeanArchivesScanningDisabled() {
        return !this.enableImplicitBeanArchives;
    }

    @Override
    public boolean emptyBeansXMLExplicitBeanArchive() {
        return this.emptyBeansXMLExplicitBeanArchive;
    }
}

