/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.recoverylog.spi.RLSUtils;
import java.nio.ByteBuffer;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public abstract class LogRecord {
    private static final TraceComponent tc = Tr.register(LogRecord.class, (String)"Transaction", (String)"com.ibm.ws.Transaction.resources.TransactionMsgs");
    protected static final byte TRUE = 1;
    protected static final byte FALSE = 0;
    protected ByteBuffer _buffer = null;
    private final int _absolutePosition;
    protected static final byte[] RECORD_MAGIC_NUMBER = new byte[]{82, 67, 82, 68};
    public static final int HEADER_SIZE = RECORD_MAGIC_NUMBER.length + 8 + 4 + 8;
    static final long serialVersionUID = -8662050972176592179L;

    @ManualTrace
    protected LogRecord(ByteBuffer buffer, int absolutePosition) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"LogRecord", (Object[])new Object[]{buffer, absolutePosition});
        }
        this._buffer = buffer;
        this._absolutePosition = absolutePosition;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"LogRecord", (Object)this);
        }
    }

    @ManualTrace
    protected int position() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"position", (Object[])new Object[]{this});
        }
        int position = this._absolutePosition + this._buffer.position();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"position", (Object)position);
        }
        return position;
    }

    @ManualTrace
    protected void position(int newPosition) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"position", (Object[])new Object[]{this, newPosition});
        }
        this._buffer.position(newPosition -= this._absolutePosition);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"position");
        }
    }

    @ManualTrace
    protected int absolutePosition() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"absolutePosition", (Object[])new Object[]{this});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"absolutePosition", (Object)this._absolutePosition);
        }
        return this._absolutePosition;
    }

    @ManualTrace
    protected void advancePosition(int bytes) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"advancePosition", (Object[])new Object[]{this, bytes});
        }
        int newPosition = this._buffer.position() + bytes;
        this._buffer.position(newPosition);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Buffer's position now " + newPosition), (Object[])new Object[0]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"advancePosition");
        }
    }

    @ManualTrace
    protected void get(byte[] bytes) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"get", (Object[])new Object[]{this, bytes.length});
        }
        this._buffer.get(bytes);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)RLSUtils.toHexString(bytes, 32), (Object[])new Object[0]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"get");
        }
    }

    @ManualTrace
    protected int getInt() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getInt", (Object[])new Object[]{this});
        }
        int data = this._buffer.getInt();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getInt", (Object)data);
        }
        return data;
    }

    @ManualTrace
    protected long getLong() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getLong", (Object[])new Object[]{this});
        }
        long data = this._buffer.getLong();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getLong", (Object)data);
        }
        return data;
    }

    @ManualTrace
    protected short getShort() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getShort", (Object[])new Object[]{this});
        }
        short data = this._buffer.getShort();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getShort", (Object)data);
        }
        return data;
    }

    @ManualTrace
    protected boolean getBoolean() {
        byte dataByte;
        boolean data;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getBoolean", (Object[])new Object[]{this});
        }
        boolean bl = data = (dataByte = this._buffer.get()) == 1;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getBoolean", (Object)data);
        }
        return data;
    }
}

