/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.internal.impl;

import com.ibm.websphere.logging.WsLevel;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.logging.internal.impl.LoggingConstants;
import com.ibm.ws.logging.internal.impl.LoggingFileUtils;
import com.ibm.ws.logging.utils.MetatypeUtils;
import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class LoggingConfigUtils {
    static File getLogDirectory(Object newValue, File defaultDirectory) {
        File newDirectory = defaultDirectory;
        if (newValue != null && newValue instanceof String) {
            newDirectory = new File((String)newValue);
        }
        if (newDirectory == null) {
            String value = ".";
            try {
                value = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                    @Override
                    public String run() throws Exception {
                        return System.getProperty("user.dir");
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
            newDirectory = new File(value);
        }
        return LoggingFileUtils.validateDirectory(newDirectory);
    }

    public static boolean getBooleanValue(Object newValue, boolean defaultValue) {
        if (newValue != null) {
            if (newValue instanceof String) {
                return Boolean.parseBoolean((String)newValue);
            }
            if (newValue instanceof Boolean) {
                return (Boolean)newValue;
            }
        }
        return defaultValue;
    }

    public static int getIntValue(Object newValue, int defaultValue) {
        if (newValue != null) {
            if (newValue instanceof String) {
                try {
                    return Integer.parseInt((String)newValue);
                }
                catch (NumberFormatException numberFormatException) {
                }
            } else if (newValue instanceof Integer) {
                return (Integer)newValue;
            }
        }
        return defaultValue;
    }

    public static long getLongValue(Object newValue, long defaultValue) {
        if (newValue != null) {
            if (newValue instanceof String) {
                try {
                    return Long.parseLong((String)newValue);
                }
                catch (NumberFormatException numberFormatException) {
                }
            } else if (newValue instanceof Long) {
                return (Long)newValue;
            }
        }
        return defaultValue;
    }

    public static long getLongDurationValue(Object newValue, long defaultValue, TimeUnit timeUnit) {
        if (newValue != null) {
            if (newValue instanceof String) {
                try {
                    if (!((String)newValue).isEmpty()) {
                        return MetatypeUtils.evaluateDuration((String)newValue, timeUnit);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else if (newValue instanceof Long) {
                return (Long)newValue;
            }
        }
        return defaultValue;
    }

    public static String getStringValue(Object newValue, String defaultValue) {
        if (newValue == null) {
            return defaultValue;
        }
        return (String)newValue;
    }

    public static Level getLogLevel(Object newValue, Level defaultLevel) {
        Level result = defaultLevel;
        if (newValue != null && newValue instanceof String) {
            String strValue = ((String)newValue).toUpperCase();
            if (strValue.equals("INFO")) {
                return Level.INFO;
            }
            if (strValue.equals("AUDIT")) {
                return WsLevel.AUDIT;
            }
            if (strValue.equals("WARNING")) {
                return Level.WARNING;
            }
            if (strValue.equals("ERROR")) {
                return WsLevel.ERROR;
            }
            if (strValue.equals("OFF")) {
                return Level.OFF;
            }
        }
        return result;
    }

    public static LoggingConstants.TraceFormat getFormatValue(Object newValue, LoggingConstants.TraceFormat defaultValue) {
        if (newValue != null && newValue instanceof String) {
            String strValue = ((String)newValue).toUpperCase();
            try {
                return LoggingConstants.TraceFormat.valueOf(strValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static LoggingConstants.FFDCSummaryPolicy getFFDCSummaryPolicy(Object newValue, LoggingConstants.FFDCSummaryPolicy defaultValue) {
        if (newValue != null && newValue instanceof String) {
            String strValue = ((String)newValue).toUpperCase();
            try {
                return LoggingConstants.FFDCSummaryPolicy.valueOf(strValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static <T> T getDelegate(Class<T> delegateClass, String className, String defaultDelegateClass) {
        if (className == null) {
            className = defaultDelegateClass;
        }
        try {
            return Class.forName(className).asSubclass(delegateClass).newInstance();
        }
        catch (Throwable e) {
            System.err.println("Unable to locate configured delegate: " + delegateClass + ", " + e);
            return null;
        }
    }

    @FFDCIgnore(value={Exception.class})
    public static Collection<String> parseStringCollection(String propertyKey, Object obj, Collection<String> defaultValue) {
        if (obj != null) {
            try {
                if (obj instanceof Collection) {
                    return (Collection)obj;
                }
                if (obj instanceof String) {
                    String commaList = (String)obj;
                    return Arrays.asList(commaList.split("\\s*,\\s*"));
                }
                if (obj instanceof String[]) {
                    return Arrays.asList((String[])obj);
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Collection of strings could not be parsed: key=" + propertyKey + ", value=" + obj, e);
            }
            throw new IllegalArgumentException("Collection of strings could not be parsed: key=" + propertyKey + ", value=" + obj);
        }
        return defaultValue;
    }

    public static String getStringFromCollection(Collection<String> values) {
        StringBuilder builder = new StringBuilder();
        if (values != null) {
            for (String value : values) {
                builder.append(value).append(',');
            }
            if (builder.charAt(builder.length() - 1) == ',') {
                builder.deleteCharAt(builder.length() - 1);
            }
        }
        return builder.toString();
    }

    public static String getEnvValue(final String envName) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getenv(envName);
            }
        });
    }

    public static boolean isMessageFormatValueValid(String formatValue) {
        return formatValue.toLowerCase().equals("simple") || formatValue.toLowerCase().equals("json") || formatValue.toLowerCase().equals("tbasic") || formatValue.toLowerCase().equals("basic");
    }

    public static boolean isConsoleFormatValueValid(String formatValue) {
        return formatValue.toLowerCase().equals("dev") || formatValue.toLowerCase().equals("simple") || formatValue.toLowerCase().equals("json") || formatValue.toLowerCase().equals("tbasic") || formatValue.toLowerCase().equals("basic");
    }
}

