/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.microprofile.client.sse;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.concurrent.ExecutorService;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Providers;
import javax.ws.rs.sse.InboundSseEvent;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.ext.MessageContextImpl;
import org.apache.cxf.jaxrs.impl.ProvidersImpl;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.microprofile.client.Utils;
import org.apache.cxf.microprofile.client.sse.SsePublisher;
import org.apache.cxf.microprofile.client.sse.SseTypeSafeProcessor;
import org.reactivestreams.Publisher;

@Produces(value={"text/event-stream"})
@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SseMessageBodyReader
implements MessageBodyReader<Publisher<?>> {
    static final long serialVersionUID = -1735691970163893936L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return Publisher.class.isAssignableFrom(type) && MediaType.SERVER_SENT_EVENTS_TYPE.isCompatible(mediaType);
    }

    public Publisher<?> readFrom(Class<Publisher<?>> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        Message m = JAXRSUtils.getCurrentMessage();
        ExecutorService executor = Utils.getExecutorService((MessageContext)new MessageContextImpl(m));
        SsePublisher publisher = new SsePublisher(entityStream, executor, (Providers)new ProvidersImpl(m));
        if (genericType instanceof ParameterizedType) {
            Type typeArgument = ((ParameterizedType)genericType).getActualTypeArguments()[0];
            if (typeArgument.equals(InboundSseEvent.class)) {
                return publisher;
            }
            return new SseTypeSafeProcessor(new GenericType(typeArgument), publisher);
        }
        return null;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.apache.cxf.microprofile.client.sse.SseMessageBodyReader", SseMessageBodyReader.class, null, null);
    }
}

