/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cdi.impl.weld;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.cdi.CDIException;
import com.ibm.ws.cdi.CDIService;
import com.ibm.ws.cdi.executor.ExecutorServicesImpl;
import com.ibm.ws.cdi.impl.CDIImpl;
import com.ibm.ws.cdi.impl.weld.BDAFactory;
import com.ibm.ws.cdi.impl.weld.OnDemandArchive;
import com.ibm.ws.cdi.impl.weld.TransactionServicesImpl;
import com.ibm.ws.cdi.impl.weld.injection.WebSphereInjectionServicesImpl;
import com.ibm.ws.cdi.internal.interfaces.Application;
import com.ibm.ws.cdi.internal.interfaces.ArchiveType;
import com.ibm.ws.cdi.internal.interfaces.CDIRuntime;
import com.ibm.ws.cdi.internal.interfaces.CDIUtils;
import com.ibm.ws.cdi.internal.interfaces.TransactionService;
import com.ibm.ws.cdi.internal.interfaces.WebSphereBeanDeploymentArchive;
import com.ibm.ws.cdi.internal.interfaces.WebSphereCDIDeployment;
import com.ibm.ws.cdi.liberty.ExtensionMetaData;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.injectionengine.InjectionException;
import com.ibm.wsspi.injectionengine.ReferenceContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import javax.enterprise.inject.spi.CDI;
import javax.enterprise.inject.spi.Extension;
import org.jboss.weld.bootstrap.WeldBootstrap;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.api.helpers.SimpleServiceRegistry;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.Metadata;
import org.jboss.weld.manager.api.ExecutorServices;
import org.jboss.weld.probe.ProbeExtension;
import org.jboss.weld.security.spi.SecurityServices;
import org.jboss.weld.serialization.spi.ProxyServices;
import org.jboss.weld.transaction.spi.TransactionServices;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class WebSphereCDIDeploymentImpl
implements WebSphereCDIDeployment {
    private static final TraceComponent tc = Tr.register(WebSphereCDIDeploymentImpl.class, (String)"JCDI", (String)"com.ibm.ws.cdi.internal.resources.CDI");
    private final String id;
    private final Map<String, WebSphereBeanDeploymentArchive> deploymentDBAs = new HashMap<String, WebSphereBeanDeploymentArchive>();
    private final Set<WebSphereBeanDeploymentArchive> applicationBDAs = new HashSet<WebSphereBeanDeploymentArchive>();
    private final Map<String, WebSphereBeanDeploymentArchive> extensionBDAs = new HashMap<String, WebSphereBeanDeploymentArchive>();
    private final List<WebSphereBeanDeploymentArchive> orderedBDAs = new ArrayList<WebSphereBeanDeploymentArchive>();
    private WeldBootstrap bootstrap;
    private ClassLoader classloader;
    private final Set<ClassLoader> extensionClassLoaders = new HashSet<ClassLoader>();
    private Boolean cdiEnabled;
    private final Map<String, Boolean> cdiStatusMap = new HashMap<String, Boolean>();
    private final ConcurrentMap<Class<?>, WebSphereBeanDeploymentArchive> classBDAMap = new ConcurrentHashMap();
    private Application application;
    private final SimpleServiceRegistry serviceRegistry;
    private Iterable<Metadata<Extension>> extensions;
    private final WebSphereInjectionServicesImpl injectionServices;
    private final CDIRuntime cdiRuntime;
    private final CDIImpl cdi;
    static final long serialVersionUID = 741167280954358959L;

    public WebSphereCDIDeploymentImpl(Application application, CDIRuntime cdiRuntime) {
        this.bootstrap = new WeldBootstrap();
        this.id = application.getJ2EEName().toString();
        this.application = application;
        this.serviceRegistry = new SimpleServiceRegistry();
        TransactionService wsTransactionService = cdiRuntime.getTransactionService();
        TransactionServicesImpl transactionServices = null;
        if (wsTransactionService != null) {
            transactionServices = new TransactionServicesImpl(wsTransactionService);
        }
        this.serviceRegistry.add(TransactionServices.class, (Service)transactionServices);
        this.serviceRegistry.add(SecurityServices.class, (Service)cdiRuntime.getSecurityServices());
        this.serviceRegistry.add(ProxyServices.class, (Service)cdiRuntime.getProxyServices());
        ExecutorService executorService = cdiRuntime.getExecutorService();
        if (executorService != null) {
            ExecutorServicesImpl executorServices = new ExecutorServicesImpl(executorService, cdiRuntime.getScheduledExecutorService());
            this.serviceRegistry.add(ExecutorServices.class, (Service)executorServices);
        }
        this.injectionServices = new WebSphereInjectionServicesImpl(this);
        this.cdiRuntime = cdiRuntime;
        this.cdi = new CDIImpl((CDIService)cdiRuntime);
    }

    public WebSphereInjectionServicesImpl getInjectionServices() {
        return this.injectionServices;
    }

    public void setClassLoader(ClassLoader classloader) {
        this.classloader = classloader;
        this.extensionClassLoaders.add(classloader);
    }

    public ClassLoader getClassLoader() {
        return this.classloader;
    }

    public WeldBootstrap getBootstrap() {
        return this.bootstrap;
    }

    public String getDeploymentID() {
        return this.id;
    }

    public WebSphereBeanDeploymentArchive getBeanDeploymentArchive(String archiveID) {
        return this.deploymentDBAs.get(archiveID);
    }

    public Collection<WebSphereBeanDeploymentArchive> getApplicationBDAs() {
        return Collections.unmodifiableSet(this.applicationBDAs);
    }

    public boolean isCDIEnabled() {
        if (this.cdiEnabled == null) {
            this.cdiEnabled = this.isCDIEnabled(this.getApplicationBDAs());
        }
        return this.cdiEnabled;
    }

    private boolean isCDIEnabled(Collection<WebSphereBeanDeploymentArchive> bdas) {
        boolean anyHasBeans = false;
        for (WebSphereBeanDeploymentArchive bda : bdas) {
            boolean hasBeans = false;
            if (bda.getType() != ArchiveType.RUNTIME_EXTENSION) {
                hasBeans = this.isCDIEnabled(bda);
            }
            if (!(anyHasBeans = anyHasBeans || hasBeans)) continue;
            break;
        }
        return anyHasBeans;
    }

    private boolean isCDIEnabled(WebSphereBeanDeploymentArchive bda) {
        Boolean hasBeans = this.cdiStatusMap.get(bda.getId());
        if (hasBeans == null) {
            hasBeans = bda.hasBeans() || bda.isExtension();
            this.cdiStatusMap.put(bda.getId(), hasBeans);
            hasBeans = hasBeans != false || this.isCDIEnabled(bda.getWebSphereBeanDeploymentArchives());
            this.cdiStatusMap.put(bda.getId(), hasBeans);
        }
        return hasBeans;
    }

    public boolean isCDIEnabled(String bdaId) {
        boolean hasBeans = false;
        if (this.isCDIEnabled()) {
            WebSphereBeanDeploymentArchive bda;
            Boolean hasBeansBoolean = this.cdiStatusMap.get(bdaId);
            hasBeans = hasBeansBoolean == null ? ((bda = this.deploymentDBAs.get(bdaId)) == null ? false : this.isCDIEnabled(bda)) : hasBeansBoolean;
        }
        return hasBeans;
    }

    public String toString() {
        return "WebSphere CDI Deployment for " + this.id;
    }

    public Collection<BeanDeploymentArchive> getBeanDeploymentArchives() {
        return new ArrayList<WebSphereBeanDeploymentArchive>(this.deploymentDBAs.values());
    }

    public void initializeOrderedBeanDeploymentArchives() {
        this.orderedBDAs.addAll(this.extensionBDAs.values());
        this.orderedBDAs.addAll(this.applicationBDAs);
    }

    public Collection<WebSphereBeanDeploymentArchive> getWebSphereBeanDeploymentArchives() {
        return new ArrayList<WebSphereBeanDeploymentArchive>(this.deploymentDBAs.values());
    }

    public BeanDeploymentArchive loadBeanDeploymentArchive(Class<?> beanClass) {
        WebSphereBeanDeploymentArchive bda = this.getBeanDeploymentArchiveFromClass(beanClass);
        if (bda == null) {
            try {
                bda = this.createBDAOntheFly(beanClass);
            }
            catch (CDIException cDIException) {
                FFDCFilter.processException((Throwable)cDIException, (String)"com.ibm.ws.cdi.impl.weld.WebSphereCDIDeploymentImpl", (String)"317", (Object)this, (Object[])new Object[]{beanClass});
                bda = null;
            }
        }
        return bda;
    }

    private BeanDeploymentArchive createBDAOntheFly(Class<?> beanClass) throws CDIException {
        BeanDeploymentArchive bdaToReturn = this.findCandidateBDAtoAddThisClass(beanClass);
        if (bdaToReturn != null) {
            return bdaToReturn;
        }
        return this.createNewBdaAndMakeWiring(beanClass);
    }

    /*
     * WARNING - void declaration
     */
    private BeanDeploymentArchive createNewBdaAndMakeWiring(Class<?> beanClass) {
        try {
            OnDemandArchive onDemandArchive = new OnDemandArchive(this.cdiRuntime, this.application, beanClass);
            WebSphereBeanDeploymentArchive newBda = BDAFactory.createBDA((WebSphereCDIDeployment)this, onDemandArchive, this.cdiRuntime);
            ClassLoader beanClassCL = onDemandArchive.getClassLoader();
            for (WebSphereBeanDeploymentArchive wbda : this.getWebSphereBeanDeploymentArchives()) {
                ClassLoader thisBDACL = wbda.getClassLoader();
                if (wbda.getType() == ArchiveType.RUNTIME_EXTENSION) {
                    newBda.addBeanDeploymentArchive(wbda);
                } else {
                    this.makeWiring(newBda, wbda, thisBDACL, beanClassCL);
                }
                if (wbda.getType() == ArchiveType.RUNTIME_EXTENSION && wbda.extensionCanSeeApplicationBDAs()) {
                    wbda.addBeanDeploymentArchive(newBda);
                    continue;
                }
                this.makeWiring(wbda, newBda, beanClassCL, thisBDACL);
            }
            this.addBeanDeploymentArchive(newBda);
            return newBda;
        }
        catch (CDIException onDemandArchive) {
            void e;
            FFDCFilter.processException((Throwable)onDemandArchive, (String)"com.ibm.ws.cdi.impl.weld.WebSphereCDIDeploymentImpl", (String)"393", (Object)this, (Object[])new Object[]{beanClass});
            throw new IllegalStateException((Throwable)e);
        }
    }

    private BeanDeploymentArchive findCandidateBDAtoAddThisClass(Class<?> beanClass) throws CDIException {
        for (WebSphereBeanDeploymentArchive wbda : this.getWebSphereBeanDeploymentArchives()) {
            if (wbda.getClassLoader() == beanClass.getClassLoader()) {
                wbda.addToBeanClazzes(beanClass);
                return wbda;
            }
            if (beanClass.getClassLoader() != null || !wbda.getId().endsWith("BdaForClassesLoadedByRootClassLoader")) continue;
            wbda.addToBeanClazzes(beanClass);
            return wbda;
        }
        return null;
    }

    private void makeWiring(WebSphereBeanDeploymentArchive wireFromBda, WebSphereBeanDeploymentArchive wireToBda, ClassLoader wireToBdaCL, ClassLoader wireFromBdaCL) {
        while (wireFromBdaCL != null) {
            if (wireFromBdaCL == wireToBdaCL) {
                wireFromBda.addBeanDeploymentArchive(wireToBda);
                break;
            }
            wireFromBdaCL = wireFromBdaCL.getParent();
        }
        if (wireFromBdaCL == wireToBdaCL) {
            wireFromBda.addBeanDeploymentArchive(wireToBda);
        }
    }

    @Trivial
    public ServiceRegistry getServices() {
        return this.serviceRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public Iterable<Metadata<Extension>> getExtensions() {
        if (this.extensions == null) {
            HashSet<Metadata<Extension>> extensionSet = new HashSet<Metadata<Extension>>();
            ClassLoader oldCL = null;
            try {
                for (ClassLoader classLoader : this.extensionClassLoaders) {
                    Iterable extensionIt;
                    if (oldCL != null) {
                        CDIUtils.getAndSetLoader((ClassLoader)classLoader);
                    } else {
                        oldCL = CDIUtils.getAndSetLoader((ClassLoader)classLoader);
                    }
                    if ((extensionIt = this.bootstrap.loadExtensions(classLoader)) == null) continue;
                    for (Metadata extension : extensionIt) {
                        Class<?> extClass = ((Extension)extension.getValue()).getClass();
                        WebSphereBeanDeploymentArchive bda = this.getBeanDeploymentArchive(extClass);
                        if (bda == null) continue;
                        extensionSet.add((Metadata<Extension>)extension);
                        this.extensionBDAs.put(bda.getId(), bda);
                    }
                }
            }
            finally {
                if (oldCL != null) {
                    CDIUtils.getAndSetLoader(oldCL);
                }
            }
            if (CDIUtils.isDevelopementMode()) {
                extensionSet.add(this.getProbeExtension());
                WebSphereBeanDeploymentArchive bda = this.getBeanDeploymentArchive(ProbeExtension.class);
                this.extensionBDAs.put(bda.getId(), bda);
            }
            for (WebSphereBeanDeploymentArchive deploymentBDA : this.deploymentDBAs.values()) {
                Set spiExtensionSuppliers = deploymentBDA.getSPIExtensionSuppliers();
                if (spiExtensionSuppliers.isEmpty()) continue;
                this.extensionBDAs.put(deploymentBDA.getId(), deploymentBDA);
                for (Supplier spiExtensionSupplier : spiExtensionSuppliers) {
                    try {
                        Extension extension = (Extension)spiExtensionSupplier.get();
                        ExtensionMetaData metaData = new ExtensionMetaData(extension);
                        extensionSet.add(metaData);
                    }
                    catch (Exception extension) {
                        void e;
                        FFDCFilter.processException((Throwable)extension, (String)"com.ibm.ws.cdi.impl.weld.WebSphereCDIDeploymentImpl", (String)"520", (Object)this, (Object[])new Object[0]);
                        Tr.error((TraceComponent)tc, (String)"exception.creating.extensions.CWOWB1012E", (Object[])new Object[]{deploymentBDA.toString(), e.toString()});
                    }
                }
            }
            this.initializeOrderedBeanDeploymentArchives();
            this.extensions = extensionSet;
        }
        return this.extensions;
    }

    private Metadata<Extension> getProbeExtension() {
        return CDIUtils.loadExtension((String)ProbeExtension.class.getName(), (ClassLoader)ProbeExtension.class.getClassLoader());
    }

    public WebSphereBeanDeploymentArchive getBeanDeploymentArchive(Class<?> beanClass) {
        for (WebSphereBeanDeploymentArchive bda : this.deploymentDBAs.values()) {
            if (!bda.containsBeanClass(beanClass)) continue;
            return bda;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Trivial
    public WebSphereBeanDeploymentArchive getBeanDeploymentArchiveFromClass(Class<?> clazz) {
        WebSphereBeanDeploymentArchive wbda = (WebSphereBeanDeploymentArchive)this.classBDAMap.get(clazz);
        if (wbda == null) {
            for (WebSphereBeanDeploymentArchive bda : this.orderedBDAs) {
                if (!bda.getAllClazzes().contains(clazz.getName())) continue;
                Class bdaClazz = null;
                try {
                    bdaClazz = CDIUtils.loadClass((ClassLoader)bda.getClassLoader(), (String)clazz.getName());
                }
                catch (CDIException cDIException) {
                    void e;
                    FFDCFilter.processException((Throwable)cDIException, (String)"com.ibm.ws.cdi.impl.weld.WebSphereCDIDeploymentImpl", (String)"567", (Object)this, (Object[])new Object[]{clazz});
                    e.printStackTrace();
                }
                if (bdaClazz != clazz) continue;
                wbda = bda;
                this.classBDAMap.put(clazz, bda);
                break;
            }
        }
        return wbda;
    }

    public void addBeanDeploymentArchive(WebSphereBeanDeploymentArchive bda) throws CDIException {
        this.deploymentDBAs.put(bda.getId(), bda);
        this.extensionClassLoaders.add(bda.getClassLoader());
        ArchiveType type = bda.getType();
        if (type != ArchiveType.SHARED_LIB && type != ArchiveType.RUNTIME_EXTENSION) {
            this.applicationBDAs.add(bda);
        }
    }

    public void addBeanDeploymentArchives(Set<WebSphereBeanDeploymentArchive> bdas) throws CDIException {
        for (WebSphereBeanDeploymentArchive bda : bdas) {
            this.addBeanDeploymentArchive(bda);
        }
    }

    public void scan() throws CDIException {
        ArrayList<WebSphereBeanDeploymentArchive> allBDAs = new ArrayList<WebSphereBeanDeploymentArchive>(this.deploymentDBAs.values());
        for (WebSphereBeanDeploymentArchive bda : allBDAs) {
            bda.scanForBeanDefiningAnnotations(true);
        }
        for (WebSphereBeanDeploymentArchive bda : allBDAs) {
            if (bda.hasBeenScanned()) continue;
            bda.scan();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void initializeInjectionServices() throws CDIException {
        HashSet<ReferenceContext> cdiReferenceContexts = new HashSet<ReferenceContext>();
        for (WebSphereBeanDeploymentArchive bda : this.getApplicationBDAs()) {
            if (bda.getType() == ArchiveType.MANIFEST_CLASSPATH || bda.getType() == ArchiveType.WEB_INF_LIB) continue;
            ReferenceContext referenceContext2 = bda.initializeInjectionServices();
            cdiReferenceContexts.add(referenceContext2);
        }
        for (ReferenceContext referenceContext : cdiReferenceContexts) {
            try {
                referenceContext.process();
            }
            catch (InjectionException referenceContext2) {
                void e;
                FFDCFilter.processException((Throwable)referenceContext2, (String)"com.ibm.ws.cdi.impl.weld.WebSphereCDIDeploymentImpl", (String)"663", (Object)this, (Object[])new Object[0]);
                throw new CDIException((Throwable)e);
            }
        }
    }

    public void shutdown() {
        if (this.bootstrap != null) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){
                static final long serialVersionUID = -7043929022981666580L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Void run() {
                    WebSphereCDIDeploymentImpl.this.bootstrap.shutdown();
                    return null;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.cdi.impl.weld.WebSphereCDIDeploymentImpl$1", 1.class, (String)"JCDI", (String)"com.ibm.ws.cdi.internal.resources.CDI");
                }
            });
            this.bootstrap = null;
            this.deploymentDBAs.clear();
            this.applicationBDAs.clear();
            this.extensionBDAs.clear();
            this.orderedBDAs.clear();
            this.classloader = null;
            this.extensionClassLoaders.clear();
            this.cdiEnabled = false;
            this.cdiStatusMap.clear();
            this.application = null;
            this.classBDAMap.clear();
        }
    }

    public void validateJEEComponentClasses() throws CDIException {
        Collection<WebSphereBeanDeploymentArchive> bdas = this.getWebSphereBeanDeploymentArchives();
        for (WebSphereBeanDeploymentArchive bda : bdas) {
            if (bda.getType().equals((Object)ArchiveType.RUNTIME_EXTENSION)) continue;
            bda.createInjectionTargetsForJEEComponentClasses();
        }
    }

    public void addReferenceContext(ReferenceContext referenceContext) {
        this.getInjectionServices().addReferenceContext(referenceContext);
    }

    public CDI<Object> getCDI() {
        return this.cdi;
    }
}

