/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cdi.liberty;

import com.ibm.ejs.util.Util;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.cdi.CDIException;
import com.ibm.ws.cdi.CDIService;
import com.ibm.ws.cdi.extension.WebSphereCDIExtension;
import com.ibm.ws.cdi.impl.AbstractCDIRuntime;
import com.ibm.ws.cdi.impl.CDIContainerImpl;
import com.ibm.ws.cdi.internal.archive.liberty.CDILibertyRuntime;
import com.ibm.ws.cdi.internal.archive.liberty.RuntimeFactory;
import com.ibm.ws.cdi.internal.config.CDIConfiguration;
import com.ibm.ws.cdi.internal.interfaces.Application;
import com.ibm.ws.cdi.internal.interfaces.ArchiveType;
import com.ibm.ws.cdi.internal.interfaces.BeansXmlParser;
import com.ibm.ws.cdi.internal.interfaces.BuildCompatibleExtensionFinder;
import com.ibm.ws.cdi.internal.interfaces.CDIArchive;
import com.ibm.ws.cdi.internal.interfaces.CDIContainerEventManager;
import com.ibm.ws.cdi.internal.interfaces.CDIUtils;
import com.ibm.ws.cdi.internal.interfaces.EjbEndpointService;
import com.ibm.ws.cdi.internal.interfaces.ExtensionArchive;
import com.ibm.ws.cdi.internal.interfaces.ExtensionArchiveProvider;
import com.ibm.ws.cdi.internal.interfaces.TransactionService;
import com.ibm.ws.cdi.internal.interfaces.WebSphereCDIDeployment;
import com.ibm.ws.cdi.liberty.CDIDeferredMetaDataFactoryImpl;
import com.ibm.ws.cdi.liberty.JndiHelperComponentMetaData;
import com.ibm.ws.cdi.proxy.ProxyServicesImpl;
import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.container.service.metadata.MetaDataSlotService;
import com.ibm.ws.container.service.metadata.extended.DeferredMetaDataFactory;
import com.ibm.ws.container.service.state.ApplicationStateListener;
import com.ibm.ws.container.service.state.StateChangeException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.LibertyProcess;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.resource.ResourceRefConfigFactory;
import com.ibm.ws.runtime.metadata.ApplicationMetaData;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.MetaData;
import com.ibm.ws.runtime.metadata.MetaDataSlot;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.wsspi.adaptable.module.AdaptableModuleFactory;
import com.ibm.wsspi.artifact.factory.ArtifactContainerFactory;
import com.ibm.wsspi.classloading.ClassLoadingService;
import com.ibm.wsspi.injectionengine.InjectionEngine;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceSet;
import com.ibm.wsspi.kernel.service.utils.ServiceAndServiceReferencePair;
import io.openliberty.cdi.spi.CDIExtensionMetadata;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import javax.enterprise.inject.spi.CDIProvider;
import org.jboss.weld.ejb.spi.EjbServices;
import org.jboss.weld.security.spi.SecurityServices;
import org.jboss.weld.serialization.spi.ProxyServices;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(name="com.ibm.ws.cdi.liberty.CDIRuntimeImpl", service={ApplicationStateListener.class, CDIService.class, CDIProvider.class}, property={"service.vendor=IBM"})
public class CDIRuntimeImpl
extends AbstractCDIRuntime
implements ApplicationStateListener,
CDIService,
CDILibertyRuntime,
CDIProvider {
    private static final TraceComponent tc = Tr.register(CDIRuntimeImpl.class, (String)"JCDI", (String)"com.ibm.ws.cdi.internal.resources.CDI");
    private final AtomicServiceReference<MetaDataSlotService> metaDataSlotServiceSR = new AtomicServiceReference("metaDataSlotService");
    private final AtomicServiceReference<EjbEndpointService> ejbEndpointServiceSR = new AtomicServiceReference("ejbEndpointService");
    private final AtomicServiceReference<ClassLoadingService> classLoadingSRRef = new AtomicServiceReference("classLoadingService");
    private final AtomicServiceReference<EjbServices> ejbServices = new AtomicServiceReference("ejbServices");
    private final AtomicServiceReference<TransactionService> transactionService = new AtomicServiceReference("transactionService");
    private final AtomicServiceReference<SecurityServices> securityServices = new AtomicServiceReference("securityServices");
    private final ConcurrentServiceReferenceSet<WebSphereCDIExtension> extensionsSR = new ConcurrentServiceReferenceSet("extensionService");
    private final ConcurrentServiceReferenceSet<CDIExtensionMetadata> spiExtensionsSR = new ConcurrentServiceReferenceSet("spiExtensionService");
    private final AtomicServiceReference<ArtifactContainerFactory> containerFactorySRRef = new AtomicServiceReference("containerFactory");
    private final AtomicServiceReference<AdaptableModuleFactory> adaptableModuleFactorySRRef = new AtomicServiceReference("adaptableModuleFactory");
    private final AtomicServiceReference<InjectionEngine> injectionEngineServiceRef = new AtomicServiceReference("injectionEngine");
    private final AtomicServiceReference<ScheduledExecutorService> scheduledExecutorServiceRef = new AtomicServiceReference("scheduledExecutorService");
    private final AtomicServiceReference<ExecutorService> executorServiceRef = new AtomicServiceReference("executorService");
    private final AtomicServiceReference<ExecutorService> managedExecutorServiceRef = new AtomicServiceReference("managedExecutorService");
    private final AtomicServiceReference<ResourceRefConfigFactory> resourceRefConfigFactoryRef = new AtomicServiceReference("resourceRefConfigFactory");
    private final AtomicServiceReference<DeferredMetaDataFactory> deferredMetaDataFactoryRef = new AtomicServiceReference("cdiDeferredMetaDataFactoryImpl");
    @Reference
    private BeansXmlParser beansXmlParser;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile BuildCompatibleExtensionFinder bceFinder;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile CDIContainerEventManager cdiContainerEventManager;
    @Reference
    private CDIConfiguration cdiContainerConfig;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile List<ExtensionArchiveProvider> extensionArchiveProviders;
    private MetaDataSlot applicationSlot;
    private boolean isClientProcess;
    private RuntimeFactory runtimeFactory;
    private ProxyServicesImpl proxyServices;
    private final Map<String, ClassLoader> appTccls = new ConcurrentHashMap<String, ClassLoader>();
    static final long serialVersionUID = -9156477760047595530L;

    public void activate(ComponentContext cc) {
        this.metaDataSlotServiceSR.activate(cc);
        this.ejbEndpointServiceSR.activate(cc);
        this.classLoadingSRRef.activate(cc);
        this.extensionsSR.activate(cc);
        this.spiExtensionsSR.activate(cc);
        this.applicationSlot = ((MetaDataSlotService)this.metaDataSlotServiceSR.getServiceWithException()).reserveMetaDataSlot(ApplicationMetaData.class);
        this.ejbServices.activate(cc);
        this.securityServices.activate(cc);
        this.transactionService.activate(cc);
        this.containerFactorySRRef.activate(cc);
        this.scheduledExecutorServiceRef.activate(cc);
        this.executorServiceRef.activate(cc);
        this.adaptableModuleFactorySRRef.activate(cc);
        this.injectionEngineServiceRef.activate(cc);
        this.resourceRefConfigFactoryRef.activate(cc);
        this.managedExecutorServiceRef.activate(cc);
        this.deferredMetaDataFactoryRef.activate(cc);
        this.runtimeFactory = new RuntimeFactory((CDILibertyRuntime)this);
        this.proxyServices = new ProxyServicesImpl();
        this.start();
    }

    public void deactivate(ComponentContext cc) {
        this.stop();
        this.runtimeFactory = null;
        this.proxyServices = null;
        this.metaDataSlotServiceSR.deactivate(cc);
        this.ejbEndpointServiceSR.deactivate(cc);
        this.classLoadingSRRef.deactivate(cc);
        this.ejbServices.deactivate(cc);
        this.securityServices.deactivate(cc);
        this.transactionService.deactivate(cc);
        this.extensionsSR.deactivate(cc);
        this.spiExtensionsSR.deactivate(cc);
        this.containerFactorySRRef.deactivate(cc);
        this.scheduledExecutorServiceRef.deactivate(cc);
        this.executorServiceRef.deactivate(cc);
        this.adaptableModuleFactorySRRef.deactivate(cc);
        this.injectionEngineServiceRef.deactivate(cc);
        this.resourceRefConfigFactoryRef.deactivate(cc);
        this.managedExecutorServiceRef.deactivate(cc);
        this.deferredMetaDataFactoryRef.deactivate(cc);
    }

    @Reference(name="cdiDeferredMetaDataFactoryImpl", service=DeferredMetaDataFactory.class, target="(deferredMetaData=CDI)")
    protected void setCDIDeferredMetaDataFactoryImpl(ServiceReference<DeferredMetaDataFactory> ref) {
        this.deferredMetaDataFactoryRef.setReference(ref);
    }

    protected void unsetCDIDeferredMetaDataFactoryImpl(ServiceReference<DeferredMetaDataFactory> ref) {
        this.deferredMetaDataFactoryRef.unsetReference(ref);
    }

    @Reference(name="executorService", service=ExecutorService.class)
    protected void setExecutorService(ServiceReference<ExecutorService> ref) {
        this.executorServiceRef.setReference(ref);
    }

    protected void unsetExecutorService(ServiceReference<ExecutorService> ref) {
        this.executorServiceRef.unsetReference(ref);
    }

    @Reference(name="managedExecutorService", service=ExecutorService.class, target="(id=DefaultManagedExecutorService)", policyOption=ReferencePolicyOption.GREEDY, cardinality=ReferenceCardinality.OPTIONAL)
    protected void setManagedExecutorService(ServiceReference<ExecutorService> ref) {
        this.managedExecutorServiceRef.setReference(ref);
    }

    protected void unsetManagedExecutorService(ServiceReference<ExecutorService> ref) {
        this.managedExecutorServiceRef.unsetReference(ref);
    }

    @Reference(name="scheduledExecutorService", service=ScheduledExecutorService.class, target="(deferrable=false)")
    protected void setScheduledExecutorService(ServiceReference<ScheduledExecutorService> ref) {
        this.scheduledExecutorServiceRef.setReference(ref);
    }

    protected void unsetScheduledExecutorService(ServiceReference<ScheduledExecutorService> ref) {
        this.scheduledExecutorServiceRef.unsetReference(ref);
    }

    @Reference(name="containerFactory", service=ArtifactContainerFactory.class, target="(&(category=DIR)(category=JAR)(category=BUNDLE))")
    protected void setContainerFactory(ServiceReference<ArtifactContainerFactory> ref) {
        this.containerFactorySRRef.setReference(ref);
    }

    protected void unsetContainerFactory(ServiceReference<ArtifactContainerFactory> ref) {
        this.containerFactorySRRef.unsetReference(ref);
    }

    @Reference(name="adaptableModuleFactory", service=AdaptableModuleFactory.class)
    protected void setAdaptableModuleFactory(ServiceReference<AdaptableModuleFactory> ref) {
        this.adaptableModuleFactorySRRef.setReference(ref);
    }

    protected void unsetAdaptableModuleFactory(ServiceReference<AdaptableModuleFactory> ref) {
        this.adaptableModuleFactorySRRef.unsetReference(ref);
    }

    @Reference(name="extensionService", service=WebSphereCDIExtension.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE)
    protected void setExtensionService(ServiceReference<WebSphereCDIExtension> reference) {
        this.extensionsSR.addReference(reference);
    }

    protected void unsetExtensionService(ServiceReference<WebSphereCDIExtension> reference) {
        this.extensionsSR.removeReference(reference);
        CDIContainerImpl cdiContainer = this.getCDIContainer();
        if (cdiContainer != null) {
            cdiContainer.removeRuntimeExtensionArchive(reference);
        }
    }

    @Reference(name="spiExtensionService", service=CDIExtensionMetadata.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE)
    protected void setSPIExtensionService(ServiceReference<CDIExtensionMetadata> reference) {
        this.spiExtensionsSR.addReference(reference);
    }

    protected void unsetSPIExtensionService(ServiceReference<CDIExtensionMetadata> reference) {
        this.spiExtensionsSR.removeReference(reference);
        CDIContainerImpl cdiContainer = this.getCDIContainer();
        if (cdiContainer != null) {
            cdiContainer.removeRuntimeExtensionArchiveMetaData(reference);
        }
    }

    @Reference(name="transactionService", service=TransactionService.class)
    protected void setTransactionService(ServiceReference<TransactionService> transactionService) {
        this.transactionService.setReference(transactionService);
    }

    protected void unsetTransactionService(ServiceReference<TransactionService> transactionService) {
        this.transactionService.unsetReference(transactionService);
    }

    @Reference(name="securityServices", service=SecurityServices.class)
    protected void setSecurityServices(ServiceReference<SecurityServices> securityServices) {
        this.securityServices.setReference(securityServices);
    }

    protected void unsetSecurityServices(ServiceReference<SecurityServices> securityServices) {
        this.securityServices.unsetReference(securityServices);
    }

    @Reference(name="ejbServices", service=EjbServices.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL)
    protected void setEjbServices(ServiceReference<EjbServices> ejbServices) {
        this.ejbServices.setReference(ejbServices);
    }

    protected void unsetEjbServices(ServiceReference<EjbServices> ejbServices) {
        this.ejbServices.unsetReference(ejbServices);
    }

    @Reference(name="metaDataSlotService", service=MetaDataSlotService.class)
    protected void setMetaDataSlotService(ServiceReference<MetaDataSlotService> reference) {
        this.metaDataSlotServiceSR.setReference(reference);
    }

    protected void unsetMetaDataSlotService(ServiceReference<MetaDataSlotService> reference) {
        this.metaDataSlotServiceSR.unsetReference(reference);
    }

    @Reference(name="ejbEndpointService", service=EjbEndpointService.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL)
    protected void setEjbEndpointService(ServiceReference<EjbEndpointService> reference) {
        this.ejbEndpointServiceSR.setReference(reference);
    }

    protected void unsetEjbEndpointService(ServiceReference<EjbEndpointService> reference) {
        this.ejbEndpointServiceSR.unsetReference(reference);
    }

    @Reference(name="resourceRefConfigFactory", service=ResourceRefConfigFactory.class)
    protected void setResourceRefConfigFactory(ServiceReference<ResourceRefConfigFactory> resourceRefConfigFactory) {
        this.resourceRefConfigFactoryRef.setReference(resourceRefConfigFactory);
    }

    protected void unsetResourceRefConfigFactory(ServiceReference<ResourceRefConfigFactory> resourceRefConfigFactory) {
        this.resourceRefConfigFactoryRef.unsetReference(resourceRefConfigFactory);
    }

    @Reference(name="classLoadingService", service=ClassLoadingService.class)
    protected void setClassLoadingService(ServiceReference<ClassLoadingService> ref) {
        this.classLoadingSRRef.setReference(ref);
    }

    protected void unsetClassLoadingService(ServiceReference<ClassLoadingService> ref) {
        this.classLoadingSRRef.unsetReference(ref);
    }

    @Reference(name="injectionEngine", service=InjectionEngine.class)
    protected void setInjectionEngine(ServiceReference<InjectionEngine> ref) {
        this.injectionEngineServiceRef.setReference(ref);
    }

    protected void unsetInjectionEngine(ServiceReference<InjectionEngine> ref) {
        this.injectionEngineServiceRef.unsetReference(ref);
    }

    @Reference(name="libertyProcess", service=LibertyProcess.class, target="(wlp.process.type=client)", cardinality=ReferenceCardinality.OPTIONAL)
    protected void setLibertyProcess(ServiceReference<LibertyProcess> sr) {
        this.isClientProcess = true;
    }

    public ResourceRefConfigFactory getResourceRefConfigFactory() {
        return (ResourceRefConfigFactory)this.resourceRefConfigFactoryRef.getService();
    }

    public TransactionService getTransactionService() {
        return (TransactionService)this.transactionService.getService();
    }

    public SecurityServices getSecurityServices() {
        return (SecurityServices)this.securityServices.getService();
    }

    public Iterator<ServiceAndServiceReferencePair<WebSphereCDIExtension>> getExtensionServices() {
        return this.extensionsSR.getServicesWithReferences();
    }

    public Iterator<ServiceAndServiceReferencePair<CDIExtensionMetadata>> getSPIExtensionServices() {
        return this.spiExtensionsSR.getServicesWithReferences();
    }

    public ArtifactContainerFactory getArtifactContainerFactory() {
        return (ArtifactContainerFactory)this.containerFactorySRRef.getService();
    }

    public AdaptableModuleFactory getAdaptableModuleFactory() {
        return (AdaptableModuleFactory)this.adaptableModuleFactorySRRef.getService();
    }

    public MetaDataSlot getApplicationSlot() {
        return this.applicationSlot;
    }

    public EjbEndpointService getEjbEndpointService() {
        return (EjbEndpointService)this.ejbEndpointServiceSR.getService();
    }

    public InjectionEngine getInjectionEngine() {
        return (InjectionEngine)this.injectionEngineServiceRef.getService();
    }

    public ScheduledExecutorService getScheduledExecutorService() {
        return (ScheduledExecutorService)this.scheduledExecutorServiceRef.getService();
    }

    public ExecutorService getExecutorService() {
        ExecutorService managedExecutorService = (ExecutorService)this.managedExecutorServiceRef.getService();
        if (managedExecutorService != null) {
            return managedExecutorService;
        }
        return (ExecutorService)this.executorServiceRef.getService();
    }

    public boolean isClientProcess() {
        return this.isClientProcess;
    }

    /*
     * WARNING - void declaration
     */
    public void applicationStarting(ApplicationInfo appInfo) throws StateChangeException {
        boolean setContext;
        block14: {
            ClassLoader newCL = null;
            ClassLoader oldCl = null;
            setContext = false;
            try {
                Application application = this.runtimeFactory.newApplication(appInfo);
                if (!application.hasModules()) {
                    this.runtimeFactory.removeApplication(appInfo);
                    return;
                }
                ClassLoader appCL = this.getRealAppClassLoader(application);
                if (appCL != null) {
                    newCL = ((ClassLoadingService)this.classLoadingSRRef.getServiceWithException()).createThreadContextClassLoader(appCL);
                    this.appTccls.put(appInfo.getName(), newCL);
                    oldCl = CDIUtils.getAndSetLoader((ClassLoader)newCL);
                }
                if (application.getModuleArchives().size() > 0 && application.getApplicationMetaData() != null) {
                    CDIArchive archive = (CDIArchive)application.getModuleArchives().iterator().next();
                    this.beginContext(archive);
                    setContext = true;
                }
                for (CDIArchive archive : application.getModuleArchives()) {
                    this.registerDeferedMetaData(archive);
                }
                WebSphereCDIDeployment webSphereCDIDeployment = this.getCDIContainer().startInitialization(application);
                if (webSphereCDIDeployment != null) {
                    this.getCDIContainer().endInitialization(webSphereCDIDeployment);
                }
                if (oldCl == null) break block14;
            }
            catch (CDIException application) {
                void e;
                FFDCFilter.processException((Throwable)application, (String)"com.ibm.ws.cdi.liberty.CDIRuntimeImpl", (String)"492", (Object)this, (Object[])new Object[]{appInfo});
                throw new StateChangeException((Throwable)e);
            }
            finally {
                if (oldCl != null) {
                    CDIUtils.getAndSetLoader(oldCl);
                }
                if (setContext) {
                    this.endContext();
                }
            }
            CDIUtils.getAndSetLoader((ClassLoader)oldCl);
        }
        if (setContext) {
            this.endContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void applicationStopped(ApplicationInfo appInfo) {
        Application application = this.runtimeFactory.removeApplication(appInfo);
        if (application == null) {
            return;
        }
        try {
            this.getCDIContainer().applicationStopped(application);
        }
        catch (CDIException tccl32) {
            FFDCFilter.processException((Throwable)tccl32, (String)"com.ibm.ws.cdi.liberty.CDIRuntimeImpl", (String)"518", (Object)this, (Object[])new Object[]{appInfo});
            try {
                Iterator tccl32 = application.getModuleArchives().iterator();
                while (tccl32.hasNext()) {
                    CDIArchive archive = (CDIArchive)tccl32.next();
                    DeferredMetaDataFactory metaDataFactory = (DeferredMetaDataFactory)this.deferredMetaDataFactoryRef.getService();
                    CDIDeferredMetaDataFactoryImpl cdiMetaDataFactory = (CDIDeferredMetaDataFactoryImpl)metaDataFactory;
                    cdiMetaDataFactory.removeComponentMetaData(archive);
                }
                return;
            }
            catch (CDIException tccl2) {
                FFDCFilter.processException((Throwable)tccl2, (String)"com.ibm.ws.cdi.liberty.CDIRuntimeImpl", (String)"527", (Object)this, (Object[])new Object[]{appInfo});
                return;
            }
            finally {
                ClassLoader tccl2 = this.appTccls.get(appInfo.getName());
                if (tccl2 != null) {
                    ((ClassLoadingService)this.classLoadingSRRef.getServiceWithException()).destroyThreadContextClassLoader(tccl2);
                    this.appTccls.remove(appInfo.getName());
                }
            }
        }
        catch (Throwable throwable) {
            try {
                Iterator iterator = application.getModuleArchives().iterator();
                while (iterator.hasNext()) {
                    CDIArchive archive = (CDIArchive)iterator.next();
                    DeferredMetaDataFactory metaDataFactory = (DeferredMetaDataFactory)this.deferredMetaDataFactoryRef.getService();
                    CDIDeferredMetaDataFactoryImpl cdiMetaDataFactory = (CDIDeferredMetaDataFactoryImpl)metaDataFactory;
                    cdiMetaDataFactory.removeComponentMetaData(archive);
                }
                throw throwable;
            }
            catch (CDIException tccl) {
                FFDCFilter.processException((Throwable)tccl, (String)"com.ibm.ws.cdi.liberty.CDIRuntimeImpl", (String)"527", (Object)this, (Object[])new Object[]{appInfo});
                throw throwable;
            }
            finally {
                ClassLoader tccl = this.appTccls.get(appInfo.getName());
                if (tccl != null) {
                    ((ClassLoadingService)this.classLoadingSRRef.getServiceWithException()).destroyThreadContextClassLoader(tccl);
                    this.appTccls.remove(appInfo.getName());
                }
            }
        }
        try {
            Iterator iterator = application.getModuleArchives().iterator();
            while (iterator.hasNext()) {
                CDIArchive archive = (CDIArchive)iterator.next();
                DeferredMetaDataFactory metaDataFactory = (DeferredMetaDataFactory)this.deferredMetaDataFactoryRef.getService();
                CDIDeferredMetaDataFactoryImpl cdiMetaDataFactory = (CDIDeferredMetaDataFactoryImpl)metaDataFactory;
                cdiMetaDataFactory.removeComponentMetaData(archive);
            }
            return;
        }
        catch (CDIException tccl) {
            FFDCFilter.processException((Throwable)tccl, (String)"com.ibm.ws.cdi.liberty.CDIRuntimeImpl", (String)"527", (Object)this, (Object[])new Object[]{appInfo});
            return;
        }
        finally {
            ClassLoader tccl = this.appTccls.get(appInfo.getName());
            if (tccl != null) {
                ((ClassLoadingService)this.classLoadingSRRef.getServiceWithException()).destroyThreadContextClassLoader(tccl);
                this.appTccls.remove(appInfo.getName());
            }
        }
    }

    public void applicationStarted(ApplicationInfo appInfo) throws StateChangeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)Util.identity((Object)this), (Object[])new Object[]{"applicationStarted", appInfo});
        }
        try {
            Application application = this.runtimeFactory.newApplication(appInfo);
            if (application != null) {
                this.getCDIContainer().applicationStarted(application);
            }
        }
        catch (CDIException cDIException) {
            FFDCFilter.processException((Throwable)cDIException, (String)"com.ibm.ws.cdi.liberty.CDIRuntimeImpl", (String)"552", (Object)this, (Object[])new Object[]{appInfo});
        }
    }

    public void applicationStopping(ApplicationInfo appInfo) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)Util.identity((Object)this), (Object[])new Object[]{"applicationStopping", appInfo});
        }
        try {
            Application application = this.runtimeFactory.newApplication(appInfo);
            if (application != null) {
                this.getCDIContainer().applicationStopping(application);
            }
        }
        catch (CDIException cDIException) {
            FFDCFilter.processException((Throwable)cDIException, (String)"com.ibm.ws.cdi.liberty.CDIRuntimeImpl", (String)"567", (Object)this, (Object[])new Object[]{appInfo});
        }
    }

    public boolean isImplicitBeanArchivesScanningDisabled(CDIArchive archive) {
        return this.cdiContainerConfig.isImplicitBeanArchivesScanningDisabled();
    }

    public ExtensionArchive getExtensionArchiveForBundle(Bundle bundle, Set<String> extraClasses, Set<String> extraAnnotations, boolean applicationBDAsVisible, boolean extClassesOnly, Set<String> spiExtensionClasses) throws CDIException {
        ExtensionArchive extensionArchive = this.runtimeFactory.getExtensionArchiveForBundle(bundle, extraClasses, extraAnnotations, applicationBDAsVisible, extClassesOnly, spiExtensionClasses);
        return extensionArchive;
    }

    public ProxyServices getProxyServices() {
        return this.proxyServices;
    }

    public void beginContext(CDIArchive archive) throws CDIException {
        JndiHelperComponentMetaData cmd = null;
        MetaData metaData = archive.getMetaData();
        if (archive.isModule()) {
            ModuleMetaData moduleMetaData = (ModuleMetaData)metaData;
            cmd = new JndiHelperComponentMetaData(moduleMetaData);
        } else {
            ApplicationMetaData applicationMetaData = (ApplicationMetaData)metaData;
            cmd = new JndiHelperComponentMetaData(applicationMetaData);
        }
        ComponentMetaDataAccessorImpl accessor = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor();
        accessor.beginContext((ComponentMetaData)cmd);
    }

    private void registerDeferedMetaData(CDIArchive archive) throws CDIException {
        JndiHelperComponentMetaData cmd = null;
        MetaData metaData = archive.getMetaData();
        if (archive.isModule()) {
            ModuleMetaData moduleMetaData = (ModuleMetaData)metaData;
            cmd = new JndiHelperComponentMetaData(moduleMetaData);
        } else {
            ApplicationMetaData applicationMetaData = (ApplicationMetaData)metaData;
            cmd = new JndiHelperComponentMetaData(applicationMetaData);
        }
        DeferredMetaDataFactory metaDataFactory = (DeferredMetaDataFactory)this.deferredMetaDataFactoryRef.getService();
        CDIDeferredMetaDataFactoryImpl cdiMetaDataFactory = (CDIDeferredMetaDataFactoryImpl)metaDataFactory;
        cdiMetaDataFactory.registerComponentMetaData(archive, cmd);
    }

    public ClassLoader getRealAppClassLoader(Application application) {
        try {
            ArrayList moduleArchives = new ArrayList(application.getModuleArchives());
            if (moduleArchives.isEmpty()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)Util.identity((Object)this), (Object[])new Object[]{"Application {0} has no modules so no thread context class loader will be set, this is expected for an OSGI app.", application});
                }
                return null;
            }
            if (moduleArchives.size() == 1 && ArchiveType.WEB_MODULE == ((CDIArchive)moduleArchives.get(0)).getType()) {
                return ((CDIArchive)moduleArchives.get(0)).getClassLoader();
            }
            return application.getClassLoader();
        }
        catch (CDIException moduleArchives) {
            FFDCFilter.processException((Throwable)moduleArchives, (String)"com.ibm.ws.cdi.liberty.CDIRuntimeImpl", (String)"663", (Object)this, (Object[])new Object[]{application});
            return null;
        }
    }

    public boolean isWeldProxy(Class clazz) {
        return CDIUtils.isWeldProxy((Class)clazz);
    }

    public boolean isWeldProxy(Object obj) {
        return CDIUtils.isWeldProxy((Object)obj);
    }

    public BeansXmlParser getBeansXmlParser() {
        return this.beansXmlParser;
    }

    public CDIContainerEventManager getCDIContainerEventManager() {
        return this.cdiContainerEventManager;
    }

    public Collection<ExtensionArchiveProvider> getExtensionArchiveProviders() {
        return this.extensionArchiveProviders;
    }

    public BuildCompatibleExtensionFinder getBuildCompatibleExtensionFinder() {
        return this.bceFinder;
    }
}

