/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.health31.internal.servlet;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.health31.internal.HealthCheck31Service;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class HealthCheckServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final TraceComponent tc = Tr.register(HealthCheckServlet.class, (String)"HEALTH", (String)"io.openliberty.microprofile.health.resources.Health");
    private transient HealthCheck31Service healthService = null;
    private static final Logger logger = Logger.getLogger(HealthCheckServlet.class.getName(), "io.openliberty.microprofile.health.resources.Health");

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.findHealthService(request);
        this.healthService.performHealthCheck(request, response);
    }

    private synchronized void findHealthService(HttpServletRequest request) throws ServletException {
        if (this.healthService == null) {
            HttpSession session = request.getSession();
            ServletContext sc = session.getServletContext();
            BundleContext ctxt = (BundleContext)sc.getAttribute("osgi-bundlecontext");
            ServiceReference ref = ctxt.getServiceReference(HealthCheck31Service.class);
            if (ref == null) {
                logger.log(Level.SEVERE, "OSGI_SERVICE_ERROR", "HealthCheckService");
                throw new ServletException(Tr.formatMessage((TraceComponent)tc, (String)"OSGI_SERVICE_ERROR", (Object[])new Object[]{"HealthCheckService"}));
            }
            this.healthService = (HealthCheck31Service)ctxt.getService(ref);
        }
    }
}

