/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs20.server;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.jaxrs20.api.JaxRsFactoryBeanCustomizer;
import com.ibm.ws.jaxrs20.injection.InjectionRuntimeContextHelper;
import com.ibm.ws.jaxrs20.injection.metadata.InjectionRuntimeContext;
import com.ibm.ws.jaxrs20.injection.metadata.ParamInjectionMetadata;
import com.ibm.ws.jaxrs20.server.LibertyJaxRsServerFactoryBean;
import com.ibm.ws.jaxrs20.server.ResourceUtils;
import com.ibm.ws.jaxrs20.server.component.JaxRsBeanValidation;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.JAXRSInvoker;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.logging.FaultListener;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class LibertyJaxRsInvoker
extends JAXRSInvoker {
    private static final TraceComponent tc = Tr.register(LibertyJaxRsInvoker.class, (String)"JaxRsServer", (String)"com.ibm.ws.jaxrs20.server.internal.resources.JaxRsServerMessages");
    private final Class cxfBeanValidationProviderClass;
    private final Map<String, Method> cxfBeanValidationProviderMethodsMap = new HashMap<String, Method>();
    private final boolean isEnableBeanValidation;
    private final LibertyJaxRsServerFactoryBean libertyJaxRsServerFactoryBean;
    private final BeanValidationFaultListener beanValidationFaultListener;
    private volatile Object beanValidationProvider = null;
    private static final String cxfBeanValidationProviderClassName = "org.apache.cxf.validation.BeanValidationProvider";
    private boolean validateServiceObject = true;
    static final long serialVersionUID = -4154743020338369210L;

    @FFDCIgnore(value={ClassNotFoundException.class})
    public LibertyJaxRsInvoker(LibertyJaxRsServerFactoryBean libertyJaxRsServerFactoryBean, boolean isEnableBeanValidation) {
        this.libertyJaxRsServerFactoryBean = libertyJaxRsServerFactoryBean;
        this.isEnableBeanValidation = isEnableBeanValidation;
        if (!isEnableBeanValidation) {
            this.cxfBeanValidationProviderClass = null;
            this.beanValidationFaultListener = null;
        } else {
            this.cxfBeanValidationProviderClass = JaxRsBeanValidation.getBeanValidationProviderClass();
            if (this.cxfBeanValidationProviderClass == null) {
                this.beanValidationFaultListener = null;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Bean Validation Provider Class not found", (Object[])new Object[0]);
                }
                return;
            }
            this.cacheValidationMethod("validateBean", new Class[]{Object.class});
            this.cacheValidationMethod("validateParameters", new Class[]{Object.class, Method.class, Object[].class});
            this.cacheValidationMethod("validateReturnValue", new Class[]{Object.class, Method.class, Object.class});
            ClassLoader loader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){
                static final long serialVersionUID = 6822338735624457769L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public ClassLoader run() {
                    return Thread.currentThread().getContextClassLoader();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.jaxrs20.server.LibertyJaxRsInvoker$1", 1.class, (String)"JaxRsServer", (String)"com.ibm.ws.jaxrs20.server.internal.resources.JaxRsServerMessages");
                }
            });
            BeanValidationFaultListener listener = null;
            try {
                Class<?> cve = loader.loadClass("javax.validation.ConstraintViolationException");
                listener = new BeanValidationFaultListener(cve);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            this.beanValidationFaultListener = listener;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void cacheValidationMethod(String methodName, Class[] paramTypes) {
        block4: {
            try {
                Method m = this.cxfBeanValidationProviderClass.getMethod(methodName, paramTypes);
                this.cxfBeanValidationProviderMethodsMap.put(methodName, m);
            }
            catch (NoSuchMethodException m) {
                FFDCFilter.processException((Throwable)m, (String)"com.ibm.ws.jaxrs20.server.LibertyJaxRsInvoker", (String)"144", (Object)((Object)this), (Object[])new Object[]{methodName, paramTypes});
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    void e;
                    Tr.debug((TraceComponent)tc, (String)("Can't find method \"" + methodName + "\" for Bean Validation Provider. " + e.getMessage()), (Object[])new Object[0]);
                }
            }
            catch (SecurityException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jaxrs20.server.LibertyJaxRsInvoker", (String)"148", (Object)((Object)this), (Object[])new Object[]{methodName, paramTypes});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)("Can't access method \"" + methodName + "\" for Bean Validation Provider due to security issue. " + e.getMessage()), (Object[])new Object[0]);
            }
        }
    }

    protected Object performInvocation(Exchange exchange, Object serviceObject, Method m, Object[] paramArray) throws Exception {
        paramArray = this.insertExchange(m, paramArray, exchange);
        return this.libertyJaxRsServerFactoryBean.performInvocation(exchange, serviceObject, m, paramArray);
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={RuntimeException.class})
    public Object invoke(Exchange exchange, Object serviceObject, Method m, List<Object> params) {
        Object realServiceObject = null;
        JaxRsFactoryBeanCustomizer beanCustomizer = null;
        OperationResourceInfo ori = (OperationResourceInfo)exchange.get(OperationResourceInfo.class);
        ClassResourceInfo cri = ori.getClassResourceInfo();
        try {
            MessageContentsList list;
            if (!cri.isSingleton()) {
                Method postConstructMethod;
                Class<?> clazz = serviceObject.getClass();
                beanCustomizer = this.libertyJaxRsServerFactoryBean.findBeanCustomizer(clazz);
                if (beanCustomizer != null) {
                    realServiceObject = beanCustomizer.beforeServiceInvoke(serviceObject, cri.isSingleton(), this.libertyJaxRsServerFactoryBean.getBeanCustomizerContext(beanCustomizer));
                    if (!(realServiceObject != serviceObject || beanCustomizer.getClass().getName().equalsIgnoreCase("com.ibm.ws.jaxrs20.ejb.JaxRsFactoryBeanEJBCustomizer") || cri.contextsAvailable() || cri.paramsAvailable())) {
                        postConstructMethod = ResourceUtils.findPostConstructMethod(realServiceObject.getClass());
                        InjectionUtils.invokeLifeCycleMethod((Object)realServiceObject, (Method)postConstructMethod);
                    }
                } else {
                    realServiceObject = serviceObject;
                    if (!cri.contextsAvailable() && !cri.paramsAvailable()) {
                        postConstructMethod = ResourceUtils.findPostConstructMethod(serviceObject.getClass());
                        InjectionUtils.invokeLifeCycleMethod((Object)serviceObject, (Method)postConstructMethod);
                    }
                }
            } else {
                realServiceObject = serviceObject;
            }
            Message message = JAXRSUtils.getCurrentMessage();
            Object theProvider = null;
            if (this.isEnableBeanValidation && this.cxfBeanValidationProviderClass != null) {
                theProvider = this.getProvider(message);
                try {
                    if (this.isValidateServiceObject()) {
                        this.callValidationMethod("validateBean", new Object[]{realServiceObject}, theProvider);
                    }
                    this.callValidationMethod("validateParameters", new Object[]{realServiceObject, m, params.toArray()}, theProvider);
                }
                catch (RuntimeException e) {
                    if (this.beanValidationFaultListener != null && this.beanValidationFaultListener.cve.isInstance(e)) {
                        Message m2 = exchange.getInMessage();
                        m2.put((Object)FaultListener.class.getName(), (Object)this.beanValidationFaultListener);
                    }
                    throw e;
                }
            }
            Object response = super.invoke(exchange, realServiceObject, m, params);
            if (this.isEnableBeanValidation && this.cxfBeanValidationProviderClass != null && theProvider != null && response instanceof MessageContentsList && (list = (MessageContentsList)response).size() == 1) {
                Object entity = list.get(0);
                if (entity instanceof Response) {
                    this.callValidationMethod("validateReturnValue", new Object[]{realServiceObject, m, ((Response)entity).getEntity()}, theProvider);
                } else {
                    this.callValidationMethod("validateReturnValue", new Object[]{realServiceObject, m, entity}, theProvider);
                }
            }
            Object object = response;
            return object;
        }
        catch (RuntimeException e) {
            InjectionRuntimeContextHelper.removeRuntimeContext();
            throw e;
        }
        catch (Error e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jaxrs20.server.LibertyJaxRsInvoker", (String)"301", (Object)((Object)this), (Object[])new Object[]{exchange, serviceObject, m, params});
            InjectionRuntimeContextHelper.removeRuntimeContext();
            throw e;
        }
        catch (Throwable e) {
            void t;
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jaxrs20.server.LibertyJaxRsInvoker", (String)"304", (Object)((Object)this), (Object[])new Object[]{exchange, serviceObject, m, params});
            InjectionRuntimeContextHelper.removeRuntimeContext();
            throw new RuntimeException((Throwable)t);
        }
        finally {
            if (beanCustomizer != null && realServiceObject != null) {
                beanCustomizer.afterServiceInvoke(realServiceObject, cri.isSingleton(), this.libertyJaxRsServerFactoryBean.getBeanCustomizerContext(beanCustomizer));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected Object getProvider(Message message) {
        block7: {
            if (this.beanValidationProvider == null) {
                Object prop = message.getContextualProperty(cxfBeanValidationProviderClassName);
                if (prop != null) {
                    this.beanValidationProvider = prop;
                } else {
                    try {
                        this.beanValidationProvider = this.cxfBeanValidationProviderClass.newInstance();
                    }
                    catch (InstantiationException instantiationException) {
                        FFDCFilter.processException((Throwable)instantiationException, (String)"com.ibm.ws.jaxrs20.server.LibertyJaxRsInvoker", (String)"336", (Object)((Object)this), (Object[])new Object[]{message});
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            void e;
                            Tr.debug((TraceComponent)tc, (String)("init Bean Validation Provider fails. " + e.getMessage()), (Object[])new Object[0]);
                        }
                    }
                    catch (IllegalAccessException e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jaxrs20.server.LibertyJaxRsInvoker", (String)"340", (Object)((Object)this), (Object[])new Object[]{message});
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block7;
                        Tr.debug((TraceComponent)tc, (String)("Can't access the initialization of Bean Validation Provider. " + e.getMessage()), (Object[])new Object[0]);
                    }
                }
            }
        }
        return this.beanValidationProvider;
    }

    @FFDCIgnore(value={SecurityException.class, IllegalAccessException.class, IllegalArgumentException.class, InvocationTargetException.class})
    private void callValidationMethod(String methodName, Object[] paramValues, Object theProvider) {
        block11: {
            if (theProvider == null) {
                return;
            }
            Method m = this.cxfBeanValidationProviderMethodsMap.get(methodName);
            if (m == null) {
                return;
            }
            try {
                m.invoke(theProvider, paramValues);
            }
            catch (SecurityException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Can't access the method \"" + m.getName() + "\" due to security issue." + e.getMessage()), (Object[])new Object[0]);
                }
            }
            catch (IllegalAccessException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Can't access the method \"" + m.getName() + "\"." + e.getMessage()), (Object[])new Object[0]);
                }
            }
            catch (IllegalArgumentException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Illegal argument to the method \"" + m.getName() + "\"." + e.getMessage()), (Object[])new Object[0]);
                }
            }
            catch (InvocationTargetException e) {
                Throwable validationException;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Invocation of the method \"" + m.getName() + "\" fails" + e.getMessage()), (Object[])new Object[0]);
                }
                if (null == (validationException = e.getTargetException()) || !(validationException instanceof RuntimeException)) break block11;
                throw (RuntimeException)validationException;
            }
        }
    }

    public void setProvider(Object provider) {
        if (provider == null) {
            return;
        }
        if (!provider.getClass().getName().equals(cxfBeanValidationProviderClassName)) {
            return;
        }
        this.beanValidationProvider = provider;
    }

    public boolean isValidateServiceObject() {
        return this.validateServiceObject;
    }

    public void setValidateServiceObject(boolean validateServiceObject) {
        this.validateServiceObject = validateServiceObject;
    }

    public Object invoke(Exchange exchange, Object request, Object resourceObject) {
        JaxRsFactoryBeanCustomizer beanCustomizer = this.libertyJaxRsServerFactoryBean.findBeanCustomizer(resourceObject.getClass());
        if (beanCustomizer != null) {
            OperationResourceInfo ori = (OperationResourceInfo)exchange.get(OperationResourceInfo.class);
            Message inMessage = exchange.getInMessage();
            InjectionRuntimeContext irc = InjectionRuntimeContextHelper.getRuntimeContext();
            ParamInjectionMetadata pimd = new ParamInjectionMetadata(ori, inMessage);
            irc.setRuntimeCtxObject(ParamInjectionMetadata.class.getName(), (Object)pimd);
        }
        return super.invoke(exchange, request, resourceObject);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class BeanValidationFaultListener
    implements FaultListener {
        final Class<? extends RuntimeException> cve;
        static final long serialVersionUID = 2580426959783377424L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        BeanValidationFaultListener(Class<? extends RuntimeException> cve) {
            this.cve = cve;
        }

        public boolean faultOccurred(Exception exception, String description, Message message) {
            return !this.cve.isInstance(exception);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.jaxrs20.server.LibertyJaxRsInvoker$BeanValidationFaultListener", BeanValidationFaultListener.class, (String)"JaxRsServer", (String)"com.ibm.ws.jaxrs20.server.internal.resources.JaxRsServerMessages");
        }
    }
}

