/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.javaeesec.identitystore;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.javaeesec.identitystore.ELHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import javax.security.enterprise.identitystore.DatabaseIdentityStoreDefinition;
import javax.security.enterprise.identitystore.IdentityStore;
import javax.security.enterprise.identitystore.PasswordHash;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class DatabaseIdentityStoreDefinitionWrapper {
    private static final TraceComponent tc = Tr.register(DatabaseIdentityStoreDefinitionWrapper.class, (String)"security", (String)"com.ibm.ws.security.javaeesec.internal.resources.JavaEESecMessages");
    private final String callerQuery;
    private final String dataSourceLookup;
    private final String groupsQuery;
    private final Class<? extends PasswordHash> hashAlgorithm;
    private final List<String> hashAlgorithmParameters;
    private final DatabaseIdentityStoreDefinition idStoreDefinition;
    private final Integer priority;
    private final Set<IdentityStore.ValidationType> useFor;
    private boolean datasourceEvaluated = false;
    private final ELHelper elHelper;
    static final long serialVersionUID = -5155381691669685152L;

    DatabaseIdentityStoreDefinitionWrapper(DatabaseIdentityStoreDefinition idStoreDefinition) {
        if (idStoreDefinition == null) {
            throw new IllegalArgumentException("The DatabaseIdentityStoreDefinition cannot be null.");
        }
        this.idStoreDefinition = idStoreDefinition;
        this.elHelper = new ELHelper();
        this.callerQuery = this.evaluateCallerQuery(true);
        this.dataSourceLookup = this.evaluateDataSourceLookup(true);
        if (this.dataSourceLookup != null) {
            this.datasourceEvaluated = true;
        }
        this.groupsQuery = this.evaluateGroupsQuery(true);
        this.hashAlgorithm = this.evaluateHashAlgorithm();
        this.hashAlgorithmParameters = this.evaluateHashAlgorithmParameters();
        this.priority = this.evaluatePriority(true);
        this.useFor = this.evaluateUseFor(true);
    }

    @FFDCIgnore(value={IllegalArgumentException.class})
    private String evaluateCallerQuery(boolean immediateOnly) {
        String callerQuery = this.idStoreDefinition.callerQuery();
        try {
            return this.elHelper.processString("callerQuery", callerQuery, immediateOnly);
        }
        catch (IllegalArgumentException e) {
            if (immediateOnly) {
                if (ELHelper.isDeferredExpression(callerQuery)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"evaluateCallerQuery", (Object[])new Object[]{"Returning null since callerQuery is a deferred expression and this is called on initialization."});
                    }
                    return null;
                }
            }
            throw e;
        }
    }

    @FFDCIgnore(value={IllegalArgumentException.class})
    private String evaluateDataSourceLookup(boolean immediateOnly) {
        String dataSourceLookup = this.idStoreDefinition.dataSourceLookup();
        try {
            return this.elHelper.processString("dataSourceLookup", dataSourceLookup, immediateOnly);
        }
        catch (IllegalArgumentException e) {
            if (immediateOnly) {
                if (ELHelper.isDeferredExpression(dataSourceLookup)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"evaluateDataSourceLookup", (Object[])new Object[]{"Returning null since dataSourceLookup is a deferred expression and this is called on initialization."});
                    }
                    return null;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled()) {
                Tr.warning((TraceComponent)tc, (String)"JAVAEESEC_WARNING_IDSTORE_CONFIG", (Object[])new Object[]{"dataSourceLookup", "java:comp/DefaultDataSource"});
            }
            return "java:comp/DefaultDataSource";
        }
    }

    @FFDCIgnore(value={IllegalArgumentException.class})
    private String evaluateGroupsQuery(boolean immediateOnly) {
        String groupsQuery = this.idStoreDefinition.groupsQuery();
        try {
            return this.elHelper.processString("groupsQuery", groupsQuery, immediateOnly);
        }
        catch (IllegalArgumentException e) {
            if (immediateOnly) {
                if (ELHelper.isDeferredExpression(groupsQuery)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"evaluateGroupsQuery", (Object[])new Object[]{"Returning null since groupsQuery is a deferred expression and this is called on initialization."});
                    }
                    return null;
                }
            }
            throw e;
        }
    }

    private Class<? extends PasswordHash> evaluateHashAlgorithm() {
        return this.idStoreDefinition.hashAlgorithm();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @FFDCIgnore(value={IllegalArgumentException.class})
    private List<String> evaluateHashAlgorithmParameters() {
        ArrayList<String> parameters = new ArrayList<String>();
        String[] rawArray = this.idStoreDefinition.hashAlgorithmParameters();
        if (rawArray == null || rawArray.length == 0) {
            return parameters;
        }
        if (rawArray.length == 1) {
            try {
                String value = this.elHelper.processString("hashAlgorithmParameters[0]", rawArray[0], false);
                if (value == null || value.isEmpty()) return parameters;
                parameters.add(value);
                return parameters;
            }
            catch (IllegalArgumentException value) {
                try {
                    String[] array = this.elHelper.processStringArray("hashAlgorithmParameters[0]", rawArray[0], false, false);
                    if (array == null || array.length != 0) return parameters;
                    for (String value2 : array) {
                        if (value2 == null || value2.isEmpty()) continue;
                        parameters.add(value2);
                    }
                    return parameters;
                }
                catch (IllegalArgumentException array) {
                    try {
                        Stream<String> stream = this.elHelper.processStringStream("hashAlgorithmParameters[0]", rawArray[0], false, false);
                        Iterator iterator = stream.iterator();
                        while (iterator.hasNext()) {
                            String value3 = (String)iterator.next();
                            if (value3 == null || value3.isEmpty()) continue;
                            parameters.add(value3);
                        }
                        return parameters;
                    }
                    catch (IllegalArgumentException stream) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isWarningEnabled()) return parameters;
                        Tr.warning((TraceComponent)tc, (String)"JAVAEESEC_WARNING_IDSTORE_CONFIG", (Object[])new Object[]{"hashAlgorithmParameters[0]", Collections.emptyList()});
                        return parameters;
                    }
                }
            }
        } else {
            if (rawArray == null || rawArray.length <= 0) return parameters;
            for (int idx = 0; idx < rawArray.length; ++idx) {
                List<String> value = this.elHelper.processStringOrStringArray("hashAlgorithmParameters[" + idx + "]", rawArray[idx], false, false);
                if (value == null) continue;
                for (String innerValue : value) {
                    parameters.add(innerValue);
                }
            }
        }
        return parameters;
    }

    @FFDCIgnore(value={IllegalArgumentException.class})
    private Integer evaluatePriority(boolean immediateOnly) {
        String priorityExpression = this.idStoreDefinition.priorityExpression();
        int priority = this.idStoreDefinition.priority();
        try {
            return this.elHelper.processInt("priorityExpression", priorityExpression, priority, immediateOnly);
        }
        catch (IllegalArgumentException e) {
            if (immediateOnly) {
                if (ELHelper.isDeferredExpression(priorityExpression)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"evaluatePriority", (Object[])new Object[]{"Returning null since priorityExpression is a deferred expression and this is called on initialization."});
                    }
                    return null;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled()) {
                Tr.warning((TraceComponent)tc, (String)"JAVAEESEC_WARNING_IDSTORE_CONFIG", (Object[])new Object[]{"priority/priorityExpression", 70});
            }
            return 70;
        }
    }

    @FFDCIgnore(value={IllegalArgumentException.class})
    private Set<IdentityStore.ValidationType> evaluateUseFor(boolean immediateOnly) {
        String useForExpression = this.idStoreDefinition.useForExpression();
        IdentityStore.ValidationType[] useFor = this.idStoreDefinition.useFor();
        try {
            return this.elHelper.processUseFor(useForExpression, useFor, immediateOnly);
        }
        catch (IllegalArgumentException e) {
            if (immediateOnly) {
                if (ELHelper.isDeferredExpression(useForExpression)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"evaluateUseFor", (Object[])new Object[]{"Returning null since useForExpression is a deferred expression and this is called on initialization."});
                    }
                    return null;
                }
            }
            HashSet<IdentityStore.ValidationType> values = new HashSet<IdentityStore.ValidationType>();
            values.add(IdentityStore.ValidationType.PROVIDE_GROUPS);
            values.add(IdentityStore.ValidationType.VALIDATE);
            if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled()) {
                Tr.warning((TraceComponent)tc, (String)"JAVAEESEC_WARNING_IDSTORE_CONFIG", (Object[])new Object[]{"useFor/useForExpression", values});
            }
            return values;
        }
    }

    String getCallerQuery() {
        return this.callerQuery != null ? this.callerQuery : this.evaluateCallerQuery(false);
    }

    String getDataSourceLookup() {
        return this.dataSourceLookup != null ? this.dataSourceLookup : this.evaluateDataSourceLookup(false);
    }

    String getGroupsQuery() {
        return this.groupsQuery != null ? this.groupsQuery : this.evaluateGroupsQuery(false);
    }

    Class<? extends PasswordHash> getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    List<String> getHashAlgorithmParameters() {
        return this.hashAlgorithmParameters;
    }

    int getPriority() {
        return this.priority != null ? this.priority : this.evaluatePriority(false);
    }

    Set<IdentityStore.ValidationType> getUseFor() {
        return this.useFor != null ? this.useFor : this.evaluateUseFor(false);
    }

    boolean isDataSourceEvaluated() {
        return this.datasourceEvaluated;
    }
}

