/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.jwt.web;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.jwt.web.JwtEndpointServices;
import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class JwtEndpointServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static TraceComponent tc = Tr.register(JwtEndpointServlet.class, (String)"JWTBUILDER", (String)"com.ibm.ws.security.jwt.internal.resources.JWTMessages");
    private transient ServletContext servletContext = null;
    private transient BundleContext bundleContext = null;
    private transient JwtEndpointServices jwtEndpointServices = null;
    private transient ServiceReference<JwtEndpointServices> jwtEndpointServicesRef = null;

    public void init() {
        this.servletContext = this.getServletContext();
        this.bundleContext = (BundleContext)this.servletContext.getAttribute("osgi-bundlecontext");
        this.jwtEndpointServicesRef = this.bundleContext.getServiceReference(JwtEndpointServices.class);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doHead(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.getJwtEndpointServices();
        this.jwtEndpointServices.handleEndpointRequest(request, response, this.servletContext);
    }

    private synchronized JwtEndpointServices getJwtEndpointServices() throws ServletException {
        if (this.jwtEndpointServicesRef == null) {
            throw new ServletException(Tr.formatMessage((TraceComponent)tc, (String)"JWT_OSGI_ENDPOINT_SERVICE_ERROR", (Object[])new Object[0]));
        }
        this.jwtEndpointServices = (JwtEndpointServices)this.bundleContext.getService(this.jwtEndpointServicesRef);
        return this.jwtEndpointServices;
    }
}

