/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager.internal.lifecycle;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.application.lifecycle.ApplicationPrereq;
import com.ibm.wsspi.logging.Introspector;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(immediate=true, configurationPid={"com.ibm.ws.app.prereqs"}, configurationPolicy=ConfigurationPolicy.REQUIRE)
public class ApplicationPrereqMonitor
implements Introspector {
    public static final TraceComponent tc = Tr.register(ApplicationPrereqMonitor.class, (String[])new String[]{"applications", "app.manager"}, (String)"com.ibm.ws.app.manager.internal.resources.AppManagerMessages", (String)"com.ibm.ws.app.manager.internal.lifecycle.ApplicationPrereqMonitor");
    private static final AtomicInteger counter = new AtomicInteger(0);
    private final int version = counter.incrementAndGet();
    private final ConfigurationAdmin configurationAdmin;
    private Set<String> declaredPrereqs = new TreeSet<String>();
    private final Set<String> realizedPrereqs = new TreeSet<String>();
    private boolean configInconsistent = false;
    static final long serialVersionUID = 2523981553387789806L;

    @Activate
    public ApplicationPrereqMonitor(@Reference ConfigurationAdmin configurationAdmin, Map<String, Object> properties) {
        this.configurationAdmin = configurationAdmin;
        Object[] pids = (String[])properties.get("applicationPrereqDeclarations");
        Stream.of(pids).map(this::servicePidToConfigId).forEach(this.declaredPrereqs::add);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(this + "\nKnown configured application Prereq Pids:" + Arrays.toString(pids) + "\nids:" + this.declaredPrereqs), (Object[])new Object[0]);
        }
    }

    @ManualTrace
    @Modified
    synchronized void modified(Map<String, Object> properties) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"modified", (Object[])new Object[0]);
        }
        this.configInconsistent = false;
        String[] pids = (String[])properties.get("applicationPrereqDeclarations");
        Set<String> oldSet = this.declaredPrereqs;
        Set newSet = Stream.of(pids).map(this::servicePidToConfigId).collect(TreeSet::new, Set::add, Set::addAll);
        if (newSet.equals(oldSet)) {
            return;
        }
        this.declaredPrereqs = newSet;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            TreeSet<String> removed = new TreeSet<String>(oldSet);
            TreeSet added = new TreeSet(newSet);
            TreeSet<String> unmodified = new TreeSet<String>(oldSet);
            removed.removeAll(newSet);
            added.removeAll(oldSet);
            unmodified.removeAll(removed);
            if (unmodified.size() > 0) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Prereq declarations unmodified:", (Object[])new Object[]{unmodified});
            }
            if (removed.size() > 0) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Prereq declarations removed:", (Object[])new Object[]{removed});
            }
            if (added.size() > 0) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Prereq declarations added:", (Object[])new Object[]{added});
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"modified");
        }
    }

    @Deactivate
    void deactivate() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(this + " deactivate"), (Object[])new Object[0]);
        }
    }

    @Trivial
    @FFDCIgnore(value={IllegalStateException.class})
    private String servicePidToConfigId(String servicePid) {
        try {
            Object[] configs = this.configurationAdmin.listConfigurations("(service.pid=" + servicePid + ")");
            if (configs == null) {
                throw new IllegalStateException("No configs found matching servicePid=" + servicePid);
            }
            if (configs.length > 1) {
                throw new IllegalStateException("Non unique servicePid=" + servicePid + " matched configs=" + Arrays.toString(configs));
            }
            String id = (String)configs[0].getProperties().get("id");
            return id;
        }
        catch (IOException | IllegalStateException | InvalidSyntaxException e) {
            try {
                throw new ConfigurationOutOfDateException(e);
            }
            catch (ConfigurationOutOfDateException configurationOutOfDateException) {
                FFDCFilter.processException((Throwable)configurationOutOfDateException, (String)"com.ibm.ws.app.manager.internal.lifecycle.ApplicationPrereqMonitor", (String)"160", (Object)this, (Object[])new Object[]{servicePid});
                this.configInconsistent = true;
                return "Error converting servicePid: " + servicePid;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, name="candidateApplicationPrereq", unbind="unsetApplicationPrereq", policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    synchronized void setApplicationPrereq(ApplicationPrereq applicationPrereq) {
        this.realizedPrereqs.add(applicationPrereq.getApplicationPrereqID());
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(this + " Prereq added:" + applicationPrereq.getClass().getName() + "\nConfigured:" + this.declaredPrereqs + "\n  Realized:" + this.realizedPrereqs), (Object[])new Object[0]);
        }
        if (this.configInconsistent) {
            return;
        }
        if (this.declaredPrereqs.containsAll(this.realizedPrereqs)) {
            return;
        }
        TreeSet<String> surplusPrereqs = new TreeSet<String>(this.realizedPrereqs);
        surplusPrereqs.removeAll(this.declaredPrereqs);
        try {
            throw new IllegalStateException("Undeclared Prereqs:" + surplusPrereqs);
        }
        catch (IllegalStateException illegalStateException) {
            void illegalStateException2;
            FFDCFilter.processException((Throwable)illegalStateException, (String)"com.ibm.ws.app.manager.internal.lifecycle.ApplicationPrereqMonitor", (String)"201", (Object)this, (Object[])new Object[]{applicationPrereq});
            throw illegalStateException2;
        }
    }

    synchronized void unsetApplicationPrereq(ApplicationPrereq applicationPrereq) {
        this.realizedPrereqs.remove(applicationPrereq.getApplicationPrereqID());
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(this + " Prereq removed:" + applicationPrereq.getClass().getName() + "\nConfigured:" + this.declaredPrereqs + "\n  Realized:" + this.realizedPrereqs), (Object[])new Object[0]);
        }
    }

    public String toString() {
        return ApplicationPrereqMonitor.class.getName() + "#" + this.version;
    }

    public String getIntrospectorName() {
        return this.getClass().getSimpleName();
    }

    public String getIntrospectorDescription() {
        return String.format("List the declared (D) and the realized (R) application prereqs.%nApplication Handlers cannot start until all the declared prereqs become available (i.e. are realized).", new Object[0]);
    }

    public synchronized void introspect(PrintWriter out) throws Exception {
        ((Stream)Stream.concat(this.declaredPrereqs.stream(), this.realizedPrereqs.stream()).sorted().distinct().sequential()).peek(s -> out.print('[')).peek(s -> out.print(this.declaredPrereqs.contains(s) ? (char)'D' : (char)' ')).peek(s -> out.print(this.realizedPrereqs.contains(s) ? (char)'R' : (char)' ')).peek(s -> out.print("] ")).forEach(out::println);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class ConfigurationOutOfDateException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ConfigurationOutOfDateException(Throwable cause) {
            super(cause);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ConfigurationOutOfDateException.class, (String[])new String[]{"applications", "app.manager"}, (String)"com.ibm.ws.app.manager.internal.resources.AppManagerMessages", (String)"com.ibm.ws.app.manager.internal.lifecycle.ApplicationPrereqMonitor$ConfigurationOutOfDateException");
        }
    }
}

