/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cdi.transaction.liberty;

import com.ibm.tx.jta.impl.TransactionImpl;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.cdi.internal.interfaces.TransactionService;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="TC", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(property={"service.vendor=IBM"})
public class LibertyTransactionService
implements TransactionService {
    private static final TraceComponent TC = Tr.register(LibertyTransactionService.class, (String)"JCDI", null);
    private final AtomicServiceReference<UserTransaction> userTransaction = new AtomicServiceReference("userTransaction");
    private final AtomicServiceReference<TransactionManager> transactionManager = new AtomicServiceReference("transactionManager");
    static final long serialVersionUID = 4159344492016871734L;

    protected void activate(ComponentContext compcontext) {
        if (TC.isDebugEnabled()) {
            Tr.debug((TraceComponent)TC, (String)("Activating " + this.getClass().getName()), (Object[])new Object[0]);
        }
        this.userTransaction.activate(compcontext);
        this.transactionManager.activate(compcontext);
    }

    protected void deactivate(ComponentContext compcontext) {
        if (TC.isDebugEnabled()) {
            Tr.debug((TraceComponent)TC, (String)("Deactivating " + this.getClass().getName()), (Object[])new Object[0]);
        }
        this.userTransaction.deactivate(compcontext);
        this.transactionManager.deactivate(compcontext);
    }

    @Reference(name="userTransaction", service=UserTransaction.class, policy=ReferencePolicy.DYNAMIC)
    protected void setUserTransaction(ServiceReference<UserTransaction> ref) {
        this.userTransaction.setReference(ref);
    }

    protected void unsetUserTransaction(ServiceReference<UserTransaction> ref) {
        this.userTransaction.unsetReference(ref);
    }

    @Reference(name="transactionManager", service=TransactionManager.class, policy=ReferencePolicy.DYNAMIC)
    protected void setTransactionManager(ServiceReference<TransactionManager> ref) {
        this.transactionManager.setReference(ref);
    }

    protected void unsetTransactionManager(ServiceReference<TransactionManager> ref) {
        this.transactionManager.unsetReference(ref);
    }

    public TransactionManager getTransactionManager() {
        TransactionManager transactionManager = (TransactionManager)this.transactionManager.getService();
        if (transactionManager == null && TC.isDebugEnabled()) {
            Tr.debug((TraceComponent)TC, (String)"Returning a null TransactionManager because the TransactionManager service is not currently unavailable. Is the transaction feature enabled?", (Object[])new Object[0]);
        }
        return transactionManager;
    }

    /*
     * WARNING - void declaration
     */
    public Transaction getTransaction() {
        TransactionManager transactionManager = this.getTransactionManager();
        if (transactionManager == null) {
            if (TC.isDebugEnabled()) {
                Tr.debug((TraceComponent)TC, (String)"Returning a null Transaction because the TransactionManager service is not currently unavailable. Is the transaction feature enabled?", (Object[])new Object[0]);
            }
            return null;
        }
        try {
            return transactionManager.getTransaction();
        }
        catch (SystemException systemException) {
            FFDCFilter.processException((Throwable)systemException, (String)"com.ibm.ws.cdi.transaction.liberty.LibertyTransactionService", (String)"130", (Object)this, (Object[])new Object[0]);
            if (TC.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)TC, (String)("Returning a null Transaction: " + e.getMessage()), (Object[])new Object[0]);
            }
            return null;
        }
    }

    public UserTransaction getUserTransaction() {
        UserTransaction utx = (UserTransaction)this.userTransaction.getService();
        if (utx == null && TC.isDebugEnabled()) {
            Tr.debug((TraceComponent)TC, (String)"Returning a null UserTransaction because the UserTransaction service is not currently unavailable. Is the transaction feature enabled?", (Object[])new Object[0]);
        }
        return utx;
    }

    public void cleanup() {
        if (TC.isDebugEnabled()) {
            Tr.debug((TraceComponent)TC, (String)("cleaning up " + this.getClass().getName()), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean isTransactionActive() {
        if (this.getTransactionManager() != null) {
            try {
                if (this.getTransactionManager().getStatus() == 0) {
                    return true;
                }
            }
            catch (SystemException systemException) {
                FFDCFilter.processException((Throwable)systemException, (String)"com.ibm.ws.cdi.transaction.liberty.LibertyTransactionService", (String)"173", (Object)this, (Object[])new Object[0]);
                if (TC.isDebugEnabled()) {
                    void se;
                    Tr.debug((TraceComponent)TC, (String)("Returning isTransactionActive() false: " + se.getMessage()), (Object[])new Object[0]);
                }
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public void registerSynchronization(Synchronization sync) {
        TransactionManager transactionManager = this.getTransactionManager();
        try {
            Transaction tran = transactionManager.getTransaction();
            if (tran instanceof TransactionImpl) {
                ((TransactionImpl)tran).registerSynchronization(sync, 0);
            } else {
                tran.registerSynchronization(sync);
            }
        }
        catch (SystemException tran) {
            void se;
            FFDCFilter.processException((Throwable)tran, (String)"com.ibm.ws.cdi.transaction.liberty.LibertyTransactionService", (String)"198", (Object)this, (Object[])new Object[]{sync});
            FFDCFilter.processException((Throwable)se, (String)(this.getClass().getName() + ".registerSynchronization"), (String)"177", (Object)this);
        }
        catch (RollbackException se) {
            void re;
            FFDCFilter.processException((Throwable)se, (String)"com.ibm.ws.cdi.transaction.liberty.LibertyTransactionService", (String)"200", (Object)this, (Object[])new Object[]{sync});
            FFDCFilter.processException((Throwable)re, (String)(this.getClass().getName() + ".registerSynchronization"), (String)"180", (Object)this);
        }
        catch (IllegalStateException re) {
            void ie;
            FFDCFilter.processException((Throwable)re, (String)"com.ibm.ws.cdi.transaction.liberty.LibertyTransactionService", (String)"203", (Object)this, (Object[])new Object[]{sync});
            FFDCFilter.processException((Throwable)ie, (String)(this.getClass().getName() + ".registerSynchronization"), (String)"182", (Object)this);
        }
    }
}

