/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tx.jta.impl;

import com.ibm.tx.jta.impl.TxPrimaryKey;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.Transaction.JTA.Util;
import com.ibm.ws.Transaction.JTS.Configuration;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import javax.transaction.xa.Xid;

public class XidImpl
implements Xid,
Serializable {
    private static final TraceComponent tc = Tr.register(XidImpl.class, (String)"Transaction", (String)"com.ibm.ws.Transaction.resources.TransactionMsgs");
    private static final long serialVersionUID = -4291259441393350686L;
    private static final String nl = AccessController.doPrivileged(new PrivilegedAction<String>(){

        @Override
        public String run() {
            return System.getProperty("line.separator");
        }
    });
    protected final int _formatId;
    protected final byte[] _gtrid;
    protected final byte[] _bqual;
    private byte[] _otid;
    private TxPrimaryKey _primaryKey;
    public static final int ZOS_FID_CB390 = -1010695802;
    public static final int ZOS_FID_CBLT = -1010641949;
    private static final int ZOS_FID_WASZ = -423501079;
    public static final int WAS_FID_WASC = 1463898947;
    protected static final int WAS_FID_WASD = 1463898948;
    private static final int WAS_FID_WASZ = 1463898970;
    protected static final int WAS_FORMAT_ID = 1463898948;
    static final String digits = "0123456789ABCDEF";
    protected static final int BQUAL_PKEY_OFFSET = 0;
    protected static final int BQUAL_PKEY_LENGTH = 16;
    protected static final int BQUAL_UUID_OFFSET = 16;
    protected static final int BQUAL_UUID_LENGTH = 20;
    public static final int GTRID_JTA_GTRID_LENGTH = 36;
    protected static final int BQUAL_BRANCH_INDEX_OFFSET = 39;
    protected static final int BQUAL_JTA_GTRID_LENGTH = 40;
    private static final int BQUAL_STOKEN_OFFSET = 40;
    private static final int BQUAL_STOKEN_LENGTH = 8;
    private static final int BQUAL_RECOVERY_ID_OFFSET_UNUSED = 48;
    private static final int BQUAL_RECOVERY_ID_LENGTH_UNUSED = 4;
    private static final int BQUAL_RM_SEQ_OFFSET = 52;
    private static final int BQUAL_RM_SEQ_LENGTH = 2;
    public static final int BQUAL_JTA_BQUAL_LENGTH = 54;

    public XidImpl(byte[] gtrid, TxPrimaryKey pk, int index) {
        this(gtrid, pk, index, 1463898948);
    }

    public XidImpl(byte[] gtrid, TxPrimaryKey pk, int index, int formatID) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"XidImpl", (Object[])new Object[]{Util.toHexString(gtrid), pk, index});
        }
        this._formatId = formatID;
        this._bqual = new byte[40];
        byte[] theApplid = Configuration.getApplId();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Creating XID using applid " + Util.toHexString(theApplid)), (Object[])new Object[0]);
        }
        System.arraycopy(pk.toBytes(), 0, this._bqual, 0, 16);
        System.arraycopy(theApplid, 0, this._bqual, 16, 20);
        this._bqual[39] = (byte)index;
        this._gtrid = Util.duplicateByteArray(gtrid);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"XidImpl", (Object)this);
        }
    }

    public XidImpl(byte[] nativeXid, int offset) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"XidImpl", (Object[])new Object[]{Util.toHexString(nativeXid), offset});
        }
        this._formatId = Util.getIntFromBytes(nativeXid, offset, 4);
        int gtridLength = Util.getIntFromBytes(nativeXid, offset + 4, 4);
        this._gtrid = Util.duplicateByteArray(nativeXid, offset + 12, gtridLength);
        int bqualLength = Util.getIntFromBytes(nativeXid, offset + 8, 4);
        this._bqual = new byte[bqualLength];
        System.arraycopy(nativeXid, offset + 12 + gtridLength, this._bqual, 0, bqualLength);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"XidImpl", (Object)this);
        }
    }

    public XidImpl(Xid xid) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"XidImpl", (Object[])new Object[]{xid});
        }
        this._formatId = xid.getFormatId();
        this._gtrid = Util.duplicateByteArray(xid.getGlobalTransactionId());
        this._bqual = Util.duplicateByteArray(xid.getBranchQualifier());
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"XidImpl", (Object)this);
        }
    }

    public XidImpl(Xid oldXid, int sequenceNumber) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"XidImpl", (Object[])new Object[]{oldXid, sequenceNumber});
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Creating XID for a resource branch", (Object[])new Object[0]);
        }
        this._formatId = oldXid.getFormatId();
        this._gtrid = Util.duplicateByteArray(oldXid.getGlobalTransactionId());
        this._bqual = new byte[54];
        byte[] oldBqual = oldXid.getBranchQualifier();
        System.arraycopy(oldBqual, 0, this._bqual, 0, oldBqual.length);
        this.setSequenceNumber(sequenceNumber);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"XidImpl", (Object)this);
        }
    }

    public XidImpl(byte[] nativeXid, int sequence, byte[] stoken) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"XidImpl", (Object[])new Object[]{Util.toHexString(nativeXid), sequence, Util.toHexString(stoken)});
        }
        this._formatId = Util.getIntFromBytes(nativeXid, 0, 4);
        int gtridLength = Util.getIntFromBytes(nativeXid, 4, 4);
        this._gtrid = Util.duplicateByteArray(nativeXid, 12, gtridLength);
        int bqualLength = Util.getIntFromBytes(nativeXid, 8, 4);
        this._bqual = new byte[54];
        System.arraycopy(nativeXid, 12 + gtridLength, this._bqual, 0, bqualLength);
        this.setSequenceNumber(sequence);
        this.setStoken(stoken);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"XidImpl", (Object)this);
        }
    }

    public XidImpl(TxPrimaryKey pk) {
        this(1463898948, pk);
    }

    public XidImpl(Xid oldXid, TxPrimaryKey pk) {
        this(oldXid.getGlobalTransactionId(), pk, 1);
    }

    protected XidImpl(int formatId, TxPrimaryKey pk) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"XidImpl", (Object[])new Object[]{Integer.toHexString(formatId), pk});
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Creating XID for a global transaction", (Object[])new Object[0]);
        }
        this._formatId = formatId;
        this._bqual = new byte[40];
        byte[] theApplid = Configuration.getApplId();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Creating XID using applid " + Util.toHexString(theApplid)), (Object[])new Object[0]);
        }
        System.arraycopy(pk.toBytes(), 0, this._bqual, 0, 16);
        System.arraycopy(theApplid, 0, this._bqual, 16, 20);
        this._bqual[39] = 1;
        this._gtrid = new byte[36];
        System.arraycopy(this._bqual, 0, this._gtrid, 0, 36);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"XidImpl", (Object)this);
        }
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XidImpl)) {
            return false;
        }
        XidImpl other = (XidImpl)o;
        if (this._formatId != other._formatId) {
            return false;
        }
        return Arrays.equals(this._bqual, other._bqual) && Arrays.equals(this._gtrid, other._gtrid);
    }

    public String toString() {
        return new String("{XidImpl: formatId(" + Integer.toHexString(this._formatId) + "), gtrid_length(" + (this._gtrid == null ? 0 : this._gtrid.length) + "), bqual_length(" + (this._bqual == null ? 0 : this._bqual.length) + ")," + nl + "data(" + (this._gtrid == null ? "" : Util.toHexString(this._gtrid)) + (this._bqual == null ? "" : Util.toHexString(this._bqual)) + ")}");
    }

    @Override
    public final int getFormatId() {
        return this._formatId;
    }

    @Override
    public final byte[] getGlobalTransactionId() {
        return this._gtrid;
    }

    @Override
    public final byte[] getBranchQualifier() {
        return this._bqual;
    }

    public byte[] toBytes() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"toBytes", (Object[])new Object[0]);
        }
        int gtridLength = this._gtrid == null ? 0 : this._gtrid.length;
        int bqualLength = this._bqual == null ? 0 : this._bqual.length;
        int nbytes = 12 + gtridLength + bqualLength;
        byte[] result = new byte[nbytes];
        Util.setBytesFromInt(result, 0, 4, this._formatId);
        Util.setBytesFromInt(result, 4, 4, gtridLength);
        Util.setBytesFromInt(result, 8, 4, bqualLength);
        if (gtridLength > 0) {
            System.arraycopy(this._gtrid, 0, result, 12, gtridLength);
        }
        if (bqualLength > 0) {
            System.arraycopy(this._bqual, 0, result, 12 + gtridLength, bqualLength);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"toBytes", (Object)Util.toHexString(result));
        }
        return result;
    }

    public byte[] getOtidBytes() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getOtidBytes", (Object[])new Object[0]);
        }
        if (this._otid == null) {
            int total_length = this._gtrid.length + this._bqual.length;
            this._otid = new byte[total_length];
            System.arraycopy(this._gtrid, 0, this._otid, 0, this._gtrid.length);
            System.arraycopy(this._bqual, 0, this._otid, this._gtrid.length, this._bqual.length);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getOtidBytes", (Object)this._otid);
        }
        return Util.duplicateByteArray(this._otid);
    }

    public String printOtid() {
        int i;
        int total_length = this._gtrid.length * 2 + this._bqual.length * 2 + 1;
        StringBuilder result = new StringBuilder(total_length);
        for (i = 0; i < this._gtrid.length; ++i) {
            result.append(digits.charAt(this._gtrid[i] >> 4 & 0xF));
            result.append(digits.charAt(this._gtrid[i] & 0xF));
        }
        result.append(':');
        for (i = 0; i < this._bqual.length; ++i) {
            result.append(digits.charAt(this._bqual[i] >> 4 & 0xF));
            result.append(digits.charAt(this._bqual[i] & 0xF));
        }
        return result.toString();
    }

    public byte[] getCruuid() {
        byte[] theCruuid = Util.duplicateByteArray(this._bqual, 16, 20);
        return theCruuid;
    }

    public byte[] getStoken() {
        return Util.duplicateByteArray(this._bqual, 40, 8);
    }

    protected void setStoken(byte[] stoken) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setStoken", (Object[])new Object[]{stoken});
        }
        if (stoken != null) {
            System.arraycopy(stoken, 0, this._bqual, 40, 8);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setStoken");
        }
    }

    public int getSequenceNumber() {
        return Util.getIntFromBytes(this._bqual, 52, 2);
    }

    protected void setSequenceNumber(int sequenceNumber) {
        Util.setBytesFromInt(this._bqual, 52, 2, sequenceNumber);
    }

    public TxPrimaryKey getPrimaryKey() {
        if (this._primaryKey == null) {
            this._primaryKey = new TxPrimaryKey(this._bqual, 0);
        }
        return this._primaryKey;
    }

    public int getEpoch() {
        return this.getPrimaryKey().getEpochNumber();
    }

    public int getPrimaryKeySequenceNumber() {
        return this.getPrimaryKey().getSequenceNumber();
    }

    public final int hashCode() {
        if (this._bqual != null) {
            return this.getPrimaryKeySequenceNumber();
        }
        return 0;
    }

    public static boolean isOurFormatId(int formatIdentifier) {
        boolean result;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isOurFormatId", (Object[])new Object[]{formatIdentifier});
        }
        switch (formatIdentifier) {
            case -1010695802: 
            case -1010641949: 
            case 1463898948: {
                result = true;
                break;
            }
            default: {
                result = false;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isOurFormatId", (Object)result);
        }
        return result;
    }

    public final int getBqualBranchIndex() {
        return 0xFF & this._bqual[39];
    }
}

