/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.interceptor;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
class CachedTime {
    private static final DateTimeFormatter dateFormatter;
    private long lastTimeCheck = 0L;
    private String sTime = null;
    private static CachedTime instance;
    protected static final long DEFAULT_TOLERANCE = 1000L;
    static final long serialVersionUID = 8968713044379515854L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    protected CachedTime() {
    }

    public static CachedTime getCachedTime() {
        return instance;
    }

    private void updateTime(long tolerance) {
        long now = System.currentTimeMillis();
        if (now == this.lastTimeCheck) {
            return;
        }
        if (0L != tolerance) {
            long range;
            long l = range = -1L == tolerance ? 1000L : tolerance;
            if (now - this.lastTimeCheck <= range) {
                return;
            }
        }
        this.sTime = dateFormatter.format(Instant.ofEpochMilli(now));
        this.lastTimeCheck = now;
    }

    protected synchronized String getTimeAsString(long tolerance) {
        this.updateTime(tolerance);
        return this.sTime;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxrs.interceptor.CachedTime", CachedTime.class, null, null);
        dateFormatter = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US).withZone(ZoneId.of("GMT"));
        instance = new CachedTime();
    }
}

