/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.container.service.annocache.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.container.service.annocache.Annotations;
import com.ibm.ws.container.service.annocache.SpecificAnnotations;
import com.ibm.ws.container.service.annocache.internal.AnnotationsAdapterImpl;
import com.ibm.ws.container.service.annocache.internal.SpecificAnnotationsImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.Entry;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.annocache.classsource.ClassSource;
import com.ibm.wsspi.annocache.classsource.ClassSource_Aggregate;
import com.ibm.wsspi.annocache.classsource.ClassSource_ClassLoader;
import com.ibm.wsspi.annocache.classsource.ClassSource_Exception;
import com.ibm.wsspi.annocache.classsource.ClassSource_Factory;
import com.ibm.wsspi.annocache.classsource.ClassSource_MappedContainer;
import com.ibm.wsspi.annocache.classsource.ClassSource_Options;
import com.ibm.wsspi.annocache.info.ClassInfo;
import com.ibm.wsspi.annocache.info.InfoStore;
import com.ibm.wsspi.annocache.info.InfoStoreException;
import com.ibm.wsspi.annocache.info.InfoStoreFactory;
import com.ibm.wsspi.annocache.service.AnnotationCacheService_Service;
import com.ibm.wsspi.annocache.targets.AnnotationTargets_Exception;
import com.ibm.wsspi.annocache.targets.AnnotationTargets_Factory;
import com.ibm.wsspi.annocache.targets.AnnotationTargets_Targets;
import com.ibm.wsspi.artifact.ArtifactContainer;
import com.ibm.wsspi.artifact.ArtifactEntry;
import com.ibm.wsspi.artifact.overlay.OverlayContainer;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public abstract class AnnotationsImpl
implements Annotations {
    public static final TraceComponent tc = Tr.register(AnnotationsImpl.class, (String)"container.service", (String)"com.ibm.ws.container.service.resources.Messages");
    private static final String JAVAX_RESOURCE = "javax.annotation.Resource";
    private static final String JAVAX_RESOURCES = "javax.annotation.Resources";
    private static final String JAVAX_POST_CONSTRUCT = "javax.annotation.PostConstruct";
    private static final String JAVAX_PRE_DESTROY = "javax.annotation.PreDestroy";
    private static final String JAKARTA_RESOURCE = "jakarta.annotation.Resource";
    private static final String JAKARTA_POST_CONSTRUCT = "jakarta.annotation.PostConstruct";
    private static final String JAKARTA_PRE_DESTROY = "jakarta.annotation.PreDestroy";
    private final AnnotationsAdapterImpl annotationsAdapter;
    private final Container rootContainer;
    private final ArtifactContainer rootDelegateContainer;
    private final OverlayContainer rootOverlayContainer;
    private final Container rootAdaptableContainer;
    private boolean useJandex;
    private String appName;
    private String modName;
    private boolean isUnnamedMod;
    private final String modCatName;
    private boolean isLightweight;
    private final ClassSourceLock classSourceLock = new ClassSourceLock();
    protected ClassLoader classLoader;
    protected ClassSource_Aggregate rootClassSource;
    private final TargetsLock targetsLock = new TargetsLock();
    private boolean isSetTargets;
    private AnnotationTargets_Targets annotationTargets;
    private final InfoStoreLock infoStoreLock = new InfoStoreLock();
    private boolean isSetInfoStore;
    private InfoStore infoStore;
    static final long serialVersionUID = -8142719560366690667L;

    public static ArtifactContainer getRootOfRoots(ArtifactContainer container) {
        ArtifactEntry entry;
        while ((entry = container.getRoot().getEntryInEnclosingContainer()) != null) {
            container = entry.getEnclosingContainer();
        }
        return container;
    }

    public static PathData getPathData(Container parentContainer, Container container) throws UnableToAdaptException {
        Entry entry;
        StringBuilder pathBuilder = new StringBuilder();
        int spans = 0;
        boolean foundParent = container == parentContainer;
        int spansBelow = 0;
        int spansAbove = 0;
        while ((entry = (Entry)container.adapt(Entry.class)) != null) {
            ++spans;
            pathBuilder.insert(0, entry.getPath());
            container = entry.getRoot();
            if (!foundParent) {
                ++spansBelow;
            } else {
                ++spansAbove;
            }
            if (foundParent) continue;
            foundParent = container == parentContainer;
        }
        String path = pathBuilder.toString();
        if (foundParent) {
            return new PathData(path, spans, spansBelow, spansAbove);
        }
        return new PathData(path, spans);
    }

    public static String getPath(Container container) throws UnableToAdaptException {
        Entry entry;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getPath Initial [ " + container + " ]"), (Object[])new Object[0]);
        }
        StringBuilder pathBuilder = new StringBuilder();
        while ((entry = (Entry)container.adapt(Entry.class)) != null) {
            pathBuilder.insert(0, entry.getPath());
            container = entry.getRoot();
            if (!tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)("getPath Next [ " + container + " ]"), (Object[])new Object[0]);
        }
        return pathBuilder.toString();
    }

    protected String getContainerPath(Container targetContainer) {
        String targetPathCase;
        ArtifactContainer targetDelegate;
        ArtifactContainer modDelegate;
        String targetPath;
        String useAppName = this.getAppName();
        String useModName = this.getModName();
        Container modContainer = this.rootAdaptableContainer;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("AppName [ " + useAppName + " ]"), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("Mod Name [ " + useModName + " ]"), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("Module Container [ " + modContainer + " ]"), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("Target Container [ " + targetContainer + " ]"), (Object[])new Object[0]);
        }
        try {
            targetPath = AnnotationsImpl.getPath(targetContainer);
        }
        catch (UnableToAdaptException unableToAdaptException) {
            FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.container.service.annocache.internal.AnnotationsImpl", (String)"208", (Object)this, (Object[])new Object[]{targetContainer});
            return null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Target Path [ " + targetPath + " ]"), (Object[])new Object[0]);
        }
        try {
            modDelegate = (ArtifactContainer)modContainer.adapt(ArtifactContainer.class);
        }
        catch (UnableToAdaptException unableToAdaptException) {
            FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.container.service.annocache.internal.AnnotationsImpl", (String)"218", (Object)this, (Object[])new Object[]{targetContainer});
            return null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Module Delegate [ " + modDelegate + " ]"), (Object[])new Object[0]);
        }
        try {
            targetDelegate = (ArtifactContainer)targetContainer.adapt(ArtifactContainer.class);
        }
        catch (UnableToAdaptException unableToAdaptException) {
            FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.container.service.annocache.internal.AnnotationsImpl", (String)"228", (Object)this, (Object[])new Object[]{targetContainer});
            return null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Target Delegate [ " + targetDelegate + " ]"), (Object[])new Object[0]);
        }
        ArtifactContainer rootOfRootsModDelegate = AnnotationsImpl.getRootOfRoots(modDelegate);
        ArtifactContainer rootOfRootsTargetDelegate = AnnotationsImpl.getRootOfRoots(targetDelegate);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Module Delegate Root-of-roots [ " + rootOfRootsModDelegate + " ]"), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("Target Delegate Root-of-roots[ " + rootOfRootsTargetDelegate + " ]"), (Object[])new Object[0]);
        }
        if (targetPath.isEmpty() || modDelegate == rootOfRootsModDelegate || rootOfRootsModDelegate == null || rootOfRootsTargetDelegate == null || rootOfRootsModDelegate != rootOfRootsTargetDelegate) {
            if (useModName == null || useModName.isEmpty()) {
                if (useAppName == null || useAppName.isEmpty()) {
                    Tr.warning((TraceComponent)tc, (String)("Unable to obtain path for container [ " + targetContainer + " ] relative to [ " + modContainer + " ]"), (Object[])new Object[0]);
                    return null;
                }
                if (targetPath.isEmpty()) {
                    targetPath = useAppName;
                    targetPathCase = "App name replaces empty target path";
                } else {
                    targetPath = useAppName + "_" + targetPath;
                    targetPathCase = "App name prefix to non-local target path";
                }
            } else if (targetPath.isEmpty()) {
                targetPath = useModName;
                targetPathCase = "Mod name replaces empty target path";
            } else {
                targetPath = useModName + "_" + targetPath;
                targetPathCase = "Mod name prefix to non-local target path";
            }
        } else {
            targetPathCase = "Full local path";
        }
        String message = this.getClass().getSimpleName() + ".getContainerPath: Container [ " + targetContainer + " ] Path [ " + targetPath + " ]: " + targetPathCase;
        Tr.debug((TraceComponent)tc, (String)message, (Object[])new Object[0]);
        return targetPath;
    }

    protected static <T> T cacheGet(OverlayContainer container, String targetPath, Class<T> targetClass) {
        Object retrievedInfo = container.getFromNonPersistentCache(targetPath, targetClass);
        return (T)retrievedInfo;
    }

    protected static <T> void cachePut(OverlayContainer container, String targetPath, Class<T> targetClass, T targetObject) {
        container.addToNonPersistentCache(targetPath, targetClass, targetObject);
    }

    protected static <T> void cacheRemove(OverlayContainer container, String targetPath, Class<T> targetClass) {
        container.removeFromNonPersistentCache(targetPath, targetClass);
    }

    public AnnotationsImpl(AnnotationsAdapterImpl annotationsAdapter, Container rootContainer, OverlayContainer rootOverlayContainer, ArtifactContainer rootDelegateContainer, Container rootAdaptableContainer, String appName, boolean isUnnamedMod, String modName, String modCatName) {
        this.annotationsAdapter = annotationsAdapter;
        this.rootContainer = rootContainer;
        this.rootDelegateContainer = rootDelegateContainer;
        this.rootOverlayContainer = rootOverlayContainer;
        this.rootAdaptableContainer = rootAdaptableContainer;
        this.appName = appName;
        this.modName = modName;
        this.modCatName = modCatName;
        this.isLightweight = false;
        this.rootClassSource = null;
        this.isSetTargets = false;
        this.annotationTargets = null;
        this.isSetInfoStore = false;
        this.infoStore = null;
        if (tc.isDebugEnabled()) {
            String prefix = this.getClass().getSimpleName() + ".<init>: ";
            Tr.debug((TraceComponent)tc, (String)(prefix + "Root container [ " + rootContainer + " ]"), (Object[])new Object[0]);
            for (URL url : rootContainer.getURLs()) {
                Tr.debug((TraceComponent)tc, (String)(prefix + "  URL [ " + url + " ]"), (Object[])new Object[0]);
            }
            Tr.debug((TraceComponent)tc, (String)(prefix + "Application [ " + appName + " ]"), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)(prefix + "Module [ " + modName + " ]"), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)(prefix + "Module Category [ " + modCatName + " ]"), (Object[])new Object[0]);
        }
    }

    public AnnotationCacheService_Service getAnnoCacheService() {
        try {
            return this.annotationsAdapter.getAnnoCacheService();
        }
        catch (UnableToAdaptException unableToAdaptException) {
            FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.container.service.annocache.internal.AnnotationsImpl", (String)"387", (Object)this, (Object[])new Object[0]);
            return null;
        }
    }

    public ClassSource_Factory getClassSourceFactory() {
        AnnotationCacheService_Service useService = this.getAnnoCacheService();
        return useService == null ? null : useService.getClassSourceFactory();
    }

    public AnnotationTargets_Factory getTargetsFactory() {
        AnnotationCacheService_Service useService = this.getAnnoCacheService();
        return useService == null ? null : useService.getAnnotationTargetsFactory();
    }

    public InfoStoreFactory getInfoStoreFactory() {
        AnnotationCacheService_Service useService = this.getAnnoCacheService();
        return useService == null ? null : useService.getInfoStoreFactory();
    }

    public ArtifactContainer getRootDelegateContainer() {
        return this.rootDelegateContainer;
    }

    public OverlayContainer getRootOverlayContainer() {
        return this.rootOverlayContainer;
    }

    protected <T> T cacheGet(Class<T> targetClass) {
        return AnnotationsImpl.cacheGet(this.getRootOverlayContainer(), this.getContainerPath(), targetClass);
    }

    protected <T> void cachePut(Class<T> targetClass, T targetObject) {
        AnnotationsImpl.cachePut(this.getRootOverlayContainer(), this.getContainerPath(), targetClass, targetObject);
    }

    protected <T> void cacheRemove(Class<T> targetClass) {
        AnnotationsImpl.cacheRemove(this.getRootOverlayContainer(), this.getContainerPath(), targetClass);
    }

    @Override
    public Container getContainer() {
        return this.rootAdaptableContainer;
    }

    @Override
    public String getContainerName() {
        return this.getContainer().getName();
    }

    @Override
    public String getContainerPath() {
        return this.getContainer().getPath();
    }

    @Override
    public boolean getUseJandex() {
        return this.useJandex;
    }

    @Override
    public void setUseJandex(boolean useJandex) {
        this.useJandex = useJandex;
    }

    protected ClassSource_Options createOptions() {
        ClassSource_Factory classSourceFactory = this.getClassSourceFactory();
        if (classSourceFactory == null) {
            return null;
        }
        ClassSource_Options options = classSourceFactory.createOptions();
        if (!options.getIsSetUseJandex()) {
            options.setUseJandex(this.getUseJandex());
        } else {
            Tr.info((TraceComponent)tc, (String)("Application jandex setting [ " + this.getUseJandex() + " ] overridden by property setting [ " + options.getUseJandex() + " ]"), (Object[])new Object[0]);
        }
        return options;
    }

    @Override
    public String getAppName() {
        return this.appName;
    }

    @Override
    public void setAppName(String appName) {
        this.appName = appName;
    }

    @Override
    public String getModName() {
        return this.modName;
    }

    @Override
    public void setIsUnnamedMod(boolean isUnnamedMod) {
        this.isUnnamedMod = isUnnamedMod;
    }

    @Override
    public boolean getIsUnnamedMod() {
        return this.isUnnamedMod;
    }

    protected void forceModName() throws UnableToAdaptException {
        if (this.getIsUnnamedMod()) {
            return;
        }
        if (this.modName == null || this.modName.isEmpty()) {
            String modNameCase;
            String useModName = AnnotationsImpl.getPath(this.getContainer());
            if (useModName == null || useModName.isEmpty()) {
                useModName = this.getAppName();
                if (useModName == null || useModName.isEmpty()) {
                    useModName = null;
                    String modNameCase2 = "unavailable";
                    return;
                }
                modNameCase = "assigned from application";
            } else {
                modNameCase = "assigned from module container";
            }
            this.modName = useModName;
            if (tc.isDebugEnabled()) {
                String message = this.getClass().getSimpleName() + ".forceModName: App [ " + this.getAppName() + " ] Container [ " + this.getContainer() + " ] Mod [ " + this.modName + " ] (" + modNameCase + ")";
                Tr.debug((TraceComponent)tc, (String)message, (Object[])new Object[0]);
            }
        }
    }

    @Override
    public void setModName(String modName) {
        this.modName = modName;
    }

    @Override
    public String getModCategoryName() {
        return this.modCatName;
    }

    @Override
    public boolean getIsLightweight() {
        return this.isLightweight;
    }

    @Override
    public void setIsLightweight(boolean isLightweight) {
        this.isLightweight = isLightweight;
    }

    protected boolean addContainerClassSource(String path, Container container) {
        return this.addContainerClassSource(path, container, ClassSource_Factory.UNUSED_ENTRY_PREFIX);
    }

    protected boolean addContainerClassSource(String path, Container container, String entryPrefix) {
        ClassSource_MappedContainer containerClassSource;
        try {
            containerClassSource = this.getClassSourceFactory().createContainerClassSource(this.rootClassSource, path, container, entryPrefix);
        }
        catch (ClassSource_Exception classSource_Exception) {
            FFDCFilter.processException((Throwable)classSource_Exception, (String)"com.ibm.ws.container.service.annocache.internal.AnnotationsImpl", (String)"599", (Object)this, (Object[])new Object[]{path, container, entryPrefix});
            return false;
        }
        this.rootClassSource.addClassSource((ClassSource)containerClassSource);
        return true;
    }

    protected boolean addContainerClassSource(String path, Container container, ClassSource_Aggregate.ScanPolicy scanPolicy) {
        return this.addContainerClassSource(path, container, ClassSource_Factory.UNUSED_ENTRY_PREFIX, scanPolicy);
    }

    protected boolean addContainerClassSource(String path, Container container, String entryPrefix, ClassSource_Aggregate.ScanPolicy scanPolicy) {
        ClassSource_MappedContainer containerClassSource;
        try {
            containerClassSource = this.getClassSourceFactory().createContainerClassSource(this.rootClassSource, path, container, entryPrefix);
        }
        catch (ClassSource_Exception classSource_Exception) {
            FFDCFilter.processException((Throwable)classSource_Exception, (String)"com.ibm.ws.container.service.annocache.internal.AnnotationsImpl", (String)"615", (Object)this, (Object[])new Object[]{path, container, entryPrefix, scanPolicy});
            return false;
        }
        this.rootClassSource.addClassSource((ClassSource)containerClassSource, scanPolicy);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClassLoader getClassLoader() {
        ClassSourceLock classSourceLock = this.classSourceLock;
        synchronized (classSourceLock) {
            return this.classLoader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClassLoader(ClassLoader classLoader) {
        ClassSourceLock classSourceLock = this.classSourceLock;
        synchronized (classSourceLock) {
            if (this.classLoader != null) {
                if (this.classLoader != classLoader) {
                    throw new IllegalArgumentException("Duplicate class loader [ " + classLoader + " ]; previous [ " + this.classLoader + " ]");
                }
                return;
            }
            this.classLoader = classLoader;
            this.addExternalToClassSource();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClassSource_Aggregate releaseClassSource() {
        ClassSourceLock classSourceLock = this.classSourceLock;
        synchronized (classSourceLock) {
            if (this.rootClassSource == null) {
                return null;
            }
            ClassSource_Aggregate oldClassSource = this.rootClassSource;
            this.rootClassSource = null;
            return oldClassSource;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClassSource_Aggregate getClassSource() {
        ClassSourceLock classSourceLock = this.classSourceLock;
        synchronized (classSourceLock) {
            if (this.rootClassSource == null) {
                this.rootClassSource = this.createRootClassSource();
                if (this.rootClassSource == null) {
                    String message = "Null class source created for  app [ " + this.appName + " ] module [ " + this.modName + " ] module category [ " + this.modCatName + " ]";
                    Tr.warning((TraceComponent)tc, (String)(this.getClass().getName() + ": " + message), (Object[])new Object[0]);
                }
                this.addInternalToClassSource();
                this.addExternalToClassSource();
            }
            return this.rootClassSource;
        }
    }

    protected ClassSource_Aggregate createRootClassSource() {
        ClassSource_Factory classSourceFactory = this.getClassSourceFactory();
        if (classSourceFactory == null) {
            return null;
        }
        try {
            this.forceModName();
        }
        catch (UnableToAdaptException unableToAdaptException) {
            FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.container.service.annocache.internal.AnnotationsImpl", (String)"689", (Object)this, (Object[])new Object[0]);
            return null;
        }
        String useAppName = this.getAppName();
        String useModName = this.getModName();
        String useModCatName = this.getModCategoryName();
        ClassSource_Options options = this.createOptions();
        if (tc.isDebugEnabled()) {
            String prefix = this.getClass().getSimpleName() + ".createRootClassSource:";
            String message1 = prefix + " Class source  app [ " + useAppName + " ] module [ " + useModName + " ] module category [ " + useModCatName + " ]";
            String message2 = prefix + " Scan threads [ " + options.getScanThreads() + " ]";
            Tr.debug((TraceComponent)tc, (String)message1, (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)message2, (Object[])new Object[0]);
        }
        try {
            return classSourceFactory.createAggregateClassSource(useAppName, useModName, useModCatName, options);
        }
        catch (ClassSource_Exception prefix) {
            FFDCFilter.processException((Throwable)prefix, (String)"com.ibm.ws.container.service.annocache.internal.AnnotationsImpl", (String)"717", (Object)this, (Object[])new Object[0]);
            return null;
        }
    }

    protected abstract void addInternalToClassSource();

    protected void addExternalToClassSource() {
        ClassSource_ClassLoader classLoaderClassSource;
        if (this.rootClassSource == null) {
            return;
        }
        if (this.classLoader == null) {
            return;
        }
        ClassSource_Factory classSourceFactory = this.getClassSourceFactory();
        if (classSourceFactory == null) {
            return;
        }
        try {
            classLoaderClassSource = classSourceFactory.createClassLoaderClassSource(this.rootClassSource, "classloader", this.classLoader);
        }
        catch (ClassSource_Exception classSource_Exception) {
            FFDCFilter.processException((Throwable)classSource_Exception, (String)"com.ibm.ws.container.service.annocache.internal.AnnotationsImpl", (String)"740", (Object)this, (Object[])new Object[0]);
            return;
        }
        this.rootClassSource.addClassLoaderClassSource(classLoaderClassSource);
    }

    @Trivial
    @FFDCIgnore(value={ClassNotFoundException.class})
    private boolean jakartaCommonAnnotationAPIs() {
        if (this.classLoader == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Jakarta Common Annotations not present - ClassLoader not set", (Object[])new Object[0]);
            }
            return false;
        }
        try {
            this.classLoader.loadClass(JAKARTA_RESOURCE);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Jakarta Common Annotations present", (Object[])new Object[0]);
            }
            return true;
        }
        catch (ClassNotFoundException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Jakarta Common Annotations not present", (Object[])new Object[0]);
            }
            return false;
        }
    }

    private void checkForWrongPackageCommonAnnotations(AnnotationTargets_Targets targets, int scanPolicies) {
        if (this.modName == null || !this.jakartaCommonAnnotationAPIs()) {
            return;
        }
        TreeSet foundClasses = new TreeSet();
        foundClasses.addAll(targets.getAnnotatedClasses(JAVAX_RESOURCE, scanPolicies));
        foundClasses.addAll(targets.getAnnotatedClasses(JAVAX_RESOURCES, scanPolicies));
        foundClasses.addAll(targets.getClassesWithFieldAnnotation(JAVAX_RESOURCE, scanPolicies));
        foundClasses.addAll(targets.getClassesWithMethodAnnotation(JAVAX_RESOURCE, scanPolicies));
        if (!foundClasses.isEmpty()) {
            Tr.audit((TraceComponent)tc, (String)"wrong.annotation.package.CWWKM0483I", (Object[])new Object[]{JAVAX_RESOURCE, this.modName, this.appName, JAKARTA_RESOURCE, String.join((CharSequence)", ", foundClasses)});
            foundClasses.clear();
        }
        foundClasses.addAll(targets.getClassesWithMethodAnnotation(JAVAX_POST_CONSTRUCT, scanPolicies));
        if (!foundClasses.isEmpty()) {
            Tr.audit((TraceComponent)tc, (String)"wrong.annotation.package.CWWKM0483I", (Object[])new Object[]{JAVAX_POST_CONSTRUCT, this.modName, this.appName, JAKARTA_POST_CONSTRUCT, String.join((CharSequence)", ", foundClasses)});
            foundClasses.clear();
        }
        foundClasses.addAll(targets.getClassesWithMethodAnnotation(JAVAX_PRE_DESTROY, scanPolicies));
        if (!foundClasses.isEmpty()) {
            Tr.audit((TraceComponent)tc, (String)"wrong.annotation.package.CWWKM0483I", (Object[])new Object[]{JAVAX_PRE_DESTROY, this.modName, this.appName, JAKARTA_PRE_DESTROY, String.join((CharSequence)", ", foundClasses)});
            foundClasses.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AnnotationTargets_Targets getTargets() {
        boolean checkWrongPackage = false;
        TargetsLock targetsLock = this.targetsLock;
        synchronized (targetsLock) {
            if (!this.isSetTargets) {
                this.isSetTargets = true;
                checkWrongPackage = true;
                this.annotationTargets = this.createTargets();
            }
        }
        if (checkWrongPackage) {
            this.checkForWrongPackageCommonAnnotations(this.annotationTargets, AnnotationTargets_Targets.POLICY_SEED);
        }
        return this.annotationTargets;
    }

    @Override
    public AnnotationTargets_Targets getAnnotationTargets() {
        return this.getTargets();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AnnotationTargets_Targets releaseTargets() {
        TargetsLock targetsLock = this.targetsLock;
        synchronized (targetsLock) {
            if (!this.isSetTargets) {
                return null;
            }
            this.isSetTargets = false;
            AnnotationTargets_Targets oldTargets = this.annotationTargets;
            this.annotationTargets = null;
            this.cacheRemove(AnnotationTargets_Targets.class);
            return oldTargets;
        }
    }

    protected AnnotationTargets_Targets createTargets() {
        AnnotationTargets_Targets useTargets;
        ClassSource_Aggregate useClassSource = this.getClassSource();
        if (useClassSource == null) {
            String message = "Null class source creating targets for  app [ " + this.appName + " ] module [ " + this.modName + " ] module category [ " + this.modCatName + " ]";
            Tr.warning((TraceComponent)tc, (String)(this.getClass().getName() + ": " + message), (Object[])new Object[0]);
            return null;
        }
        AnnotationTargets_Factory targetsFactory = this.getTargetsFactory();
        if (targetsFactory == null) {
            String message = "Null factory creating targets for  app [ " + this.appName + " ] module [ " + this.modName + " ] module category [ " + this.modCatName + " ]";
            Tr.warning((TraceComponent)tc, (String)(this.getClass().getName() + ": " + message), (Object[])new Object[0]);
            return null;
        }
        if (this.classLoader == null) {
            String message = "Null class loader creating targets for  app [ " + this.appName + " ] module [ " + this.modName + " ] module category [ " + this.modCatName + " ]";
            Tr.debug((TraceComponent)tc, (String)(this.getClass().getName() + ": " + message), (Object[])new Object[0]);
        }
        try {
            useTargets = targetsFactory.createTargets(this.getIsLightweight());
        }
        catch (AnnotationTargets_Exception annotationTargets_Exception) {
            FFDCFilter.processException((Throwable)annotationTargets_Exception, (String)"com.ibm.ws.container.service.annocache.internal.AnnotationsImpl", (String)"905", (Object)this, (Object[])new Object[0]);
            return null;
        }
        useTargets.scan(useClassSource);
        return useTargets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InfoStore releaseInfoStore() {
        InfoStoreLock infoStoreLock = this.infoStoreLock;
        synchronized (infoStoreLock) {
            if (!this.isSetInfoStore) {
                return null;
            }
            this.isSetInfoStore = false;
            InfoStore oldStore = this.infoStore;
            this.infoStore = null;
            this.cacheRemove(InfoStore.class);
            return oldStore;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InfoStore getInfoStore() {
        InfoStoreLock infoStoreLock = this.infoStoreLock;
        synchronized (infoStoreLock) {
            if (!this.isSetInfoStore) {
                this.isSetInfoStore = true;
                this.infoStore = this.createInfoStore();
            }
            return this.infoStore;
        }
    }

    protected InfoStore createInfoStore() {
        ClassSource_Aggregate useClassSource = this.getClassSource();
        if (useClassSource == null) {
            return null;
        }
        InfoStoreFactory infoStoreFactory = this.getInfoStoreFactory();
        if (infoStoreFactory == null) {
            return null;
        }
        try {
            return infoStoreFactory.createInfoStore(useClassSource);
        }
        catch (InfoStoreException infoStoreException) {
            FFDCFilter.processException((Throwable)infoStoreException, (String)"com.ibm.ws.container.service.annocache.internal.AnnotationsImpl", (String)"971", (Object)this, (Object[])new Object[0]);
            return null;
        }
    }

    @Override
    public boolean isIncludedClass(String className) {
        AnnotationTargets_Targets useTargets = this.getTargets();
        if (useTargets == null) {
            return false;
        }
        return useTargets.isSeedClassName(className);
    }

    @Override
    public boolean isPartialClass(String className) {
        AnnotationTargets_Targets useTargets = this.getTargets();
        if (useTargets == null) {
            return false;
        }
        return useTargets.isPartialClassName(className);
    }

    @Override
    public boolean isExcludedClass(String className) {
        AnnotationTargets_Targets useTargets = this.getTargets();
        if (useTargets == null) {
            return false;
        }
        return useTargets.isExcludedClassName(className);
    }

    @Override
    public boolean isExternalClass(String className) {
        AnnotationTargets_Targets useTargets = this.getTargets();
        if (useTargets == null) {
            return false;
        }
        return useTargets.isExternalClassName(className);
    }

    @Override
    public ClassInfo getClassInfo(String className) {
        return this.getInfoStore().getDelayableClassInfo(className);
    }

    @Override
    public void openInfoStore() {
        try {
            this.getInfoStore().open();
        }
        catch (InfoStoreException infoStoreException) {
            FFDCFilter.processException((Throwable)infoStoreException, (String)"com.ibm.ws.container.service.annocache.internal.AnnotationsImpl", (String)"1029", (Object)this, (Object[])new Object[0]);
        }
    }

    @Override
    public void closeInfoStore() {
        try {
            this.getInfoStore().close();
        }
        catch (InfoStoreException infoStoreException) {
            FFDCFilter.processException((Throwable)infoStoreException, (String)"com.ibm.ws.container.service.annocache.internal.AnnotationsImpl", (String)"1038", (Object)this, (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SpecificAnnotations getSpecificAnnotations(Set<String> specificClassNames) throws UnableToAdaptException {
        AnnotationTargets_Targets specificTargets;
        ClassSource_Aggregate useClassSource = this.getClassSource();
        if (useClassSource == null) {
            return null;
        }
        AnnotationTargets_Factory useTargetsFactory = this.getTargetsFactory();
        if (useTargetsFactory == null) {
            return null;
        }
        try {
            specificTargets = useTargetsFactory.createTargets();
        }
        catch (AnnotationTargets_Exception annotationTargets_Exception) {
            void e;
            FFDCFilter.processException((Throwable)annotationTargets_Exception, (String)"com.ibm.ws.container.service.annocache.internal.AnnotationsImpl", (String)"1060", (Object)this, (Object[])new Object[]{specificClassNames});
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"failed.to.obtain.module.annotation.targets.CWWKM0473E", (Object[])new Object[]{"Failed to obtain annotation targets", e});
            throw new UnableToAdaptException(msg);
        }
        try {
            specificTargets.scan(useClassSource, specificClassNames);
        }
        catch (AnnotationTargets_Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.container.service.annocache.internal.AnnotationsImpl", (String)"1068", (Object)this, (Object[])new Object[]{specificClassNames});
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"failed.to.obtain.module.annotation.targets.CWWKM0474E", (Object[])new Object[]{"Failed to obtain annotation targets", specificClassNames, e});
            throw new UnableToAdaptException(msg);
        }
        return new SpecificAnnotationsImpl(specificTargets);
    }

    @Override
    public boolean hasSpecifiedAnnotations(Collection<String> annotationClassNames) {
        AnnotationTargets_Targets useTargets = this.getTargets();
        if (useTargets == null) {
            return false;
        }
        for (String annotationClassName : annotationClassNames) {
            Set annotatedClassNames = useTargets.getAnnotatedClasses(annotationClassName);
            if (annotatedClassNames.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    @Trivial
    public Set<String> getClassesWithAnnotation(String annotationClassName) {
        return this.getClassesWithAnnotations(Collections.singletonList(annotationClassName));
    }

    @Override
    public Set<String> getClassesWithAnnotations(Collection<String> annotationClassNames) {
        AnnotationTargets_Targets useTargets = this.getTargets();
        if (useTargets == null) {
            return Collections.emptySet();
        }
        HashSet annotatedClassNames = null;
        for (String annotationClassName : annotationClassNames) {
            Set nextClassNames = useTargets.getAnnotatedClasses(annotationClassName);
            if (nextClassNames.isEmpty()) continue;
            if (annotatedClassNames == null) {
                annotatedClassNames = new HashSet(nextClassNames);
                continue;
            }
            annotatedClassNames.addAll(nextClassNames);
        }
        if (annotatedClassNames == null) {
            return Collections.emptySet();
        }
        return annotatedClassNames;
    }

    @Override
    public Set<String> getClassesWithSpecifiedInheritedAnnotations(Collection<String> annotationClassNames) {
        AnnotationTargets_Targets useTargets = this.getTargets();
        if (useTargets == null) {
            return Collections.emptySet();
        }
        HashSet<String> allAnnotatedClassNames = new HashSet<String>();
        for (String annotationClassName : annotationClassNames) {
            Set annotatedClassNames = useTargets.getAllInheritedAnnotatedClasses(annotationClassName);
            allAnnotatedClassNames.addAll(annotatedClassNames);
        }
        return allAnnotatedClassNames;
    }

    protected long scanStart() {
        long startTime = this.getTimeInNanoSec();
        return startTime;
    }

    protected long scanEnd(long startTime) {
        long endTime = this.getTimeInNanoSec();
        long elapsedTime = endTime - startTime;
        return elapsedTime;
    }

    private long getTimeInNanoSec() {
        return System.nanoTime();
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public class InfoStoreLock {
        static final long serialVersionUID = 3713004984371091313L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.container.service.annocache.internal.AnnotationsImpl$InfoStoreLock", InfoStoreLock.class, (String)"container.service", (String)"com.ibm.ws.container.service.resources.Messages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public class TargetsLock {
        static final long serialVersionUID = -1466406145162206500L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.container.service.annocache.internal.AnnotationsImpl$TargetsLock", TargetsLock.class, (String)"container.service", (String)"com.ibm.ws.container.service.resources.Messages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public class ClassSourceLock {
        static final long serialVersionUID = 7087751503327107663L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.container.service.annocache.internal.AnnotationsImpl$ClassSourceLock", ClassSourceLock.class, (String)"container.service", (String)"com.ibm.ws.container.service.resources.Messages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class PathData {
        public final String path;
        public final int spans;
        public final int spansAboveParent;
        public final int spansBelowParent;
        static final long serialVersionUID = -315071255724544968L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public PathData(String path, int spans) {
            this.path = path;
            this.spans = spans;
            this.spansAboveParent = -1;
            this.spansBelowParent = -1;
        }

        public PathData(String path, int spans, int spansBelowParent, int spansAboveParent) {
            this.path = path;
            this.spans = spans;
            this.spansBelowParent = spansBelowParent;
            this.spansAboveParent = spansAboveParent;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.container.service.annocache.internal.AnnotationsImpl$PathData", PathData.class, (String)"container.service", (String)"com.ibm.ws.container.service.resources.Messages");
        }
    }
}

