/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core.scanner;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexReader;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class ResourceScanner {
    private static final DotName JAKARTA;
    private static final DotName ANNOTATION;
    private static final DotName PRIORITY;
    private static final DotName WS;
    private static final DotName RS;
    private static final DotName APPLICATION_PATH;
    private static final DotName PATH;
    private static final DotName CORE;
    private static final DotName APPLICATION;
    private static final DotName EXT;
    private static final DotName PROVIDER;
    private final IndexView index;
    private final Map<DotName, Set<String>> scanned;
    static final long serialVersionUID = -3722679794045799755L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    private ResourceScanner(IndexView index) {
        this.index = index;
        this.scanned = new ConcurrentHashMap<DotName, Set<String>>();
    }

    public static ResourceScanner fromClassPath(ClassLoader cl) throws IOException {
        return ResourceScanner.fromClassPath(cl, null);
    }

    public static ResourceScanner fromClassPath(ClassLoader cl, Predicate<Path> filter) throws IOException {
        String[] cpEntries;
        Enumeration<URL> resources = cl.getResources("META-INF/jandex.idx");
        if (resources.hasMoreElements()) {
            ArrayList<Index> indexes = new ArrayList<Index>();
            while (resources.hasMoreElements()) {
                InputStream in = resources.nextElement().openStream();
                try {
                    IndexReader reader = new IndexReader(in);
                    indexes.add(reader.read());
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
            return new ResourceScanner((IndexView)CompositeIndex.create(indexes));
        }
        final Indexer indexer = new Indexer();
        for (String entry : cpEntries = System.getProperty("java.class.path").split(File.pathSeparator)) {
            Path path = Paths.get(entry, new String[0]);
            if (!Files.exists(path, new LinkOption[0]) || filter != null && !filter.test(path)) continue;
            if (Files.isDirectory(path, new LinkOption[0])) {
                Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){
                    static final long serialVersionUID = 3661728250390961195L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        if (file.getFileName().toString().endsWith(".class")) {
                            ResourceScanner.indexClass(indexer, file);
                        }
                        return FileVisitResult.CONTINUE;
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.core.scanner.ResourceScanner$1", 1.class, null, null);
                    }
                });
                continue;
            }
            if (path.getFileName().toString().endsWith(".class")) {
                ResourceScanner.indexClass(indexer, path);
                continue;
            }
            if (!path.getFileName().toString().endsWith(".jar")) continue;
            ResourceScanner.indexJar(indexer, path);
        }
        return new ResourceScanner((IndexView)indexer.complete());
    }

    public static ResourceScanner of(Index index) {
        return new ResourceScanner((IndexView)index);
    }

    public Set<String> getApplications() {
        Set applications = this.scanned.computeIfAbsent(APPLICATION_PATH, annotation -> {
            ArrayList<ClassInfo> apps = new ArrayList<ClassInfo>();
            apps.addAll(this.resolveTypeFromAnnotation((DotName)annotation));
            apps.addAll(this.index.getAllKnownSubclasses(APPLICATION));
            apps.sort(PrioritySorter.INSTANCE);
            return apps.stream().map(classInfo -> classInfo.name().toString()).collect(Collectors.toSet());
        });
        return Collections.unmodifiableSet(applications);
    }

    public Set<String> getProviders() {
        return this.getTypesAnnotatedWith(PROVIDER);
    }

    public Set<String> getResources() {
        return this.getTypesAnnotatedWith(PATH);
    }

    public Set<String> getTypesAnnotatedWith(DotName annotation) {
        return Collections.unmodifiableSet(this.scanned.computeIfAbsent(annotation, this::resolveFromAnnotation));
    }

    private Set<String> resolveFromAnnotation(DotName annotation) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        this.resolveTypeFromAnnotation(annotation).forEach(classInfo -> result.add(classInfo.name().toString()));
        return result;
    }

    private Collection<ClassInfo> resolveTypeFromAnnotation(DotName annotation) {
        ArrayList<ClassInfo> results = new ArrayList<ClassInfo>();
        for (AnnotationInstance instance : this.index.getAnnotations(annotation)) {
            AnnotationTarget target = instance.target();
            if (!(target instanceof ClassInfo)) continue;
            results.add((ClassInfo)target);
        }
        results.sort(PrioritySorter.INSTANCE);
        return results;
    }

    private static void indexJar(final Indexer indexer, Path jar) throws IOException {
        try (FileSystem fs = ResourceScanner.getZipFs(jar);){
            Files.walkFileTree(fs.getPath("/", new String[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){
                static final long serialVersionUID = -9199321068549340053L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (file.getFileName().toString().endsWith(".class")) {
                        ResourceScanner.indexClass(indexer, file);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.core.scanner.ResourceScanner$2", 2.class, null, null);
                }
            });
        }
    }

    private static void indexClass(Indexer indexer, Path file) throws IOException {
        try (InputStream in = Files.newInputStream(file, new OpenOption[0]);){
            indexer.index(in);
        }
    }

    private static FileSystem getZipFs(Path path) throws IOException {
        URI uri = URI.create("jar:" + path.toUri());
        try {
            return FileSystems.getFileSystem(uri);
        }
        catch (FileSystemNotFoundException fileSystemNotFoundException) {
            return FileSystems.newFileSystem(uri, Collections.emptyMap());
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.core.scanner.ResourceScanner", ResourceScanner.class, null, null);
        JAKARTA = DotName.createComponentized(null, (String)"jakarta");
        ANNOTATION = DotName.createComponentized((DotName)JAKARTA, (String)"annotation");
        PRIORITY = DotName.createComponentized((DotName)ANNOTATION, (String)"Priority");
        WS = DotName.createComponentized((DotName)JAKARTA, (String)"ws");
        RS = DotName.createComponentized((DotName)WS, (String)"rs");
        APPLICATION_PATH = DotName.createComponentized((DotName)RS, (String)"ApplicationPath");
        PATH = DotName.createComponentized((DotName)RS, (String)"Path");
        CORE = DotName.createComponentized((DotName)RS, (String)"core");
        APPLICATION = DotName.createComponentized((DotName)CORE, (String)"Application");
        EXT = DotName.createComponentized((DotName)RS, (String)"ext");
        PROVIDER = DotName.createComponentized((DotName)EXT, (String)"Provider");
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    private static class PrioritySorter
    implements Comparator<ClassInfo> {
        static final PrioritySorter INSTANCE;
        static final long serialVersionUID = 8772522592099976189L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private PrioritySorter() {
        }

        @Override
        public int compare(ClassInfo o1, ClassInfo o2) {
            int p1 = Integer.MAX_VALUE;
            int p2 = Integer.MAX_VALUE;
            AnnotationInstance pa1 = o1.classAnnotation(PRIORITY);
            AnnotationInstance pa2 = o2.classAnnotation(PRIORITY);
            if (pa1 != null) {
                p1 = pa1.value().asInt();
            }
            if (pa2 != null) {
                p2 = pa2.value().asInt();
            }
            return Integer.compare(p1, p2);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.core.scanner.ResourceScanner$PrioritySorter", PrioritySorter.class, null, null);
            INSTANCE = new PrioritySorter();
        }
    }
}

