/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.spi.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import jakarta.annotation.PostConstruct;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public final class Types {
    private static final Type[] EMPTY_TYPE_ARRAY;
    static final long serialVersionUID = -4101043665486089853L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static boolean isA(Class clazz, ParameterizedType pType) {
        return clazz.isAssignableFrom((Class)pType.getRawType());
    }

    public static Class getArgumentType(ParameterizedType pType, int index) {
        return (Class)pType.getActualTypeArguments()[index];
    }

    public static Class getTemplateParameterOfInterface(Class base, Class desiredInterface) {
        Object rtn = Types.searchForInterfaceTemplateParameter(base, desiredInterface);
        if (rtn != null && rtn instanceof Class) {
            return (Class)rtn;
        }
        return null;
    }

    private static Object searchForInterfaceTemplateParameter(Class base, Class desiredInterface) {
        for (int i = 0; i < base.getInterfaces().length; ++i) {
            Class<?> intf = base.getInterfaces()[i];
            Type generic = base.getGenericInterfaces()[i];
            if (intf.equals(desiredInterface)) {
                if (generic instanceof ParameterizedType) {
                    ParameterizedType p = (ParameterizedType)generic;
                    Type type = p.getActualTypeArguments()[0];
                    Class<?> rtn = Types.getRawTypeNoException(type);
                    if (rtn != null) {
                        return rtn;
                    }
                    return type;
                }
                return null;
            }
            Object ret = Types.searchForInterfaceTemplateParameterInSupertype(intf, generic, desiredInterface);
            if (ret == null) continue;
            return ret;
        }
        return Types.searchForInterfaceTemplateParameterInSupertype(base.getSuperclass(), base.getGenericSuperclass(), desiredInterface);
    }

    private static Object searchForInterfaceTemplateParameterInSupertype(Class<?> supertype, Type genericSupertype, Class<?> desiredInterface) {
        if (supertype == null || supertype.equals(Object.class)) {
            return null;
        }
        Object rtn = Types.searchForInterfaceTemplateParameter(supertype, desiredInterface);
        if (rtn == null || rtn instanceof Class) {
            return rtn;
        }
        if (!(rtn instanceof TypeVariable)) {
            return null;
        }
        String name = ((TypeVariable)rtn).getName();
        int index = -1;
        TypeVariable<Class<?>>[] variables = supertype.getTypeParameters();
        if (variables == null || variables.length < 1) {
            return null;
        }
        for (int i = 0; i < variables.length; ++i) {
            if (!variables[i].getName().equals(name)) continue;
            index = i;
        }
        if (index == -1) {
            return null;
        }
        if (!(genericSupertype instanceof ParameterizedType)) {
            return null;
        }
        ParameterizedType pt = (ParameterizedType)genericSupertype;
        Type type = pt.getActualTypeArguments()[index];
        Class<?> clazz = Types.getRawTypeNoException(type);
        if (clazz != null) {
            return clazz;
        }
        return type;
    }

    public static boolean isCompatible(Method method, Method intfMethod) {
        if (method == intfMethod) {
            return true;
        }
        if (!method.getName().equals(intfMethod.getName())) {
            return false;
        }
        if (method.getParameterCount() != intfMethod.getParameterCount()) {
            return false;
        }
        for (int i = 0; i < method.getParameterCount(); ++i) {
            Class<?> rootParam = method.getParameterTypes()[i];
            Class<?> intfParam = intfMethod.getParameterTypes()[i];
            if (intfParam.isAssignableFrom(rootParam)) continue;
            return false;
        }
        return true;
    }

    public static Method getImplementingMethod(Class clazz, Method intfMethod) {
        Class<?> declaringClass = intfMethod.getDeclaringClass();
        if (declaringClass.equals(clazz)) {
            return intfMethod;
        }
        Class<?>[] paramTypes = intfMethod.getParameterTypes();
        if (declaringClass.getTypeParameters().length > 0 && paramTypes.length > 0) {
            Type[] intfTypes = Types.findParameterizedTypes(clazz, declaringClass);
            HashMap<String, Type> typeVarMap = new HashMap<String, Type>();
            TypeVariable<Class<?>>[] vars = declaringClass.getTypeParameters();
            for (int i = 0; i < vars.length; ++i) {
                if (intfTypes != null && i < intfTypes.length) {
                    typeVarMap.put(vars[i].getName(), intfTypes[i]);
                    continue;
                }
                typeVarMap.put(vars[i].getName(), vars[i].getGenericDeclaration());
            }
            Type[] paramGenericTypes = intfMethod.getGenericParameterTypes();
            paramTypes = new Class[paramTypes.length];
            for (int i = 0; i < paramTypes.length; ++i) {
                if (paramGenericTypes[i] instanceof TypeVariable) {
                    TypeVariable tv = (TypeVariable)paramGenericTypes[i];
                    Type t = (Type)typeVarMap.get(tv.getName());
                    if (t == null) {
                        throw new RuntimeException(Messages.MESSAGES.unableToResolveTypeVariable());
                    }
                    paramTypes[i] = Types.getRawType(t);
                    continue;
                }
                paramTypes[i] = Types.getRawType(paramGenericTypes[i]);
            }
        }
        try {
            return clazz.getMethod(intfMethod.getName(), paramTypes);
        }
        catch (NoSuchMethodException intfTypes) {
            try {
                Method tmp = clazz.getMethod(intfMethod.getName(), intfMethod.getParameterTypes());
                return tmp;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return intfMethod;
            }
        }
    }

    public static Method getImplementedInterfaceMethod(Class<?> root, Class<?> iface, Method implementation) {
        Method overriddenInterfaceMethod = Types.findOverriddenMethod(root, iface, implementation);
        if (overriddenInterfaceMethod != null) {
            return overriddenInterfaceMethod;
        }
        for (Class<?> extended : iface.getInterfaces()) {
            overriddenInterfaceMethod = Types.getImplementedInterfaceMethod(root, extended, implementation);
            if (overriddenInterfaceMethod == null) continue;
            return overriddenInterfaceMethod;
        }
        return null;
    }

    public static Method findOverriddenMethod(Class<?> root, Class<?> superClass, Method implementation) {
        try {
            Method method = superClass.getDeclaredMethod(implementation.getName(), implementation.getParameterTypes());
            return method;
        }
        catch (NoSuchMethodException method) {
            Map<TypeVariable<?>, Type> genericTypeMap = Types.populateParameterizedMap(root, superClass);
            for (Method superClassMethod : superClass.getDeclaredMethods()) {
                if (superClassMethod.isSynthetic() || !implementation.getName().equals(superClassMethod.getName()) || implementation.getParameterCount() != superClassMethod.getParameterCount()) continue;
                Object[] actualMethodParameters = Types.extractTypeVariables(genericTypeMap, superClassMethod.getGenericParameterTypes());
                if (!Arrays.equals(implementation.getGenericParameterTypes(), actualMethodParameters)) continue;
                return superClassMethod;
            }
            return null;
        }
    }

    public static Class<?> getRawType(Type type) {
        WildcardType wildcardType;
        Type[] upperBounds;
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            return (Class)rawType;
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            Class<?> componentRawType = Types.getRawType(genericArrayType.getGenericComponentType());
            return Array.newInstance(componentRawType, 0).getClass();
        }
        if (type instanceof TypeVariable) {
            TypeVariable typeVar = (TypeVariable)type;
            if (typeVar.getBounds() != null && typeVar.getBounds().length > 0) {
                return Types.getRawType(typeVar.getBounds()[0]);
            }
        } else if (type instanceof WildcardType && (upperBounds = (wildcardType = (WildcardType)type).getUpperBounds()) != null && upperBounds.length > 0) {
            return Types.getRawType(upperBounds[0]);
        }
        throw new RuntimeException(Messages.MESSAGES.unableToDetermineBaseClass());
    }

    public static Class<?> getRawTypeNoException(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            return (Class)rawType;
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            Class<?> componentRawType = Types.getRawType(genericArrayType.getGenericComponentType());
            return Array.newInstance(componentRawType, 0).getClass();
        }
        return null;
    }

    public static Class<?> getTypeArgument(Type genericType) {
        if (!(genericType instanceof ParameterizedType)) {
            return null;
        }
        ParameterizedType parameterizedType = (ParameterizedType)genericType;
        Type[] genericTypes = parameterizedType.getActualTypeArguments();
        return genericTypes.length == 0 ? Object.class : Types.getRawType(genericTypes[0]);
    }

    public static boolean isGenericTypeInstanceOf(Class<?> c, Type type) {
        if (type == null) {
            return false;
        }
        Class<?> typeArg = Types.getTypeArgument(type);
        return typeArg != null && c.isAssignableFrom(typeArg);
    }

    public static Class getCollectionBaseType(Class type, Type genericType) {
        if (genericType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericType;
            Type componentGenericType = parameterizedType.getActualTypeArguments()[0];
            return Types.getRawType(componentGenericType);
        }
        if (genericType instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)genericType;
            Type componentGenericType = genericArrayType.getGenericComponentType();
            return Types.getRawType(componentGenericType);
        }
        if (type.isArray()) {
            return type.getComponentType();
        }
        return null;
    }

    public static Class getMapKeyType(Type genericType) {
        if (genericType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericType;
            Type componentGenericType = parameterizedType.getActualTypeArguments()[0];
            return Types.getRawType(componentGenericType);
        }
        return null;
    }

    public static Class getMapValueType(Type genericType) {
        if (genericType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericType;
            Type componentGenericType = parameterizedType.getActualTypeArguments()[1];
            return Types.getRawType(componentGenericType);
        }
        return null;
    }

    public static Type resolveTypeVariables(Class<?> root, Type type) {
        if (type instanceof TypeVariable) {
            Type newType = Types.resolveTypeVariable(root, (TypeVariable)type);
            return newType == null ? type : newType;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType param = (ParameterizedType)type;
            Type[] actuals = new Type[param.getActualTypeArguments().length];
            for (int i = 0; i < actuals.length; ++i) {
                Type newType = Types.resolveTypeVariables(root, param.getActualTypeArguments()[i]);
                actuals[i] = newType == null ? param.getActualTypeArguments()[i] : newType;
            }
            return new ResteasyParameterizedType(actuals, param.getRawType(), param.getOwnerType());
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)type;
            final Type componentType = Types.resolveTypeVariables(root, arrayType.getGenericComponentType());
            if (componentType == null) {
                return type;
            }
            return new GenericArrayType(){
                static final long serialVersionUID = -3534324030629811009L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Type getGenericComponentType() {
                    return componentType;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.spi.util.Types$1", 1.class, null, null);
                }
            };
        }
        return type;
    }

    public static Type resolveTypeVariable(Class<?> root, TypeVariable<?> typeVariable) {
        if (typeVariable.getGenericDeclaration() instanceof Class) {
            Class classDeclaringTypeVariable = (Class)typeVariable.getGenericDeclaration();
            Type[] types = Types.findParameterizedTypes(root, classDeclaringTypeVariable);
            if (types == null) {
                return null;
            }
            for (int i = 0; i < types.length; ++i) {
                TypeVariable tv = classDeclaringTypeVariable.getTypeParameters()[i];
                if (!tv.equals(typeVariable)) continue;
                return types[i];
            }
        }
        return null;
    }

    public static Type[] getActualTypeArgumentsOfAnInterface(Class<?> classToSearch, Class<?> interfaceToFind) {
        Type[] types = Types.findParameterizedTypes(classToSearch, interfaceToFind);
        if (types == null) {
            throw new RuntimeException(Messages.MESSAGES.unableToFindTypeArguments(interfaceToFind));
        }
        return types;
    }

    public static Type[] findParameterizedTypes(Class<?> root, Class<?> searchedFor) {
        if (searchedFor.isInterface()) {
            return Types.findInterfaceParameterizedTypes(root, null, searchedFor);
        }
        return Types.findClassParameterizedTypes(root, null, searchedFor);
    }

    public static Type[] findClassParameterizedTypes(Class<?> root, ParameterizedType rootType, Class<?> searchedForClass) {
        if (Object.class.equals(root)) {
            return null;
        }
        Map<TypeVariable<?>, Type> typeVarMap = Types.populateParameterizedMap(root, rootType);
        Class<?> superclass = root.getSuperclass();
        Type genericSuper = root.getGenericSuperclass();
        if (superclass.equals(searchedForClass)) {
            return Types.extractTypes(typeVarMap, genericSuper);
        }
        if (genericSuper instanceof ParameterizedType) {
            ParameterizedType intfParam = (ParameterizedType)genericSuper;
            Type[] types = Types.findClassParameterizedTypes(superclass, intfParam, searchedForClass);
            if (types != null) {
                return Types.extractTypeVariables(typeVarMap, types);
            }
        } else {
            Type[] types = Types.findClassParameterizedTypes(superclass, null, searchedForClass);
            if (types != null) {
                return types;
            }
        }
        return null;
    }

    private static Map<TypeVariable<?>, Type> populateParameterizedMap(Class<?> root, ParameterizedType rootType) {
        HashMap typeVarMap = new HashMap();
        if (rootType != null) {
            TypeVariable<Class<?>>[] vars = root.getTypeParameters();
            for (int i = 0; i < vars.length; ++i) {
                typeVarMap.put(vars[i], rootType.getActualTypeArguments()[i]);
            }
        }
        return typeVarMap;
    }

    public static Map<TypeVariable<?>, Type> populateParameterizedMap(Class<?> root, Class<?> superClass) {
        Type[] types = Types.findParameterizedTypes(root, superClass);
        TypeVariable<Class<?>>[] typeParameters = superClass.getTypeParameters();
        HashMap genericTypeMap = new HashMap();
        if (typeParameters != null && types != null) {
            int i;
            for (i = 0; i < types.length; ++i) {
                genericTypeMap.put(typeParameters[i], types[i]);
            }
            while (i < typeParameters.length) {
                genericTypeMap.put(typeParameters[i], typeParameters[i].getGenericDeclaration());
                ++i;
            }
        }
        return genericTypeMap;
    }

    public static Type[] findInterfaceParameterizedTypes(Class<?> root, ParameterizedType rootType, Class<?> searchedForInterface) {
        int i;
        Map<TypeVariable<?>, Type> typeVarMap = Types.populateParameterizedMap(root, rootType);
        for (i = 0; i < root.getInterfaces().length; ++i) {
            Class<?> sub = root.getInterfaces()[i];
            Type genericSub = root.getGenericInterfaces()[i];
            if (!sub.equals(searchedForInterface)) continue;
            return Types.extractTypes(typeVarMap, genericSub);
        }
        for (i = 0; i < root.getInterfaces().length; ++i) {
            Class<?> sub;
            Type genericSub = root.getGenericInterfaces()[i];
            Type[] types = Types.recurseSuperclassForInterface(searchedForInterface, typeVarMap, genericSub, sub = root.getInterfaces()[i]);
            if (types == null) continue;
            return types;
        }
        if (root.isInterface()) {
            return null;
        }
        Class<?> superclass = root.getSuperclass();
        Type genericSuper = root.getGenericSuperclass();
        return Types.recurseSuperclassForInterface(searchedForInterface, typeVarMap, genericSuper, superclass);
    }

    private static Type[] recurseSuperclassForInterface(Class<?> searchedForInterface, Map<TypeVariable<?>, Type> typeVarMap, Type genericSub, Class<?> sub) {
        if (genericSub instanceof ParameterizedType) {
            ParameterizedType intfParam = (ParameterizedType)genericSub;
            Type[] types = Types.findInterfaceParameterizedTypes(sub, intfParam, searchedForInterface);
            if (types != null) {
                return Types.extractTypeVariables(typeVarMap, types);
            }
        } else {
            Type[] types = Types.findInterfaceParameterizedTypes(sub, null, searchedForInterface);
            if (types != null) {
                return types;
            }
        }
        return null;
    }

    private static Type[] extractTypeVariables(Map<TypeVariable<?>, Type> typeVarMap, Type[] types) {
        Type[] resolvedMethodParameterTypes = new Type[types.length];
        for (int i = 0; i < types.length; ++i) {
            Type methodParameterType = types[i];
            resolvedMethodParameterTypes[i] = methodParameterType instanceof TypeVariable ? typeVarMap.get(methodParameterType) : methodParameterType;
        }
        return resolvedMethodParameterTypes;
    }

    private static Type[] extractTypes(Map<TypeVariable<?>, Type> typeVarMap, Type genericSub) {
        if (genericSub instanceof ParameterizedType) {
            ParameterizedType param = (ParameterizedType)genericSub;
            Type[] types = param.getActualTypeArguments();
            Type[] returnTypes = Types.extractTypeVariables(typeVarMap, types);
            return returnTypes;
        }
        return EMPTY_TYPE_ARRAY;
    }

    public static Type boxPrimitives(Type genericType) {
        if (genericType == Boolean.TYPE) {
            return Boolean.class;
        }
        if (genericType == Character.TYPE) {
            return Character.class;
        }
        if (genericType == Byte.TYPE) {
            return Byte.class;
        }
        if (genericType == Short.TYPE) {
            return Short.class;
        }
        if (genericType == Integer.TYPE) {
            return Integer.class;
        }
        if (genericType == Long.TYPE) {
            return Long.class;
        }
        if (genericType == Float.TYPE) {
            return Float.class;
        }
        if (genericType == Double.TYPE) {
            return Double.class;
        }
        return genericType;
    }

    public static boolean hasPostConstruct(Class<?> clazz) {
        return Types.hasPostConstruct(clazz, mm -> mm.getParameterCount() == 0);
    }

    public static boolean hasPostConstruct(Class<?> clazz, Function<Method, Boolean> validateParameterCount) {
        for (Method m : clazz.getDeclaredMethods()) {
            if (m.getAnnotation(PostConstruct.class) == null || !Types.validatePostConstructMethod(m, validateParameterCount)) continue;
            return true;
        }
        Class<?> parent = clazz.getSuperclass();
        if (parent != null && parent != Object.class) {
            return Types.hasPostConstruct(parent, validateParameterCount);
        }
        return false;
    }

    private static boolean validatePostConstructMethod(Method m, Function<Method, Boolean> validateParameterCount) {
        if (!validateParameterCount.apply(m).booleanValue()) {
            return false;
        }
        if (!Void.TYPE.equals(m.getReturnType())) {
            return false;
        }
        for (Class<?> c : m.getExceptionTypes()) {
            if (RuntimeException.class.isAssignableFrom(c)) continue;
            return false;
        }
        return !Modifier.isStatic(m.getModifiers());
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.spi.util.Types", Types.class, null, null);
        EMPTY_TYPE_ARRAY = new Type[0];
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    public static class ResteasyParameterizedType
    implements ParameterizedType {
        private Type[] actuals;
        private Type rawType;
        private Type ownerType;
        static final long serialVersionUID = -1716886773632693881L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ResteasyParameterizedType(Type[] actuals, Type rawType, Type ownerType) {
            this.actuals = actuals;
            this.rawType = rawType;
            this.ownerType = ownerType;
        }

        @Override
        public Type[] getActualTypeArguments() {
            return this.actuals;
        }

        @Override
        public Type getRawType() {
            return this.rawType;
        }

        @Override
        public Type getOwnerType() {
            return this.ownerType;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (!(other instanceof ParameterizedType)) {
                return false;
            }
            ParameterizedType b = (ParameterizedType)other;
            return Arrays.equals(this.actuals, b.getActualTypeArguments()) && Objects.equals(this.rawType, b.getRawType()) && Objects.equals(this.ownerType, b.getOwnerType());
        }

        public int hashCode() {
            return Arrays.hashCode(this.actuals) ^ Objects.hashCode(this.ownerType) ^ Objects.hashCode(this.rawType);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.getOwnerType() != null) {
                sb.append(this.getOwnerType()).append(".");
            }
            sb.append(this.getRawType());
            if (this.actuals != null && this.actuals.length > 0) {
                sb.append("<");
                boolean first = true;
                for (Type actual : this.actuals) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append(actual);
                }
                sb.append(">");
            }
            return sb.toString();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.spi.util.Types$ResteasyParameterizedType", ResteasyParameterizedType.class, null, null);
        }
    }
}

