/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.security;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.jwtsso.token.proxy.JwtSSOTokenHelper;
import com.ibm.ws.security.krb5.SpnegoUtil;
import com.ibm.ws.webcontainer.security.CookieHelper;
import com.ibm.ws.webcontainer.security.WebAppSecurityConfig;
import com.ibm.ws.webcontainer.security.WebRequest;
import com.ibm.ws.webcontainer.security.WebSecurityContext;
import com.ibm.ws.webcontainer.security.metadata.FormLoginConfiguration;
import com.ibm.ws.webcontainer.security.metadata.LoginConfiguration;
import com.ibm.ws.webcontainer.security.metadata.MatchResponse;
import com.ibm.ws.webcontainer.security.metadata.SecurityMetadata;
import com.ibm.ws.webcontainer.srt.ISRTServletRequest;
import com.ibm.wsspi.http.channel.values.HttpHeaderKeys;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class WebRequestImpl
implements WebRequest {
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String BEARER_AUTHORIZATION_METHOD = "Bearer ";
    private static final String BASIC_AUTHORIZATION_METHOD = "Basic ";
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final String appName;
    private final WebSecurityContext webSecurityContext;
    private final MatchResponse matchResponse;
    private final SecurityMetadata securityMetadata;
    private final WebAppSecurityConfig config;
    private boolean formLoginRedirect = true;
    private boolean callAfterSSO = true;
    private boolean unprotectedURI = false;
    private boolean specialUnprotectedURI = false;
    private Map<String, Object> propMap = null;
    private boolean requestAuthenticate = false;
    private boolean disableClientCertFailOver = false;
    private final SpnegoUtil spnegoUtil = new SpnegoUtil();
    private boolean isPerformTAIForUnProtectedURI = false;
    static final long serialVersionUID = -8240350506301126524L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public WebRequestImpl(HttpServletRequest req, HttpServletResponse resp, SecurityMetadata securityMetadata, WebAppSecurityConfig config) {
        this(req, resp, null, null, securityMetadata, null, config);
    }

    public WebRequestImpl(HttpServletRequest req, HttpServletResponse resp, String appName, WebSecurityContext webSecurityContext, SecurityMetadata securityMetadata, MatchResponse matchResponse, WebAppSecurityConfig config) {
        this.request = req;
        this.response = resp;
        this.appName = appName;
        this.webSecurityContext = webSecurityContext;
        this.matchResponse = matchResponse;
        this.securityMetadata = securityMetadata;
        this.config = config;
    }

    @Override
    public HttpServletRequest getHttpServletRequest() {
        return this.request;
    }

    @Override
    public HttpServletResponse getHttpServletResponse() {
        return this.response;
    }

    @Override
    public String getApplicationName() {
        return this.appName;
    }

    @Override
    public WebSecurityContext getWebSecurityContext() {
        return this.webSecurityContext;
    }

    @Override
    public boolean isFormLoginRedirectEnabled() {
        return this.formLoginRedirect;
    }

    @Override
    public List<String> getRequiredRoles() {
        return this.matchResponse.getRoles();
    }

    @Override
    public boolean isSSLRequired() {
        return this.matchResponse.isSSLRequired();
    }

    @Override
    public boolean isAccessPrecluded() {
        return this.matchResponse.isAccessPrecluded();
    }

    @Override
    public SecurityMetadata getSecurityMetadata() {
        return this.securityMetadata;
    }

    @Override
    public LoginConfiguration getLoginConfig() {
        LoginConfiguration loginConfig = this.securityMetadata != null ? this.securityMetadata.getLoginConfiguration() : null;
        return loginConfig;
    }

    @Override
    public FormLoginConfiguration getFormLoginConfiguration() {
        return this.securityMetadata.getLoginConfiguration().getFormLoginConfiguration();
    }

    @Override
    public MatchResponse getMatchResponse() {
        return this.matchResponse;
    }

    private boolean determineIfRequestHasAuthenticationData() {
        String hdrValue = ISRTServletRequest.getHeader((HttpServletRequest)this.request, (HttpHeaderKeys)HttpHeaderKeys.HDR_AUTHORIZATION);
        return this.isBasicOrBearerAuthHeaderInRequest(hdrValue) || this.isClientCertHeaderInRequest(this.request) || this.isSSOCookieInRequest(this.request) || this.spnegoUtil.isSpnegoOrKrb5Token(hdrValue);
    }

    private boolean isBasicOrBearerAuthHeaderInRequest(String authHeaderValue) {
        return authHeaderValue != null && (authHeaderValue.startsWith(BASIC_AUTHORIZATION_METHOD) || authHeaderValue.startsWith(BEARER_AUTHORIZATION_METHOD));
    }

    private boolean isClientCertHeaderInRequest(HttpServletRequest request) {
        boolean hasClientCertHeader = false;
        LoginConfiguration loginConfig = this.getLoginConfig();
        String authenticationMethod = null;
        if (loginConfig != null) {
            authenticationMethod = loginConfig.getAuthenticationMethod();
        }
        if ("CLIENT_CERT".equals(authenticationMethod)) {
            X509Certificate[] certChain = (X509Certificate[])request.getAttribute("javax.net.ssl.peer_certificates");
            hasClientCertHeader = certChain != null && certChain.length > 0;
        }
        return hasClientCertHeader;
    }

    private boolean isSSOCookieInRequest(HttpServletRequest request) {
        return this.isJwtCookieInRequest(request) || this.canUseLTPATokenFromRequest(request);
    }

    private boolean isJwtCookieInRequest(HttpServletRequest request) {
        String jwtCookieName = JwtSSOTokenHelper.getJwtCookieName();
        if (jwtCookieName == null) {
            return false;
        }
        Cookie[] cookies = request.getCookies();
        return CookieHelper.hasCookie(cookies, jwtCookieName);
    }

    private boolean canUseLTPATokenFromRequest(HttpServletRequest request) {
        return JwtSSOTokenHelper.shouldUseLtpaIfJwtAbsent() && this.isLtpaCookieInRequest(request);
    }

    private boolean isLtpaCookieInRequest(HttpServletRequest request) {
        String cookieName;
        boolean ssoCookieFound = false;
        Cookie[] cookies = request.getCookies();
        if (cookies != null && cookies.length > 0 && !(ssoCookieFound = CookieHelper.hasCookie(cookies, cookieName = this.config.getSSOCookieName()))) {
            boolean useOnlyCustomCookieName;
            boolean bl = useOnlyCustomCookieName = this.config != null && this.config.isUseOnlyCustomCookieName();
            if (!"LtpaToken2".equalsIgnoreCase(cookieName) && !useOnlyCustomCookieName) {
                ssoCookieFound = CookieHelper.hasCookie(cookies, "LtpaToken2");
            }
        }
        return ssoCookieFound;
    }

    @Override
    public boolean hasAuthenticationData() {
        return this.determineIfRequestHasAuthenticationData();
    }

    @Override
    public boolean isUnprotectedURI() {
        return this.unprotectedURI;
    }

    @Override
    public void setUnprotectedURI(boolean unprotectedURI) {
        this.unprotectedURI = unprotectedURI;
    }

    @Override
    public void disableFormLoginRedirect() {
        this.formLoginRedirect = false;
    }

    @Override
    public boolean isProviderSpecialUnprotectedURI() {
        return this.specialUnprotectedURI;
    }

    @Override
    public void setProviderSpecialUnprotectedURI(boolean specialUnprotectedURI) {
        this.specialUnprotectedURI = specialUnprotectedURI;
    }

    @Override
    public void setCallAfterSSO(boolean callAfterSSO) {
        this.callAfterSSO = callAfterSSO;
    }

    @Override
    public boolean isCallAfterSSO() {
        return this.callAfterSSO;
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.propMap;
    }

    @Override
    public void setProperties(Map<String, Object> props) {
        this.propMap = props;
    }

    @Override
    public boolean isRequestAuthenticate() {
        return this.requestAuthenticate;
    }

    @Override
    public void setRequestAuthenticate(boolean requestAuthenticate) {
        this.requestAuthenticate = requestAuthenticate;
    }

    @Override
    public boolean isDisableClientCertFailOver() {
        return this.disableClientCertFailOver;
    }

    @Override
    public void setDisableClientCertFailOver(boolean isDisable) {
        this.disableClientCertFailOver = isDisable;
    }

    @Override
    public void setPerformTAIForUnProtectedURI(boolean isPerformTAIForUnProtectedURI) {
        this.isPerformTAIForUnProtectedURI = isPerformTAIForUnProtectedURI;
    }

    @Override
    public boolean isPerformTAIForUnProtectedURI() {
        return this.isPerformTAIForUnProtectedURI;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.webcontainer.security.WebRequestImpl", WebRequestImpl.class, (String)"WebAppSecurity", (String)"com.ibm.ws.webcontainer.security.resources.WebAppSecurityMessages");
    }
}

