/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.org.jboss.resteasy.common.component;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.container.service.annocache.AnnotationsBetaHelper;
import com.ibm.ws.container.service.annotations.WebAnnotations;
import com.ibm.ws.container.service.app.deploy.WebModuleInfo;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.NonPersistentCache;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.anno.info.ClassInfo;
import com.ibm.wsspi.anno.info.FieldInfo;
import com.ibm.wsspi.anno.info.MethodInfo;
import com.ibm.wsspi.anno.targets.AnnotationTargets_Targets;
import com.ibm.wsspi.webcontainer.collaborator.WebAppInjectionClassListCollaborator;
import jakarta.ws.rs.ApplicationPath;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.ext.Provider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.osgi.service.component.annotations.Component;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
@Component(name="com.ibm.ws.resteasy.cdi.component.ResteasyInjectionClassListCollaborator", service={WebAppInjectionClassListCollaborator.class}, immediate=true, property={"service.vendor=IBM"})
public class ResteasyInjectionClassListCollaborator
implements WebAppInjectionClassListCollaborator {
    private static final TraceComponent tc = Tr.register(ResteasyInjectionClassListCollaborator.class, (String)"RESTfulWS", (String)"io.openliberty.org.jboss.resteasy.common.nls.RESTfulWSServer");
    private static final Set<String> RESTFUL_WS_INTERFACE_NAMES = new HashSet<String>();
    private static final Set<String> RESTFUL_WS_ABSTRACT_CLASS_NAMES;
    private static final String INJECT_CLASS_NAME = "jakarta.inject.Inject";
    private static final String RESOURCE_CLASS_NAME = "jakarta.annotation.Resource";
    private static List<String> EXPLICIT_LIFECYCLE_CLASS_NAMES;
    static final long serialVersionUID = 7756605058700271602L;

    public List<String> getInjectionClasses(Container moduleContainer) {
        try {
            if (!ResteasyInjectionClassListCollaborator.isWebModule(moduleContainer)) {
                return Collections.emptyList();
            }
            return ResteasyInjectionClassListCollaborator.getRESTfulWSInjectionClasses(moduleContainer);
        }
        catch (UnableToAdaptException e) {
            return Collections.emptyList();
        }
    }

    private static boolean isWebModule(Container container) throws UnableToAdaptException {
        NonPersistentCache overlayCache = (NonPersistentCache)container.adapt(NonPersistentCache.class);
        if (overlayCache != null) {
            return overlayCache.getFromCache(WebModuleInfo.class) != null;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getRESTfulWSInjectionClasses(Container moduleContainer) {
        AnnotationTargets_Targets annotationTargets;
        WebAnnotations webAnnotations;
        try {
            webAnnotations = AnnotationsBetaHelper.getWebAnnotations((Container)moduleContainer);
            annotationTargets = webAnnotations.getAnnotationTargets();
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
        HashSet candidateClassNames = new HashSet();
        candidateClassNames.addAll(annotationTargets.getAllInheritedAnnotatedClasses(Provider.class.getName()));
        candidateClassNames.addAll(annotationTargets.getAllInheritedAnnotatedClasses(Path.class.getName()));
        candidateClassNames.addAll(annotationTargets.getAllInheritedAnnotatedClasses(ApplicationPath.class.getName()));
        for (String interfaceName : RESTFUL_WS_INTERFACE_NAMES) {
            candidateClassNames.addAll(annotationTargets.getAllImplementorsOf(interfaceName));
        }
        for (String abstractClassName : RESTFUL_WS_ABSTRACT_CLASS_NAMES) {
            candidateClassNames.addAll(annotationTargets.getSubclassNames(abstractClassName));
        }
        if (candidateClassNames.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            webAnnotations.openInfoStore();
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
        try {
            HashSet<String> selectedClassNames = new HashSet<String>();
            for (String candidateClassName : candidateClassNames) {
                ClassInfo candidateClassInfo;
                try {
                    candidateClassInfo = webAnnotations.getClassInfo(candidateClassName);
                }
                catch (Exception e) {
                    continue;
                }
                if (candidateClassInfo == null) continue;
                if (!candidateClassInfo.isInterface()) {
                    if (!ResteasyInjectionClassListCollaborator.selectForInjection(candidateClassInfo)) continue;
                    selectedClassNames.add(candidateClassName);
                    continue;
                }
                Set implementerNames = annotationTargets.getAllImplementorsOf(candidateClassName);
                if (implementerNames.isEmpty() || !ResteasyInjectionClassListCollaborator.selectForInjection(candidateClassInfo)) continue;
                selectedClassNames.addAll(implementerNames);
            }
            ArrayList arrayList = new ArrayList(selectedClassNames);
            return arrayList;
        }
        finally {
            try {
                webAnnotations.closeInfoStore();
            }
            catch (Exception exception) {}
        }
    }

    private static boolean selectForInjection(ClassInfo classInfo) {
        if ((classInfo.isAnnotationPresent(INJECT_CLASS_NAME) || classInfo.isAnnotationPresent(RESOURCE_CLASS_NAME)) && !classInfo.isAnnotationWithin(EXPLICIT_LIFECYCLE_CLASS_NAMES)) {
            return true;
        }
        for (FieldInfo fieldInfo : classInfo.getDeclaredFields()) {
            if (!fieldInfo.isAnnotationPresent(INJECT_CLASS_NAME) && !fieldInfo.isAnnotationPresent(RESOURCE_CLASS_NAME)) continue;
            return true;
        }
        for (MethodInfo methodInfo : classInfo.getDeclaredMethods()) {
            if (!methodInfo.isAnnotationPresent(INJECT_CLASS_NAME) && !methodInfo.isAnnotationPresent(RESOURCE_CLASS_NAME)) continue;
            return true;
        }
        for (MethodInfo constructorInfo : classInfo.getDeclaredConstructors()) {
            if (!constructorInfo.isAnnotationPresent(INJECT_CLASS_NAME) && !constructorInfo.isAnnotationPresent(RESOURCE_CLASS_NAME)) continue;
            return true;
        }
        ClassInfo superClassInfo = classInfo.getSuperclass();
        if (superClassInfo != null) {
            return ResteasyInjectionClassListCollaborator.selectForInjection(superClassInfo);
        }
        return false;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        RESTFUL_WS_INTERFACE_NAMES.add("jakarta.ws.rs.ext.MessageBodyWriter");
        RESTFUL_WS_INTERFACE_NAMES.add("jakarta.ws.rs.ext.MessageBodyReader");
        RESTFUL_WS_INTERFACE_NAMES.add("jakarta.ws.rs.ext.ExceptionMapper");
        RESTFUL_WS_INTERFACE_NAMES.add("jakarta.ws.rs.ext.ContextResolver");
        RESTFUL_WS_INTERFACE_NAMES.add("jakarta.ws.rs.ext.ReaderInterceptor");
        RESTFUL_WS_INTERFACE_NAMES.add("jakarta.ws.rs.ext.WriterInterceptor");
        RESTFUL_WS_INTERFACE_NAMES.add("jakarta.ws.rs.ext.ParamConverterProvider");
        RESTFUL_WS_INTERFACE_NAMES.add("jakarta.ws.rs.container.ContainerRequestFilter");
        RESTFUL_WS_INTERFACE_NAMES.add("jakarta.ws.rs.container.ContainerResponseFilter");
        RESTFUL_WS_INTERFACE_NAMES.add("jakarta.ws.rs.container.DynamicFeature");
        RESTFUL_WS_INTERFACE_NAMES.add("org.apache.cxf.jaxrs.ext.ContextResolver");
        RESTFUL_WS_ABSTRACT_CLASS_NAMES = new HashSet<String>();
        RESTFUL_WS_ABSTRACT_CLASS_NAMES.add("jakarta.ws.rs.core.Application");
        EXPLICIT_LIFECYCLE_CLASS_NAMES = new ArrayList<String>();
        EXPLICIT_LIFECYCLE_CLASS_NAMES.add("jakarta.enterprise.context.RequestScoped");
        EXPLICIT_LIFECYCLE_CLASS_NAMES.add("jakarta.enterprise.context.ApplicationScoped");
        EXPLICIT_LIFECYCLE_CLASS_NAMES.add("jakarta.enterprise.context.SessionScoped");
        EXPLICIT_LIFECYCLE_CLASS_NAMES.add("jakarta.enterprise.context.Dependent");
    }
}

