/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.metrics50.rest;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.rest.handler.helper.ServletRESTRequestImpl;
import com.ibm.ws.rest.handler.helper.ServletRESTResponseImpl;
import com.ibm.wsspi.rest.handler.RESTHandlerContainer;
import com.ibm.wsspi.rest.handler.RESTRequest;
import com.ibm.wsspi.rest.handler.RESTResponse;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

@Trivial
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public abstract class BaseMetricsRESTProxyServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final TraceComponent tc = Tr.register(BaseMetricsRESTProxyServlet.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.resources.Metrics");
    private transient RESTHandlerContainer REST_HANDLER_CONTAINER = null;

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.getAndSetRESTHandlerContainer(request);
        this.handleWithDelegate(request, response);
    }

    private void handleWithDelegate(HttpServletRequest request, HttpServletResponse response) throws IOException {
        boolean foundHandler = this.REST_HANDLER_CONTAINER.handleRequest((RESTRequest)new ServletRESTRequestImpl(request), (RESTResponse)new ServletRESTResponseImpl(response));
        if (!foundHandler) {
            String errorMsg = "There are no registered handlers that match the requested URL " + request.getRequestURI();
            response.sendError(404, errorMsg);
        }
    }

    private synchronized void getAndSetRESTHandlerContainer(HttpServletRequest request) throws ServletException {
        if (this.REST_HANDLER_CONTAINER == null) {
            ServletContext sc;
            BundleContext ctxt;
            ServiceReference ref;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Request Session ID [{0}], Thread [{1}]", (Object[])new Object[]{request.getRequestedSessionId(), Thread.currentThread()});
            }
            if ((ref = (ctxt = (BundleContext)(sc = request.getServletContext()).getAttribute("osgi-bundlecontext")).getServiceReference(RESTHandlerContainer.class)) == null) {
                throw new ServletException("OSGi service RESTHandlerContainer is not available.");
            }
            this.REST_HANDLER_CONTAINER = (RESTHandlerContainer)ctxt.getService(ref);
            request.getSession();
        }
    }
}

