/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager.module.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.app.manager.module.ApplicationNestedConfigHelper;
import com.ibm.ws.app.manager.module.DeployedAppServices;
import com.ibm.ws.app.manager.module.internal.ModuleClassLoaderFactory;
import com.ibm.ws.app.manager.module.internal.SimpleDeployedAppInfoBase;
import com.ibm.ws.classloading.ClassLoaderConfigHelper;
import com.ibm.ws.classloading.ClassLoadingButler;
import com.ibm.ws.classloading.java2sec.PermissionManager;
import com.ibm.ws.container.service.app.deploy.ApplicationClassesContainerInfo;
import com.ibm.ws.container.service.app.deploy.ContainerInfo;
import com.ibm.ws.container.service.app.deploy.NestedConfigHelper;
import com.ibm.ws.container.service.app.deploy.extended.AppClassLoaderFactory;
import com.ibm.ws.container.service.app.deploy.extended.ExtendedApplicationInfo;
import com.ibm.ws.container.service.app.deploy.extended.LibraryClassesContainerInfo;
import com.ibm.ws.container.service.app.deploy.extended.LibraryContainerInfo;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.javaee.dd.permissions.PermissionsConfig;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.AdaptableModuleFactory;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.application.handler.ApplicationInformation;
import com.ibm.wsspi.artifact.ArtifactContainer;
import com.ibm.wsspi.artifact.factory.ArtifactContainerFactory;
import com.ibm.wsspi.classloading.ClassLoaderConfiguration;
import com.ibm.wsspi.classloading.ClassLoadingService;
import com.ibm.wsspi.classloading.GatewayConfiguration;
import com.ibm.wsspi.config.Fileset;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.utils.FileUtils;
import com.ibm.wsspi.kernel.service.utils.FilterUtils;
import com.ibm.wsspi.library.Library;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Future;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

@TraceObjectField(fieldName="_tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public abstract class DeployedAppInfoBase
extends SimpleDeployedAppInfoBase
implements ApplicationClassesContainerInfo,
AppClassLoaderFactory,
ModuleClassLoaderFactory {
    private static final TraceComponent _tc = Tr.register(DeployedAppInfoBase.class, (String)"app.manager", (String)"com.ibm.ws.app.manager.module.internal.resources.Messages");
    private static final String PERMISSION_XML = "permissions.xml";
    protected final ApplicationInformation<?> applicationInformation;
    public final String location;
    protected final ClassLoadingService classLoadingService;
    protected final Library globalSharedLibrary;
    protected final SharedLibDeploymentInfo sharedLibDeploymentInfo;
    private final ConfigurationAdmin configAdmin;
    private final ClassLoaderConfigHelper libraryConfigHelper;
    protected final boolean isDelegateLast;
    private final PermissionManager permissionManager;
    private final PermissionsConfig permissionsConfig;
    static final long serialVersionUID = 1131686356392279747L;

    /*
     * WARNING - void declaration
     */
    protected DeployedAppInfoBase(ApplicationInformation<?> applicationInformation, DeployedAppServices deployedAppServices) throws UnableToAdaptException {
        super(deployedAppServices);
        this.applicationInformation = applicationInformation;
        this.location = applicationInformation.getLocation();
        this.classLoadingService = deployedAppServices.getClassLoadingService();
        this.globalSharedLibrary = deployedAppServices.getGlobalSharedLibrary();
        this.configAdmin = deployedAppServices.getConfigurationAdmin();
        this.libraryConfigHelper = new ClassLoaderConfigHelper(this.getConfigHelper(), this.configAdmin, this.classLoadingService);
        this.isDelegateLast = this.libraryConfigHelper.isDelegateLast();
        this.permissionManager = deployedAppServices.getPermissionManager();
        try {
            this.permissionsConfig = (PermissionsConfig)this.getContainer().adapt(PermissionsConfig.class);
        }
        catch (UnableToAdaptException unableToAdaptException) {
            void e;
            FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.app.manager.module.internal.DeployedAppInfoBase", (String)"298", (Object)this, (Object[])new Object[]{applicationInformation, deployedAppServices});
            Tr.error((TraceComponent)_tc, (String)"error.application.parse.descriptor", (Object[])new Object[]{this.getName(), "META-INF/permissions.xml", e});
            throw e;
        }
        String parentPid = (String)applicationInformation.getConfigProperty("service.pid");
        String sourcePid = (String)applicationInformation.getConfigProperty("ibm.extends.source.pid");
        if (sourcePid != null) {
            parentPid = sourcePid;
        }
        this.sharedLibDeploymentInfo = new SharedLibDeploymentInfo(deployedAppServices, parentPid);
    }

    @Trivial
    public String getName() {
        return this.applicationInformation.getName();
    }

    @Trivial
    public Container getContainer() {
        return this.applicationInformation.getContainer();
    }

    @Trivial
    public NestedConfigHelper getConfigHelper() {
        return new ApplicationNestedConfigHelper(this.applicationInformation);
    }

    protected abstract ExtendedApplicationInfo createApplicationInfo();

    public List<ContainerInfo> getLibraryClassesContainerInfo() {
        if (this.sharedLibDeploymentInfo.getClassesContainerInfo() != null) {
            return Collections.unmodifiableList(this.sharedLibDeploymentInfo.getClassesContainerInfo());
        }
        return Collections.emptyList();
    }

    public ClassLoader createAppClassLoader() {
        return null;
    }

    public boolean deployApp(Future<Boolean> result) {
        if (this.moduleContainerInfos.isEmpty()) {
            throw new IllegalStateException();
        }
        this.appInfo = this.createApplicationInfo();
        return this.installApp(result);
    }

    protected ModuleClassLoaderFactory getModuleClassLoaderFactory() {
        return this;
    }

    protected ClassLoader createTopLevelClassLoader(List<Container> classPath, GatewayConfiguration gwConfig, ClassLoaderConfiguration config) {
        ClassLoader classLoader = this.libraryConfigHelper.createTopLevelClassLoader(classPath, gwConfig, config, this.classLoadingService, this.globalSharedLibrary);
        this.associateClassLoaderWithApp(classLoader);
        return classLoader;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean associateClassLoaderWithApp(ClassLoader loader) {
        boolean success;
        block2: {
            try {
                ClassLoadingButler butler = (ClassLoadingButler)this.appInfo.getContainer().adapt(ClassLoadingButler.class);
                butler.addClassLoader(loader);
                success = true;
            }
            catch (Exception butler) {
                void ex;
                FFDCFilter.processException((Throwable)butler, (String)"com.ibm.ws.app.manager.module.internal.DeployedAppInfoBase", (String)"372", (Object)this, (Object[])new Object[]{loader});
                success = false;
                if (!_tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)_tc, (String)"Failed to associate this app with a its loader via the ClassLoadingButler", (Object[])new Object[]{ex});
            }
        }
        return success;
    }

    @FFDCIgnore(value={MalformedURLException.class})
    protected ProtectionDomain getProtectionDomain() {
        CodeSource codeSource;
        Permissions perms;
        block7: {
            perms = new Permissions();
            try {
                codeSource = this.getCodeSource();
            }
            catch (MalformedURLException e) {
                codeSource = null;
                if (!_tc.isDebugEnabled()) break block7;
                Tr.debug((TraceComponent)_tc, (String)"Code Source could not be set. Setting it to null.", (Object[])new Object[]{e});
            }
        }
        if (!this.java2SecurityEnabled()) {
            ((PermissionCollection)perms).add(new AllPermission());
        } else {
            if (this.permissionsConfig != null && codeSource != null) {
                List configuredPermissions = this.permissionsConfig.getPermissions();
                this.addPermissions(codeSource, configuredPermissions);
            }
            PermissionCollection mergedPermissions = new Permissions();
            if (codeSource != null) {
                mergedPermissions = Policy.getPolicy().getPermissions(codeSource);
            }
            Enumeration<Permission> enumeration = ((PermissionCollection)mergedPermissions).elements();
            while (enumeration.hasMoreElements()) {
                Permission p = enumeration.nextElement();
                ((PermissionCollection)perms).add(p);
            }
        }
        return new ProtectionDomain(codeSource, perms);
    }

    private CodeSource getCodeSource() throws MalformedURLException {
        CodeSource codeSource = this.getContainerCodeSource();
        if (codeSource == null) {
            codeSource = this.getLocationCodeSource();
        }
        return codeSource;
    }

    private CodeSource getContainerCodeSource() {
        Iterator urlsIterator;
        CodeSource containerCodeSource = null;
        Container container = this.applicationInformation.getContainer();
        if (container != null && (urlsIterator = container.getURLs().iterator()).hasNext()) {
            containerCodeSource = new CodeSource((URL)urlsIterator.next(), (Certificate[])null);
        }
        return containerCodeSource;
    }

    private CodeSource getLocationCodeSource() throws MalformedURLException {
        String loc = this.applicationInformation.getLocation();
        return new CodeSource(new URL("file://" + (loc.startsWith("/") ? "" : "/") + loc), (Certificate[])null);
    }

    private void addPermissions(CodeSource codeSource, List<com.ibm.ws.javaee.dd.permissions.Permission> configuredPermissions) {
        Permission[] permissions = new Permission[configuredPermissions.size()];
        int count = 0;
        for (com.ibm.ws.javaee.dd.permissions.Permission permission : configuredPermissions) {
            Permission perm = this.permissionManager.createPermissionObject(permission.getClassName(), permission.getName(), permission.getActions(), null, null, null, PERMISSION_XML);
            if (perm == null) continue;
            permissions[count++] = perm;
            this.permissionManager.addPermissionsXMLPermission(codeSource, perm);
        }
    }

    private boolean java2SecurityEnabled() {
        SecurityManager sm = System.getSecurityManager();
        return sm != null;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    protected static final class SharedLibDeploymentInfo {
        private final WsLocationAdmin locAdmin;
        private final ArtifactContainerFactory artifactFactory;
        private final AdaptableModuleFactory moduleFactory;
        private final List<ContainerInfo> classesContainerInfo = new ArrayList<ContainerInfo>();
        static final long serialVersionUID = 5154735746662585226L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public SharedLibDeploymentInfo(DeployedAppServices deployedAppServices, String parentPid) {
            this.locAdmin = deployedAppServices.getLocationAdmin();
            this.artifactFactory = deployedAppServices.getArtifactFactory();
            this.moduleFactory = deployedAppServices.getModuleFactory();
            try {
                StringBuilder classloaderFilter = new StringBuilder(200);
                classloaderFilter.append("(&");
                classloaderFilter.append(FilterUtils.createPropertyFilter((String)"service.factoryPid", (String)"com.ibm.ws.classloading.classloader"));
                classloaderFilter.append(FilterUtils.createPropertyFilter((String)"config.parentPID", (String)parentPid));
                classloaderFilter.append(')');
                Configuration[] classloaderConfigs = deployedAppServices.getConfigurationAdmin().listConfigurations(classloaderFilter.toString());
                if (classloaderConfigs != null && classloaderConfigs.length == 1) {
                    Configuration cfg = classloaderConfigs[0];
                    Dictionary props = cfg.getProperties();
                    if (props != null) {
                        String[] libraryPIDs = (String[])props.get("privateLibraryRef");
                        this.processLibraryPIDs(deployedAppServices, this.classesContainerInfo, libraryPIDs, LibraryContainerInfo.LibraryType.PRIVATE_LIB);
                        libraryPIDs = (String[])props.get("commonLibraryRef");
                        this.processLibraryPIDs(deployedAppServices, this.classesContainerInfo, libraryPIDs, LibraryContainerInfo.LibraryType.COMMON_LIB);
                    } else {
                        cfg.delete();
                        return;
                    }
                }
                if (this.classesContainerInfo.isEmpty()) {
                    this.addLibraryContainers(this.classesContainerInfo, deployedAppServices.getGlobalSharedLibraryPid(), LibraryContainerInfo.LibraryType.GLOBAL_LIB, deployedAppServices.getGlobalSharedLibrary());
                }
            }
            catch (IOException classloaderFilter) {
                FFDCFilter.processException((Throwable)classloaderFilter, (String)"com.ibm.ws.app.manager.module.internal.DeployedAppInfoBase$SharedLibDeploymentInfo", (String)"162", (Object)this, (Object[])new Object[]{deployedAppServices, parentPid});
                return;
            }
            catch (InvalidSyntaxException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.app.manager.module.internal.DeployedAppInfoBase$SharedLibDeploymentInfo", (String)"165", (Object)this, (Object[])new Object[]{deployedAppServices, parentPid});
                return;
            }
        }

        public List<ContainerInfo> getClassesContainerInfo() {
            return this.classesContainerInfo;
        }

        private void processLibraryPIDs(DeployedAppServices deployedAppServices, List<ContainerInfo> sharedLibContainers, String[] libraryPIDs, LibraryContainerInfo.LibraryType libType) throws InvalidSyntaxException {
            if (libraryPIDs != null) {
                for (String pid : libraryPIDs) {
                    List<Library> libraries = deployedAppServices.getLibrariesFromPid(pid);
                    for (Library library : libraries) {
                        this.addLibraryContainers(sharedLibContainers, pid, libType, library);
                    }
                }
            }
        }

        private void addLibraryContainers(List<ContainerInfo> sharedLibContainers, String pid, LibraryContainerInfo.LibraryType libType, Library library) {
            if (library != null) {
                String libName = library.id();
                SharedLibClassesContainerInfo libClassesInfo = new SharedLibClassesContainerInfo(libType, library, "/" + libName);
                Collection files = library.getFiles();
                this.addContainers(libClassesInfo.getClassesContainerInfo(), pid, libName, files);
                Collection folders = library.getFolders();
                this.addContainers(libClassesInfo.getClassesContainerInfo(), pid, libName, folders);
                Collection filesets = library.getFilesets();
                for (Fileset fileset : filesets) {
                    this.addContainers(libClassesInfo.getClassesContainerInfo(), pid, libName, fileset.getFileset());
                }
                if (!libClassesInfo.getClassesContainerInfo().isEmpty()) {
                    sharedLibContainers.add((ContainerInfo)libClassesInfo);
                }
            }
        }

        private void addContainers(List<ContainerInfo> sharedLibContainers, String pid, String libName, Collection<File> files) {
            if (files != null) {
                for (File file : files) {
                    final Container container = this.setupContainer(pid, file);
                    if (container == null) continue;
                    final String name = "/" + libName + "/" + file.getName();
                    sharedLibContainers.add(new ContainerInfo(){
                        static final long serialVersionUID = -6809503652722008649L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        public ContainerInfo.Type getType() {
                            return ContainerInfo.Type.SHARED_LIB;
                        }

                        public String getName() {
                            return name;
                        }

                        public Container getContainer() {
                            return container;
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register(1.class, (String[])new String[]{"applications", "app.manager"}, null, (String)"com.ibm.ws.app.manager.module.internal.DeployedAppInfoBase$SharedLibDeploymentInfo$1");
                        }
                    });
                }
            }
        }

        private Container setupContainer(String pid, File locationFile) {
            if (!FileUtils.fileExists((File)locationFile)) {
                return null;
            }
            File cacheDir = new File(this.getCacheDir(), pid);
            if (!FileUtils.ensureDirExists((File)cacheDir)) {
                return null;
            }
            ArtifactContainer artifactContainer = this.artifactFactory.getContainer(cacheDir, (Object)locationFile);
            if (artifactContainer == null) {
                return null;
            }
            File cacheDirAdapt = new File(this.getCacheAdaptDir(), pid);
            if (!FileUtils.ensureDirExists((File)cacheDirAdapt)) {
                return null;
            }
            File cacheDirOverlay = new File(this.getCacheOverlayDir(), pid);
            if (!FileUtils.ensureDirExists((File)cacheDirOverlay)) {
                return null;
            }
            return this.moduleFactory.getContainer(cacheDirAdapt, cacheDirOverlay, artifactContainer);
        }

        private File getCacheAdaptDir() {
            return this.locAdmin.getBundleFile((Object)this, "cacheAdapt");
        }

        private File getCacheOverlayDir() {
            return this.locAdmin.getBundleFile((Object)this, "cacheOverlay");
        }

        private File getCacheDir() {
            return this.locAdmin.getBundleFile((Object)this, "cache");
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(SharedLibDeploymentInfo.class, (String[])new String[]{"applications", "app.manager"}, null, (String)"com.ibm.ws.app.manager.module.internal.DeployedAppInfoBase$SharedLibDeploymentInfo");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    protected static final class SharedLibClassesContainerInfo
    implements LibraryClassesContainerInfo {
        private final LibraryContainerInfo.LibraryType libType;
        private final Library sharedLib;
        private final String libName;
        private final List<ContainerInfo> classesContainerInfo = new ArrayList<ContainerInfo>();
        static final long serialVersionUID = 6112678435634051759L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        SharedLibClassesContainerInfo(LibraryContainerInfo.LibraryType libType, Library sharedLib, String libName) {
            this.sharedLib = sharedLib;
            this.libName = libName;
            this.libType = libType;
        }

        public ContainerInfo.Type getType() {
            return ContainerInfo.Type.SHARED_LIB;
        }

        public String getName() {
            return this.libName;
        }

        public Container getContainer() {
            return null;
        }

        public LibraryContainerInfo.LibraryType getLibraryType() {
            return this.libType;
        }

        public ClassLoader getClassLoader() {
            return this.sharedLib.getClassLoader();
        }

        public List<ContainerInfo> getClassesContainerInfo() {
            return this.classesContainerInfo;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(SharedLibClassesContainerInfo.class, (String[])new String[]{"applications", "app.manager"}, null, (String)"com.ibm.ws.app.manager.module.internal.DeployedAppInfoBase$SharedLibClassesContainerInfo");
        }
    }
}

