/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.injectionengine.osgi.internal;

import com.ibm.ejs.util.Util;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.injectionengine.osgi.internal.OSGiInjectionEngineImpl;
import com.ibm.ws.injectionengine.osgi.internal.ResourceFactoryObjectFactory;
import com.ibm.ws.resource.ResourceFactory;
import com.ibm.ws.resource.ResourceFactoryBuilder;
import com.ibm.wsspi.injectionengine.InjectionEngineAccessor;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import java.util.Vector;
import javax.naming.Reference;

@Trivial
public class ResourceFactoryReference
extends Reference {
    private static final long serialVersionUID = 4798118416701402834L;
    private static final short CLASS_VERSION = 1;
    private ResourceFactory resourceFactory;
    private Map<String, Object> properties;

    ResourceFactoryReference(String className, ResourceFactory resourceFactory, Map<String, Object> properties) {
        super(className, ResourceFactoryObjectFactory.class.getName(), null);
        this.resourceFactory = resourceFactory;
        this.properties = properties;
    }

    @Override
    public String toString() {
        return Util.identity((Object)this) + '[' + "type=" + this.getClassName() + ", resourceFactory=" + this.resourceFactory + ']';
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public boolean equals(Object o) {
        return this == o;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeShort(1);
        out.writeObject(this.className);
        out.writeObject(this.classFactory);
        out.writeObject(this.classFactoryLocation);
        out.writeObject(this.addrs);
        out.writeObject(this.properties);
    }

    private void readObject(ObjectInputStream in) throws IOException {
        try {
            if (in.readShort() != 1) {
                throw new InvalidObjectException("This ResourceFactoryReference class is not the correct version.This clent should be upgraded");
            }
            this.className = (String)in.readObject();
            this.classFactory = (String)in.readObject();
            this.classFactoryLocation = (String)in.readObject();
            this.addrs = (Vector)in.readObject();
            this.properties = (Map)in.readObject();
            OSGiInjectionEngineImpl ie = (OSGiInjectionEngineImpl)InjectionEngineAccessor.getInstance();
            ResourceFactoryBuilder builder = ie.getResourceFactoryBuilder(this.className);
            this.resourceFactory = builder.createResourceFactory(this.properties);
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    ResourceFactory getResourceFactory() {
        return this.resourceFactory;
    }
}

