/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.feature.internal.subsystem;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.feature.AppForceRestart;
import com.ibm.ws.kernel.feature.ProcessType;
import com.ibm.ws.kernel.feature.Visibility;
import com.ibm.ws.kernel.feature.internal.subsystem.FeatureManifestException;
import com.ibm.ws.kernel.feature.internal.subsystem.FeatureRepository;
import com.ibm.ws.kernel.feature.internal.subsystem.FeatureResourceImpl;
import com.ibm.ws.kernel.feature.provisioning.ActivationType;
import com.ibm.ws.kernel.feature.provisioning.FeatureResource;
import com.ibm.ws.kernel.feature.provisioning.HeaderElementDefinition;
import com.ibm.ws.kernel.feature.provisioning.SubsystemContentType;
import com.ibm.ws.kernel.provisioning.VersionUtility;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import org.apache.aries.util.manifest.ManifestHeaderProcessor;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class FeatureDefinitionUtils {
    private static final TraceComponent tc = Tr.register(FeatureDefinitionUtils.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
    static final String EMPTY = "";
    static final String SYMBOLIC_NAME = "Subsystem-SymbolicName";
    static final String TYPE = "Subsystem-Type";
    static final String VERSION = "Subsystem-Version";
    static final String CONTENT = "Subsystem-Content";
    static final String SHORT_NAME = "IBM-ShortName";
    static final String IBM_FEATURE_VERSION = "IBM-Feature-Version";
    static final String IBM_APP_FORCE_RESTART = "IBM-App-ForceRestart";
    public static final String IBM_API_SERVICE = "IBM-API-Service";
    public static final String IBM_API_PACKAGE = "IBM-API-Package";
    public static final String IBM_SPI_PACKAGE = "IBM-SPI-Package";
    public static final String IBM_PROVISION_CAPABILITY = "IBM-Provision-Capability";
    public static final String IBM_PROCESS_TYPES = "IBM-Process-Types";
    public static final String IBM_ACTIVATION_TYPE = "WLP-Activation-Type";
    public static final String IBM_ALT_NAMES = "WLP-AlsoKnownAs";
    public static final String IBM_DISABLE_ALL_FEATURES_ON_CONFLICT = "WLP-DisableAllFeatures-OnConflict";
    static final String FILTER_ATTR_NAME = "filter";
    static final String FILTER_FEATURE_KEY = "osgi.identity";
    static final String FILTER_TYPE_KEY = "type";
    static final List<String> LOCALIZABLE_HEADERS = Collections.unmodifiableList(Arrays.asList("Subsystem-Name", "Subsystem-Description"));
    public static final Collection<String> ALLOWED_ON_CLIENT_ONLY_FEATURES = Arrays.asList("com.ibm.websphere.appserver.javaeeClient-7.0", "com.ibm.websphere.appserver.javaeeClient-8.0", "io.openliberty.jakartaeeClient-9.1", "io.openliberty.jakartaeeClient-10.0", "com.ibm.websphere.appserver.appSecurityClient-1.0");
    public static final String NL = "\r\n";
    static final String SPLIT_CHAR = ";";
    static final Pattern splitPattern = Pattern.compile(";");
    static final String FEATURE_SPLIT_CHAR = ",";
    static final Pattern installedFeatureSplitPattern = Pattern.compile(",");
    static final long serialVersionUID = -5329925980885655117L;

    static ImmutableAttributes loadAttributes(String repoType, File featureFile, ProvisioningDetails details) throws IOException {
        details.ensureValid();
        String symbolicName = details.getNameAttribute(null);
        int featureVersion = details.getIBMFeatureVersion();
        Visibility visibility = Visibility.fromString(details.getNameAttribute("visibility:"));
        boolean isSingleton = Boolean.parseBoolean(details.getNameAttribute("singleton:"));
        String shortName = visibility != Visibility.PUBLIC ? null : details.getMainAttributeValue(SHORT_NAME);
        Version version = VersionUtility.stringToVersion((String)details.getMainAttributeValue(VERSION));
        AppForceRestart appRestart = AppForceRestart.fromString(details.getMainAttributeValue(IBM_APP_FORCE_RESTART));
        String subsystemType = details.getMainAttributeValue(TYPE);
        String value = details.getCachedRawHeader(IBM_PROVISION_CAPABILITY);
        boolean isAutoFeature = value != null && SubsystemContentType.FEATURE_TYPE.getValue().equals(subsystemType);
        value = details.getCachedRawHeader(IBM_API_SERVICE);
        boolean hasApiServices = value != null;
        value = details.getCachedRawHeader(IBM_API_PACKAGE);
        boolean hasApiPackages = value != null;
        value = details.getCachedRawHeader(IBM_SPI_PACKAGE);
        boolean hasSpiPackages = value != null;
        EnumSet<ProcessType> processTypes = ProcessType.fromString(details.getCachedRawHeader(IBM_PROCESS_TYPES));
        repoType = FeatureDefinitionUtils.emptyIfNull(repoType);
        String activationTypeHeader = details.getCachedRawHeader(IBM_ACTIVATION_TYPE);
        ActivationType activationType = repoType.length() > 0 ? ActivationType.SEQUENTIAL : (activationTypeHeader == null ? ActivationType.SEQUENTIAL : ActivationType.fromString(activationTypeHeader));
        boolean disableOnConflict = Boolean.parseBoolean(details.getCachedRawHeader(IBM_DISABLE_ALL_FEATURES_ON_CONFLICT));
        ImmutableAttributes iAttr = new ImmutableAttributes(repoType, symbolicName, FeatureDefinitionUtils.nullIfEmpty(shortName), details.getAltNames(), featureVersion, visibility, appRestart, version, featureFile, featureFile == null ? -1L : featureFile.lastModified(), featureFile == null ? -1L : featureFile.length(), isAutoFeature, hasApiServices, hasApiPackages, hasSpiPackages, isSingleton, disableOnConflict, processTypes, activationType);
        details.setImmutableAttributes(iAttr);
        return iAttr;
    }

    @FFDCIgnore(value={NumberFormatException.class})
    static int getIntegerValue(String value, int defaultValue) {
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    @Trivial
    public static String emptyIfNull(String str) {
        if (str == null) {
            return EMPTY;
        }
        return str;
    }

    @Trivial
    public static String nullIfEmpty(String str) {
        if (str != null && str.isEmpty()) {
            return null;
        }
        return str;
    }

    /*
     * Exception decompiling
     */
    @FFDCIgnore(value={IOException.class})
    private static Manifest loadManifest(File mfFile, InputStream in) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Trivial
    @FFDCIgnore(value={IOException.class})
    public static boolean tryToClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
                return true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static final class ProvisioningDetails {
        private Manifest manifest = null;
        private ImmutableAttributes iAttr = null;
        private static final int featureVersion = Integer.MIN_VALUE;
        private String autoFeatureCapability = null;
        private String apiPackages = null;
        private String spiPackages = null;
        private String apiServices = null;
        private boolean supersededChecked = false;
        private String supersededBy = null;
        private List<FeatureResource> subsystemContent = null;
        private Collection<Filter> featureCapabilityFilters = null;
        private Map<String, Collection<HeaderElementDefinition>> headerElements = null;
        private String symbolicName = null;
        private Map<String, String> symNameAttributes = null;
        private List<String> alternateNames = null;
        static final long serialVersionUID = -1946934077099279829L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        ProvisioningDetails(File mfFile, InputStream inStream) throws IOException {
            this.manifest = FeatureDefinitionUtils.loadManifest(mfFile, inStream);
        }

        List<String> getAltNames() {
            if (this.alternateNames == null) {
                List result;
                String ibmAltNames;
                try {
                    ibmAltNames = this.getMainAttributeValue(FeatureDefinitionUtils.IBM_ALT_NAMES);
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.kernel.feature.internal.subsystem.FeatureDefinitionUtils$ProvisioningDetails", (String)"424", (Object)this, (Object[])new Object[0]);
                    return Collections.emptyList();
                }
                if (ibmAltNames == null) {
                    result = Collections.emptyList();
                } else {
                    Map data = ManifestHeaderProcessor.parseImportString((String)ibmAltNames);
                    result = new ArrayList(data.keySet().size());
                    for (String name : data.keySet()) {
                        result.add(FeatureRepository.lowerFeature(name));
                    }
                }
                this.alternateNames = Collections.unmodifiableList(result);
            }
            return this.alternateNames;
        }

        ProvisioningDetails(ImmutableAttributes iAttr, String autoFeatureCapability, String apiServices, String apiPackages, String spiPackages) {
            this.iAttr = iAttr;
            this.autoFeatureCapability = autoFeatureCapability;
            this.apiServices = apiServices;
            this.apiPackages = apiPackages;
            this.spiPackages = spiPackages;
        }

        private Manifest getManifest() throws IOException {
            Manifest mf = this.manifest;
            if (mf == null) {
                mf = this.manifest = FeatureDefinitionUtils.loadManifest(this.iAttr.featureFile, null);
            }
            return mf;
        }

        private Map<String, Collection<HeaderElementDefinition>> getHeaderElementMap() {
            if (this.headerElements == null) {
                this.headerElements = new HashMap<String, Collection<HeaderElementDefinition>>();
            }
            return this.headerElements;
        }

        String getMainAttributeValue(String key) throws IOException {
            return this.getManifest().getMainAttributes().getValue(key);
        }

        String getNameAttribute(String key) throws IOException {
            Map attr = this.symNameAttributes;
            if (attr == null) {
                String nameHeader = this.getMainAttributeValue(FeatureDefinitionUtils.SYMBOLIC_NAME);
                if (nameHeader == null) {
                    String fakeNLS = "The required {0} header was missing or empty";
                    String message = Tr.formatMessage((TraceComponent)tc, (String)"The required {0} header was missing or empty", (Object[])new Object[]{FeatureDefinitionUtils.SYMBOLIC_NAME});
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)message, (Object[])new Object[0]);
                    }
                    throw new FeatureManifestException("Unable to read Subsystem-SymbolicName header from manifest", message);
                }
                ManifestHeaderProcessor.NameValuePair nvp = ManifestHeaderProcessor.parseBundleSymbolicName((String)nameHeader);
                this.symbolicName = nvp.getName();
                attr = this.symNameAttributes = nvp.getAttributes();
            }
            if (key == null) {
                return this.symbolicName;
            }
            if (attr != null) {
                return attr.get(key);
            }
            return null;
        }

        void setImmutableAttributes(ImmutableAttributes iAttr) {
            this.iAttr = iAttr;
        }

        void ensureValid() throws IOException {
            String fakeNLS = "The {0} header in feature {1} was missing or specified an invalid value. value={2}";
            String symbolicName = this.getNameAttribute(null);
            int fVersion = this.getIBMFeatureVersion();
            if (fVersion > 2) {
                Tr.error((TraceComponent)tc, (String)"UNSUPPORTED_FEATURE_VERSION", (Object[])new Object[]{symbolicName, fVersion});
                String message = Tr.formatMessage((TraceComponent)tc, (String)"UNSUPPORTED_FEATURE_VERSION", (Object[])new Object[]{symbolicName, fVersion});
                throw new FeatureManifestException("Unsupported feature version", message);
            }
            String type = this.getMainAttributeValue(FeatureDefinitionUtils.TYPE);
            if (type == null || !SubsystemContentType.FEATURE_TYPE.getValue().equals(type)) {
                String message = Tr.formatMessage((TraceComponent)tc, (String)"The {0} header in feature {1} was missing or specified an invalid value. value={2}", (Object[])new Object[]{FeatureDefinitionUtils.TYPE, symbolicName, type});
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)message, (Object[])new Object[0]);
                }
                throw new FeatureManifestException("Invalid value for Subsystem-Type manifest header: " + type, message);
            }
            String version = this.getMainAttributeValue(FeatureDefinitionUtils.VERSION);
            if (version == null) {
                String message = Tr.formatMessage((TraceComponent)tc, (String)"The {0} header in feature {1} was missing or specified an invalid value. value={2}", (Object[])new Object[]{FeatureDefinitionUtils.VERSION, symbolicName, null});
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)message, (Object[])new Object[0]);
                }
                throw new FeatureManifestException("Null value for Subsystem-Version manifest header", message);
            }
        }

        int getIBMFeatureVersion() throws IOException {
            int version = Integer.MIN_VALUE;
            if (version < 0) {
                version = FeatureDefinitionUtils.getIntegerValue(this.getMainAttributeValue(FeatureDefinitionUtils.IBM_FEATURE_VERSION), 0);
            }
            return version;
        }

        String getCachedRawHeader(String header) {
            String result = null;
            try {
                if (FeatureDefinitionUtils.IBM_PROVISION_CAPABILITY.equals(header)) {
                    result = this.autoFeatureCapability;
                    if (result == null) {
                        result = this.autoFeatureCapability = this.getMainAttributeValue(FeatureDefinitionUtils.IBM_PROVISION_CAPABILITY);
                    }
                } else if (FeatureDefinitionUtils.IBM_API_SERVICE.equals(header)) {
                    result = this.apiServices;
                    if (result == null) {
                        result = this.apiServices = this.getMainAttributeValue(FeatureDefinitionUtils.IBM_API_SERVICE);
                    }
                } else if (FeatureDefinitionUtils.IBM_API_PACKAGE.equals(header)) {
                    result = this.apiPackages;
                    if (result == null) {
                        result = this.apiPackages = this.getMainAttributeValue(FeatureDefinitionUtils.IBM_API_PACKAGE);
                    }
                } else if (FeatureDefinitionUtils.IBM_SPI_PACKAGE.equals(header)) {
                    result = this.spiPackages;
                    if (result == null) {
                        result = this.spiPackages = this.getMainAttributeValue(FeatureDefinitionUtils.IBM_SPI_PACKAGE);
                    }
                } else {
                    result = this.getMainAttributeValue(header);
                }
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.kernel.feature.internal.subsystem.FeatureDefinitionUtils$ProvisioningDetails", (String)"632", (Object)this, (Object[])new Object[]{header});
            }
            return result;
        }

        /*
         * WARNING - void declaration
         */
        Collection<Filter> getCapabilityFilters() {
            Collection<Filter> filters = this.featureCapabilityFilters;
            if (filters == null) {
                String capabilityHeader = this.getCachedRawHeader(FeatureDefinitionUtils.IBM_PROVISION_CAPABILITY);
                if (capabilityHeader != null) {
                    filters = new ArrayList<Filter>();
                    for (ManifestHeaderProcessor.GenericMetadata metadata : ManifestHeaderProcessor.parseCapabilityString((String)capabilityHeader)) {
                        String filterString = (String)metadata.getDirectives().get(FeatureDefinitionUtils.FILTER_ATTR_NAME);
                        if (filterString == null) continue;
                        try {
                            Filter filter = FrameworkUtil.createFilter((String)filterString);
                            filters.add(filter);
                        }
                        catch (InvalidSyntaxException filter) {
                            void ise;
                            FFDCFilter.processException((Throwable)filter, (String)"com.ibm.ws.kernel.feature.internal.subsystem.FeatureDefinitionUtils$ProvisioningDetails", (String)"659", (Object)this, (Object[])new Object[0]);
                            Tr.warning((TraceComponent)tc, (String)"INVALID_PROVISION_CAPABILITY_FILTER", (Object[])new Object[]{filterString, this.iAttr.symbolicName, ise.getMessage()});
                        }
                    }
                    this.featureCapabilityFilters = filters;
                } else {
                    filters = this.featureCapabilityFilters = Collections.emptyList();
                }
            }
            return filters;
        }

        Collection<FeatureResource> getConstituents(SubsystemContentType type) {
            List<FeatureResource> result = this.subsystemContent;
            if (result == null) {
                String contents = null;
                try {
                    contents = this.getMainAttributeValue(FeatureDefinitionUtils.CONTENT);
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.kernel.feature.internal.subsystem.FeatureDefinitionUtils$ProvisioningDetails", (String)"684", (Object)this, (Object[])new Object[]{type});
                    return Collections.emptyList();
                }
                List data = ManifestHeaderProcessor.parseExportString((String)contents);
                result = new ArrayList<FeatureResource>(data.size());
                HashSet<String> preventDups = new HashSet<String>();
                for (ManifestHeaderProcessor.NameValuePair content : data) {
                    if (!preventDups.add(content.getName())) continue;
                    result.add(new FeatureResourceImpl(content.getName(), content.getAttributes(), this.iAttr.bundleRepositoryType, this.iAttr.featureName, this.iAttr.activationType));
                }
                this.subsystemContent = result;
            }
            if (type != null) {
                List<FeatureResource> unfiltered = result;
                result = new ArrayList<FeatureResource>();
                for (FeatureResource resource : unfiltered) {
                    if (!resource.isType(type)) continue;
                    result.add(resource);
                }
            }
            return Collections.unmodifiableCollection(result);
        }

        Collection<HeaderElementDefinition> getRawHeaderElements(String header) {
            Collection<HeaderElementDefinition> elements = this.getHeaderElementMap().get(header);
            if (elements == null) {
                String contents = this.getCachedRawHeader(header);
                if (contents == null || contents.isEmpty()) {
                    return Collections.emptyList();
                }
                List data = ManifestHeaderProcessor.parseExportString((String)contents);
                ListIterator listIterator = data.listIterator();
                elements = new ArrayList<HeaderElementDefinition>(data.size());
                while (listIterator.hasNext()) {
                    ManifestHeaderProcessor.NameValuePair element = (ManifestHeaderProcessor.NameValuePair)listIterator.next();
                    elements.add(new FeatureResourceImpl(element.getName(), element.getAttributes(), this.iAttr.bundleRepositoryType, this.iAttr.featureName, this.iAttr.activationType));
                }
                elements = Collections.unmodifiableCollection(elements);
                this.getHeaderElementMap().put(header, elements);
            }
            return elements;
        }

        private void checkSuperseded() {
            if (this.supersededChecked) {
                return;
            }
            this.supersededChecked = true;
            try {
                String value = this.getNameAttribute("superseded-by");
                if (!Boolean.parseBoolean(this.getNameAttribute("superseded")) && value != null) {
                    Tr.error((TraceComponent)tc, (String)"SUPERSEDED_CONFIGURATION_ERROR", (Object[])new Object[]{this.iAttr.featureName, value});
                } else {
                    this.supersededBy = value;
                }
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.kernel.feature.internal.subsystem.FeatureDefinitionUtils$ProvisioningDetails", (String)"754", (Object)this, (Object[])new Object[0]);
            }
        }

        boolean isSuperseded() {
            this.checkSuperseded();
            return this.supersededBy != null;
        }

        String getSupersededBy() {
            this.checkSuperseded();
            return this.supersededBy;
        }

        public void setHeaderValue(String header, String value) {
            try {
                this.getManifest().getMainAttributes().putValue(header, value);
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.kernel.feature.internal.subsystem.FeatureDefinitionUtils$ProvisioningDetails", (String)"772", (Object)this, (Object[])new Object[]{header, value});
            }
        }

        public String toString() {
            return (this.iAttr == null ? "noAttr" : this.iAttr.toString()) + "(loaded" + (this.manifest == null ? FeatureDefinitionUtils.EMPTY : "+") + (this.headerElements == null ? FeatureDefinitionUtils.EMPTY : "%") + ")";
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.subsystem.FeatureDefinitionUtils$ProvisioningDetails", ProvisioningDetails.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static class ImmutableAttributes {
        final String bundleRepositoryType;
        final String featureName;
        final String symbolicName;
        final String shortName;
        final Collection<String> alternateNames;
        final int featureVersion;
        final Visibility visibility;
        final AppForceRestart appRestart;
        final EnumSet<ProcessType> processTypes;
        final ActivationType activationType;
        final Version version;
        final boolean isAutoFeature;
        final boolean hasApiPackages;
        final boolean hasSpiPackages;
        final boolean hasApiServices;
        final boolean isSingleton;
        final boolean disableOnConflict;
        final File featureFile;
        final long lastModified;
        final long length;
        static final long serialVersionUID = 1666809925899829646L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        ImmutableAttributes(String repoType, String symbolicName, String shortName, Collection<String> alternateNames, int featureVersion, Visibility visibility, AppForceRestart appRestart, Version version, File featureFile, long lastModified, long fileSize, boolean isAutoFeature, boolean hasApiServices, boolean hasApiPackages, boolean hasSpiPackages, boolean isSingleton, boolean disableOnConflict, EnumSet<ProcessType> processType, ActivationType activationType) {
            this.bundleRepositoryType = repoType;
            this.symbolicName = symbolicName;
            this.shortName = shortName;
            this.alternateNames = alternateNames;
            this.featureName = this.buildFeatureName(repoType, symbolicName, shortName);
            this.featureVersion = featureVersion;
            this.visibility = visibility;
            this.appRestart = appRestart;
            this.processTypes = processType;
            this.activationType = activationType;
            this.version = version;
            this.isAutoFeature = isAutoFeature;
            this.hasApiServices = hasApiServices;
            this.hasApiPackages = hasApiPackages;
            this.hasSpiPackages = hasSpiPackages;
            this.isSingleton = isSingleton;
            this.disableOnConflict = disableOnConflict;
            this.featureFile = featureFile;
            this.lastModified = lastModified;
            this.length = fileSize;
        }

        private String buildFeatureName(String repoType, String symbolicName, String shortName) {
            if (repoType == null || repoType.isEmpty()) {
                if (shortName != null) {
                    return shortName;
                }
                return symbolicName;
            }
            StringBuilder s = new StringBuilder();
            s.append(repoType).append(":");
            if (shortName != null) {
                s.append(shortName);
            } else {
                s.append(symbolicName);
            }
            return s.toString();
        }

        File getChecksumFile() {
            if (this.featureFile == null) {
                return null;
            }
            return new File(this.featureFile.getParentFile(), "checksums/" + this.symbolicName + ".cs");
        }

        File getLocalizationDirectory() {
            if (this.featureFile == null) {
                return null;
            }
            return new File(this.featureFile.getParentFile(), "l10n");
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.symbolicName == null ? 0 : this.symbolicName.hashCode());
            result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
            result = 31 * result + (this.shortName == null ? 0 : this.shortName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ImmutableAttributes other = (ImmutableAttributes)obj;
            if (this.symbolicName == null ? other.symbolicName != null : !this.symbolicName.equals(other.symbolicName)) {
                return false;
            }
            if (this.version == null ? other.version != null : !this.version.equals((Object)other.version)) {
                return false;
            }
            if (this.shortName == null ? other.shortName != null : !this.shortName.equals(other.shortName)) {
                return false;
            }
            return !(this.bundleRepositoryType == null ? other.bundleRepositoryType != null : !this.bundleRepositoryType.equals(other.bundleRepositoryType));
        }

        public boolean isSupportedFeatureVersion() {
            return this.featureVersion == 0 || this.featureVersion == 2;
        }

        public String toString() {
            return (this.featureName == this.symbolicName ? FeatureDefinitionUtils.EMPTY : this.featureName + '/') + this.symbolicName + '/' + this.version;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.subsystem.FeatureDefinitionUtils$ImmutableAttributes", ImmutableAttributes.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
        }
    }
}

