/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.feature.internal.subsystem;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.feature.AppForceRestart;
import com.ibm.ws.kernel.feature.ProcessType;
import com.ibm.ws.kernel.feature.Visibility;
import com.ibm.ws.kernel.feature.internal.subsystem.FeatureDefinitionUtils;
import com.ibm.ws.kernel.feature.internal.subsystem.FeatureManifestException;
import com.ibm.ws.kernel.feature.internal.subsystem.SubsystemFeatureDefinitionImpl;
import com.ibm.ws.kernel.feature.provisioning.ActivationType;
import com.ibm.ws.kernel.feature.provisioning.ProvisioningFeatureDefinition;
import com.ibm.ws.kernel.feature.resolver.FeatureResolver;
import com.ibm.ws.kernel.provisioning.BundleRepositoryRegistry;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.feature.LibertyFeature;
import com.ibm.wsspi.kernel.service.location.WsResource;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.Version;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public final class FeatureRepository
implements FeatureResolver.Repository {
    private static final TraceComponent tc = Tr.register(FeatureRepository.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
    private static final int FEATURE_CACHE_VERSION = 3;
    private static final String EMPTY = "";
    private boolean isDirty;
    private boolean cacheOk = true;
    private final WsResource cacheRes;
    private final BundleContext bundleContext;
    private volatile Set<String> installedFeatures = Collections.emptySet();
    private volatile Set<String> configuredFeatures = Collections.emptySet();
    private volatile boolean configurationError = true;
    private final Map<String, SubsystemFeatureDefinitionImpl> cachedFeatures = new HashMap<String, SubsystemFeatureDefinitionImpl>();
    private final Map<String, String> publicFeatureNameToSymbolicName = new HashMap<String, String>();
    private final Map<String, String> alternateFeatureNameToPublicName = new HashMap<String, String>();
    private final ConcurrentMap<String, LibertyFeatureServiceFactory> featureServiceFactories = new ConcurrentHashMap<String, LibertyFeatureServiceFactory>();
    private ArrayList<SubsystemFeatureDefinitionImpl> autoFeatures;
    Map<File, SubsystemFeatureDefinitionImpl> knownFeatures;
    Map<File, BadFeature> knownBadFeatures;
    private static final String TOLERATE_PREFIX = "tolerates.";
    private static String FEATURE_SERVICE_NAME = "ibm.featureName";
    private static String FEATURE_SERVICE_SYMBOLIC_NAME = "osgi.symbolicName";
    private static String FEATURE_SERVICE_VERSION = "osgi.version";
    private static String FEATURE_SERVICE_CATEGORY = "osgi.category";
    static final long serialVersionUID = 6782881691419819697L;

    public FeatureRepository() {
        this.cacheRes = null;
        this.isDirty = true;
        this.bundleContext = null;
    }

    public FeatureRepository(WsResource res, BundleContext bundleContext) {
        this.cacheRes = res;
        this.bundleContext = bundleContext;
    }

    public String matchesAlternate(String featureName) {
        return this.alternateFeatureNameToPublicName.get(FeatureRepository.lowerFeature(featureName));
    }

    public boolean disableAllFeaturesOnConflict(String featureName) {
        SubsystemFeatureDefinitionImpl feature = (SubsystemFeatureDefinitionImpl)this.getFeature(featureName);
        if (feature != null) {
            return feature.getImmutableAttributes().disableOnConflict;
        }
        return false;
    }

    public void init() {
        this.isDirty = false;
        boolean firstInit = this.cachedFeatures.isEmpty();
        this.autoFeatures = new ArrayList();
        this.knownFeatures = new HashMap<File, SubsystemFeatureDefinitionImpl>();
        this.knownBadFeatures = new HashMap<File, BadFeature>();
        this.readCache(firstInit);
        this.readFeatureManifests();
        if (this.isDirty && firstInit) {
            this.installedFeatures = Collections.emptySet();
            this.configuredFeatures = Collections.emptySet();
        }
    }

    public void dispose() {
        this.storeCache();
        this.autoFeatures = null;
        this.knownFeatures = null;
        this.knownBadFeatures = null;
        for (SubsystemFeatureDefinitionImpl def : this.cachedFeatures.values()) {
            def.setProvisioningDetails(null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void readCache(boolean firstInit) {
        if (this.cacheOk && this.cacheRes != null && this.cacheRes.exists()) {
            ArrayList<SubsystemFeatureDefinitionImpl> cachedEntries = new ArrayList<SubsystemFeatureDefinitionImpl>();
            HashSet<String> installed = new HashSet<String>();
            HashSet<String> configured = new HashSet<String>();
            HashMap<File, BadFeature> knownBad = new HashMap<File, BadFeature>();
            boolean configError = false;
            try {
                DataInputStream in;
                block24: {
                    in = new DataInputStream(new BufferedInputStream(this.cacheRes.get()));
                    if (in.readInt() == 3) break block24;
                    in.close();
                    return;
                }
                try {
                    int numFeatures = in.readInt();
                    for (int i = 0; i < numFeatures; ++i) {
                        FeatureDefinitionUtils.ImmutableAttributes cachedAttr;
                        FeatureDefinitionUtils.ImmutableAttributes newAttr = FeatureRepository.loadFeatureAttributes(in);
                        FeatureDefinitionUtils.ProvisioningDetails details = FeatureRepository.loadProvisioningDetails(in, newAttr);
                        String symbolicName = newAttr.symbolicName;
                        SubsystemFeatureDefinitionImpl cachedEntry = this.cachedFeatures.get(symbolicName);
                        FeatureDefinitionUtils.ImmutableAttributes immutableAttributes = cachedAttr = cachedEntry == null ? null : cachedEntry.getImmutableAttributes();
                        if (!newAttr.featureFile.exists()) {
                            newAttr = null;
                        } else if (cachedAttr != null) {
                            newAttr = cachedAttr;
                        }
                        if (newAttr != null) {
                            if (cachedAttr == newAttr) {
                                cachedEntry.setProvisioningDetails(details);
                            } else {
                                if (!firstInit) {
                                    this.isDirty = true;
                                }
                                cachedEntry = new SubsystemFeatureDefinitionImpl(newAttr, details);
                            }
                        } else if (cachedAttr != null) {
                            this.isDirty = true;
                            this.cachedFeatures.remove(symbolicName);
                            cachedEntry = null;
                        } else {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"cacheAttr and newAttr BOTH null while reading cache", (Object[])new Object[]{symbolicName});
                            }
                            this.isDirty = true;
                            cachedEntry = null;
                        }
                        cachedEntries.add(cachedEntry);
                    }
                    int numInstalled = in.readInt();
                    for (int i = 0; i < numInstalled; ++i) {
                        installed.add(in.readUTF());
                    }
                    int numConfigured = in.readInt();
                    for (int i = 0; i < numConfigured; ++i) {
                        configured.add(in.readUTF());
                    }
                    configError = in.readBoolean();
                    int numBad = in.readInt();
                    for (int i = 0; i < numBad; ++i) {
                        File f = new File(in.readUTF());
                        long lastModified = in.readLong();
                        long length = in.readLong();
                        if (!f.isFile()) continue;
                        knownBad.put(f, new BadFeature(lastModified, length));
                    }
                }
                catch (Throwable numFeatures) {
                    FFDCFilter.processException((Throwable)numFeatures, (String)"com.ibm.ws.kernel.feature.internal.subsystem.FeatureRepository", (String)"211", (Object)this, (Object[])new Object[]{firstInit});
                    try {
                        in.close();
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.kernel.feature.internal.subsystem.FeatureRepository", (String)"211", (Object)this, (Object[])new Object[]{firstInit});
                        numFeatures.addSuppressed(throwable);
                    }
                    throw numFeatures;
                }
                in.close();
            }
            catch (IOException in) {
                void e;
                FFDCFilter.processException((Throwable)in, (String)"com.ibm.ws.kernel.feature.internal.subsystem.FeatureRepository", (String)"289", (Object)this, (Object[])new Object[]{firstInit});
                this.cacheWarning((IOException)e);
                return;
            }
            this.installedFeatures = Collections.unmodifiableSet(installed);
            this.configuredFeatures = Collections.unmodifiableSet(configured);
            this.configurationError = configError;
            this.knownBadFeatures.putAll(knownBad);
            for (SubsystemFeatureDefinitionImpl cachedEntry : cachedEntries) {
                this.updateMaps(cachedEntry);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void storeCache() {
        if (this.cacheOk && this.cacheRes != null && this.isDirty) {
            try {
                DataOutputStream out = new DataOutputStream(new BufferedOutputStream(this.cacheRes.putStream()));
                try {
                    ArrayList<AbstractMap.SimpleEntry<FeatureDefinitionUtils.ImmutableAttributes, FeatureDefinitionUtils.ProvisioningDetails>> features = new ArrayList<AbstractMap.SimpleEntry<FeatureDefinitionUtils.ImmutableAttributes, FeatureDefinitionUtils.ProvisioningDetails>>();
                    for (SubsystemFeatureDefinitionImpl subsystemFeatureDefinitionImpl : this.cachedFeatures.values()) {
                        FeatureDefinitionUtils.ImmutableAttributes immutableAttributes = subsystemFeatureDefinitionImpl.getImmutableAttributes();
                        FeatureDefinitionUtils.ProvisioningDetails provDetails = subsystemFeatureDefinitionImpl.getProvisioningDetails();
                        if (immutableAttributes != null && provDetails != null) {
                            features.add(new AbstractMap.SimpleEntry<FeatureDefinitionUtils.ImmutableAttributes, FeatureDefinitionUtils.ProvisioningDetails>(immutableAttributes, provDetails));
                            continue;
                        }
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)("Unable to write out " + subsystemFeatureDefinitionImpl.getFeatureName() + " to cache because the provisioning detail: " + provDetails + " or imAttrs: " + immutableAttributes + " is null"), (Object[])new Object[0]);
                    }
                    out.writeInt(3);
                    out.writeInt(features.size());
                    for (Map.Entry entry : features) {
                        FeatureRepository.writeFeatureAttributes((FeatureDefinitionUtils.ImmutableAttributes)entry.getKey(), (FeatureDefinitionUtils.ProvisioningDetails)entry.getValue(), out);
                    }
                    Set<String> curInstalled = this.installedFeatures;
                    out.writeInt(curInstalled.size());
                    for (String string : curInstalled) {
                        out.writeUTF(string);
                    }
                    Set<String> set = this.configuredFeatures;
                    out.writeInt(set.size());
                    for (String configured : set) {
                        out.writeUTF(configured);
                    }
                    out.writeBoolean(this.configurationError);
                    Map<File, BadFeature> map = this.knownBadFeatures;
                    out.writeInt(map.size());
                    for (Map.Entry<File, BadFeature> entry : this.knownBadFeatures.entrySet()) {
                        out.writeUTF(entry.getKey().getAbsolutePath());
                        out.writeLong(entry.getValue().lastModified);
                        out.writeLong(entry.getValue().length);
                    }
                    this.isDirty = false;
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.kernel.feature.internal.subsystem.FeatureRepository", (String)"313", (Object)this, (Object[])new Object[0]);
                    try {
                        out.close();
                    }
                    catch (Throwable throwable2) {
                        FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.ws.kernel.feature.internal.subsystem.FeatureRepository", (String)"313", (Object)this, (Object[])new Object[0]);
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                out.close();
            }
            catch (IOException out) {
                void e;
                FFDCFilter.processException((Throwable)out, (String)"com.ibm.ws.kernel.feature.internal.subsystem.FeatureRepository", (String)"358", (Object)this, (Object[])new Object[0]);
                this.cacheWarning((IOException)e);
            }
        }
    }

    static void writeFeatureAttributes(FeatureDefinitionUtils.ImmutableAttributes iAttr, FeatureDefinitionUtils.ProvisioningDetails details, DataOutputStream out) throws IOException {
        if (iAttr == null || details == null) {
            throw new NullPointerException("Both attributes and details are required for caching: attr=" + iAttr + ", details=" + details);
        }
        out.writeUTF(iAttr.bundleRepositoryType == null ? EMPTY : iAttr.bundleRepositoryType);
        out.writeUTF(iAttr.symbolicName);
        out.writeUTF(iAttr.featureFile == null ? EMPTY : iAttr.featureFile.getAbsolutePath());
        out.writeLong(iAttr.lastModified);
        out.writeLong(iAttr.length);
        out.writeUTF(iAttr.shortName == null ? EMPTY : iAttr.shortName);
        out.writeInt(iAttr.featureVersion);
        out.writeUTF(iAttr.visibility.toString());
        out.writeUTF(iAttr.appRestart.toString());
        out.writeInt(iAttr.version.getMajor());
        out.writeInt(iAttr.version.getMinor());
        out.writeInt(iAttr.version.getMicro());
        String qualifier = iAttr.version.getQualifier();
        out.writeUTF(qualifier == null ? EMPTY : qualifier);
        out.writeBoolean(iAttr.isAutoFeature);
        out.writeBoolean(iAttr.hasApiServices);
        out.writeBoolean(iAttr.hasApiPackages);
        out.writeBoolean(iAttr.hasSpiPackages);
        out.writeBoolean(iAttr.isSingleton);
        out.writeBoolean(iAttr.disableOnConflict);
        out.writeInt(iAttr.processTypes.size());
        for (ProcessType type : iAttr.processTypes) {
            out.writeUTF(type.toString());
        }
        out.writeUTF(iAttr.activationType.toString());
        out.writeInt(iAttr.alternateNames.size());
        for (String s : iAttr.alternateNames) {
            out.writeUTF(s);
        }
        if (iAttr.isAutoFeature) {
            FeatureRepository.writeLongString(out, details.getCachedRawHeader("IBM-Provision-Capability"));
        }
        if (iAttr.hasApiServices) {
            FeatureRepository.writeLongString(out, details.getCachedRawHeader("IBM-API-Service"));
        }
        if (iAttr.hasApiPackages) {
            FeatureRepository.writeLongString(out, details.getCachedRawHeader("IBM-API-Package"));
        }
        if (iAttr.hasSpiPackages) {
            FeatureRepository.writeLongString(out, details.getCachedRawHeader("IBM-SPI-Package"));
        }
    }

    private static void writeLongString(DataOutputStream out, String longString) throws IOException {
        byte[] data = longString.getBytes();
        if (data.length > 65535) {
            out.writeBoolean(true);
            out.writeInt(data.length);
            out.write(data);
        } else {
            out.writeBoolean(false);
            out.writeUTF(longString);
        }
    }

    private static String readLongString(DataInputStream in) throws IOException {
        if (in.readBoolean()) {
            byte[] data = new byte[in.readInt()];
            in.readFully(data);
            return new String(data, StandardCharsets.UTF_8);
        }
        return in.readUTF();
    }

    static FeatureDefinitionUtils.ImmutableAttributes loadFeatureAttributes(DataInputStream in) throws IOException {
        String repositoryType = in.readUTF();
        if (repositoryType.isEmpty()) {
            repositoryType = EMPTY;
        }
        String symbolicName = in.readUTF();
        String featurePath = in.readUTF();
        File featureFile = featurePath.isEmpty() ? null : new File(featurePath);
        long lastModified = in.readLong();
        long fileSize = in.readLong();
        String shortName = in.readUTF();
        if (shortName.isEmpty()) {
            shortName = null;
        }
        int featureVersion = in.readInt();
        Visibility visibility = FeatureRepository.valueOf(in.readUTF(), Visibility.PRIVATE);
        AppForceRestart appRestart = FeatureRepository.valueOf(in.readUTF(), AppForceRestart.NEVER);
        Version version = new Version(in.readInt(), in.readInt(), in.readInt(), in.readUTF());
        boolean isAutoFeature = in.readBoolean();
        boolean hasApiServices = in.readBoolean();
        boolean hasApiPackages = in.readBoolean();
        boolean hasSpiPackages = in.readBoolean();
        boolean isSingleton = in.readBoolean();
        boolean disableOnConflict = in.readBoolean();
        int processTypeNum = in.readInt();
        EnumSet<ProcessType> processTypes = EnumSet.noneOf(ProcessType.class);
        for (int i = 0; i < processTypeNum; ++i) {
            processTypes.add(FeatureRepository.valueOf(in.readUTF(), ProcessType.SERVER));
        }
        ActivationType activationType = FeatureRepository.valueOf(in.readUTF(), ActivationType.SEQUENTIAL);
        int altNamesCount = in.readInt();
        ArrayList<String> altNames = new ArrayList<String>(altNamesCount);
        for (int x = 0; x < altNamesCount; ++x) {
            altNames.add(in.readUTF());
        }
        return new FeatureDefinitionUtils.ImmutableAttributes(repositoryType, symbolicName, shortName, altNames, featureVersion, visibility, appRestart, version, featureFile, lastModified, fileSize, isAutoFeature, hasApiServices, hasApiPackages, hasSpiPackages, isSingleton, disableOnConflict, processTypes, activationType);
    }

    static FeatureDefinitionUtils.ProvisioningDetails loadProvisioningDetails(DataInputStream in, FeatureDefinitionUtils.ImmutableAttributes iAttr) throws IOException {
        String autoFeatureCapability = iAttr.isAutoFeature ? FeatureRepository.readLongString(in) : null;
        String apiServices = iAttr.hasApiServices ? FeatureRepository.readLongString(in) : null;
        String apiPackages = iAttr.hasApiPackages ? FeatureRepository.readLongString(in) : null;
        String spiPackages = iAttr.hasSpiPackages ? FeatureRepository.readLongString(in) : null;
        return new FeatureDefinitionUtils.ProvisioningDetails(iAttr, autoFeatureCapability, apiServices, apiPackages, spiPackages);
    }

    @FFDCIgnore(value={IllegalArgumentException.class})
    public static <T extends Enum<T>> T valueOf(String name, T defaultValue) {
        try {
            return (T)Enum.valueOf(defaultValue.getClass(), name);
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
    }

    private void readFeatureManifests() {
        for (final BundleRepositoryRegistry.BundleRepositoryHolder holder : BundleRepositoryRegistry.holders()) {
            File libFeatureDir = new File(holder.getInstallDir(), "lib/features/");
            if (!libFeatureDir.isDirectory()) continue;
            libFeatureDir.listFiles(new FileFilter(){
                static final long serialVersionUID = 8518982116570981387L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                /*
                 * WARNING - void declaration
                 */
                @Override
                public boolean accept(File file) {
                    if (file == null) {
                        return false;
                    }
                    BadFeature bad = FeatureRepository.this.knownBadFeatures.get(file);
                    if (FeatureRepository.this.isFeatureStillBad(file, bad)) {
                        return false;
                    }
                    SubsystemFeatureDefinitionImpl def = FeatureRepository.this.knownFeatures.get(file);
                    if (FeatureRepository.this.isCachedEntryValid(file, def)) {
                        return false;
                    }
                    if (!file.isFile()) {
                        return false;
                    }
                    String name = file.getName();
                    int pos = name.lastIndexOf(46);
                    if (pos < 0) {
                        return false;
                    }
                    if (name.regionMatches(true, pos, ".mf", 0, 3)) {
                        FeatureRepository.this.isDirty = true;
                        try {
                            FeatureDefinitionUtils.ProvisioningDetails details = new FeatureDefinitionUtils.ProvisioningDetails(file, null);
                            FeatureDefinitionUtils.ImmutableAttributes attr = FeatureDefinitionUtils.loadAttributes(holder.getFeatureType(), file, details);
                            if (!attr.isSupportedFeatureVersion()) {
                                FeatureRepository.this.knownBadFeatures.put(file, new BadFeature(file.lastModified(), file.length()));
                                return false;
                            }
                            def = new SubsystemFeatureDefinitionImpl(attr, details);
                            FeatureRepository.this.updateMaps(def);
                        }
                        catch (IOException details) {
                            FFDCFilter.processException((Throwable)details, (String)"com.ibm.ws.kernel.feature.internal.subsystem.FeatureRepository$1", (String)"578", (Object)this, (Object[])new Object[]{file});
                            if (tc.isDebugEnabled()) {
                                void e;
                                Tr.debug((TraceComponent)tc, (String)"An exception occurred while reading the feature manifest", (Object[])new Object[]{e.toString()});
                            }
                            FeatureRepository.this.knownBadFeatures.put(file, new BadFeature(file.lastModified(), file.length()));
                        }
                    }
                    return false;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.subsystem.FeatureRepository$1", 1.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
                }
            });
        }
    }

    boolean isFeatureStillBad(File f, BadFeature bf) {
        return bf != null && f.lastModified() == bf.lastModified && f.length() == bf.length;
    }

    long reduceTimestampPrecision(long value) {
        return value / 1000L * 1000L;
    }

    boolean isCachedEntryValid(File f, SubsystemFeatureDefinitionImpl def) {
        if (def != null) {
            FeatureDefinitionUtils.ImmutableAttributes cachedAttr = def.getImmutableAttributes();
            if (this.reduceTimestampPrecision(cachedAttr.lastModified) == this.reduceTimestampPrecision(f.lastModified()) && cachedAttr.length == f.length()) {
                return true;
            }
            this.cachedFeatures.remove(cachedAttr.symbolicName);
            this.publicFeatureNameToSymbolicName.remove(FeatureRepository.lowerFeature(cachedAttr.featureName));
            if (cachedAttr.isAutoFeature) {
                this.autoFeatures.remove(def);
            }
        }
        return false;
    }

    private void updateMaps(SubsystemFeatureDefinitionImpl def) {
        if (def != null) {
            FeatureDefinitionUtils.ImmutableAttributes cachedAttr = def.getImmutableAttributes();
            SubsystemFeatureDefinitionImpl previousValue = this.cachedFeatures.put(cachedAttr.symbolicName, def);
            if (previousValue != null && !previousValue.equals(def)) {
                this.cachedFeatures.put(cachedAttr.symbolicName, previousValue);
                FeatureManifestException fme = new FeatureManifestException("Duplicate symbolic name: " + cachedAttr.symbolicName + ", " + def.getFeatureDefinitionFile().getAbsolutePath() + " will be ignored. The file " + previousValue.getFeatureDefinitionFile().getAbsolutePath() + " will be used instead.", (String)null);
                FFDCFilter.processException((Throwable)fme, (String)this.getClass().getName(), (String)"updateMaps", (Object)this, (Object[])new Object[]{previousValue, def});
                File file = cachedAttr.featureFile;
                this.knownBadFeatures.put(file, new BadFeature(file.lastModified(), file.length()));
                return;
            }
            this.knownFeatures.put(cachedAttr.featureFile, def);
            if (!cachedAttr.featureName.equals(cachedAttr.symbolicName)) {
                this.publicFeatureNameToSymbolicName.put(FeatureRepository.lowerFeature(cachedAttr.featureName), cachedAttr.symbolicName);
            }
            if (def.getVisibility() == Visibility.PUBLIC) {
                this.publicFeatureNameToSymbolicName.put(FeatureRepository.lowerFeature(cachedAttr.symbolicName), cachedAttr.symbolicName);
            }
            for (String s : cachedAttr.alternateNames) {
                this.alternateFeatureNameToPublicName.put(s, cachedAttr.featureName);
            }
            if (cachedAttr.isAutoFeature) {
                this.autoFeatures.add(def);
            }
        }
    }

    private void cacheWarning(IOException ioe) {
        if (this.cacheOk) {
            this.cacheOk = false;
            Tr.warning((TraceComponent)tc, (String)"UPDATE_BUNDLE_CACHE_WARNING", (Object[])new Object[]{this.cacheRes.toExternalURI(), ioe.toString()});
        }
    }

    public void setInstalledFeatures(Set<String> newInstalledFeatures, Set<String> newConfiguredFeatures, boolean configurationError) {
        Set<String> current = this.installedFeatures;
        if (!current.equals(newInstalledFeatures)) {
            this.isDirty = true;
        }
        this.installedFeatures = newInstalledFeatures.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<String>(newInstalledFeatures));
        current = this.configuredFeatures;
        if (!current.equals(newConfiguredFeatures)) {
            this.isDirty = true;
        }
        this.configuredFeatures = newConfiguredFeatures.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<String>(newConfiguredFeatures));
        this.configurationError = configurationError;
    }

    public Set<String> getInstalledFeatures() {
        return this.installedFeatures;
    }

    public Set<String> getConfiguredFeatures() {
        return this.configuredFeatures;
    }

    public boolean hasConfigurationError() {
        return this.configurationError;
    }

    public void copyInstalledFeaturesTo(Set<String> features) {
        features.addAll(this.installedFeatures);
    }

    public boolean emptyFeatures() {
        return this.installedFeatures.isEmpty();
    }

    public boolean featureSetEquals(Set<String> newFeatureSet) {
        if (newFeatureSet == null) {
            return false;
        }
        return !this.isDirty && newFeatureSet.equals(this.installedFeatures);
    }

    @Override
    public Collection<ProvisioningFeatureDefinition> getAutoFeatures() {
        if (this.autoFeatures == null) {
            throw new IllegalStateException("Method called outside of provisioining operation");
        }
        return this.asProvisioningFeatureDefinitionCollection(Collections.unmodifiableCollection(this.autoFeatures));
    }

    private Collection<ProvisioningFeatureDefinition> asProvisioningFeatureDefinitionCollection(Collection<? extends ProvisioningFeatureDefinition> collection) {
        return collection;
    }

    @Trivial
    private static String toFeatureNameList(Collection<String> collection) {
        StringBuilder builder = new StringBuilder();
        for (String entry : collection) {
            builder.append(entry);
            builder.append(',');
        }
        if (builder.length() > 1) {
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }

    @Override
    public ProvisioningFeatureDefinition getFeature(String featureName) {
        SubsystemFeatureDefinitionImpl result = this.cachedFeatures.get(featureName);
        if (result == null) {
            String name = this.publicFeatureNameToSymbolicName.get(FeatureRepository.lowerFeature(featureName));
            result = this.cachedFeatures.get(name);
        }
        return result;
    }

    @Override
    public List<String> getConfiguredTolerates(String baseSymbolicName) {
        if (this.bundleContext == null) {
            return Collections.emptyList();
        }
        String tolerates = this.bundleContext.getProperty(TOLERATE_PREFIX + baseSymbolicName);
        if (tolerates == null) {
            return Collections.emptyList();
        }
        String[] parts = tolerates.split(",");
        ArrayList<String> result = new ArrayList<String>();
        for (String p : parts) {
            if (EMPTY.equals(p.trim())) continue;
            result.add(p.trim());
        }
        return result;
    }

    @Trivial
    public static String lowerFeature(String inFeature) {
        if (inFeature == null || inFeature.isEmpty()) {
            return inFeature;
        }
        int colonIndex = inFeature.indexOf(":");
        if (colonIndex > -1 && inFeature.length() > colonIndex) {
            return inFeature.substring(0, colonIndex).trim() + ':' + inFeature.substring(colonIndex + 1).trim().toLowerCase(Locale.ENGLISH);
        }
        return inFeature.toLowerCase(Locale.ENGLISH).trim();
    }

    public void updateServices() {
        if (this.bundleContext == null) {
            return;
        }
        HashSet<String> installedSymbolicNames = new HashSet<String>();
        for (String featureName : this.installedFeatures) {
            String symbolicName = this.publicFeatureNameToSymbolicName.get(FeatureRepository.lowerFeature(featureName));
            if (symbolicName == null) continue;
            installedSymbolicNames.add(symbolicName);
        }
        HashSet removedFactories = new HashSet(this.featureServiceFactories.keySet());
        removedFactories.removeAll(installedSymbolicNames);
        for (String currentFactorySymbolicName : removedFactories) {
            LibertyFeatureServiceFactory factory = (LibertyFeatureServiceFactory)this.featureServiceFactories.remove(currentFactorySymbolicName);
            if (factory == null) continue;
            factory.unregisterService();
        }
        for (String currentFactorySymbolicName : installedSymbolicNames) {
            SubsystemFeatureDefinitionImpl featureDef = this.cachedFeatures.get(currentFactorySymbolicName);
            if (featureDef == null) continue;
            LibertyFeatureServiceFactory factory = new LibertyFeatureServiceFactory();
            LibertyFeatureServiceFactory previous = this.featureServiceFactories.putIfAbsent(currentFactorySymbolicName, factory);
            factory = previous != null ? previous : factory;
            factory.update(featureDef, this.bundleContext);
        }
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void removeInstalledFeature(String feature) {
        this.configurationError = true;
        HashSet<String> newInstalledFeatures = new HashSet<String>(this.installedFeatures);
        if (newInstalledFeatures.remove(feature)) {
            this.installedFeatures = newInstalledFeatures.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(newInstalledFeatures);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class LibertyFeatureServiceFactory
    implements ServiceFactory<LibertyFeature> {
        private final Hashtable<String, Object> serviceProps = new Hashtable();
        private ServiceRegistration<LibertyFeature> registration;
        private volatile SubsystemFeatureDefinitionImpl _featureDef;
        static final long serialVersionUID = -2842376468316705229L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private LibertyFeatureServiceFactory() {
        }

        /*
         * WARNING - void declaration
         */
        public LibertyFeature getService(Bundle bundle, ServiceRegistration<LibertyFeature> registration) {
            FeatureDefinitionUtils.ProvisioningDetails details;
            SubsystemFeatureDefinitionImpl current;
            block3: {
                current = this._featureDef;
                details = current.getProvisioningDetails();
                if (details == null) {
                    try {
                        details = new FeatureDefinitionUtils.ProvisioningDetails(current.getImmutableAttributes().featureFile, null);
                    }
                    catch (IOException iOException) {
                        void e;
                        FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.kernel.feature.internal.subsystem.FeatureRepository$LibertyFeatureServiceFactory", (String)"912", (Object)this, (Object[])new Object[]{bundle, registration});
                        if (!tc.isDebugEnabled()) break block3;
                        Tr.debug((TraceComponent)tc, (String)"An exception occurred while reading the feature manifest", (Object[])new Object[]{e.toString()});
                    }
                }
            }
            current.setProvisioningDetails(details);
            return current;
        }

        public void ungetService(Bundle bundle, ServiceRegistration<LibertyFeature> registration, LibertyFeature service) {
            this._featureDef.setProvisioningDetails(null);
        }

        void registerService(BundleContext bundleContext) {
            this.registration = bundleContext.registerService(LibertyFeature.class, (ServiceFactory)this, this.serviceProps);
        }

        void unregisterService() {
            if (this.registration != null) {
                this.registration.unregister();
            }
        }

        void update(SubsystemFeatureDefinitionImpl featureDef, BundleContext bundleContext) {
            if (featureDef == this._featureDef) {
                return;
            }
            if (this.registration != null) {
                this.registration.unregister();
            }
            this._featureDef = featureDef;
            this.getServiceProps();
            this.registerService(bundleContext);
        }

        private void getServiceProps() {
            this.serviceProps.clear();
            this.serviceProps.put(FEATURE_SERVICE_NAME, this._featureDef.getFeatureName());
            this.serviceProps.put(FEATURE_SERVICE_SYMBOLIC_NAME, this._featureDef.getSymbolicName());
            this.serviceProps.put(FEATURE_SERVICE_VERSION, this._featureDef.getVersion());
            String category = this._featureDef.getHeader("Subsystem-Category");
            if (category != null) {
                this.serviceProps.put(FEATURE_SERVICE_CATEGORY, category.split("\\s*,\\s*"));
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.subsystem.FeatureRepository$LibertyFeatureServiceFactory", LibertyFeatureServiceFactory.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static class BadFeature {
        final long lastModified;
        final long length;
        static final long serialVersionUID = -4822730322691946046L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        BadFeature(long lastModified, long length) {
            this.lastModified = lastModified;
            this.length = length;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.subsystem.FeatureRepository$BadFeature", BadFeature.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
        }
    }
}

