/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.async;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.servlet.error.ServletErrorReport;
import com.ibm.ws.webcontainer.async.AsyncContextImpl;
import com.ibm.ws.webcontainer.async.AsyncListenerEntry;
import com.ibm.ws.webcontainer.async.AsyncListenerEnum;
import com.ibm.ws.webcontainer.async.AsyncServletReentrantLock;
import com.ibm.ws.webcontainer.collaborator.CollaboratorMetaDataImpl;
import com.ibm.ws.webcontainer.servlet.IServletContextExtended;
import com.ibm.ws.webcontainer.webapp.WebAppDispatcherContext;
import com.ibm.wsspi.webcontainer.WebContainerRequestState;
import com.ibm.wsspi.webcontainer.async.WrapperRunnable;
import com.ibm.wsspi.webcontainer.collaborator.CollaboratorHelper;
import com.ibm.wsspi.webcontainer.collaborator.ICollaboratorHelper;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import com.ibm.wsspi.webcontainer.logging.LoggerHelper;
import com.ibm.wsspi.webcontainer.metadata.WebComponentMetaData;
import com.ibm.wsspi.webcontainer.servlet.AsyncContext;
import com.ibm.wsspi.webcontainer.servlet.IExtendedRequest;
import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import com.ibm.wsspi.webcontainer.util.ServletUtil;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ListenerHelper {
    protected static Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.ws.webcontainer.async");
    private static final String CLASS_NAME = "com.ibm.ws.webcontainer.async.ListenerHelper";
    protected static TraceNLS nls = TraceNLS.getTraceNLS(ListenerHelper.class, (String)"com.ibm.ws.webcontainer.resources.Messages");

    public static void invokeAsyncErrorHandling(AsyncContext asyncContext, WebContainerRequestState reqState, Throwable th, AsyncListenerEnum asyncEnum, ExecuteNextRunnable executeNextRunnable, CheckDispatching checkDispatching) {
        AsyncServletReentrantLock lock = asyncContext.getErrorHandlingLock();
        ListenerHelper.invokeAsyncErrorHandling(asyncContext, reqState, th, asyncEnum, executeNextRunnable, checkDispatching, lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invokeAsyncErrorHandling(AsyncContext asyncContext, WebContainerRequestState reqState, Throwable th, AsyncListenerEnum asyncEnum, ExecuteNextRunnable executeNextRunnable, CheckDispatching checkDispatching, AsyncServletReentrantLock lock) {
        boolean unlock = false;
        boolean invokeAsyncErrorHandling = false;
        try {
            AsyncContext asyncContext2 = asyncContext;
            synchronized (asyncContext2) {
                boolean gotValidLock = false;
                if (lock.tryLock()) {
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                        logger.logp(Level.FINER, CLASS_NAME, "invokeAsyncErrorHandling", "locking by current thread->" + lock);
                    }
                    if (lock.getAndSetIsValid(false)) {
                        gotValidLock = true;
                    }
                    unlock = true;
                } else if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINER, CLASS_NAME, "invokeAsyncErrorHandling", "lock is held by a different thread so skipping->" + lock);
                }
                if (gotValidLock) {
                    asyncContext.cancelAsyncTimer();
                    Collection<WrapperRunnable> startRunnables = asyncContext.getAndClearStartRunnables();
                    if (startRunnables != null) {
                        for (WrapperRunnable startRunnable : startRunnables) {
                            startRunnable.getAndSetRunning(true);
                        }
                    }
                    if (checkDispatching == CheckDispatching.TRUE && asyncContext.isDispatching()) {
                        asyncContext.setInvokeErrorHandling(true);
                        lock.getAndSetIsValid(true);
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                            logger.logp(Level.FINER, CLASS_NAME, "workRejected", "still dispatching so invoke error handling later");
                        }
                    } else if (asyncContext.isComplete()) {
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                            logger.logp(Level.FINER, CLASS_NAME, "_invokeAsyncErrorHandling", "asyncContext is already completed");
                        }
                    } else if (asyncContext.isCompletePending() || asyncContext.isDispatchPending()) {
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                            logger.logp(Level.FINER, CLASS_NAME, "_invokeAsyncErrorHandling", "asyncContext is already pending complete or dispatch");
                        }
                        if (executeNextRunnable == ExecuteNextRunnable.TRUE) {
                            asyncContext.executeNextRunnable();
                        }
                    } else {
                        asyncContext.setDispatching(true);
                        invokeAsyncErrorHandling = true;
                    }
                }
            }
            if (invokeAsyncErrorHandling) {
                ListenerHelper._invokeAsyncErrorHandling(asyncContext, reqState, th, asyncEnum, executeNextRunnable);
            }
        }
        finally {
            if (unlock) {
                lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _invokeAsyncErrorHandling(AsyncContext asyncContext, WebContainerRequestState reqState, Throwable th, AsyncListenerEnum asyncEnum, ExecuteNextRunnable executeNextRunnable) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "_invokeAsyncErrorHandling", new Object[]{asyncContext, reqState, th, asyncEnum});
        }
        try {
            ServletRequest servletRequest = asyncContext.getRequest();
            ServletResponse servletResponse = asyncContext.getResponse();
            IExtendedRequest wasreq = ServletUtil.unwrapRequest(servletRequest);
            HttpServletResponse httpRes = (HttpServletResponse)ServletUtil.unwrapResponse(servletResponse, HttpServletResponse.class);
            IServletContext iServletContext = asyncContext.getWebApp();
            ICollaboratorHelper collabHelper = ((IServletContextExtended)iServletContext).getCollaboratorHelper();
            WebComponentMetaData componentMetaData = iServletContext.getWebAppCmd();
            WebAppDispatcherContext dispatchContext = (WebAppDispatcherContext)wasreq.getWebAppDispatcherContext();
            CollaboratorMetaDataImpl collabMetaData = new CollaboratorMetaDataImpl(componentMetaData, wasreq, httpRes, dispatchContext, null, iServletContext, null);
            try {
                if (reqState != null) {
                    reqState.setAttribute("_invokeAsyncErrorHandling", true);
                }
                collabHelper.preInvokeCollaborators(collabMetaData, CollaboratorHelper.allCollabEnum);
                List<AsyncListenerEntry> list = asyncContext.getAsyncListenerEntryList();
                if (list != null) {
                    block25: {
                        try {
                            if (((AsyncContextImpl)asyncContext).registerPostEventAsyncListeners()) {
                                list = asyncContext.getAsyncListenerEntryList();
                            }
                        }
                        catch (ClassCastException exc) {
                            if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINEST)) break block25;
                            logger.fine("_invokeAsyncErrorHandling cannot cast AsyncContext to an impl class so post event Asynclistenrs will not be registered");
                        }
                    }
                    for (AsyncListenerEntry entry : list) {
                        try {
                            if (asyncEnum == AsyncListenerEnum.ERROR) {
                                entry.invokeOnError(th);
                                continue;
                            }
                            entry.invokeOnTimeout();
                        }
                        catch (Throwable throwable) {
                            LoggerHelper.logParamsAndException(logger, Level.WARNING, CLASS_NAME, "_invokeAsyncErrorHandling", "exception.invoking.async.listener", new Object[]{entry.getAsyncListener()}, throwable);
                        }
                    }
                }
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "_invokeAsyncErrorHandling", "vals after listeners [asyncContext.isComplete(),asyncContext.isCompletePending(),asyncContext.isDispatchPending()]->[" + asyncContext.isComplete() + "," + asyncContext.isCompletePending() + "," + asyncContext.isDispatchPending() + "]");
                }
                if (!(asyncContext.isComplete() || asyncContext.isCompletePending() || asyncContext.isDispatchPending())) {
                    if (th != null) {
                        ServletErrorReport ser = !(th instanceof ServletErrorReport) ? new ServletErrorReport(th) : (ServletErrorReport)((Object)th);
                        ser.setErrorCode(500);
                        asyncContext.getWebApp().sendError(wasreq, httpRes, ser);
                    } else {
                        IExtendedRequest iExtendedRequest = ServletUtil.unwrapRequest(servletRequest, IExtendedRequest.class);
                        iExtendedRequest.getWebAppDispatcherContext().sendError(500, nls.getFormattedMessage("error.occurred.during.async.servlet.handling", new Object[]{asyncEnum}, (Object)((Object)asyncEnum) + " occurred during async handling"), true);
                    }
                }
            }
            finally {
                collabHelper.postInvokeCollaborators(collabMetaData, CollaboratorHelper.allCollabEnum);
                if (reqState != null) {
                    reqState.removeAttribute("_invokeAsyncErrorHandling");
                }
            }
        }
        catch (Throwable throwable) {
            logger.logp(Level.WARNING, CLASS_NAME, "_invokeAsyncErrorHandling", "exception.invoking.asnyc.error.mechanism", throwable);
        }
        finally {
            if (!(asyncContext.isComplete() || asyncContext.isCompletePending() || asyncContext.isDispatchPending())) {
                asyncContext.complete();
            }
            asyncContext.executeNextRunnable();
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.exiting(CLASS_NAME, "_invokeAsyncErrorHandling", asyncContext);
            }
        }
    }

    public static enum CheckDispatching {
        TRUE,
        FALSE;

    }

    public static enum ExecuteNextRunnable {
        TRUE,
        FALSE;

    }
}

