/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.session.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WSSecurityHelper;
import com.ibm.websphere.servlet.session.UnauthorizedSessionRequestException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.SecurityContext;
import com.ibm.ws.session.AbstractSessionData;
import com.ibm.ws.session.MemoryStoreHelper;
import com.ibm.ws.session.SessionAffinityManager;
import com.ibm.ws.session.SessionApplicationParameters;
import com.ibm.ws.session.SessionContext;
import com.ibm.ws.session.SessionCrossoverStackTrace;
import com.ibm.ws.session.SessionData;
import com.ibm.ws.session.SessionManagerConfig;
import com.ibm.ws.session.SessionStoreService;
import com.ibm.ws.session.utils.LoggingUtil;
import com.ibm.ws.webcontainer.osgi.collaborator.CollaboratorHelperImpl;
import com.ibm.ws.webcontainer.session.IHttpSessionContext;
import com.ibm.ws.webcontainer.session.impl.HttpSessionImpl;
import com.ibm.ws.webcontainer.session.impl.MemoryStoreHelperImpl;
import com.ibm.ws.webcontainer.session.impl.SessionAffinityManagerImpl;
import com.ibm.ws.webcontainer.srt.ISRTServletRequest;
import com.ibm.wsspi.http.channel.values.HttpHeaderKeys;
import com.ibm.wsspi.session.IGenericSessionManager;
import com.ibm.wsspi.session.ISession;
import com.ibm.wsspi.session.ISessionAffinityManager;
import com.ibm.wsspi.session.IStore;
import com.ibm.wsspi.session.SessionAffinityContext;
import com.ibm.wsspi.webcontainer.servlet.IExtendedRequest;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HttpSessionContextImpl
extends SessionContext
implements IHttpSessionContext {
    private static final String methodClassName = "HttpSessionContextImpl";

    public HttpSessionContextImpl(SessionManagerConfig smc, SessionApplicationParameters sap, SessionStoreService sessionStoreService) {
        super(smc, sap, sessionStoreService);
    }

    public HttpSessionContextImpl(SessionManagerConfig smc, SessionApplicationParameters sap, SessionStoreService sessionStoreService, boolean removeAttrOnInvalidate) {
        super(smc, sap, sessionStoreService, removeAttrOnInvalidate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockSession(HttpServletRequest req, HttpSession sess) {
        String isNested = (String)req.getAttribute("com.ibm.servlet.engine.webapp.dispatch_nested");
        if (isNested == null || isNested.equalsIgnoreCase("false")) {
            try {
                long syncSessionTimeOut = (long)this._smc.getSerializedSessionAccessMaxWaitTime() * 1000L;
                long syncSessionTimeOutNanos = syncSessionTimeOut * 1000000L;
                if (sess != null) {
                    int llsize;
                    LinkedList ll;
                    Object lock = new Object();
                    LinkedList linkedList = ll = ((AbstractSessionData)sess).getLockList();
                    synchronized (linkedList) {
                        ((AbstractSessionData)sess).setSessionLock((Object)Thread.currentThread(), lock);
                        ll.addLast(lock);
                        llsize = ll.size();
                    }
                    if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                        LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodNames[18], "size = " + llsize + " thread = " + Thread.currentThread().getId() + " lock = " + lock.hashCode());
                    }
                    if (llsize > 1) {
                        long before = System.nanoTime();
                        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodNames[18], "waiting...");
                        }
                        Object object = lock;
                        synchronized (object) {
                            lock.wait(syncSessionTimeOut);
                        }
                        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodNames[18], "Done waiting.");
                        }
                        long after = System.nanoTime();
                        LinkedList linkedList2 = ll;
                        synchronized (linkedList2) {
                            if (after - syncSessionTimeOutNanos >= before) {
                                if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                                    LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodNames[18], "notified after wait timed out");
                                }
                                if (!this._smc.getAccessSessionOnTimeout()) {
                                    ll.remove(lock);
                                    LoggingUtil.SESSION_LOGGER_CORE.logp(Level.SEVERE, methodClassName, methodNames[18], "WsSessionContext.timeOut");
                                    throw new RuntimeException("Session Lock time outException");
                                }
                            }
                        }
                    }
                }
                if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                    LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[18], sess);
                }
            }
            catch (InterruptedException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.webcontainer.session.impl.HttpSessionContextImpl.lockSession", (String)"133", (Object)this);
                LoggingUtil.SESSION_LOGGER_CORE.logp(Level.SEVERE, methodClassName, methodNames[18], "CommonMessage.exception", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockSession(HttpSession sess) {
        AbstractSessionData session;
        Object obj;
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.entering(methodClassName, methodNames[19]);
        }
        if ((obj = (session = (AbstractSessionData)sess).getSessionLock((Object)Thread.currentThread())) != null) {
            LinkedList linkList;
            LinkedList linkedList = linkList = session.getLockList();
            synchronized (linkedList) {
                block13: {
                    try {
                        linkList.remove(obj);
                        if (linkList.size() > 0) {
                            Object nextLock = linkList.getFirst();
                            if (nextLock == null) break block13;
                            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                                LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodNames[19], "notify after postInvoke");
                            }
                            Object e = nextLock;
                            synchronized (e) {
                                nextLock.notify();
                                break block13;
                            }
                        }
                        session.clearSessionLocks();
                    }
                    catch (Exception e) {
                        if (!TraceComponent.isAnyTracingEnabled() || !LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) break block13;
                        LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodNames[19], "failed to unlock session", e);
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[19]);
        }
    }

    @Override
    public HttpSession sessionPreInvoke(HttpServletRequest req, HttpServletResponse res) {
        HttpSession sess;
        block7: {
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_CORE.entering(methodClassName, methodNames[3]);
            }
            if (this._smc.getIntegrateSecurity() && req instanceof IExtendedRequest) {
                ((IExtendedRequest)req).setRunningCollaborators(true);
            }
            sess = null;
            try {
                sess = this.getIHttpSession(req, res, false, this._smc.getOnlyCheckInCacheDuringPreInvoke());
                if (this._smc.getIntegrateSecurity() && req instanceof IExtendedRequest) {
                    ((IExtendedRequest)req).setRunningCollaborators(false);
                }
                if (this._smc.getAllowSerializedSessionAccess()) {
                    this.lockSession(req, sess);
                }
            }
            catch (IllegalStateException e) {
                if (!TraceComponent.isAnyTracingEnabled() || !LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) break block7;
                LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodNames[3], "IllegalStateException occurred getting the session during preinvoke possibly due to a timing window.  Continuing with the request", e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[3]);
        }
        return sess;
    }

    @Override
    public boolean isValid(HttpSession sess, HttpServletRequest req, boolean create) {
        ISession isess;
        boolean valid;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.entering(methodClassName, methodNames[7]);
        }
        if (valid = (isess = ((AbstractSessionData)sess).getISession()).isValid()) {
            if (this._smc.getIntegrateSecurity()) {
                try {
                    this.checkSecurity((AbstractSessionData)sess, req);
                }
                catch (UnauthorizedSessionRequestException unauthException) {
                    if (this._smc.getInvalidateOnUnauthorizedSessionRequestException()) {
                        valid = false;
                    }
                    if (create || this._smc.getThrowSecurityExceptionOnGetSessionFalse()) {
                        throw unauthException;
                    }
                    valid = false;
                }
            }
            if (valid && this._smc.isDebugSessionCrossover() && this.crossoverCheck(req, sess)) {
                valid = false;
                Object[] parms = new Object[]{this.getAppName(), sess.getId(), this.getCurrentSessionId()};
                LoggingUtil.logParamsAndException((Logger)LoggingUtil.SESSION_LOGGER_CORE, (Level)Level.SEVERE, (String)methodClassName, (String)methodNames[7], (String)"SessionContext.CrossoverOnRetrieve", (Object[])parms, (Throwable)new SessionCrossoverStackTrace());
            }
        }
        if (!valid) {
            boolean active;
            ((IExtendedRequest)req).setSessionId(null);
            SessionAffinityContext sac = this.getSessionAffinityContext(req);
            sac.setResponseSessionID(null);
            boolean bl = active = isess.getRefCount() > 0;
            if (isTraceOn && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodNames[7], "Still in the service method " + active);
            }
            if (!active && this._smc.getModifyActiveCountOnInvalidatedSession()) {
                this._coreHttpSessionManager.getIStore().getStoreCallback().sessionReleased(isess);
            }
        }
        if (isTraceOn && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[7], "" + valid);
        }
        return valid;
    }

    public boolean crossoverCheck(HttpServletRequest req, HttpSession session) {
        String inUseSessionId;
        boolean collab = false;
        if (req != null) {
            collab = ((IExtendedRequest)req).getRunningCollaborators();
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "crossoverCheck", "" + collab);
            }
        }
        return !collab && !session.isNew() && (inUseSessionId = this.getCurrentSessionId()) != null && !inUseSessionId.equals(session.getId());
    }

    protected SessionAffinityContext getSessionAffinityContext(HttpServletRequest _request) {
        String sacKey;
        SessionAffinityContext sac;
        Hashtable<String, SessionAffinityContext> sacHashtable = (Hashtable<String, SessionAffinityContext>)((IExtendedRequest)_request).getSessionAffinityContext();
        if (sacHashtable == null) {
            sacHashtable = new Hashtable<String, SessionAffinityContext>();
            ((IExtendedRequest)_request).setSessionAffinityContext(sacHashtable);
            if (this._smc.isDebugSessionCrossover()) {
                currentThreadSacHashtable.set(sacHashtable);
            }
        }
        if ((sac = (SessionAffinityContext)sacHashtable.get(sacKey = this._smc.getSessionAffinityContextKey())) != null) {
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodNames[14], "Found sac on request for key " + sacKey);
            }
        } else {
            sac = this._sam.analyzeRequest((ServletRequest)_request);
            sacHashtable.put(sacKey, sac);
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodNames[14], "Created sac and stored on request for key " + sacKey);
            }
        }
        return sac;
    }

    @Override
    public String getRequestedSessionId(HttpServletRequest _request) {
        SessionAffinityContext sac = this.getSessionAffinityContext(_request);
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.entering(methodClassName, methodNames[1], sac.isFirstSessionIdValid());
        }
        String reqSessId = sac.getRequestedSessionID();
        boolean idIsValid = this._coreHttpSessionManager.isRequestedSessionIDValid(reqSessId, 0);
        if (reqSessId != null && !idIsValid && !sac.isAllSessionIdsSetViaSet() || !sac.isAllSessionIdsSetViaSet() && !sac.isFirstSessionIdValid()) {
            List allSessionIds = this._sam.getAllCookieValues((ServletRequest)_request);
            sac.setAllSessionIds(allSessionIds);
        }
        if (sac.getNumSessionIds() > 1) {
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodNames[1], "multiple incoming ids");
            }
            while (!idIsValid && this._sam.setNextId(sac)) {
                reqSessId = sac.getRequestedSessionID();
                idIsValid = this._coreHttpSessionManager.isRequestedSessionIDValid(reqSessId, 0);
            }
            if (!idIsValid) {
                if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                    LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodNames[1], "none valid - return first");
                }
                reqSessId = sac.getFirstRequestedSessionID();
            }
        } else if (!idIsValid && !sac.isFirstSessionIdValid()) {
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodNames[1], "return the only one id sent from client");
            }
            reqSessId = sac.getFirstRequestedSessionID();
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[1], reqSessId);
        }
        return reqSessId;
    }

    @Override
    public boolean isRequestedSessionIdValid(HttpServletRequest _request, HttpSession sess) {
        SessionAffinityContext sac = this.getSessionAffinityContext(_request);
        String sessionId = sac.getRequestedSessionID();
        return sessionId != null && sess != null && (!sess.isNew() || !this._smc.checkSessionNewOnIsValidRequest()) && sessionId.equals(sess.getId());
    }

    @Override
    public boolean isRequestedSessionIdFromCookie(HttpServletRequest _request) {
        SessionAffinityContext sac = this.getSessionAffinityContext(_request);
        return sac.isRequestedSessionIDFromCookie();
    }

    protected HttpSession getIHttpSession(HttpServletRequest _request, HttpServletResponse _response, boolean create, boolean cacheOnly) {
        AbstractSessionData sd;
        String id;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.entering(methodClassName, methodNames[2], "createIfAbsent = " + create);
        }
        HttpSession session = null;
        SessionAffinityContext sac = this.getSessionAffinityContext(_request);
        if (!sac.isFirstSessionIdValid() && !sac.isAllSessionIdsSetViaSet()) {
            List allSessionIds = this._sam.getAllCookieValues((ServletRequest)_request);
            sac.setAllSessionIds(allSessionIds);
            this._sam.setNextId(sac);
        }
        if ((id = this._sam.getInUseSessionID((ServletRequest)_request, sac)) != null && Boolean.valueOf(ISRTServletRequest.getHeader(_request, HttpHeaderKeys.HDR_$WSFO)).booleanValue()) {
            IStore iStore = this._coreHttpSessionManager.getIStore();
            iStore.removeFromMemory(id);
        }
        if (!(id == null || cacheOnly && this._coreHttpSessionManager.getIStore().getFromMemory((Object)id) == null)) {
            session = (HttpSession)this._coreHttpSessionManager.getSession((ServletRequest)_request, (ServletResponse)_response, sac, false);
        }
        if (session != null) {
            Object[] parms;
            id = this._sam.getInUseSessionID((ServletRequest)_request, sac);
            if (session.getMaxInactiveInterval() == 0) {
                session.invalidate();
                session = null;
            } else if (!id.equals(session.getId())) {
                parms = new Object[]{this.getAppName(), session.getId(), id};
                LoggingUtil.logParamsAndException((Logger)LoggingUtil.SESSION_LOGGER_CORE, (Level)Level.SEVERE, (String)methodClassName, (String)methodNames[2], (String)"SessionContext.CrossoverOnRetrieve", (Object[])parms, (Throwable)new SessionCrossoverStackTrace());
                session = null;
            } else if (this._smc.isDebugSessionCrossover() && this.crossoverCheck(_request, session)) {
                parms = new Object[]{this._sap.getAppName(), session.getId(), this.getCurrentSessionId()};
                LoggingUtil.logParamsAndException((Logger)LoggingUtil.SESSION_LOGGER_CORE, (Level)Level.SEVERE, (String)methodClassName, (String)methodNames[2], (String)"SessionContext.CrossoverOnRetrieve", (Object[])parms, (Throwable)new SessionCrossoverStackTrace());
                session = null;
            }
        }
        boolean createdOnThisRequest = false;
        if (session == null && create) {
            boolean reuseId = this.shouldReuseId(_request, sac) && this.checkSessionIdIsRightLength(this._sam.getInUseSessionID((ServletRequest)_request, sac));
            session = (HttpSession)this._coreHttpSessionManager.createSession((ServletRequest)_request, (ServletResponse)_response, sac, reuseId);
            createdOnThisRequest = true;
        }
        if ((sd = (AbstractSessionData)session) != null) {
            if (this._smc.getIntegrateSecurity()) {
                SecurityCheckObject securityCheckObject = this.doSecurityCheck(sd, _request, create);
                if (securityCheckObject.isDoSecurityCheckAgain()) {
                    boolean reuseId = this.shouldReuseId(_request, sac) && this.checkSessionIdIsRightLength(this._sam.getInUseSessionID((ServletRequest)_request, sac));
                    session = (HttpSession)this._coreHttpSessionManager.createSession((ServletRequest)_request, (ServletResponse)_response, sac, reuseId);
                    sd = (AbstractSessionData)session;
                    createdOnThisRequest = true;
                    securityCheckObject = this.doSecurityCheck(sd, _request, create);
                }
                sd = securityCheckObject.getSessionObject();
            }
            if (this.isSIPApplication) {
                sd.setSIPCookieInfo(_request);
                sd.setPathInfo(_request.getPathInfo());
                if (!_response.isCommitted()) {
                    this.setSIPCookieIfApplicable(_request, _response, (SessionData)sd);
                }
            }
        }
        if (this._sap.getAllowDispatchRemoteInclude()) {
            ((SessionAffinityManager)this._sam).setSessionId(_request, sac);
        }
        if (isTraceOn && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[2]);
        }
        return sd;
    }

    private SecurityCheckObject doSecurityCheck(AbstractSessionData sd, HttpServletRequest _request, boolean create) {
        SecurityCheckObject securityCheckObject = new SecurityCheckObject();
        if (sd.isNew()) {
            String userName = null;
            userName = CollaboratorHelperImpl.getCurrentSecurityCollaborator(sd.getServletContext()) != null && WSSecurityHelper.isServerSecurityEnabled() ? this.getUser() : _request.getRemoteUser();
            if (userName != null) {
                sd.setUser(userName);
            }
        } else {
            try {
                this.checkSecurity(sd, _request);
            }
            catch (UnauthorizedSessionRequestException unauthException) {
                if (this._smc.getInvalidateOnUnauthorizedSessionRequestException()) {
                    if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                        LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "doSecurityCheck", "UnauthorizedSessionRequestException thrown - invalidating session");
                    }
                    sd.invalidate();
                    sd = null;
                    securityCheckObject.setDoSecurityCheckAgain(create);
                }
                if (create || this._smc.getThrowSecurityExceptionOnGetSessionFalse()) {
                    if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                        LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "doSecurityCheck", "throwing an UnauthorizedSessionRequestException");
                    }
                    throw unauthException;
                }
                if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                    LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "doSecurityCheck", "getSession(false) can not access the session due to an UnauthorizedSessionRequestException");
                }
                sd = null;
            }
        }
        securityCheckObject.setSessionObject(sd);
        return securityCheckObject;
    }

    private String getUser() {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return SecurityContext.getUser();
            }
        });
    }

    @Override
    public HttpSession getIHttpSession(HttpServletRequest _request, HttpServletResponse _response, boolean create) {
        return this.getIHttpSession(_request, _response, create, false);
    }

    @Override
    public String getSessionUserName(HttpServletRequest request, HttpServletResponse response) {
        String id;
        HttpSession session = null;
        SessionAffinityContext sac = this.getSessionAffinityContext(request);
        if (!sac.isFirstSessionIdValid() && !sac.isAllSessionIdsSetViaSet()) {
            List allSessionIds = this._sam.getAllCookieValues((ServletRequest)request);
            sac.setAllSessionIds(allSessionIds);
            this._sam.setNextId(sac);
        }
        if ((id = this._sam.getInUseSessionID((ServletRequest)request, sac)) != null) {
            session = (HttpSession)this._coreHttpSessionManager.getSession((ServletRequest)request, (ServletResponse)response, sac, false);
        }
        if (session != null) {
            return ((AbstractSessionData)session).getUserName();
        }
        return null;
    }

    @Override
    public boolean isRequestedSessionIdFromUrl(HttpServletRequest req) {
        SessionAffinityContext sac = this.getSessionAffinityContext(req);
        return sac.isRequestedSessionIDFromURL();
    }

    protected void checkSecurity(AbstractSessionData s, HttpServletRequest req) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.entering(methodClassName, methodNames[15]);
        }
        String auth = null;
        String owner = s.getUserName();
        if (CollaboratorHelperImpl.getCurrentSecurityCollaborator(s.getServletContext()) != null && WSSecurityHelper.isServerSecurityEnabled()) {
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodNames[15], "calling getUser");
            }
            auth = this.getUser();
        } else {
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodNames[15], "calling getRemoteUser");
            }
            auth = req.getRemoteUser();
        }
        if (auth == null) {
            auth = "anonymous";
        }
        if (!(auth == null || owner == null || this._smc.getSecurityUserIgnoreCase() && auth.equalsIgnoreCase(owner) || auth.equals(owner))) {
            if (owner.equals("anonymous")) {
                s.setUser(auth);
            } else if (!((IExtendedRequest)req).getRunningCollaborators()) {
                UnauthorizedSessionRequestException usre;
                ResourceBundle rb;
                Object[] params = new Object[]{auth, owner};
                if (!this._smc.getInvalidateOnUnauthorizedSessionRequestException()) {
                    LoggingUtil.SESSION_LOGGER_CORE.logp(Level.SEVERE, methodClassName, methodNames[15], "SessionContext.unauthAccessError", params);
                }
                if (this._smc.isDebugSessionCrossover()) {
                    new Throwable("Throw exception to find out who sent the unauthorized request !!!").printStackTrace(System.out);
                }
                if ((rb = LoggingUtil.SESSION_LOGGER_CORE.getResourceBundle()) != null) {
                    String msg = MessageFormat.format(rb.getString("SessionContext.unauthAccessError"), params);
                    usre = new UnauthorizedSessionRequestException(msg);
                } else {
                    usre = new UnauthorizedSessionRequestException();
                }
                if (!this._smc.getThrowSecurityExceptionOnGetSessionFalse() && !this._smc.getInvalidateOnUnauthorizedSessionRequestException()) {
                    s.getISession().decrementRefCount();
                }
                throw usre;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[15]);
        }
    }

    protected boolean shouldReuseId(HttpServletRequest _request, SessionAffinityContext sac) {
        boolean reuseId;
        boolean bl = reuseId = sac.isResponseIdSet() || sac.isRequestedSessionIDFromSSL();
        if (!reuseId && this._smc.getEnableUrlRewriting()) {
            Object objSacHashtable;
            Hashtable sacHashtable;
            boolean useCookies;
            boolean bl2 = useCookies = this._smc.getEnableCookies() && ISRTServletRequest.getHeader(_request, HttpHeaderKeys.HDR_COOKIE) != null;
            if (!useCookies && (sacHashtable = (Hashtable)(objSacHashtable = ((IExtendedRequest)_request).getSessionAffinityContext())).size() > 1) {
                Enumeration sacEnum = sacHashtable.elements();
                while (sacEnum.hasMoreElements()) {
                    SessionAffinityContext otherSac = (SessionAffinityContext)sacEnum.nextElement();
                    String otherResponseId = otherSac.getResponseSessionID();
                    if (otherResponseId == null) continue;
                    sac.setResponseSessionID(otherResponseId);
                    reuseId = true;
                    break;
                }
            }
        }
        return reuseId || SessionManagerConfig.isIdReuse();
    }

    public String encodeURLForSipConvergedApps(HttpSession session, String url) {
        return this.encodeURL(session, null, url);
    }

    @Override
    public String encodeURL(HttpSession sess, HttpServletRequest req, String url) {
        int x;
        String traceUrl;
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            traceUrl = url;
            if (SessionManagerConfig.isHideSessionValues() && traceUrl != null && (x = traceUrl.indexOf("?")) != -1) {
                traceUrl = traceUrl.substring(0, x);
            }
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_CORE.entering(methodClassName, methodNames[8], traceUrl);
            }
        }
        if (sess == null) {
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[8], null);
            }
            return null;
        }
        if (req == null) {
            url = ((SessionAffinityManager)this._sam).encodeURL(sess, url);
        } else {
            SessionAffinityContext sac = this.getSessionAffinityContext(req);
            if (this.shouldEncodeURL(url, req)) {
                if (this._smc.isDebugSessionCrossover() && this.crossoverCheck(req, sess)) {
                    Object[] parms = new Object[]{this.getAppName(), sess.getId(), this.getCurrentSessionId()};
                    LoggingUtil.logParamsAndException((Logger)LoggingUtil.SESSION_LOGGER_CORE, (Level)Level.SEVERE, (String)methodClassName, (String)methodNames[8], (String)"SessionContext.CrossoverOnReturn", (Object[])parms, (Throwable)new SessionCrossoverStackTrace());
                } else {
                    url = this._sam.encodeURL((ServletRequest)req, url, sac);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            traceUrl = url;
            if (SessionManagerConfig.isHideSessionValues() && traceUrl != null && (x = traceUrl.indexOf("?")) != -1) {
                traceUrl = traceUrl.substring(0, x);
            }
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[8], "new url is " + traceUrl);
            }
        }
        return url;
    }

    public ISessionAffinityManager createSessionAffinityManager(SessionManagerConfig smc, SessionContext sctx, IStore istore) {
        return new SessionAffinityManagerImpl(smc, sctx, istore);
    }

    public Object createSessionObject(ISession isess, ServletContext servCtx) {
        return new HttpSessionImpl(isess, this, servCtx);
    }

    public IGenericSessionManager createCoreSessionManager() {
        return super.createCoreSessionManager();
    }

    protected MemoryStoreHelper createStoreHelper(ServletContext sc) {
        return new MemoryStoreHelperImpl(sc);
    }

    @Override
    public SessionManagerConfig getWASSessionConfig() {
        return this._smc;
    }

    protected boolean checkSessionIdIsRightLength(String sessionIdOnly) {
        boolean correctLength = true;
        boolean forceSessionIdLengthCheck = this._smc.getForceSessionIdLengthCheck();
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.entering(methodClassName, methodNames[17], sessionIdOnly);
        }
        if (sessionIdOnly == null || !forceSessionIdLengthCheck) {
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[17], "no check");
            }
            return true;
        }
        if (sessionIdOnly.length() != SessionManagerConfig.getSessionIDLength()) {
            String msg = " Incoming id " + sessionIdOnly + " (" + sessionIdOnly.length() + ") failed length check against " + SessionManagerConfig.getSessionIDLength();
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.WARNING, methodClassName, methodNames[17], "CommonMessage.miscData", msg);
            correctLength = false;
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[17], correctLength);
        }
        return correctLength;
    }

    private static class SecurityCheckObject {
        private AbstractSessionData sd = null;
        private boolean doSecurityCheckAgain = false;

        SecurityCheckObject() {
        }

        AbstractSessionData getSessionObject() {
            return this.sd;
        }

        boolean isDoSecurityCheckAgain() {
            return this.doSecurityCheckAgain;
        }

        void setSessionObject(AbstractSessionData sd) {
            this.sd = sd;
        }

        void setDoSecurityCheckAgain(boolean b) {
            this.doSecurityCheckAgain = b;
        }
    }
}

