/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.internal.osgi.stackjoiner;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.logging.internal.osgi.stackjoiner.ReflectionHelper;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;

public class MethodProxy {
    private static final TraceComponent tc = Tr.register(MethodProxy.class);
    private Method method;
    private String className;
    private String methodName;

    public MethodProxy(Instrumentation inst, String className, String methodName, Class<?> ... parameterTypes) {
        this.className = className;
        this.methodName = methodName;
        Class<?> classRetrieved = this.retrieveClass(inst, className);
        if (classRetrieved != null) {
            Method method = ReflectionHelper.getDeclaredMethod(classRetrieved, methodName, parameterTypes);
            this.setMethodProxy(method);
        }
    }

    public boolean isInitialized() {
        if (this.getMethodProxy() == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Stack joiner could not be initialized. Failed to reflect method " + this.methodName + " in " + this.className + "."), (Object[])new Object[0]);
            }
            return false;
        }
        return true;
    }

    private Class<?> retrieveClass(Instrumentation inst, String className) {
        if (inst != null) {
            Class[] loadedClasses = inst.getAllLoadedClasses();
            for (int i = 0; i < loadedClasses.length; ++i) {
                String name = loadedClasses[i].getName();
                if (!name.equals(className)) continue;
                return loadedClasses[i];
            }
        }
        return null;
    }

    private void setMethodProxy(Method method) {
        this.method = method;
    }

    public Method getMethodProxy() {
        return this.method;
    }
}

