/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer31.osgi.response;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.servlet.request.IRequest;
import com.ibm.ws.http.channel.outstream.HttpOutputStreamConnectWeb;
import com.ibm.ws.webcontainer.osgi.WebContainer;
import com.ibm.ws.webcontainer.osgi.request.IRequestImpl;
import com.ibm.ws.webcontainer.osgi.response.WCOutputStream;
import com.ibm.ws.webcontainer31.async.AsyncWriteCallback;
import com.ibm.ws.webcontainer31.async.ThreadContextManager;
import com.ibm.ws.webcontainer31.async.listener.WriteListenerRunnable;
import com.ibm.ws.webcontainer31.osgi.response.BlockingWriteNotAllowedException;
import com.ibm.wsspi.channelfw.InterChannelCallback;
import com.ibm.wsspi.http.ee7.HttpOutputStreamEE7;
import com.ibm.wsspi.webcontainer.WebContainerRequestState;
import jakarta.servlet.WriteListener;
import java.io.IOException;

public class WCOutputStream31
extends WCOutputStream {
    private static final TraceComponent tc = Tr.register(WCOutputStream31.class, (String)"webcontainer", (String)"com.ibm.ws.webcontainer31.resources.Messages");
    private WriteListener _listener = null;
    private AsyncWriteCallback _callback;
    private HttpOutputStreamEE7 _httpOut = null;
    private IRequestImpl reqImpl;
    private static final byte[] CRLF = new byte[]{13, 10};
    private boolean outputStreamNBClosed = false;

    public WCOutputStream31(HttpOutputStreamConnectWeb stream, IRequest req) {
        super(stream);
        this._httpOut = (HttpOutputStreamEE7)stream;
        this.reqImpl = (IRequestImpl)req;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("constructor, out-->" + (this.output != null ? this.output : "null")), (Object[])new Object[0]);
        }
    }

    public void close() throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"close output", (Object[])new Object[0]);
        }
        if (this._listener != null && this.isOutputStreamNBClosed()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"output stream close previously completed ...return ", (Object[])new Object[0]);
            }
            return;
        }
        try {
            this._httpOut.setAsyncServletWriteListenerCallBack(null);
            super.close();
        }
        finally {
            if (this._listener != null) {
                this.setOutputStreamNBClosed(true);
            }
        }
    }

    public boolean isReady() {
        if (this.isOutputStreamNBClosed()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"output stream closed, ready->false", (Object[])new Object[0]);
            }
            return false;
        }
        return this.isWriteReadyWork(true);
    }

    public void setWriteListener(WriteListener appWLObject) {
        if (appWLObject == null) {
            Tr.error((TraceComponent)tc, (String)"writelistener.is.null", (Object[])new Object[0]);
            throw new NullPointerException(Tr.formatMessage((TraceComponent)tc, (String)"writelistener.is.null", (Object[])new Object[0]));
        }
        if (this.isOutputStreamNBClosed()) {
            Tr.error((TraceComponent)tc, (String)"stream.is.closed.no.read.write", (Object[])new Object[0]);
            throw new IllegalStateException(Tr.formatMessage((TraceComponent)tc, (String)"stream.is.closed.no.read.write", (Object[])new Object[0]));
        }
        if (!this.reqImpl.isStartAsync()) {
            Tr.error((TraceComponent)tc, (String)"writelistener.async.not.started", (Object[])new Object[0]);
            throw new IllegalStateException(Tr.formatMessage((TraceComponent)tc, (String)"writelistener.async.not.started", (Object[])new Object[0]));
        }
        if (this._listener != null) {
            Tr.error((TraceComponent)tc, (String)"writelistener.already.started", (Object[])new Object[0]);
            throw new IllegalStateException(Tr.formatMessage((TraceComponent)tc, (String)"writelistener.already.started", (Object[])new Object[0]));
        }
        this._listener = appWLObject;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("set WriteListener enabled: " + this._listener), (Object[])new Object[0]);
        }
        ThreadContextManager tcm = new ThreadContextManager();
        this._callback = new AsyncWriteCallback(this._listener, this, this._httpOut, tcm);
        this._httpOut.setAsyncServletWriteListenerCallBack((InterChannelCallback)this._callback);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && this.output.hasBufferedContent()) {
            Tr.debug((TraceComponent)tc, (String)"stream has data before start write listener first time", (Object[])new Object[0]);
        }
        WriteListenerRunnable wlRunnable = new WriteListenerRunnable(this._listener, this._httpOut, this._callback, tcm);
        WebContainerRequestState reqState = WebContainerRequestState.getInstance((boolean)true);
        if (reqState.getAttribute("com.ibm.ws.webcontainer.WriteAllowedonThisThread") != null) {
            reqState.removeAttribute("com.ibm.ws.webcontainer.WriteAllowedonThisThread");
        }
        try {
            WebContainer.getExecutorService().execute(wlRunnable);
        }
        catch (Exception e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("An exception occurred during the execute , onWritePossible may not be called: " + e.toString()), (Object[])new Object[0]);
            }
            this._listener.onError((Throwable)e);
        }
    }

    public boolean checkIfCalledFromWLonError() {
        boolean allowBlockingWrite = false;
        WebContainerRequestState reqState = WebContainerRequestState.getInstance((boolean)false);
        if (reqState != null && reqState.getAttribute("com.ibm.ws.webcontainer.AllowWriteFromE") != null) {
            allowBlockingWrite = true;
        }
        return allowBlockingWrite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] b, int start, int len) throws IOException {
        if (b == null) {
            Tr.error((TraceComponent)tc, (String)"read.write.bytearray.null", (Object[])new Object[0]);
            throw new NullPointerException(Tr.formatMessage((TraceComponent)tc, (String)"read.write.bytearray.null", (Object[])new Object[0]));
        }
        if (start < 0 || len < 0 || start + len > b.length) {
            Tr.error((TraceComponent)tc, (String)"read.write.offset.length.bytearraylength", (Object[])new Object[]{start, len, b.length});
            throw new IndexOutOfBoundsException(Tr.formatMessage((TraceComponent)tc, (String)"read.write.offset.length.bytearraylength", (Object[])new Object[]{start, len, b.length}));
        }
        if (this._listener != null && !this.checkIfCalledFromWLonError()) {
            WCOutputStream31 wCOutputStream31 = this;
            synchronized (wCOutputStream31) {
                if (this.isOutputStreamNBClosed()) {
                    Tr.error((TraceComponent)tc, (String)"stream.is.closed.no.read.write", (Object[])new Object[0]);
                    throw new IOException(Tr.formatMessage((TraceComponent)tc, (String)"stream.is.closed.no.read.write", (Object[])new Object[0]));
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("non blocking write requested, WriteListener enabled: " + this._listener), (Object[])new Object[0]);
                }
                this.write_NonBlocking(b, start, len);
            }
        } else {
            super.write(b, start, len);
        }
    }

    private void write_NonBlocking(byte[] value, int start, int len) throws IOException {
        WebContainerRequestState reqState = WebContainerRequestState.getInstance((boolean)false);
        if (reqState != null && reqState.getAttribute("com.ibm.ws.webcontainer.WriteAllowedonThisThread") != null) {
            super.write(value, start, len);
            if (reqState.getAttribute("com.ibm.ws.webcontainer.WriteAllowedonThisThread") != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("back to write_NonBlocking , remove write allowed attribute, -> WriteListener enabled: " + this._listener), (Object[])new Object[0]);
                }
                reqState.removeAttribute("com.ibm.ws.webcontainer.WriteAllowedonThisThread");
            }
        } else {
            Tr.error((TraceComponent)tc, (String)"blocking.write.not.allowed", (Object[])new Object[]{this._listener});
            throw new BlockingWriteNotAllowedException(Tr.formatMessage((TraceComponent)tc, (String)"blocking.write.not.allowed", (Object[])new Object[]{this._listener}));
        }
    }

    public void write(byte[] value) throws IOException {
        this.write(value, 0, value.length);
    }

    public void write(int value) throws IOException {
        byte[] buf = new byte[]{(byte)value};
        this.write(buf, 0, 1);
    }

    public void print(boolean b) throws IOException {
        if (this._listener != null && !this.checkIfCalledFromWLonError()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("non blocking print boolean , WriteListener enabled: " + this._listener), (Object[])new Object[0]);
            }
            this.print_NonBlocking(Boolean.toString(b));
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"print boolean", (Object[])new Object[0]);
            }
            super.print(b);
        }
    }

    public void print(char c) throws IOException {
        if (this._listener != null && !this.checkIfCalledFromWLonError()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("non blocking print char , WriteListener enabled: " + this._listener), (Object[])new Object[0]);
            }
            this.print_NonBlocking(Character.toString(c));
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"print char", (Object[])new Object[0]);
            }
            super.print(c);
        }
    }

    public void print(double d) throws IOException {
        if (this._listener != null && !this.checkIfCalledFromWLonError()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("non blocking print double , WriteListener enabled: " + this._listener), (Object[])new Object[0]);
            }
            this.print_NonBlocking(Double.toString(d));
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"print double", (Object[])new Object[0]);
            }
            super.print(d);
        }
    }

    public void print(float f) throws IOException {
        if (this._listener != null && !this.checkIfCalledFromWLonError()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("non blocking print float , WriteListener enabled: " + this._listener), (Object[])new Object[0]);
            }
            this.print_NonBlocking(Float.toString(f));
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"print float", (Object[])new Object[0]);
            }
            super.print(f);
        }
    }

    public void print(int i) throws IOException {
        if (this._listener != null && !this.checkIfCalledFromWLonError()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("non blocking print int , WriteListener enabled: " + this._listener), (Object[])new Object[0]);
            }
            this.print_NonBlocking(Integer.toString(i));
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"print int", (Object[])new Object[0]);
            }
            super.print(i);
        }
    }

    public void print(long l) throws IOException {
        if (this._listener != null && !this.checkIfCalledFromWLonError()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("non blocking print long , WriteListener enabled: " + this._listener), (Object[])new Object[0]);
            }
            this.print_NonBlocking(Long.toString(l));
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"print long", (Object[])new Object[0]);
            }
            super.print(l);
        }
    }

    public void print(String value) throws IOException {
        if (this._listener != null && !this.checkIfCalledFromWLonError()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("non blocking print String , WriteListener enabled: " + this._listener), (Object[])new Object[0]);
            }
            if (value != null) {
                this.print_NonBlocking(value);
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"print String", (Object[])new Object[0]);
            }
            super.print(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void print_NonBlocking(String value) throws IOException {
        WCOutputStream31 wCOutputStream31 = this;
        synchronized (wCOutputStream31) {
            if (this.isOutputStreamNBClosed()) {
                Tr.error((TraceComponent)tc, (String)"stream.is.closed.no.read.write", (Object[])new Object[0]);
                throw new IOException(Tr.formatMessage((TraceComponent)tc, (String)"stream.is.closed.no.read.write", (Object[])new Object[0]));
            }
            byte[] stringBytes = value.getBytes();
            this.write_NonBlocking(stringBytes, 0, stringBytes.length);
        }
    }

    public void println() throws IOException {
        if (this._listener != null && !this.checkIfCalledFromWLonError()) {
            this.write_NonBlocking(CRLF, 0, 2);
        } else {
            super.println();
        }
    }

    public void println(boolean b) throws IOException {
        if (this._listener != null && !this.checkIfCalledFromWLonError()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("non blocking println boolean , WriteListener enabled: " + this._listener), (Object[])new Object[0]);
            }
            this.println_NonBlocking(Boolean.toString(b));
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"println boolean", (Object[])new Object[0]);
            }
            super.println(b);
        }
    }

    public void println(char c) throws IOException {
        if (this._listener != null && !this.checkIfCalledFromWLonError()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("non blocking println char , WriteListener enabled: " + this._listener), (Object[])new Object[0]);
            }
            this.println_NonBlocking(Character.toString(c));
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"println char", (Object[])new Object[0]);
            }
            super.println(c);
        }
    }

    public void println(double d) throws IOException {
        if (this._listener != null && !this.checkIfCalledFromWLonError()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("non blocking println double , WriteListener enabled: " + this._listener), (Object[])new Object[0]);
            }
            this.println_NonBlocking(Double.toString(d));
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"println double", (Object[])new Object[0]);
            }
            super.println(d);
        }
    }

    public void println(float f) throws IOException {
        if (this._listener != null && !this.checkIfCalledFromWLonError()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("non blocking println float , WriteListener enabled: " + this._listener), (Object[])new Object[0]);
            }
            this.println_NonBlocking(Float.toString(f));
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"println float", (Object[])new Object[0]);
            }
            super.println(f);
        }
    }

    public void println(int i) throws IOException {
        if (this._listener != null && !this.checkIfCalledFromWLonError()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("non blocking println int , WriteListener enabled: " + this._listener), (Object[])new Object[0]);
            }
            this.println_NonBlocking(Integer.toString(i));
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"println int", (Object[])new Object[0]);
            }
            super.println(i);
        }
    }

    public void println(long l) throws IOException {
        if (this._listener != null && !this.checkIfCalledFromWLonError()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("non blocking println long , WriteListener enabled: " + this._listener), (Object[])new Object[0]);
            }
            this.println_NonBlocking(Long.toString(l));
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"println long", (Object[])new Object[0]);
            }
            super.println(l);
        }
    }

    public void println(String s) throws IOException {
        if (this._listener != null && !this.checkIfCalledFromWLonError()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("non blocking println String , WriteListener enabled: " + this._listener), (Object[])new Object[0]);
            }
            if (s != null) {
                this.println_NonBlocking(s);
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"println String", (Object[])new Object[0]);
            }
            super.println(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void println_NonBlocking(String value) throws IOException {
        WCOutputStream31 wCOutputStream31 = this;
        synchronized (wCOutputStream31) {
            if (this.isOutputStreamNBClosed()) {
                Tr.error((TraceComponent)tc, (String)"stream.is.closed.no.read.write", (Object[])new Object[0]);
                throw new IOException(Tr.formatMessage((TraceComponent)tc, (String)"stream.is.closed.no.read.write", (Object[])new Object[0]));
            }
            byte[] stringBytes = value.getBytes();
            this.write_NonBlocking(stringBytes, 0, stringBytes.length);
            if (this._httpOut.isWriteReady()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("println crlf , write allowed now , WriteListener enabled: " + this._listener + " , check crlf_pending " + this._httpOut.write_crlf_pending), (Object[])new Object[0]);
                }
                WebContainerRequestState.getInstance((boolean)true).setAttribute("com.ibm.ws.webcontainer.WriteAllowedonThisThread", (Object)true);
                this.writeCRLFIfNeeded();
            } else {
                this._httpOut.write_crlf_pending = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"flush", (Object[])new Object[0]);
        }
        boolean crlfWrite = false;
        if (this._listener != null) {
            WCOutputStream31 wCOutputStream31 = this;
            synchronized (wCOutputStream31) {
                WebContainerRequestState reqState = WebContainerRequestState.getInstance((boolean)false);
                if (reqState != null && reqState.getAttribute("com.ibm.ws.webcontainer.CRLFWriteinPorgress") != null) {
                    crlfWrite = true;
                }
                if (!this.isWriteReadyWork(false) && !crlfWrite) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"cannot flush, not write ready", (Object[])new Object[0]);
                    }
                    return;
                }
                super.flush();
            }
        } else {
            super.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWriteReadyWork(boolean externalCall) {
        boolean ready = true;
        Object object = this._httpOut._writeReadyLockObj;
        synchronized (object) {
            if (!this._httpOut.isWriteReady()) {
                ready = false;
                if (externalCall) {
                    this._httpOut.status_not_ready_checked = true;
                    WebContainerRequestState reqState = WebContainerRequestState.getInstance((boolean)false);
                    if (reqState != null && reqState.getAttribute("com.ibm.ws.webcontainer.WriteAllowedonThisThread") != null) {
                        reqState.removeAttribute("com.ibm.ws.webcontainer.WriteAllowedonThisThread");
                    }
                }
            } else {
                WebContainerRequestState reqState = WebContainerRequestState.getInstance((boolean)true);
                reqState.setAttribute("com.ibm.ws.webcontainer.WriteAllowedonThisThread", (Object)true);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(" ready->" + ready), (Object[])new Object[0]);
        }
        return ready;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeCRLFIfNeeded() throws IOException {
        WCOutputStream31 wCOutputStream31 = this;
        synchronized (wCOutputStream31) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("write queue is empty and now write crlf, WriteListener enabled: " + this._listener), (Object[])new Object[0]);
            }
            this._httpOut.write_crlf_pending = false;
            this.write_NonBlocking(CRLF, 0, 2);
        }
    }

    public boolean isOutputStreamNBClosed() {
        return this.outputStreamNBClosed;
    }

    public void setOutputStreamNBClosed(boolean outputStreamNBClosed) {
        this.outputStreamNBClosed = outputStreamNBClosed;
    }
}

